/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.participants.IRefactoringProcessor;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.Expression;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.ExpressionParser;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.IElementHandler;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.IVariablePool;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.StandardElementHandler;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.TestResult;

public class ProcessorDescriptor {
    private IConfigurationElement fConfigurationElement;
    private static final ExpressionParser PARSER = new ExpressionParser(new IElementHandler[]{StandardElementHandler.getInstance()});
    private static final String ID = "id";
    private static final String OVERRIDE = "override";
    private static final String CLASS = "class";

    public ProcessorDescriptor(IConfigurationElement element) {
        this.fConfigurationElement = element;
    }

    public String getId() {
        return this.fConfigurationElement.getAttribute(ID);
    }

    public boolean overrides() {
        return this.fConfigurationElement.getAttribute(OVERRIDE) != null;
    }

    public String getOverrideId() {
        return this.fConfigurationElement.getAttribute(OVERRIDE);
    }

    public boolean matches(IVariablePool pool) throws CoreException {
        IConfigurationElement enablement;
        Assert.isNotNull(pool);
        IConfigurationElement[] configElements = this.fConfigurationElement.getChildren("enablement");
        IConfigurationElement iConfigurationElement = enablement = configElements.length > 0 ? configElements[0] : null;
        if (enablement != null) {
            Expression exp = PARSER.parse(enablement);
            return this.convert(exp.evaluate(pool));
        }
        return false;
    }

    public IRefactoringProcessor createProcessor() throws CoreException {
        return (IRefactoringProcessor)this.fConfigurationElement.createExecutableExtension(CLASS);
    }

    private boolean convert(TestResult eval) {
        return eval != TestResult.FALSE;
    }

    public String toString() {
        return "Processor: " + this.getId();
    }
}

