/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.participants.IRefactoringParticipant;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.Expression;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.ExpressionParser;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.IElementHandler;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.IVariablePool;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.StandardElementHandler;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.TestResult;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public class ParticipantDescriptor {
    private IConfigurationElement fConfigurationElement;
    private static final ExpressionParser EXPRESSION_PARSER = new ExpressionParser(new IElementHandler[]{StandardElementHandler.getInstance()});
    private static final String ID = "id";
    private static final String CLASS = "class";

    public ParticipantDescriptor(IConfigurationElement element) {
        this.fConfigurationElement = element;
    }

    public String getId() {
        return this.fConfigurationElement.getAttribute(ID);
    }

    public IStatus checkSyntax() {
        return new Status(0, JavaPlugin.getPluginId(), 0, "Syntactically correct rename participant element", null);
    }

    public boolean matches(IVariablePool pool) throws CoreException {
        IConfigurationElement[] elements = this.fConfigurationElement.getChildren("enablement");
        if (elements.length == 0) {
            return false;
        }
        Assert.isTrue(elements.length == 1);
        Expression exp = EXPRESSION_PARSER.parse(elements[0]);
        return this.convert(exp.evaluate(pool));
    }

    public IRefactoringParticipant createParticipant() throws CoreException {
        return (IRefactoringParticipant)this.fConfigurationElement.createExecutableExtension(CLASS);
    }

    private boolean convert(TestResult eval) {
        return eval != TestResult.FALSE;
    }
}

