/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.participants.IRefactoringParticipant;
import org.eclipse.jdt.internal.corext.refactoring.participants.IRefactoringProcessor;
import org.eclipse.jdt.internal.corext.refactoring.participants.ISharableParticipant;
import org.eclipse.jdt.internal.corext.refactoring.participants.ParticipantDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.participants.ProcessorDescriptor;
import org.eclipse.jdt.internal.corext.refactoring.participants.SharableParticipants;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.IVariablePool;
import org.eclipse.jdt.internal.corext.refactoring.participants.xml.VariablePool;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public class ExtensionManager {
    private String fName;
    private String fProcessorID;
    private static final int MAX_ENTRIES = 20;
    private LinkedList fLRUProcessors = new LinkedList();
    private List fProcessors = new ArrayList(5);
    private String fParticipantID;
    private List fParticipants = new ArrayList(20);
    private static final boolean EXIST_TRACING;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jdt.ui/processor/existTracing");
        EXIST_TRACING = value != null && value.equalsIgnoreCase("true");
    }

    public ExtensionManager(String name, String processorId, String participantId) {
        Assert.isNotNull(name);
        Assert.isNotNull(processorId);
        Assert.isNotNull(participantId);
        this.fName = name;
        this.fProcessorID = processorId;
        this.fParticipantID = participantId;
        this.init();
    }

    public IVariablePool createProcessorPool(Object[] elements) {
        List<Object> col = Arrays.asList(elements);
        VariablePool result = new VariablePool(null, col);
        result.addVariable("selection", col);
        return result;
    }

    public boolean hasProcessor(IVariablePool pool) throws CoreException {
        ProcessorDescriptor descriptor;
        long start = 0L;
        if (EXIST_TRACING) {
            start = System.currentTimeMillis();
        }
        Iterator iter = this.fLRUProcessors.iterator();
        while (iter.hasNext()) {
            descriptor = (ProcessorDescriptor)iter.next();
            if (!descriptor.matches(pool)) continue;
            if (this.fLRUProcessors.getFirst() != descriptor) {
                iter.remove();
                this.fLRUProcessors.addFirst(descriptor);
            }
            if (EXIST_TRACING) {
                this.printTime(start);
            }
            return true;
        }
        iter = this.fProcessors.iterator();
        while (iter.hasNext()) {
            descriptor = (ProcessorDescriptor)iter.next();
            if (!descriptor.matches(pool)) continue;
            if (this.fLRUProcessors.size() >= 20) {
                this.fLRUProcessors.removeLast();
            }
            this.fLRUProcessors.addFirst(descriptor);
            if (EXIST_TRACING) {
                this.printTime(start);
            }
            return true;
        }
        if (EXIST_TRACING) {
            this.printTime(start);
        }
        return false;
    }

    private void printTime(long start) {
        System.out.println("[" + this.fName + " extension manager] - existing test: " + (System.currentTimeMillis() - start) + " ms");
    }

    public IRefactoringProcessor getProcessor(Object[] elements, IVariablePool pool) throws CoreException {
        ArrayList<ProcessorDescriptor> selected = new ArrayList<ProcessorDescriptor>();
        Iterator p = this.fProcessors.iterator();
        while (p.hasNext()) {
            ProcessorDescriptor ce = (ProcessorDescriptor)p.next();
            if (!ce.matches(pool)) continue;
            selected.add(ce);
        }
        if (selected.size() == 0) {
            return null;
        }
        if (selected.size() == 1) {
            return this.createProcessor((ProcessorDescriptor)selected.get(0), elements);
        }
        Comparator sorter = new Comparator(){

            public int compare(Object o1, Object o2) {
                ProcessorDescriptor d1 = (ProcessorDescriptor)o1;
                ProcessorDescriptor d2 = (ProcessorDescriptor)o2;
                String oid1 = d1.getOverrideId();
                String oid2 = d2.getOverrideId();
                if (oid1 != null && oid2 == null) {
                    if (oid1.equals(d2.getId())) {
                        return 1;
                    }
                } else if (oid1 == null && oid2 != null && oid2.equals(d1.getId())) {
                    return -1;
                }
                return 0;
            }

            public boolean equals(Object obj) {
                return super.equals(obj);
            }
        };
        Collections.sort(selected, sorter);
        int i = selected.size() - 1;
        while (i >= 0) {
            IRefactoringProcessor result = this.createProcessor((ProcessorDescriptor)selected.get(i), elements);
            if (result != null) {
                return result;
            }
            --i;
        }
        return null;
    }

    public IVariablePool createParticipantPool(Object[] elements, IRefactoringProcessor processor) throws CoreException {
        IVariablePool result = this.createProcessorPool(elements);
        result.addVariable("affectedProjects", Arrays.asList(processor.getAffectedProjects()));
        return result;
    }

    public IRefactoringParticipant[] getParticipants(IRefactoringProcessor processor, Object[] elements, IVariablePool pool, SharableParticipants shared) throws CoreException {
        ArrayList<IRefactoringParticipant> result = new ArrayList<IRefactoringParticipant>();
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            Iterator iter = this.fParticipants.iterator();
            while (iter.hasNext()) {
                ParticipantDescriptor descriptor = (ParticipantDescriptor)iter.next();
                if (!descriptor.matches(pool)) continue;
                IRefactoringParticipant participant = shared.get(descriptor);
                if (participant != null) {
                    ((ISharableParticipant)((Object)participant)).addElement(element);
                    continue;
                }
                participant = descriptor.createParticipant();
                participant.initialize(processor, element);
                if (!participant.isAvailable()) continue;
                result.add(participant);
                if (!(participant instanceof ISharableParticipant)) continue;
                shared.put(descriptor, participant);
            }
            ++i;
        }
        return result.toArray(new IRefactoringParticipant[result.size()]);
    }

    private void init() {
        IPluginRegistry registry = Platform.getPluginRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor(JavaPlugin.getPluginId(), this.fProcessorID);
        int i = 0;
        while (i < ces.length) {
            this.fProcessors.add(new ProcessorDescriptor(ces[i]));
            ++i;
        }
        ces = registry.getConfigurationElementsFor(JavaPlugin.getPluginId(), this.fParticipantID);
        i = 0;
        while (i < ces.length) {
            ParticipantDescriptor descriptor = new ParticipantDescriptor(ces[i]);
            IStatus status = descriptor.checkSyntax();
            switch (status.getSeverity()) {
                case 4: {
                    JavaPlugin.log(status);
                    break;
                }
                case 1: 
                case 2: {
                    JavaPlugin.log(status);
                }
                default: {
                    this.fParticipants.add(descriptor);
                }
            }
            ++i;
        }
    }

    private IRefactoringProcessor createProcessor(ProcessorDescriptor processor, Object[] elements) throws CoreException {
        IRefactoringProcessor result = processor.createProcessor();
        result.initialize(elements);
        if (result.isAvailable()) {
            return result;
        }
        return null;
    }
}

