/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.participants.DeleteExtensionManager;
import org.eclipse.jdt.internal.corext.refactoring.participants.DeleteProcessor;
import org.eclipse.jdt.internal.corext.refactoring.participants.IDeleteParticipant;
import org.eclipse.jdt.internal.corext.refactoring.participants.IRefactoringParticipant;

public class DeleteRefactoring
extends Refactoring {
    private Object[] fElements;
    private DeleteProcessor fProcessor;
    private IDeleteParticipant[] fElementParticipants;
    private IDeleteParticipant[] fDerivedParticipants;
    private IRefactoringParticipant[] fMappedParticipants;

    public DeleteRefactoring(Object[] elements) throws CoreException {
        Assert.isTrue(elements != null);
        this.fElements = elements;
        this.fProcessor = DeleteExtensionManager.getProcessor(this.fElements);
    }

    public boolean isAvailable() {
        return this.fProcessor != null;
    }

    public int getStyle() {
        return this.fProcessor.getStyle();
    }

    public Object getAdapter(Class clazz) {
        if (clazz.isInstance(this.fProcessor)) {
            return this.fProcessor;
        }
        return super.getAdapter(clazz);
    }

    public DeleteProcessor getProcessor() {
        return this.fProcessor;
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        try {
            result.merge(this.fProcessor.checkActivation());
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        try {
            this.fElementParticipants = this.fProcessor.getElementParticipants();
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        int i = 0;
        while (i < this.fElementParticipants.length) {
            IDeleteParticipant participant = this.fElementParticipants[i];
            try {
                result.merge(participant.checkActivation());
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
            ++i;
        }
        return result;
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        try {
            IRefactoringParticipant participant;
            this.initParticipants();
            pm.beginTask("", 2 + this.fElementParticipants.length + this.fDerivedParticipants.length + this.fMappedParticipants.length);
            result.merge(this.fProcessor.checkInput((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            if (result.hasFatalError()) {
                return result;
            }
            int i = 0;
            while (i < this.fElementParticipants.length) {
                participant = this.fElementParticipants[i];
                result.merge(participant.checkInput((IProgressMonitor)new SubProgressMonitor(pm, this.fElementParticipants.length)));
                ++i;
            }
            i = 0;
            while (i < this.fDerivedParticipants.length) {
                participant = this.fDerivedParticipants[i];
                result.merge(participant.checkInput((IProgressMonitor)new SubProgressMonitor(pm, this.fDerivedParticipants.length)));
                ++i;
            }
            i = 0;
            while (i < this.fMappedParticipants.length) {
                participant = this.fMappedParticipants[i];
                result.merge(participant.checkInput((IProgressMonitor)new SubProgressMonitor(pm, this.fMappedParticipants.length)));
                ++i;
            }
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        return result;
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", this.fElementParticipants.length + this.fDerivedParticipants.length + this.fMappedParticipants.length + 1);
        CompositeChange result = new CompositeChange();
        try {
            IRefactoringParticipant participant;
            result.add(this.fProcessor.createChange((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            int i = 0;
            while (i < this.fElementParticipants.length) {
                participant = this.fElementParticipants[i];
                result.add(participant.createChange((IProgressMonitor)new SubProgressMonitor(pm, this.fElementParticipants.length)));
                ++i;
            }
            i = 0;
            while (i < this.fDerivedParticipants.length) {
                participant = this.fDerivedParticipants[i];
                result.add(participant.createChange((IProgressMonitor)new SubProgressMonitor(pm, this.fDerivedParticipants.length)));
                ++i;
            }
            i = 0;
            while (i < this.fMappedParticipants.length) {
                participant = this.fMappedParticipants[i];
                result.add(participant.createChange((IProgressMonitor)new SubProgressMonitor(pm, this.fMappedParticipants.length)));
                ++i;
            }
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        return result;
    }

    public String getName() {
        return this.fProcessor.getProcessorName();
    }

    private void initParticipants() throws CoreException {
        this.fDerivedParticipants = this.fProcessor.getDerivedParticipants();
        this.fMappedParticipants = this.fProcessor.getMappedParticipants();
    }
}

