/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls.changes;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.NullChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Change;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.CreateFileChange;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.NLSChangesMessages;
import org.eclipse.jdt.internal.corext.util.IOCloser;

public class DeleteFileChange
extends Change {
    private IPath fPath;
    private String fSource;

    public DeleteFileChange(IFile file) {
        Assert.isNotNull(file, "file");
        this.fPath = file.getFullPath().removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getFullPath().segmentCount());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void perform(ChangeContext context, IProgressMonitor pm) throws JavaModelException, ChangeAbortException {
        block7: {
            block6: {
                try {
                    try {
                        if (!this.isActive()) {
                            Object var4_3 = null;
                            break block6;
                        }
                        pm.beginTask(NLSChangesMessages.getString("deleteFile.deleting_resource"), 1);
                        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
                        Assert.isNotNull(file);
                        Assert.isTrue(file.exists());
                        Assert.isTrue(!file.isReadOnly());
                        this.fSource = this.getSource(file);
                        file.delete(true, false, pm);
                    }
                    catch (Exception e) {
                        this.handleException(context, e);
                        this.setActive(false);
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return;
        }
        Object var4_5 = null;
        pm.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSource(IFile file) throws CoreException {
        InputStream in = file.getContents();
        StringBuffer sb = new StringBuffer();
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new InputStreamReader(in, ResourcesPlugin.getEncoding()));
                int read = 0;
                while ((read = br.read()) != -1) {
                    sb.append((char)read);
                }
            }
            catch (IOException e) {
                throw new JavaModelException((Throwable)e, 985);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                IOCloser.rethrows(br, in);
                throw throwable;
            }
            catch (IOException e) {
                throw new JavaModelException((Throwable)e, 985);
            }
        }
        {
            Object var6_9 = null;
        }
        try {}
        catch (IOException e) {
            throw new JavaModelException((Throwable)e, 985);
        }
        IOCloser.rethrows(br, in);
        return sb.toString();
    }

    public IChange getUndoChange() {
        if (!this.isActive()) {
            return new NullChange();
        }
        return new CreateFileChange(this.fPath, this.fSource);
    }

    public String getName() {
        return NLSChangesMessages.getString("deleteFile.Delete_File");
    }

    public Object getModifiedLanguageElement() {
        return null;
    }
}

