/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSUtil;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.CreateFileChange;

public class CreateTextFileChange
extends CreateFileChange {
    private final String fTextType;

    public CreateTextFileChange(IPath path, String source, String textType) {
        super(path, source);
        this.fTextType = textType;
    }

    public CreateTextFileChange(IPath path, String source, String encoding, String textType) {
        super(path, source, encoding);
        this.fTextType = textType;
    }

    public String getTextType() {
        return this.fTextType;
    }

    public String getCurrentContent() throws JavaModelException {
        IFile file = this.getOldFile((IProgressMonitor)new NullProgressMonitor());
        if (!file.exists()) {
            return "";
        }
        try {
            String c = NLSUtil.readString(file.getContents());
            return c == null ? "" : c;
        }
        catch (CoreException e) {
            throw new JavaModelException((Throwable)e, 966);
        }
    }

    public String getPreview() throws JavaModelException {
        return this.getSource();
    }
}

