/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls.changes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.NullChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Change;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.DeleteFileChange;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.NLSChangesMessages;

public class CreateFileChange
extends Change {
    private IPath fPath;
    private String fSource;
    private IChange fUndoChange;
    private String fName;
    private String fEncoding;

    public CreateFileChange(IPath path, String source, String encoding) {
        Assert.isNotNull(path, "path");
        Assert.isNotNull(source, "source");
        this.fPath = path;
        this.fSource = source;
        this.fEncoding = encoding;
    }

    public CreateFileChange(IPath path, String source) {
        this(path, source, ResourcesPlugin.getEncoding());
    }

    protected void setSource(String source) {
        this.fSource = source;
    }

    protected void setPath(IPath path) {
        this.fPath = path;
    }

    protected IPath getPath() {
        return this.fPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void perform(ChangeContext context, IProgressMonitor pm) throws JavaModelException, ChangeAbortException {
        InputStream is = null;
        try {
            block10: {
                try {
                    pm.beginTask(NLSChangesMessages.getString("createFile.creating_resource"), 2);
                    if (!this.isActive()) {
                        this.fUndoChange = new NullChange();
                        break block10;
                    }
                    IFile file = this.getOldFile((IProgressMonitor)new SubProgressMonitor(pm, 1));
                    if (file.exists()) {
                        CompositeChange composite = new CompositeChange();
                        composite.add(new DeleteFileChange(file));
                        composite.add(new CreateFileChange(this.fPath, this.fSource));
                        composite.perform(context, pm);
                        this.fUndoChange = composite.getUndoChange();
                        break block10;
                    }
                    is = this.getInputStream();
                    file.create(is, false, pm);
                    this.fUndoChange = new DeleteFileChange(file);
                }
                catch (Exception e) {
                    this.handleException(context, e);
                    this.fUndoChange = new NullChange();
                    this.setActive(false);
                }
            }
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            pm.done();
            try {
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new JavaModelException((Throwable)ioe, 985);
            }
        }
        pm.done();
        try {}
        catch (IOException ioe) {
            throw new JavaModelException((Throwable)ioe, 985);
        }
        if (is == null) return;
        is.close();
    }

    protected IFile getOldFile(IProgressMonitor pm) {
        IFile iFile;
        pm.beginTask("", 1);
        try {
            iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return iFile;
    }

    private InputStream getInputStream() {
        if (this.fEncoding == null) {
            return new ByteArrayInputStream(this.fSource.getBytes());
        }
        try {
            return new ByteArrayInputStream(this.fSource.getBytes(this.fEncoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new ByteArrayInputStream(this.fSource.getBytes());
        }
    }

    public IChange getUndoChange() {
        return this.fUndoChange;
    }

    public String getName() {
        if (this.fName == null) {
            return String.valueOf(NLSChangesMessages.getString("createFile.Create_file")) + this.fPath.toString();
        }
        return this.fName;
    }

    public Object getModifiedLanguageElement() {
        return null;
    }

    protected String getSource() {
        return this.fSource;
    }

    public void setName(String name) {
        this.fName = name;
    }
}

