/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextFileChange;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSHolder;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSMessages;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSUtil;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRegion;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class NLSRefactoring
extends Refactoring {
    public static final String KEY = "${key}";
    public static final String PROPERTY_FILE_EXT = ".properties";
    private static final String fgLineDelimiter = System.getProperty("line.separator", "\n");
    private String fAccessorClassName = "Messages";
    private boolean fCreateAccessorClass = true;
    private String fProperyFileName = "test";
    private String fCodePattern;
    private ICompilationUnit fCu;
    private NLSLine[] fLines;
    private NLSSubstitution[] fNlsSubs;
    private IPath fPropertyFilePath;
    private String fAddedImport;
    private final CodeGenerationSettings fCodeGenerationSettings;

    private NLSRefactoring(ICompilationUnit cu, CodeGenerationSettings codeGenerationSettings) {
        Assert.isNotNull(cu);
        Assert.isNotNull(codeGenerationSettings);
        this.fCu = cu;
        this.fCodeGenerationSettings = codeGenerationSettings;
    }

    public static NLSRefactoring create(ICompilationUnit cu, CodeGenerationSettings codeGenerationSettings) {
        if (!NLSRefactoring.isAvailable(cu)) {
            return null;
        }
        return new NLSRefactoring(cu, codeGenerationSettings);
    }

    public static boolean isAvailable(ICompilationUnit cu) {
        if (cu == null) {
            return false;
        }
        return cu.exists();
    }

    public void setNlsSubstitutions(NLSSubstitution[] subs) {
        Assert.isNotNull(subs);
        this.fNlsSubs = subs;
    }

    public void setAddedImportDeclaration(String decl) {
        this.fAddedImport = JavaConventions.validateImportDeclaration((String)decl).isOK() ? decl : null;
    }

    public void setCodePattern(String pattern) {
        Assert.isNotNull(pattern);
        this.fCodePattern = pattern;
    }

    public String getCodePattern() {
        if (this.fCodePattern == null) {
            return this.getDefaultCodePattern();
        }
        return this.fCodePattern;
    }

    public String getDefaultCodePattern() {
        return String.valueOf(this.fAccessorClassName) + ".getString(" + KEY + ")";
    }

    public ICompilationUnit getCu() {
        return this.fCu;
    }

    public String getName() {
        return NLSMessages.getFormattedString("NLSrefactoring.compilation_unit", this.fCu.getElementName());
    }

    public void setLines(NLSLine[] lines) {
        Assert.isNotNull(lines);
        this.fLines = lines;
    }

    public void setPropertyFilePath(IPath path) {
        this.fPropertyFilePath = path;
    }

    private IPath getPropertyFilePath() {
        if (this.fPropertyFilePath == null) {
            return this.getDefaultPropertyFilePath();
        }
        return this.fPropertyFilePath;
    }

    private IPath getDefaultPropertyFilePath() {
        Path cuName = new Path(this.fCu.getElementName());
        return ResourceUtil.getResource(this.fCu).getFullPath().removeLastSegments(cuName.segmentCount()).append(String.valueOf(this.fProperyFileName) + PROPERTY_FILE_EXT);
    }

    public String getDefaultPropertyFileName() {
        return this.getDefaultPropertyFilePath().lastSegment();
    }

    public String getDefaultPropertyPackageName() {
        IPath path = this.getDefaultPropertyFilePath();
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path.removeLastSegments(1));
        IJavaElement je = JavaCore.create((IResource)res);
        if (je instanceof IPackageFragment) {
            return je.getElementName();
        }
        return "";
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) {
        if (NLSHolder.create(this.fCu).getSubstitutions().length == 0) {
            String message = NLSMessages.getFormattedString("NLSRefactoring.no_strings", this.fCu.getElementName());
            return RefactoringStatus.createFatalErrorStatus(message);
        }
        return new RefactoringStatus();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        block9: {
            RefactoringStatus refactoringStatus2;
            block8: {
                RefactoringStatus refactoringStatus3;
                block7: {
                    try {
                        pm.beginTask(NLSMessages.getString("NLSrefactoring.checking"), 7);
                        RefactoringStatus result = new RefactoringStatus();
                        result.merge(this.checkIfAnythingToDo());
                        if (result.hasFatalError()) {
                            refactoringStatus3 = result;
                            Object var4_7 = null;
                            break block7;
                        }
                        pm.worked(1);
                        result.merge(this.validateModifiesFiles());
                        if (result.hasFatalError()) {
                            refactoringStatus2 = result;
                            break block8;
                        }
                        pm.worked(1);
                        result.merge(this.checkCodePattern());
                        pm.worked(1);
                        result.merge(this.checkForDuplicateKeys());
                        pm.worked(1);
                        result.merge(this.checkForKeysAlreadyDefined());
                        pm.worked(1);
                        result.merge(this.checkKeys());
                        pm.worked(1);
                        if (!this.propertyFileExists() && this.willModifyPropertyFile()) {
                            String msg = NLSMessages.getFormattedString("NLSrefactoring.will_be_created", this.getPropertyFilePath().toString());
                            result.addInfo(msg);
                        }
                        pm.worked(1);
                        refactoringStatus = result;
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var4_10 = null;
                        pm.done();
                        throw throwable;
                    }
                }
                pm.done();
                return refactoringStatus3;
            }
            Object var4_8 = null;
            pm.done();
            return refactoringStatus2;
        }
        Object var4_9 = null;
        pm.done();
        return refactoringStatus;
    }

    private IFile[] getAllFilesToModify() {
        IFile file;
        ArrayList<IFile> files = new ArrayList<IFile>(2);
        if (this.willModifySource() && (file = ResourceUtil.getFile(this.fCu)) != null) {
            files.add(file);
        }
        if (this.willModifyPropertyFile() && this.propertyFileExists()) {
            files.add(this.getPropertyFile());
        }
        return files.toArray(new IFile[files.size()]);
    }

    private RefactoringStatus validateModifiesFiles() {
        return Checks.validateModifiesFiles(this.getAllFilesToModify());
    }

    private RefactoringStatus checkIfAnythingToDo() throws JavaModelException {
        if (this.willCreateAccessorClass()) {
            return null;
        }
        if (this.willModifyPropertyFile()) {
            return null;
        }
        if (this.willModifySource()) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        result.addFatalError(NLSMessages.getString("NLSrefactoring.nothing_to_do"));
        return result;
    }

    private boolean propertyFileExists() {
        return Checks.resourceExists(this.getPropertyFilePath());
    }

    private RefactoringStatus checkCodePattern() {
        String msg;
        String pattern = this.getCodePattern();
        RefactoringStatus result = new RefactoringStatus();
        if ("".equals(pattern.trim())) {
            result.addError(NLSMessages.getString("NLSrefactoring.pattern_empty"));
        }
        if (pattern.indexOf(KEY) == -1) {
            msg = NLSMessages.getFormattedString("NLSrefactoring.pattern_does_not_contain", KEY);
            result.addWarning(msg);
        }
        if (pattern.indexOf(KEY) != pattern.lastIndexOf(KEY)) {
            msg = NLSMessages.getFormattedString("NLSrefactoring.Only_the_first_occurrence_of", KEY);
            result.addWarning(msg);
        }
        return result;
    }

    private RefactoringStatus checkForKeysAlreadyDefined() throws JavaModelException {
        if (!this.propertyFileExists()) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        PropertyResourceBundle bundle = this.getPropertyBundle();
        if (bundle == null) {
            return null;
        }
        int i = 0;
        while (i < this.fNlsSubs.length) {
            String s = this.getBundleString(bundle, this.fNlsSubs[i].key);
            if (s != null) {
                String msg;
                String[] args;
                if (!this.hasSameValue(s, this.fNlsSubs[i])) {
                    args = new String[]{this.fNlsSubs[i].key, s, this.fNlsSubs[i].value.getValue()};
                    msg = NLSMessages.getFormattedString("NLSrefactoring.already_exists", args);
                    result.addFatalError(msg);
                } else {
                    this.fNlsSubs[i].putToPropertyFile = false;
                    args = new String[]{this.fNlsSubs[i].key, s};
                    msg = NLSMessages.getFormattedString("NLSrefactoring.already_in_bundle", args);
                    result.addWarning(msg);
                }
            }
            ++i;
        }
        return result;
    }

    private boolean hasSameValue(String val, NLSSubstitution sub) {
        return val.equals(sub.value.getValue());
    }

    private String getBundleString(PropertyResourceBundle bundle, String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PropertyResourceBundle getPropertyBundle() throws JavaModelException {
        PropertyResourceBundle propertyResourceBundle;
        InputStream is = this.getPropertyFileInputStream();
        if (is == null) {
            return null;
        }
        try {
            try {
                PropertyResourceBundle result;
                propertyResourceBundle = result = new PropertyResourceBundle(is);
                Object var3_5 = null;
            }
            catch (IOException iOException) {
                PropertyResourceBundle propertyResourceBundle2 = null;
                Object var3_6 = null;
                try {
                    is.close();
                    return propertyResourceBundle2;
                }
                catch (IOException e) {
                    throw new JavaModelException((Throwable)e, 985);
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            try {}
            catch (IOException e) {
                throw new JavaModelException((Throwable)e, 985);
            }
            is.close();
            throw throwable;
        }
        try {}
        catch (IOException e) {
            throw new JavaModelException((Throwable)e, 985);
        }
        is.close();
        return propertyResourceBundle;
    }

    private InputStream getPropertyFileInputStream() throws JavaModelException {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.getPropertyFilePath());
        try {
            return file.getContents();
        }
        catch (CoreException e) {
            throw new JavaModelException((Throwable)e, 966);
        }
    }

    private RefactoringStatus checkForDuplicateKeys() {
        HashMap map = new HashMap();
        int i = 0;
        while (i < this.fNlsSubs.length) {
            NLSSubstitution sub = this.fNlsSubs[i];
            String key = sub.key;
            if (!map.containsKey(key)) {
                map.put(key, new HashSet());
            }
            ((Set)map.get(key)).add(sub);
            ++i;
        }
        RefactoringStatus result = new RefactoringStatus();
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Set subs = (Set)map.get(iter.next());
            result.merge(this.checkForDuplicateKeys(subs));
        }
        return result;
    }

    private RefactoringStatus checkForDuplicateKeys(Set subs) {
        if (subs.size() <= 1) {
            return null;
        }
        NLSSubstitution[] toTranslate = NLSRefactoring.getEntriesToTranslate(subs);
        if (toTranslate.length <= 1) {
            return null;
        }
        int i = 0;
        while (i < toTranslate.length) {
            toTranslate[i].putToPropertyFile = i == 0;
            ++i;
        }
        String value = toTranslate[0].value.getValue();
        int i2 = 0;
        while (i2 < toTranslate.length) {
            NLSSubstitution each = toTranslate[i2];
            if (!this.hasSameValue(value, each)) {
                String msg = NLSMessages.getFormattedString("NLSrefactoring.duplicated", each.key);
                return RefactoringStatus.createFatalErrorStatus(msg);
            }
            ++i2;
        }
        String[] args = new String[]{toTranslate[0].key, value};
        String msg = NLSMessages.getFormattedString("NLSrefactoring.reused", args);
        return RefactoringStatus.createWarningStatus(msg);
    }

    private static NLSSubstitution[] getEntriesToTranslate(Set subs) {
        ArrayList<NLSSubstitution> result = new ArrayList<NLSSubstitution>(subs.size());
        Iterator iter = subs.iterator();
        while (iter.hasNext()) {
            NLSSubstitution each = (NLSSubstitution)iter.next();
            if (each.task != 0) continue;
            result.add(each);
        }
        return result.toArray(new NLSSubstitution[result.size()]);
    }

    private RefactoringStatus checkKeys() {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < this.fNlsSubs.length) {
            result.merge(NLSRefactoring.checkKey(this.fNlsSubs[i].key));
            ++i;
        }
        return result;
    }

    public static RefactoringStatus checkKey(String key) {
        RefactoringStatus result = new RefactoringStatus();
        if (key == null) {
            result.addFatalError(NLSMessages.getString("NLSrefactoring.null"));
        }
        if (key.startsWith("!") || key.startsWith("#")) {
            JavaStringStatusContext context = new JavaStringStatusContext(key, new SourceRange(0, 0));
            result.addWarning(NLSMessages.getString("NLSRefactoring.warning"), context);
        }
        if ("".equals(key.trim())) {
            result.addFatalError(NLSMessages.getString("NLSrefactoring.empty"));
        }
        int i = 0;
        while (i < NLSHolder.UNWANTED_STRINGS.length) {
            if (key.indexOf(NLSHolder.UNWANTED_STRINGS[i]) != -1) {
                String[] args = new String[]{key, NLSHolder.UNWANTED_STRINGS[i]};
                String msg = NLSMessages.getFormattedString("NLSrefactoring.should_not_contain", args);
                result.addError(msg);
            }
            ++i;
        }
        return result;
    }

    private boolean willCreateAccessorClass() throws JavaModelException {
        if (!this.fCreateAccessorClass) {
            return false;
        }
        if (NLSSubstitution.countItems(this.fNlsSubs, 0) == 0) {
            return false;
        }
        if (this.getPackage().getCompilationUnit(this.getAccessorCUName()).exists()) {
            return false;
        }
        if (NLSRefactoring.typeNameExistsInPackage(this.getPackage(), this.fAccessorClassName)) {
            return false;
        }
        return !Checks.resourceExists(this.getAccessorCUPath());
    }

    private boolean willModifySource() {
        if (NLSSubstitution.countItems(this.fNlsSubs, 2) != this.fNlsSubs.length) {
            return true;
        }
        return this.willAddImportDeclaration();
    }

    private boolean willModifyPropertyFile() {
        return NLSSubstitution.countItems(this.fNlsSubs, 0) > 0;
    }

    private boolean willAddImportDeclaration() {
        if (this.fAddedImport == null) {
            return false;
        }
        if ("".equals(this.fAddedImport.trim())) {
            return false;
        }
        if (this.getCu().getImport(this.fAddedImport).exists()) {
            return false;
        }
        return NLSSubstitution.countItems(this.fNlsSubs, 0) != 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        CompositeChange compositeChange;
        try {
            try {
                pm.beginTask("", 3);
                CompositeChange builder = new CompositeChange();
                if (this.willModifySource()) {
                    builder.add(this.createSourceModification());
                }
                pm.worked(1);
                if (this.willModifyPropertyFile()) {
                    builder.add(this.createPropertyFile());
                }
                pm.worked(1);
                if (this.willCreateAccessorClass()) {
                    builder.add(this.createAccessorCU((IProgressMonitor)new SubProgressMonitor(pm, 1)));
                } else {
                    pm.worked(1);
                }
                compositeChange = builder;
                Object var3_6 = null;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return compositeChange;
    }

    private IChange createSourceModification() throws CoreException {
        String message = NLSMessages.getFormattedString("NLSRefactoring.externalize_strings", this.fCu.getElementName());
        CompilationUnitChange change = new CompilationUnitChange(message, this.fCu);
        int i = 0;
        while (i < this.fNlsSubs.length) {
            this.addNLS(this.fNlsSubs[i], change);
            ++i;
        }
        if (this.willAddImportDeclaration()) {
            this.addImportDeclaration(change);
        }
        return change;
    }

    private void addImportDeclaration(TextChange builder) throws JavaModelException {
        int start;
        IImportContainer importContainer = this.getCu().getImportContainer();
        if (!importContainer.exists()) {
            String packName = ((IPackageFragment)this.getCu().getParent()).getElementName();
            IPackageDeclaration packageDecl = this.getCu().getPackageDeclaration(packName);
            if (!packageDecl.exists()) {
                start = 0;
            } else {
                ISourceRange sr = packageDecl.getSourceRange();
                start = sr.getOffset() + sr.getLength() - 1;
            }
        } else {
            ISourceRange sr = importContainer.getSourceRange();
            start = sr.getOffset() + sr.getLength() - 1;
        }
        String newImportText = String.valueOf(fgLineDelimiter) + "import " + this.fAddedImport + ";";
        String name = NLSMessages.getFormattedString("NLSrefactoring.add_import_declaration", this.fAddedImport);
        builder.addTextEdit(name, (TextEdit)new InsertEdit(start + 1, newImportText));
    }

    private void addNLS(NLSSubstitution sub, TextChange builder) {
        TextRegion position = sub.value.getPosition();
        String resourceGetter = this.createResourceGetter(sub.key);
        String text = NLSMessages.getFormattedString("NLSrefactoring.extrenalize_string", sub.value.getValue());
        if (sub.task == 0) {
            builder.addTextEdit(text, (TextEdit)new ReplaceEdit(position.getOffset(), position.getLength(), resourceGetter));
        }
        if (sub.task != 2) {
            NLSElement element = sub.value;
            String[] args = new String[]{text, element.getValue()};
            String name = NLSMessages.getFormattedString("NLSrefactoring.add_tag", args);
            builder.addTextEdit(name, this.createAddTagChange(element));
        }
    }

    private NLSLine findLine(NLSElement element) {
        int i = 0;
        while (i < this.fLines.length) {
            NLSElement[] lineElements = this.fLines[i].getElements();
            int j = 0;
            while (j < lineElements.length) {
                if (lineElements[j].equals(element)) {
                    return this.fLines[i];
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private int computeIndexInLine(NLSElement element, NLSLine line) {
        int i = 0;
        while (i < line.size()) {
            if (line.get(i).equals(element)) {
                return i;
            }
            ++i;
        }
        Assert.isTrue(false, "element not found in line");
        return -1;
    }

    private int computeTagIndex(NLSElement element) {
        NLSLine line = this.findLine(element);
        Assert.isNotNull(line, "line not found for:" + element);
        return this.computeIndexInLine(element, line) + 1;
    }

    private String createTagText(NLSElement element) {
        return " " + NLSElement.createTagText(this.computeTagIndex(element));
    }

    private TextEdit createAddTagChange(NLSElement element) {
        int offset = element.getTagPosition().getOffset();
        String text = this.createTagText(element);
        return new InsertEdit(offset, text);
    }

    private String createResourceGetter(String key) {
        StringBuffer buff = new StringBuffer(this.fCodePattern);
        int i = this.fCodePattern.indexOf(KEY);
        if (i != -1) {
            buff.replace(i, i + KEY.length(), "\"" + key + "\"");
        }
        return buff.toString();
    }

    private IChange createPropertyFile() throws JavaModelException {
        if (!this.propertyFileExists()) {
            return new CreateTextFileChange(this.getPropertyFilePath(), this.createPropertyFileSource(), "8859_1", "txt");
        }
        String name = NLSMessages.getFormattedString("NLSrefactoring.Append_to_property_file", this.getPropertyFilePath().toString());
        TextFileChange tfc = new TextFileChange(name, this.getPropertyFile());
        StringBuffer old = new StringBuffer(this.getOldPropertyFileSource());
        if (NLSRefactoring.needsLineDelimiter(old)) {
            tfc.addTextEdit(NLSMessages.getString("NLSRefactoring.add_line_delimiter"), (TextEdit)new InsertEdit(old.length(), fgLineDelimiter));
        }
        int i = 0;
        while (i < this.fNlsSubs.length) {
            if (this.fNlsSubs[i].task == 0 && this.fNlsSubs[i].putToPropertyFile) {
                String entry = this.createEntry(this.fNlsSubs[i].value, this.fNlsSubs[i].key).toString();
                String message = NLSMessages.getFormattedString("NLSRefactoring.add_entry", this.fNlsSubs[i].key);
                tfc.addTextEdit(message, (TextEdit)new InsertEdit(old.length(), entry));
            }
            ++i;
        }
        return tfc;
    }

    private IFile getPropertyFile() {
        return (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(this.getPropertyFilePath());
    }

    private String createPropertyFileSource() throws JavaModelException {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getOldPropertyFileSource());
        if (NLSRefactoring.needsLineDelimiter(sb)) {
            sb.append(fgLineDelimiter);
        }
        int i = 0;
        while (i < this.fNlsSubs.length) {
            if (this.fNlsSubs[i].task == 0 && this.fNlsSubs[i].putToPropertyFile) {
                sb.append(this.createEntry(this.fNlsSubs[i].value, this.fNlsSubs[i].key).toString());
            }
            ++i;
        }
        return sb.toString();
    }

    private static boolean needsLineDelimiter(StringBuffer sb) {
        if (sb.length() == 0) {
            return false;
        }
        String s = sb.toString();
        int lastDelimiter = s.lastIndexOf(fgLineDelimiter);
        if (lastDelimiter == -1) {
            return true;
        }
        return !"".equals(s.substring(lastDelimiter).trim());
    }

    private String getOldPropertyFileSource() throws JavaModelException {
        if (!this.propertyFileExists()) {
            return "";
        }
        InputStream is = this.getPropertyFileInputStream();
        String s = NLSUtil.readString(is);
        return s == null ? "" : s;
    }

    private StringBuffer createEntry(NLSElement element, String key) {
        StringBuffer sb = new StringBuffer();
        sb.append(key).append("=").append(NLSRefactoring.convertToPropertyValue(element.getValue())).append(fgLineDelimiter);
        return sb;
    }

    private static String convertToPropertyValue(String v) {
        int firstNonWhiteSpace = NLSRefactoring.findFirstNonWhiteSpace(v);
        if (firstNonWhiteSpace == 0) {
            return v;
        }
        return String.valueOf(NLSRefactoring.escapeEachChar(v.substring(0, firstNonWhiteSpace), '\\')) + NLSRefactoring.escapeCommentChars(v.substring(firstNonWhiteSpace));
    }

    private static StringBuffer escapeCommentChars(String string) {
        StringBuffer sb = new StringBuffer(string.length() + 5);
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            switch (c) {
                case '!': {
                    sb.append("\\!");
                }
                case '#': {
                    sb.append("\\#");
                }
            }
            sb.append(c);
            ++i;
        }
        return sb;
    }

    private static String escapeEachChar(String s, char escapeChar) {
        char[] chars = new char[s.length() * 2];
        int i = 0;
        while (i < s.length()) {
            chars[2 * i] = escapeChar;
            chars[2 * i + 1] = s.charAt(i);
            ++i;
        }
        return new String(chars);
    }

    private static int findFirstNonWhiteSpace(String s) {
        int i = 0;
        while (i < s.length()) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return i;
            }
            ++i;
        }
        return s.length();
    }

    private IPackageFragment getPackage() {
        return (IPackageFragment)this.fCu.getParent();
    }

    private static boolean typeNameExistsInPackage(IPackageFragment pack, String name) throws JavaModelException {
        return Checks.findTypeInPackage(pack, name) != null;
    }

    public void setCreateAccessorClass(boolean create) {
        this.fCreateAccessorClass = create;
    }

    public boolean getCreateAccessorClass() {
        return this.fCreateAccessorClass;
    }

    public String getAccessorClassName() {
        return this.fAccessorClassName;
    }

    public void setAccessorClassName(String name) {
        this.fAccessorClassName = name;
        Assert.isNotNull(name);
    }

    private String getAccessorCUName() {
        return String.valueOf(this.fAccessorClassName) + ".java";
    }

    private IChange createAccessorCU(IProgressMonitor pm) throws CoreException {
        return new CreateTextFileChange(this.getAccessorCUPath(), this.createAccessorCUSource(pm), "java");
    }

    private IPath getAccessorCUPath() {
        Path cuName = new Path(this.fCu.getElementName());
        return ResourceUtil.getResource(this.fCu).getFullPath().removeLastSegments(cuName.segmentCount()).append(this.getAccessorCUName());
    }

    private String createAccessorCUSource(IProgressMonitor pm) throws CoreException {
        return CodeFormatterUtil.format(8, this.getUnformattedSource(pm), 0, null, null, null);
    }

    private String getUnformattedSource(IProgressMonitor pm) throws CoreException {
        String string;
        block2: {
            ICompilationUnit newCu = null;
            try {
                newCu = WorkingCopyUtil.getNewWorkingCopy(this.getPackage(), this.getAccessorCUName());
                String comment = CodeGeneration.getTypeComment(newCu, this.fAccessorClassName, fgLineDelimiter);
                newCu.getBuffer().setContents(CodeGeneration.getCompilationUnitContent(newCu, comment, this.createClass().toString(), fgLineDelimiter));
                this.addImportsToAccessorCu(newCu, pm);
                string = newCu.getSource();
                Object var4_5 = null;
                if (newCu == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_6 = null;
                    if (newCu == null) break block3;
                    newCu.destroy();
                }
                throw throwable;
            }
            newCu.destroy();
        }
        return string;
    }

    private void addImportsToAccessorCu(ICompilationUnit newCu, IProgressMonitor pm) throws CoreException {
        ImportsStructure is = new ImportsStructure(newCu, this.fCodeGenerationSettings.importOrder, this.fCodeGenerationSettings.importThreshold, true);
        is.addImport("java.util.MissingResourceException");
        is.addImport("java.util.ResourceBundle");
        is.create(false, pm);
    }

    private StringBuffer createClass() throws CoreException {
        String ld = fgLineDelimiter;
        StringBuffer b = new StringBuffer();
        b.append("public class ").append(this.fAccessorClassName).append(" {").append(ld).append(ld).append("private static final String ").append(NLSRefactoring.getBundleStringName()).append("= \"").append(this.getResourceBundleName()).append("\";").append(NLSElement.createTagText(1)).append(ld).append(ld).append("private static final ResourceBundle ").append(NLSRefactoring.getResourceBundleConstantName()).append("= ResourceBundle.getBundle(").append(NLSRefactoring.getBundleStringName()).append(");").append(ld).append(ld).append(this.createConstructor()).append(ld).append(this.createGetStringMethod()).append("}").append(ld);
        return b;
    }

    private static String getBundleStringName() {
        return "BUNDLE_NAME";
    }

    private static String getResourceBundleConstantName() {
        return "RESOURCE_BUNDLE";
    }

    private String createConstructor() throws CoreException {
        String constructorBody = CodeGeneration.getMethodBodyContent(this.fCu, this.fAccessorClassName, this.fAccessorClassName, true, "", fgLineDelimiter);
        if (constructorBody == null) {
            constructorBody = "";
        }
        return String.valueOf(this.createNewConstructorComment()) + "private " + this.fAccessorClassName + "(){" + fgLineDelimiter + constructorBody + fgLineDelimiter + '}';
    }

    private String createNewConstructorComment() throws CoreException {
        if (this.fCodeGenerationSettings.createComments) {
            String comment = CodeGeneration.getMethodComment(this.fCu, this.fAccessorClassName, this.fAccessorClassName, new String[0], new String[0], null, null, fgLineDelimiter);
            if (comment == null) {
                return "";
            }
            return String.valueOf(comment) + fgLineDelimiter;
        }
        return "";
    }

    private String createGetStringMethod() throws CoreException {
        String bodyStatement = "try {" + fgLineDelimiter + "return " + NLSRefactoring.getResourceBundleConstantName() + ".getString(key);" + fgLineDelimiter + "} catch (MissingResourceException e) {" + fgLineDelimiter + "return '!' + key + '!';" + fgLineDelimiter + "}";
        String methodBody = CodeGeneration.getMethodBodyContent(this.fCu, this.fAccessorClassName, "getString", false, bodyStatement, fgLineDelimiter);
        if (methodBody == null) {
            methodBody = "";
        }
        return String.valueOf(this.createNewGetStringMethodComment()) + "public static String getString(String key) {" + fgLineDelimiter + methodBody + fgLineDelimiter + '}';
    }

    private String createNewGetStringMethodComment() throws CoreException {
        if (this.fCodeGenerationSettings.createComments) {
            String comment = CodeGeneration.getMethodComment(this.fCu, this.fAccessorClassName, "getString", new String[]{"key"}, new String[0], "QString;", null, fgLineDelimiter);
            if (comment == null) {
                return "";
            }
            return String.valueOf(comment) + fgLineDelimiter;
        }
        return "";
    }

    private String getPropertyFileName() {
        return this.getPropertyFilePath().lastSegment();
    }

    private String getPropertyFileSimpleName() {
        String fileName = this.getPropertyFileName();
        return fileName.substring(0, fileName.indexOf(PROPERTY_FILE_EXT));
    }

    private String getResourceBundleName() {
        IJavaElement el;
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(this.getPropertyFilePath().removeLastSegments(1));
        if (res != null && res.exists() && (el = JavaCore.create((IResource)res)) instanceof IPackageFragment) {
            IPackageFragment p = (IPackageFragment)el;
            if (p.isDefaultPackage()) {
                return this.getPropertyFileSimpleName();
            }
            return String.valueOf(p.getElementName()) + "." + this.getPropertyFileSimpleName();
        }
        IPackageFragment pack = this.getPackage();
        if (pack.isDefaultPackage()) {
            return this.fProperyFileName;
        }
        return String.valueOf(pack.getElementName()) + "." + this.fProperyFileName;
    }
}

