/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.code.CallContext;
import org.eclipse.jdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.jdt.internal.corext.refactoring.code.ParameterData;
import org.eclipse.jdt.internal.corext.refactoring.code.SourceAnalyzer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.UndoEdit;

public class SourceProvider {
    private ICompilationUnit fCUnit;
    private TextBuffer fBuffer;
    private MethodDeclaration fDeclaration;
    private ASTRewrite fRewriter;
    private SourceAnalyzer fAnalyzer;
    private boolean fMustEvalReturnedExpression;
    private boolean fReturnValueNeedsLocalVariable;
    private List fReturnExpressions;

    public SourceProvider(ICompilationUnit unit, MethodDeclaration declaration) {
        this.fCUnit = unit;
        this.fDeclaration = declaration;
        List parameters = this.fDeclaration.parameters();
        Iterator iter = parameters.iterator();
        while (iter.hasNext()) {
            SingleVariableDeclaration element = (SingleVariableDeclaration)iter.next();
            ParameterData data = new ParameterData(element);
            element.setProperty(ParameterData.PROPERTY, (Object)data);
        }
        this.fRewriter = new ASTRewrite((ASTNode)this.fDeclaration);
        this.fAnalyzer = new SourceAnalyzer(this.fCUnit, this.fDeclaration);
        this.fReturnValueNeedsLocalVariable = true;
        this.fReturnExpressions = new ArrayList();
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        return this.fAnalyzer.checkActivation();
    }

    public void initialize() throws JavaModelException {
        ASTNode last;
        this.fBuffer = TextBuffer.create(this.fCUnit.getBuffer().getContents());
        this.fAnalyzer.analyzeParameters();
        if (this.hasReturnValue() && (last = this.getLastStatement()) != null) {
            ReturnAnalyzer analyzer = new ReturnAnalyzer();
            last.accept((ASTVisitor)analyzer);
        }
    }

    public boolean isExecutionFlowInterrupted() {
        return this.fAnalyzer.isExecutionFlowInterrupted();
    }

    public boolean isVariableReferenced(IVariableBinding binding) {
        VariableReferenceFinder finder = new VariableReferenceFinder(binding);
        this.fDeclaration.accept((ASTVisitor)finder);
        return finder.getResult();
    }

    public boolean hasReturnValue() {
        IMethodBinding binding = this.fDeclaration.resolveBinding();
        return binding.getReturnType() != this.fDeclaration.getAST().resolveWellKnownType("void");
    }

    public boolean mustEvaluateReturnedExpression() {
        return this.fMustEvalReturnedExpression;
    }

    public boolean returnValueNeedsLocalVariable() {
        return this.fReturnValueNeedsLocalVariable;
    }

    public int getNumberOfStatements() {
        return this.fDeclaration.getBody().statements().size();
    }

    public boolean isSimpleFunction() {
        List statements = this.fDeclaration.getBody().statements();
        if (statements.size() != 1) {
            return false;
        }
        return statements.get(0) instanceof ReturnStatement;
    }

    public MethodDeclaration getDeclaration() {
        return this.fDeclaration;
    }

    public String getMethodName() {
        return this.fDeclaration.getName().getIdentifier();
    }

    public ITypeBinding getReturnType() {
        return this.fDeclaration.resolveBinding().getReturnType();
    }

    public List getReturnExpressions() {
        return this.fReturnExpressions;
    }

    public boolean returnTypeMatchesReturnExpressions() {
        ITypeBinding returnType = this.getReturnType();
        Iterator iter = this.fReturnExpressions.iterator();
        while (iter.hasNext()) {
            Expression expression = (Expression)iter.next();
            if (Bindings.equals((IBinding)returnType, (IBinding)expression.resolveTypeBinding())) continue;
            return false;
        }
        return true;
    }

    public ParameterData getParameterData(int index) {
        SingleVariableDeclaration decl = (SingleVariableDeclaration)this.fDeclaration.parameters().get(index);
        return (ParameterData)decl.getProperty(ParameterData.PROPERTY);
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCUnit;
    }

    public boolean needsReturnedExpressionParenthesis() {
        ASTNode last = this.getLastStatement();
        if (last instanceof ReturnStatement) {
            return ASTNodes.needsParentheses(((ReturnStatement)last).getExpression());
        }
        return false;
    }

    public int getReceiversToBeUpdated() {
        return this.fAnalyzer.getImplicitReceivers().size();
    }

    public TextEdit getDeleteEdit() {
        ASTRewrite rewriter = new ASTRewrite(this.fDeclaration.getParent());
        rewriter.markAsRemoved((ASTNode)this.fDeclaration);
        MultiTextEdit result = new MultiTextEdit();
        rewriter.rewriteNode(this.fBuffer, (TextEdit)result);
        rewriter.removeModifications();
        return result;
    }

    public String[] getCodeBlocks(CallContext context) throws CoreException {
        int split;
        ASTNode last;
        this.replaceParameterWithExpression(context.arguments);
        this.updateImplicitReceivers(context);
        this.makeNamesUnique(context.scope);
        this.updateTypes(context);
        List ranges = null;
        ranges = this.hasReturnValue() ? (context.callMode == 41 ? this.getStatementRanges() : this.getExpressionRanges()) : ((last = this.getLastStatement()) != null && last.getNodeType() == 41 ? this.getReturnStatementRanges() : this.getStatementRanges());
        MultiTextEdit dummy = new MultiTextEdit();
        this.fRewriter.rewriteNode(this.fBuffer, (TextEdit)dummy);
        int size = ranges.size();
        RangeMarker[] markers = new RangeMarker[size];
        int i = 0;
        while (i < markers.length) {
            IRegion range = (IRegion)ranges.get(i);
            markers[i] = new RangeMarker(range.getOffset(), range.getLength());
            ++i;
        }
        if (size <= 1) {
            split = Integer.MAX_VALUE;
        } else {
            IRegion region = (IRegion)ranges.get(0);
            split = region.getOffset() + region.getLength();
        }
        TextEdit[] edits = dummy.removeChildren();
        int i2 = 0;
        while (i2 < edits.length) {
            TextEdit edit = edits[i2];
            int pos = edit.getOffset() >= split ? 1 : 0;
            markers[pos].addChild(edit);
            ++i2;
        }
        MultiTextEdit root = new MultiTextEdit();
        root.addChildren((TextEdit[])markers);
        TextBufferEditor editor = new TextBufferEditor(this.fBuffer);
        editor.add((TextEdit)root);
        UndoEdit undo = editor.performEdits(null);
        String[] result = this.getBlocks(markers);
        TextBufferEditor undoEditor = new TextBufferEditor(this.fBuffer);
        undoEditor.add(undo);
        undoEditor.performEdits(null);
        this.fRewriter.removeModifications();
        return result;
    }

    private void replaceParameterWithExpression(String[] expressions) {
        int i = 0;
        while (i < expressions.length) {
            String expression = expressions[i];
            ParameterData parameter = this.getParameterData(i);
            List references = parameter.references();
            Iterator iter = references.iterator();
            while (iter.hasNext()) {
                ASTNode element = (ASTNode)iter.next();
                ASTNode newNode = this.fRewriter.createPlaceholder(expression, ASTRewrite.getPlaceholderType(element));
                this.fRewriter.markAsReplaced(element, newNode);
            }
            ++i;
        }
    }

    private void makeNamesUnique(CodeScopeBuilder.Scope scope) {
        Collection usedCalleeNames = this.fAnalyzer.getUsedNames();
        Iterator iter = usedCalleeNames.iterator();
        while (iter.hasNext()) {
            SourceAnalyzer.NameData nd = (SourceAnalyzer.NameData)iter.next();
            if (!scope.isInUse(nd.getName())) continue;
            String newName = scope.createName(nd.getName(), true);
            List references = nd.references();
            Iterator refs = references.iterator();
            while (refs.hasNext()) {
                SimpleName element = (SimpleName)refs.next();
                ASTNode newNode = this.fRewriter.createPlaceholder(newName, 3);
                this.fRewriter.markAsReplaced((ASTNode)element, newNode);
            }
        }
    }

    private void updateImplicitReceivers(CallContext context) {
        if (context.receiver == null) {
            return;
        }
        List implicitReceivers = this.fAnalyzer.getImplicitReceivers();
        Iterator iter = implicitReceivers.iterator();
        while (iter.hasNext()) {
            ASTNode node = (ASTNode)iter.next();
            if (node instanceof MethodInvocation) {
                MethodInvocation inv = (MethodInvocation)node;
                inv.setExpression(this.createReceiver(context, (IMethodBinding)inv.getName().resolveBinding()));
                continue;
            }
            if (node instanceof ClassInstanceCreation) {
                ClassInstanceCreation inst = (ClassInstanceCreation)node;
                inst.setExpression(this.createReceiver(context, inst.resolveConstructorBinding()));
                continue;
            }
            if (!(node instanceof Expression)) continue;
            this.fRewriter.markAsReplaced(node, this.fRewriter.createPlaceholder(context.receiver, 3));
        }
    }

    private void updateTypes(CallContext context) {
        ImportRewrite importer = context.importer;
        Iterator iter = this.fAnalyzer.getUsedTypes().iterator();
        while (iter.hasNext()) {
            Name element = (Name)iter.next();
            ITypeBinding binding = ASTNodes.getTypeBinding(element);
            if (binding == null || binding.isLocal()) continue;
            String s = importer.addImport(binding);
            if (ASTNodes.asString((ASTNode)element).equals(s)) continue;
            this.fRewriter.markAsReplaced((ASTNode)element, this.fRewriter.createPlaceholder(s, 3));
        }
    }

    private Expression createReceiver(CallContext context, IMethodBinding method) {
        String receiver = context.receiver;
        if (!context.receiverIsStatic && Modifier.isStatic((int)method.getModifiers())) {
            receiver = context.importer.addImport(this.fDeclaration.resolveBinding().getDeclaringClass());
        }
        Expression exp = (Expression)this.fRewriter.createPlaceholder(receiver, 3);
        this.fRewriter.markAsInserted((ASTNode)exp);
        return exp;
    }

    private ASTNode getLastStatement() {
        List statements = this.fDeclaration.getBody().statements();
        if (statements.isEmpty()) {
            return null;
        }
        return (ASTNode)statements.get(statements.size() - 1);
    }

    private List getReturnStatementRanges() {
        ArrayList<IRegion> result = new ArrayList<IRegion>(1);
        List statements = this.fDeclaration.getBody().statements();
        int size = statements.size();
        if (size <= 1) {
            return result;
        }
        result.add(this.createRange(statements, size - 2));
        return result;
    }

    private List getStatementRanges() {
        ArrayList<IRegion> result = new ArrayList<IRegion>(1);
        List statements = this.fDeclaration.getBody().statements();
        int size = statements.size();
        if (size == 0) {
            return result;
        }
        result.add(this.createRange(statements, size - 1));
        return result;
    }

    private List getExpressionRanges() {
        ArrayList<Object> result = new ArrayList<Object>(2);
        List statements = this.fDeclaration.getBody().statements();
        ReturnStatement rs = null;
        int size = statements.size();
        switch (size) {
            case 0: {
                return result;
            }
            case 1: {
                ASTNode node = (ASTNode)statements.get(0);
                if (node.getNodeType() == 41) {
                    rs = (ReturnStatement)node;
                    break;
                }
                result.add(new Region(node.getStartPosition(), node.getLength()));
                break;
            }
            default: {
                ASTNode node = (ASTNode)statements.get(size - 1);
                if (node.getNodeType() == 41) {
                    result.add(this.createRange(statements, size - 2));
                    rs = (ReturnStatement)node;
                    break;
                }
                result.add(this.createRange(statements, size - 1));
            }
        }
        if (rs != null) {
            Expression exp = rs.getExpression();
            result.add(new Region(exp.getStartPosition(), exp.getLength()));
        }
        return result;
    }

    private IRegion createRange(List statements, int end) {
        int start = ((ASTNode)statements.get(0)).getStartPosition();
        ASTNode last = (ASTNode)statements.get(end);
        int length = last.getStartPosition() - start + last.getLength();
        Region range = new Region(start, length);
        return range;
    }

    private String[] getBlocks(RangeMarker[] markers) {
        String[] result = new String[markers.length];
        int i = 0;
        while (i < markers.length) {
            RangeMarker marker = markers[i];
            String content = this.fBuffer.getContent(marker.getOffset(), marker.getLength());
            String[] lines = Strings.convertIntoLines(content);
            Strings.trimIndentation(lines, CodeFormatterUtil.getTabWidth(), false);
            result[i] = Strings.concatenate(lines, this.fBuffer.getLineDelimiter());
            ++i;
        }
        return result;
    }

    private class ReturnAnalyzer
    extends ASTVisitor {
        ReturnAnalyzer() {
        }

        public boolean visit(ReturnStatement node) {
            Expression expression = node.getExpression();
            if (!ASTNodes.isLiteral(expression) && !(expression instanceof Name)) {
                SourceProvider.this.fMustEvalReturnedExpression = true;
            }
            if (Invocations.isInvocation((ASTNode)expression) || expression instanceof ClassInstanceCreation) {
                SourceProvider.this.fReturnValueNeedsLocalVariable = false;
            }
            SourceProvider.this.fReturnExpressions.add(expression);
            return false;
        }
    }

    static class VariableReferenceFinder
    extends ASTVisitor {
        private boolean fResult;
        private IVariableBinding fBinding;

        public VariableReferenceFinder(IVariableBinding binding) {
            this.fBinding = binding;
        }

        public boolean getResult() {
            return this.fResult;
        }

        public boolean visit(SimpleName node) {
            if (!this.fResult) {
                this.fResult = Bindings.equals((IBinding)this.fBinding, node.resolveBinding());
            }
            return false;
        }
    }
}

