/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.structure.MoveStaticMembersRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;

public class IntroduceParameterRefactoring
extends Refactoring {
    private ICompilationUnit fSourceCU;
    private int fSelectionStart;
    private int fSelectionLength;
    private final CodeGenerationSettings fSettings;
    private String fParameterName;
    private MoveStaticMembersRefactoring.ASTData fSource;
    private Expression fSelectedExpression;
    private MethodDeclaration fMethodDeclaration;
    private String[] fExcludedParameterNames;
    private CompositeChange fChange;
    private ICompilationUnit[] fAffectedCUs;
    static /* synthetic */ Class class$0;

    private IntroduceParameterRefactoring(ICompilationUnit cu, int selectionStart, int selectionLength, CodeGenerationSettings settings) throws CoreException {
        Assert.isTrue(cu != null && cu.exists());
        Assert.isTrue(selectionStart >= 0);
        Assert.isTrue(selectionLength >= 0);
        Assert.isNotNull(settings);
        this.fSourceCU = cu;
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fSettings = settings;
        this.fParameterName = "";
    }

    public static boolean isAvailable(ASTNode[] selectedNodes, ASTNode coveringNode) {
        return Checks.isExtractableExpression(selectedNodes, coveringNode);
    }

    public static IntroduceParameterRefactoring create(ICompilationUnit cu, int selectionStart, int selectionLength, CodeGenerationSettings settings) throws CoreException {
        return new IntroduceParameterRefactoring(cu, selectionStart, selectionLength, settings);
    }

    public String getName() {
        return RefactoringCoreMessages.getString("IntroduceParameterRefactoring.name");
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result;
        block5: {
            block4: {
                RefactoringStatus refactoringStatus;
                try {
                    pm.beginTask("", 7);
                    if (this.fSourceCU.isStructureKnown()) break block4;
                    refactoringStatus = RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("IntroduceParameterRefactoring.syntax_error"));
                    Object var3_5 = null;
                }
                catch (Throwable throwable) {
                    Object var3_8 = null;
                    pm.done();
                    throw throwable;
                }
                pm.done();
                return refactoringStatus;
            }
            pm.worked(1);
            this.fSource = new MoveStaticMembersRefactoring.ASTData(this.fSourceCU, true);
            this.initializeSelectedExpression();
            pm.worked(1);
            result = this.checkSelection((IProgressMonitor)new SubProgressMonitor(pm, 5));
            if (!result.hasFatalError()) break block5;
            RefactoringStatus refactoringStatus = result;
            Object var3_6 = null;
            pm.done();
            return refactoringStatus;
        }
        this.initializeExcludedParameterNames();
        RefactoringStatus refactoringStatus = result;
        Object var3_7 = null;
        pm.done();
        return refactoringStatus;
    }

    private void initializeSelectedExpression() throws JavaModelException {
        IASTFragment fragment = ASTFragmentFactory.createFragmentForSourceRange(new SourceRange(this.fSelectionStart, this.fSelectionLength), (ASTNode)this.fSource.root, this.fSource.unit);
        if (fragment instanceof IExpressionFragment) {
            Expression expression = ((IExpressionFragment)fragment).getAssociatedExpression();
            if (fragment.getStartPosition() == expression.getStartPosition() && fragment.getLength() == expression.getLength()) {
                this.fSelectedExpression = expression;
            }
        }
    }

    private RefactoringStatus checkSelection(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result;
        block13: {
            block12: {
                block11: {
                    block9: {
                        RefactoringStatus refactoringStatus;
                        try {
                            pm.beginTask("", 7);
                            if (this.fSelectedExpression != null) break block9;
                            String message = RefactoringCoreMessages.getString("IntroduceParameterRefactoring.select");
                            refactoringStatus = CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.fSource.root, message);
                            Object var3_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_14 = null;
                            pm.done();
                            throw throwable;
                        }
                        pm.done();
                        return refactoringStatus;
                    }
                    pm.worked(1);
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.core.dom.MethodDeclaration;").getComponentType();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.fMethodDeclaration = (MethodDeclaration)ASTNodes.getParent((ASTNode)this.fSelectedExpression, clazz);
                    if (this.fMethodDeclaration != null) break block11;
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("IntroduceParameterRefactoring.expression_in_method"));
                    Object var3_10 = null;
                    pm.done();
                    return refactoringStatus;
                }
                pm.worked(1);
                result = new RefactoringStatus();
                result.merge(this.checkExpression());
                if (!result.hasFatalError()) break block12;
                RefactoringStatus refactoringStatus = result;
                Object var3_11 = null;
                pm.done();
                return refactoringStatus;
            }
            pm.worked(1);
            result.merge(this.checkExpressionBinding());
            if (!result.hasFatalError()) break block13;
            RefactoringStatus refactoringStatus = result;
            Object var3_12 = null;
            pm.done();
            return refactoringStatus;
        }
        pm.worked(1);
        RefactoringStatus refactoringStatus = result;
        Object var3_13 = null;
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkExpression() throws JavaModelException {
        Expression selectedExpression = this.fSelectedExpression;
        if (selectedExpression instanceof Name && selectedExpression.getParent() instanceof ClassInstanceCreation) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ExtractTempRefactoring.name_in_new"));
        }
        if (selectedExpression instanceof NullLiteral) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ExtractTempRefactoring.null_literals"));
        }
        if (selectedExpression instanceof ArrayInitializer) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ExtractTempRefactoring.array_initializer"));
        }
        if (selectedExpression instanceof Assignment) {
            if (selectedExpression.getParent() instanceof Expression) {
                return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ExtractTempRefactoring.assignment"));
            }
            return null;
        }
        if (selectedExpression instanceof ConditionalExpression) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ExtractTempRefactoring.single_conditional_expression"));
        }
        if (selectedExpression instanceof SimpleName && ((SimpleName)selectedExpression).isDeclaration()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("ExtractTempRefactoring.names_in_declarations"));
        }
        return null;
    }

    private RefactoringStatus checkExpressionBinding() throws JavaModelException {
        return this.checkExpressionFragmentIsRValue();
    }

    private RefactoringStatus checkExpressionFragmentIsRValue() throws JavaModelException {
        switch (Checks.checkExpressionIsRValue(this.fSelectedExpression)) {
            case 1: {
                return RefactoringStatus.createStatus(4, RefactoringCoreMessages.getString("IntroduceParameterRefactoring.select"), null, null, 64);
            }
            case 2: {
                return RefactoringStatus.createStatus(4, RefactoringCoreMessages.getString("IntroduceParameterRefactoring.no_void"), null, null, 65);
            }
            case 0: {
                return new RefactoringStatus();
            }
        }
        Assert.isTrue(false);
        return null;
    }

    public void setParameterName(String name) {
        Assert.isNotNull(name);
        this.fParameterName = name;
    }

    public String guessedParameterName() {
        try {
            String candidate = this.guessParameterNameFromExpression(this.fSelectedExpression);
            if (candidate != null) {
                return candidate;
            }
        }
        catch (JavaModelException javaModelException) {
            return this.fParameterName;
        }
        return this.fParameterName;
    }

    private String guessParameterNameFromExpression(Expression selectedExpression) throws JavaModelException {
        ITypeBinding expressionBinding = selectedExpression.resolveTypeBinding();
        String packageName = IntroduceParameterRefactoring.getPackageName(expressionBinding);
        String typeName = IntroduceParameterRefactoring.getQualifiedName(expressionBinding);
        if (typeName.length() == 0) {
            typeName = expressionBinding.getName();
        }
        if (typeName.length() == 0) {
            return this.fParameterName;
        }
        String[] candidates = NamingConventions.suggestArgumentNames((IJavaProject)this.fSourceCU.getJavaProject(), (String)packageName, (String)typeName, (int)expressionBinding.getDimensions(), (String[])this.fExcludedParameterNames);
        if (candidates.length > 0) {
            return candidates[0];
        }
        return null;
    }

    private static String getPackageName(ITypeBinding typeBinding) {
        if (typeBinding.getPackage() != null) {
            return typeBinding.getPackage().getName();
        }
        return "";
    }

    private static String getQualifiedName(ITypeBinding typeBinding) {
        if (typeBinding.isAnonymous()) {
            return IntroduceParameterRefactoring.getQualifiedName(typeBinding.getSuperclass());
        }
        if (!typeBinding.isArray()) {
            return typeBinding.getQualifiedName();
        }
        return typeBinding.getElementType().getQualifiedName();
    }

    private void initializeExcludedParameterNames() throws JavaModelException {
        IBinding[] bindings = new ScopeAnalyzer(this.fSource.root).getDeclarationsInScope(this.fSelectedExpression.getStartPosition(), 2);
        this.fExcludedParameterNames = new String[bindings.length];
        int i = 0;
        while (i < this.fExcludedParameterNames.length) {
            this.fExcludedParameterNames[i] = bindings[i].getName();
            ++i;
        }
    }

    public RefactoringStatus validateInput() {
        RefactoringStatus status = this.checkExcludedParameterNames();
        if (!status.isOK()) {
            return status;
        }
        return Checks.checkTempName(this.fParameterName);
    }

    private RefactoringStatus checkExcludedParameterNames() {
        int i = 0;
        while (i < this.fExcludedParameterNames.length) {
            if (this.fParameterName.equals(this.fExcludedParameterNames[i])) {
                return RefactoringStatus.createErrorStatus(RefactoringCoreMessages.getString("IntroduceParameterRefactoring.duplicate_name"));
            }
            ++i;
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask(RefactoringCoreMessages.getString("IntroduceParameterRefactoring.preview"), 5);
        RefactoringStatus result = this.checkExcludedParameterNames();
        if (result.hasFatalError()) {
            return result;
        }
        this.fChange = new CompositeChange(RefactoringCoreMessages.getString("IntroduceParameterRefactoring.introduce_parameter"));
        try {
            this.fSource.reset(this.fSettings);
            this.changeSource();
            pm.worked(1);
            result.merge(this.changeReferences(new SubProgressMonitor(pm, 3)));
            this.fChange.add(this.fSource.createChange());
            HashSet<ICompilationUnit> cus = new HashSet<ICompilationUnit>();
            cus.add(this.fSource.unit);
            cus.addAll(Arrays.asList(this.fAffectedCUs));
            result.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(cus.toArray(new ICompilationUnit[cus.size()]))));
            if (result.hasFatalError()) {
                return result;
            }
            pm.worked(1);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
        return result;
    }

    private void changeSource() throws CoreException {
        AST ast = this.fSource.root.getAST();
        SimpleName newExpression = ast.newSimpleName(this.fParameterName);
        this.fSource.rewriter.markAsReplaced((ASTNode)this.fSelectedExpression, (ASTNode)newExpression, this.fSource.createGroupDescription(RefactoringCoreMessages.getString("IntroduceParameterRefactoring.replace")));
        SingleVariableDeclaration param = ast.newSingleVariableDeclaration();
        param.setName(ast.newSimpleName(this.fParameterName));
        String type = this.fSource.imports.addImport(this.fSelectedExpression.resolveTypeBinding());
        param.setType((Type)this.fSource.rewriter.createPlaceholder(type, 6));
        this.fMethodDeclaration.parameters().add(param);
        this.fSource.rewriter.markAsInserted((ASTNode)param, this.fSource.createGroupDescription(RefactoringCoreMessages.getString("IntroduceParameterRefactoring.add_parameter")));
    }

    private RefactoringStatus changeReferences(SubProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        this.fAffectedCUs = this.findAffectedCompilationUnits((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pm, 1));
        IMethodBinding method = this.fMethodDeclaration.resolveBinding();
        SubProgressMonitor sub = new SubProgressMonitor((IProgressMonitor)pm, 1);
        sub.beginTask("", this.fAffectedCUs.length);
        int i = 0;
        while (i < this.fAffectedCUs.length) {
            MoveStaticMembersRefactoring.ASTData ast = this.getASTData(this.fAffectedCUs[i]);
            ReferenceAnalyzer analyzer = new ReferenceAnalyzer(ast, method, this.fSelectedExpression);
            ast.root.accept((ASTVisitor)analyzer);
            if (ast != this.fSource) {
                this.fChange.add(ast.createChange());
            }
            sub.worked(1);
            ++i;
        }
        return new RefactoringStatus();
    }

    private MoveStaticMembersRefactoring.ASTData getASTData(ICompilationUnit unit) throws CoreException {
        if (this.fSource.unit.equals(unit)) {
            return this.fSource;
        }
        return new MoveStaticMembersRefactoring.ASTData(unit, true, this.fSettings);
    }

    private ICompilationUnit[] findAffectedCompilationUnits(IProgressMonitor pm) throws JavaModelException {
        IMethod method = Bindings.findMethod(this.fMethodDeclaration.resolveBinding(), this.fSourceCU.getJavaProject());
        Assert.isTrue(method != null);
        ICompilationUnit[] result = RefactoringSearchEngine.findAffectedCompilationUnits(pm, RefactoringScopeFactory.create((IJavaElement)method), SearchEngine.createSearchPattern((IJavaElement)method, (int)2));
        return result;
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        pm.done();
        return this.fChange;
    }

    private static class ReferenceAnalyzer
    extends ASTVisitor {
        private MoveStaticMembersRefactoring.ASTData fAst;
        private IMethodBinding fMethodBinding;
        private Expression fExpression;

        public ReferenceAnalyzer(MoveStaticMembersRefactoring.ASTData astData, IMethodBinding methodBinding, Expression expression) {
            this.fExpression = expression;
            this.fAst = astData;
            this.fMethodBinding = methodBinding;
        }

        public boolean visit(MethodInvocation node) {
            if (Bindings.equals((IBinding)this.fMethodBinding, (IBinding)node.resolveMethodBinding())) {
                Expression argument = (Expression)ASTNode.copySubtree((AST)this.fAst.root.getAST(), (ASTNode)this.fExpression);
                node.arguments().add(argument);
                this.fAst.rewriter.markAsInserted((ASTNode)argument, this.fAst.createGroupDescription(RefactoringCoreMessages.getString("IntroduceParameterRefactoring.add_argument")));
            }
            return super.visit(node);
        }
    }
}

