/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.JavaElementMapper;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.code.CallInliner;
import org.eclipse.jdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.jdt.internal.corext.refactoring.code.SourceProvider;
import org.eclipse.jdt.internal.corext.refactoring.code.TargetProvider;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.textmanipulation.GroupDescription;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class InlineMethodRefactoring
extends Refactoring {
    public static final int INLINE_ALL = 31;
    public static final int INLINE_SINGLE = 32;
    private ICompilationUnit fInitialCUnit;
    private ASTNode fInitialNode;
    private CodeGenerationSettings fCodeGenerationSettings;
    private TextChangeManager fChangeManager;
    private SourceProvider fSourceProvider;
    private TargetProvider fTargetProvider;
    private boolean fSaveChanges;
    private boolean fDeleteSource;
    private int fCurrentMode;
    static /* synthetic */ Class class$0;

    private InlineMethodRefactoring(ICompilationUnit unit, ASTNode node, CodeGenerationSettings settings) {
        Assert.isNotNull(unit);
        Assert.isNotNull(node);
        Assert.isNotNull(settings);
        this.fInitialCUnit = unit;
        this.fInitialNode = node;
        this.fCurrentMode = node.getNodeType();
        this.fCodeGenerationSettings = settings;
        this.fSaveChanges = true;
    }

    private InlineMethodRefactoring(ICompilationUnit unit, MethodInvocation node, CodeGenerationSettings settings) {
        this(unit, (ASTNode)node, settings);
        this.fTargetProvider = TargetProvider.create(unit, node);
        this.fDeleteSource = false;
    }

    private InlineMethodRefactoring(ICompilationUnit unit, SuperMethodInvocation node, CodeGenerationSettings settings) {
        this(unit, (ASTNode)node, settings);
        this.fTargetProvider = TargetProvider.create(unit, node);
        this.fDeleteSource = false;
    }

    private InlineMethodRefactoring(ICompilationUnit unit, ConstructorInvocation node, CodeGenerationSettings settings) {
        this(unit, (ASTNode)node, settings);
        this.fTargetProvider = TargetProvider.create(unit, node);
        this.fDeleteSource = false;
    }

    private InlineMethodRefactoring(ICompilationUnit unit, MethodDeclaration node, CodeGenerationSettings settings) {
        this(unit, (ASTNode)node, settings);
        this.fSourceProvider = new SourceProvider(unit, node);
        this.fTargetProvider = TargetProvider.create(unit, node);
        this.fDeleteSource = true;
    }

    public static boolean isAvailable(IMethod method) throws JavaModelException {
        return Checks.isAvailable((IJavaElement)method);
    }

    public static InlineMethodRefactoring create(ICompilationUnit unit, int offset, int length, CodeGenerationSettings settings) {
        ASTNode node = InlineMethodRefactoring.getTargetNode(unit, offset, length);
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 32) {
            return new InlineMethodRefactoring(unit, (MethodInvocation)node, settings);
        }
        if (node.getNodeType() == 31) {
            return new InlineMethodRefactoring(unit, (MethodDeclaration)node, settings);
        }
        if (node.getNodeType() == 48) {
            return new InlineMethodRefactoring(unit, (SuperMethodInvocation)node, settings);
        }
        if (node.getNodeType() == 17) {
            return new InlineMethodRefactoring(unit, (ConstructorInvocation)node, settings);
        }
        return null;
    }

    public String getName() {
        return RefactoringCoreMessages.getString("InlineMethodRefactoring.name");
    }

    public void setSaveChanges(boolean save) {
        this.fSaveChanges = save;
    }

    public boolean getDeleteSource() {
        return this.fDeleteSource;
    }

    public void setDeleteSource(boolean remove) {
        this.fDeleteSource = remove;
    }

    public int getInitialMode() {
        return this.fInitialNode.getNodeType();
    }

    public RefactoringStatus setCurrentMode(int mode) throws JavaModelException {
        Assert.isTrue(this.getInitialMode() == 32);
        this.fCurrentMode = mode;
        this.fTargetProvider = mode == 32 ? TargetProvider.create(this.fInitialCUnit, (MethodInvocation)this.fInitialNode) : TargetProvider.create(this.fSourceProvider.getCompilationUnit(), this.fSourceProvider.getDeclaration());
        return this.fTargetProvider.checkActivation((IProgressMonitor)new NullProgressMonitor());
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.fSourceProvider == null && Invocations.isInvocation(this.fInitialNode)) {
            this.fSourceProvider = InlineMethodRefactoring.resolveSourceProvider(result, this.fInitialCUnit, this.fInitialNode);
            if (result.hasFatalError()) {
                return result;
            }
        }
        this.fTargetProvider.setSourceProvider(this.fSourceProvider);
        result.merge(this.fSourceProvider.checkActivation(pm));
        result.merge(this.fTargetProvider.checkActivation(pm));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInput(IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 3);
        this.fChangeManager = new TextChangeManager();
        RefactoringStatus result = new RefactoringStatus();
        this.fSourceProvider.initialize();
        this.fTargetProvider.initialize();
        pm.setTaskName(RefactoringCoreMessages.getString("InlineMethodRefactoring.searching"));
        ICompilationUnit[] units = this.fTargetProvider.getAffectedCompilationUnits((IProgressMonitor)new SubProgressMonitor(pm, 1));
        result.merge(Checks.validateModifiesFiles(this.getFilesToBeModified(units)));
        if (result.hasFatalError()) {
            return result;
        }
        this.checkOverridden(result, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        SubProgressMonitor sub = new SubProgressMonitor(pm, 1);
        sub.beginTask("", units.length * 3);
        int c = 0;
        while (c < units.length) {
            Object var18_21;
            ICompilationUnit unit = units[c];
            sub.subTask(RefactoringCoreMessages.getFormattedString("InlineMethodRefactoring.processing", unit.getElementName()));
            CallInliner inliner = null;
            try {
                block16: {
                    try {
                        boolean added = false;
                        MultiTextEdit root = new MultiTextEdit();
                        CompilationUnitChange change = (CompilationUnitChange)this.fChangeManager.get(unit);
                        change.setSave(this.fSaveChanges);
                        change.setEdit((TextEdit)root);
                        inliner = new CallInliner(unit, this.fSourceProvider, this.fCodeGenerationSettings);
                        BodyDeclaration[] bodies = this.fTargetProvider.getAffectedBodyDeclarations(unit, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                        int b = 0;
                        while (b < bodies.length) {
                            BodyDeclaration body = bodies[b];
                            inliner.initialize(body);
                            ASTNode[] invocations = this.fTargetProvider.getInvocations(body, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                            int i = 0;
                            while (i < invocations.length) {
                                ASTNode invocation = invocations[i];
                                result.merge(inliner.initialize(invocation, this.fTargetProvider.getStatusSeverity()));
                                if (result.hasFatalError()) break;
                                if (result.getSeverity() < this.fTargetProvider.getStatusSeverity()) {
                                    added = true;
                                    TextEdit edit = inliner.perform();
                                    change.addGroupDescription(new GroupDescription(RefactoringCoreMessages.getString("InlineMethodRefactoring.edit.inline"), new TextEdit[]{edit}));
                                    root.addChild(edit);
                                } else {
                                    this.fDeleteSource = false;
                                }
                                ++i;
                            }
                            ++b;
                        }
                        if (!added) {
                            this.fChangeManager.remove(unit);
                            break block16;
                        }
                        ImportRewrite rewrite = inliner.getImportEdit();
                        if (!rewrite.isEmpty()) {
                            TextEdit edit = rewrite.createEdit(inliner.getBuffer());
                            root.addChild(edit);
                            change.addGroupDescription(new GroupDescription(RefactoringCoreMessages.getString("InlineMethodRefactoring.edit.import"), new TextEdit[]{edit}));
                        }
                    }
                    catch (JavaModelException e) {
                        throw e;
                    }
                    catch (CoreException e) {
                        throw new JavaModelException(e);
                    }
                }
                var18_21 = null;
                if (inliner != null) {
                    inliner.dispose();
                }
            }
            catch (Throwable throwable) {
                var18_21 = null;
                if (inliner != null) {
                    inliner.dispose();
                }
                throw throwable;
            }
            sub.worked(1);
            ++c;
        }
        sub.done();
        pm.done();
        return result;
    }

    public IChange createChange(IProgressMonitor pm) throws JavaModelException {
        if (this.fDeleteSource && this.fCurrentMode == 31) {
            try {
                TextChange change = this.fChangeManager.get(this.fSourceProvider.getCompilationUnit());
                TextEdit delete = this.fSourceProvider.getDeleteEdit();
                GroupDescription description = new GroupDescription(RefactoringCoreMessages.getString("InlineMethodRefactoring.edit.delete"), new TextEdit[]{delete});
                TextEdit root = change.getEdit();
                if (root != null) {
                    root.addChild(delete);
                } else {
                    change.setEdit(delete);
                }
                change.addGroupDescription(description);
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
        return new CompositeChange(RefactoringCoreMessages.getString("InlineMethodRefactoring.edit.inlineCall"), this.fChangeManager.getAllChanges());
    }

    private static SourceProvider resolveSourceProvider(RefactoringStatus status, ICompilationUnit unit, ASTNode invocation) throws JavaModelException {
        IMethodBinding methodBinding;
        CompilationUnit root = (CompilationUnit)invocation.getRoot();
        MethodDeclaration declaration = (MethodDeclaration)root.findDeclaringNode((IBinding)(methodBinding = Invocations.resolveBinding(invocation)));
        if (declaration != null) {
            return new SourceProvider(unit, declaration);
        }
        IMethod method = Bindings.findMethod(methodBinding, unit.getJavaProject());
        if (method != null) {
            ICompilationUnit source = method.getCompilationUnit();
            if (source == null) {
                status.addFatalError(RefactoringCoreMessages.getString("InlineMethodRefactoring.error.classFile"));
                return null;
            }
            source = JavaModelUtil.toWorkingCopy(source);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.core.dom.MethodDeclaration;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((declaration = (MethodDeclaration)JavaElementMapper.perform((IMember)method, clazz)) != null) {
                return new SourceProvider(source, declaration);
            }
        }
        status.addFatalError(RefactoringCoreMessages.getString("InlineMethodRefactoring.error.noMethodDeclaration"));
        return null;
    }

    private static ASTNode getTargetNode(ICompilationUnit unit, int offset, int length) {
        CompilationUnit root = AST.parseCompilationUnit((ICompilationUnit)unit, (boolean)true);
        ASTNode node = null;
        try {
            node = InlineMethodRefactoring.checkNode(NodeFinder.perform((ASTNode)root, offset, length, unit));
        }
        catch (JavaModelException javaModelException) {
            node = null;
        }
        if (node != null) {
            return node;
        }
        return InlineMethodRefactoring.checkNode(NodeFinder.perform((ASTNode)root, offset, length));
    }

    private static ASTNode checkNode(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 42) {
            node = node.getParent();
        } else if (node.getNodeType() == 21) {
            node = ((ExpressionStatement)node).getExpression();
        }
        switch (node.getNodeType()) {
            case 17: 
            case 31: 
            case 32: 
            case 48: {
                return node;
            }
        }
        return null;
    }

    private IFile[] getFilesToBeModified(ICompilationUnit[] units) {
        IFile file;
        ArrayList<IFile> result = new ArrayList<IFile>(units.length + 1);
        int i = 0;
        while (i < units.length) {
            file = this.getFile(units[i]);
            if (file != null) {
                result.add(file);
            }
            ++i;
        }
        file = this.getFile(this.fSourceProvider.getCompilationUnit());
        if (file != null && !result.contains(file)) {
            result.add(file);
        }
        return result.toArray(new IFile[result.size()]);
    }

    private IFile getFile(ICompilationUnit unit) {
        IResource resource = (unit = JavaModelUtil.toOriginal(unit)).getResource();
        if (resource != null && resource.getType() == 1) {
            return (IFile)resource;
        }
        return null;
    }

    private void checkOverridden(RefactoringStatus status, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 9);
        pm.setTaskName(RefactoringCoreMessages.getString("InlineMethodRefactoring.checking.overridden"));
        MethodDeclaration decl = this.fSourceProvider.getDeclaration();
        IMethod method = Bindings.findMethod(decl.resolveBinding(), this.fSourceProvider.getCompilationUnit().getJavaProject());
        if (method == null || Flags.isPrivate((int)method.getFlags())) {
            pm.worked(8);
            return;
        }
        IType type = method.getDeclaringType();
        ITypeHierarchy hierarchy = type.newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(pm, 6));
        this.checkSubTypes(status, method, hierarchy.getAllSubtypes(type), (IProgressMonitor)new SubProgressMonitor(pm, 1));
        this.checkSuperClasses(status, method, hierarchy.getAllSuperclasses(type), (IProgressMonitor)new SubProgressMonitor(pm, 1));
        this.checkSuperInterfaces(status, method, hierarchy.getAllSuperInterfaces(type), (IProgressMonitor)new SubProgressMonitor(pm, 1));
        pm.setTaskName("");
    }

    private void checkSubTypes(RefactoringStatus result, IMethod method, IType[] types, IProgressMonitor pm) {
        this.checkTypes(result, method, types, "InlineMethodRefactoring.checking.overridden.error", pm);
    }

    private void checkSuperClasses(RefactoringStatus result, IMethod method, IType[] types, IProgressMonitor pm) {
        this.checkTypes(result, method, types, "InlineMethodRefactoring.checking.overrides.error", pm);
    }

    private void checkSuperInterfaces(RefactoringStatus result, IMethod method, IType[] types, IProgressMonitor pm) {
        this.checkTypes(result, method, types, "InlineMethodRefactoring.checking.implements.error", pm);
    }

    private void checkTypes(RefactoringStatus result, IMethod method, IType[] types, String key, IProgressMonitor pm) {
        pm.beginTask("", types.length);
        int i = 0;
        while (i < types.length) {
            pm.worked(1);
            IMethod[] overridden = types[i].findMethods(method);
            if (overridden != null && overridden.length > 0) {
                result.addError(RefactoringCoreMessages.getFormattedString(key, types[i].getElementName()), JavaStatusContext.create((IMember)overridden[0]));
            }
            ++i;
        }
    }
}

