/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;

public class CodeRefactoringUtil {
    private CodeRefactoringUtil() {
    }

    public static RefactoringStatus checkMethodSyntaxErrors(int selectionStart, int selectionLength, CompilationUnit cuNode, String invalidSelectionMessage) {
        SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength(selectionStart, selectionLength), true);
        cuNode.accept((ASTVisitor)analyzer);
        ASTNode coveringNode = analyzer.getLastCoveringNode();
        if (!(coveringNode instanceof Block) || !(coveringNode.getParent() instanceof MethodDeclaration)) {
            return RefactoringStatus.createFatalErrorStatus(invalidSelectionMessage);
        }
        if (ASTNodes.getMessages(coveringNode, 0).length == 0) {
            return RefactoringStatus.createFatalErrorStatus(invalidSelectionMessage);
        }
        MethodDeclaration methodDecl = (MethodDeclaration)coveringNode.getParent();
        String[] keys = new String[]{methodDecl.getName().getIdentifier()};
        String message = RefactoringCoreMessages.getFormattedString("CodeRefactoringUtil.error.message", keys);
        return RefactoringStatus.createFatalErrorStatus(message);
    }

    public static int getIndentationLevel(ASTNode node, IFile file) throws CoreException {
        int n;
        block2: {
            TextBuffer buffer = null;
            try {
                buffer = TextBuffer.acquire(file);
                int startLine = buffer.getLineOfOffset(node.getStartPosition());
                n = buffer.getLineIndent(startLine, CodeFormatterUtil.getTabWidth());
                Object var4_5 = null;
                if (buffer == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var4_6 = null;
                    if (buffer == null) break block3;
                    TextBuffer.release(buffer);
                }
                throw throwable;
            }
            TextBuffer.release(buffer);
        }
        return n;
    }
}

