/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.jdt.internal.corext.dom.LocalVariableIndex;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.TypeBindingVisitor;
import org.eclipse.jdt.internal.corext.dom.TypeRules;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatusEntry;
import org.eclipse.jdt.internal.corext.refactoring.code.CallContext;
import org.eclipse.jdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.jdt.internal.corext.refactoring.code.ParameterData;
import org.eclipse.jdt.internal.corext.refactoring.code.SourceProvider;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.InputFlowAnalyzer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class CallInliner {
    private ICompilationUnit fCUnit;
    private ImportRewrite fImportEdit;
    private TextBuffer fBuffer;
    private SourceProvider fSourceProvider;
    private BodyDeclaration fBodyDeclaration;
    private CodeScopeBuilder.Scope fRootScope;
    private int fNumberOfLocals;
    private ASTNode fInvocation;
    private ASTRewrite fRewriter;
    private List fStatements;
    private int fInsertionIndex;
    private boolean fNeedsStatement;
    private ASTNode fTargetNode;
    private FlowContext fFlowContext;
    private FlowInfo fFlowInfo;
    private CodeScopeBuilder.Scope fInvocationScope;
    private boolean fFieldInitializer;
    private List fLocals;
    private CallContext fContext;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public CallInliner(ICompilationUnit unit, SourceProvider provider, CodeGenerationSettings settings) throws CoreException {
        this.fCUnit = unit;
        this.fBuffer = TextBuffer.acquire(CallInliner.getFile(this.fCUnit));
        this.fSourceProvider = provider;
        this.fImportEdit = new ImportRewrite(this.fCUnit, settings);
        this.fLocals = new ArrayList(3);
    }

    public void dispose() {
        TextBuffer.release(this.fBuffer);
    }

    TextBuffer getBuffer() {
        return this.fBuffer;
    }

    public ImportRewrite getImportEdit() {
        return this.fImportEdit;
    }

    public ASTNode getTargetNode() {
        return this.fTargetNode;
    }

    public void initialize(BodyDeclaration declaration) {
        this.fBodyDeclaration = declaration;
        this.fRootScope = CodeScopeBuilder.perform(declaration, (IBinding)this.fSourceProvider.getDeclaration().resolveBinding());
        this.fNumberOfLocals = 0;
        switch (declaration.getNodeType()) {
            case 28: 
            case 31: {
                this.fNumberOfLocals = LocalVariableIndex.perform(declaration);
            }
        }
    }

    public RefactoringStatus initialize(ASTNode invocation, int severity) {
        RefactoringStatus result = new RefactoringStatus();
        this.fInvocation = invocation;
        this.checkMethodDeclaration(result, severity);
        if (result.getSeverity() >= severity) {
            return result;
        }
        this.initializeRewriter();
        this.initializeTargetNode();
        this.flowAnalysis();
        this.fContext = new CallContext(this.fInvocationScope, this.fTargetNode.getNodeType(), this.fImportEdit);
        this.computeRealArguments();
        this.computeReceiver();
        this.checkInvocationContext(result, severity);
        if (result.getSeverity() >= severity) {
            return result;
        }
        return result;
    }

    private void initializeRewriter() {
        ASTNode parentField = ASTNodes.getParent(this.fInvocation, 23);
        if (parentField != null) {
            this.fRewriter = new ASTRewrite(parentField);
            this.fFieldInitializer = true;
        } else {
            ASTNode parentBlock = ASTNodes.getParent(this.fInvocation, 8);
            Assert.isNotNull(parentBlock);
            this.fRewriter = new ASTRewrite(parentBlock);
        }
    }

    private void initializeTargetNode() {
        ASTNode parent = this.fInvocation.getParent();
        int nodeType = parent.getNodeType();
        this.fTargetNode = nodeType == 21 || nodeType == 41 ? parent : this.fInvocation;
    }

    private void checkMethodDeclaration(RefactoringStatus result, int severity) {
        MethodDeclaration methodDeclaration = this.fSourceProvider.getDeclaration();
        if (this.fInvocation.getNodeType() != 17 && methodDeclaration.isConstructor()) {
            result.addEntry(new RefactoringStatusEntry(RefactoringCoreMessages.getString("CallInliner.constructors"), severity, JavaStatusContext.create(this.fCUnit, this.fInvocation)));
        }
    }

    private void checkInvocationContext(RefactoringStatus result, int severity) {
        ASTNode parent;
        Expression exp;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.core.dom.FieldDeclaration;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (ASTNodes.getParent(this.fInvocation, clazz) != null) {
            if (this.fSourceProvider.getNumberOfStatements() > 1) {
                this.addEntry(result, RefactoringCoreMessages.getString("CallInliner.field_initializer_simple"), 256, severity);
                return;
            }
            int argumentsCount = this.fContext.arguments.length;
            int i = 0;
            while (i < argumentsCount) {
                ParameterData parameter = this.fSourceProvider.getParameterData(i);
                if (parameter.isWrite()) {
                    this.addEntry(result, RefactoringCoreMessages.getString("CallInliner.field_initialize_write_parameter"), 256, severity);
                    return;
                }
                ++i;
            }
            if (this.fLocals.size() > 0) {
                this.addEntry(result, RefactoringCoreMessages.getString("CallInliner.field_initialize_new_local"), 256, severity);
                return;
            }
            VariableDeclarationFragment variable = (VariableDeclarationFragment)ASTNodes.getParent(this.fInvocation, 59);
            if (this.fSourceProvider.isVariableReferenced(variable.resolveBinding())) {
                this.addEntry(result, RefactoringCoreMessages.getString("CallInliner.field_initialize_self_reference"), 256, severity);
                return;
            }
        }
        if (this.fSourceProvider.isExecutionFlowInterrupted()) {
            VariableDeclaration vDecl;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("[Lorg.eclipse.jdt.core.dom.VariableDeclaration;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((vDecl = (VariableDeclaration)ASTNodes.getParent(this.fInvocation, clazz2)) != null) {
                this.addEntry(result, RefactoringCoreMessages.getString("CallInliner.execution_flow"), 257, severity);
                return;
            }
        }
        if (this.fInvocation.getNodeType() == 32 && (exp = ((MethodInvocation)this.fInvocation).getExpression()) != null && exp.resolveTypeBinding() == null) {
            this.addEntry(result, RefactoringCoreMessages.getString("CallInliner.receiver_type"), 258, severity);
            return;
        }
        int nodeType = this.fTargetNode.getNodeType();
        if (nodeType == 21) {
            if (this.fSourceProvider.isExecutionFlowInterrupted()) {
                this.addEntry(result, RefactoringCoreMessages.getString("CallInliner.execution_flow"), 260, severity);
                return;
            }
        } else if (nodeType == 32 && (parent = this.fTargetNode.getParent()).getNodeType() != 7 && !CallInliner.isSingleDeclaration(parent)) {
            if (CallInliner.isMultiDeclarationFragment(parent)) {
                if (!this.fSourceProvider.isSimpleFunction()) {
                    this.addEntry(result, RefactoringCoreMessages.getString("CallInliner.multiDeclaration"), 261, severity);
                    return;
                }
            } else {
                if (this.fSourceProvider.getNumberOfStatements() > 1) {
                    this.addEntry(result, RefactoringCoreMessages.getString("CallInliner.simple_functions"), 259, severity);
                    return;
                }
                if (!this.fSourceProvider.isSimpleFunction()) {
                    this.addEntry(result, RefactoringCoreMessages.getString("CallInliner.execution_flow"), 260, severity);
                    return;
                }
            }
        }
    }

    private static boolean isMultiDeclarationFragment(ASTNode node) {
        int nodeType = node.getNodeType();
        if (nodeType == 59 && (node = node.getParent()).getNodeType() == 60) {
            VariableDeclarationStatement vs = (VariableDeclarationStatement)node;
            return vs.fragments().size() > 1;
        }
        return false;
    }

    private static boolean isSingleDeclaration(ASTNode node) {
        int type = node.getNodeType();
        if (type == 44) {
            return true;
        }
        if (type == 59 && (node = node.getParent()).getNodeType() == 60) {
            VariableDeclarationStatement vs = (VariableDeclarationStatement)node;
            return vs.fragments().size() == 1;
        }
        return false;
    }

    private void addEntry(RefactoringStatus result, String message, int code, int severity) {
        result.addEntry(new RefactoringStatusEntry(message, severity, JavaStatusContext.create(this.fCUnit, this.fInvocation), null, code));
    }

    private void flowAnalysis() {
        this.fInvocationScope = this.fRootScope.findScope(this.fTargetNode.getStartPosition(), this.fTargetNode.getLength());
        this.fInvocationScope.setCursor(this.fTargetNode.getStartPosition());
        this.fFlowContext = new FlowContext(0, this.fNumberOfLocals + 1);
        this.fFlowContext.setConsiderAccessMode(true);
        this.fFlowContext.setComputeMode(FlowContext.ARGUMENTS);
        Selection selection = Selection.createFromStartLength(this.fInvocation.getStartPosition(), this.fInvocation.getLength());
        switch (this.fBodyDeclaration.getNodeType()) {
            case 23: 
            case 28: 
            case 31: {
                this.fFlowInfo = new InputFlowAnalyzer(this.fFlowContext, selection).perform(this.fBodyDeclaration);
                break;
            }
            default: {
                Assert.isTrue(false, "Should not happen");
            }
        }
    }

    public TextEdit perform() throws CoreException {
        String[] blocks = this.fSourceProvider.getCodeBlocks(this.fContext);
        if (!this.fFieldInitializer) {
            this.initializeInsertionPoint(this.fSourceProvider.getNumberOfStatements() + this.fLocals.size());
        }
        this.addNewLocals();
        this.replaceCall(blocks);
        MultiTextEdit result = new MultiTextEdit();
        this.fRewriter.rewriteNode(this.fBuffer, (TextEdit)result);
        this.fRewriter.removeModifications();
        return result;
    }

    private void computeRealArguments() {
        List arguments = Invocations.getArguments(this.fInvocation);
        String[] realArguments = new String[arguments.size()];
        int i = 0;
        while (i < arguments.size()) {
            ParameterData parameter;
            Expression expression = (Expression)arguments.get(i);
            if (this.canInline(expression, parameter = this.fSourceProvider.getParameterData(i))) {
                realArguments[i] = this.getContent((ASTNode)expression);
                if (expression instanceof CastExpression || expression instanceof ArrayCreation) {
                    realArguments[i] = "(" + realArguments[i] + ")";
                }
            } else {
                String name;
                realArguments[i] = name = this.fInvocationScope.createName(parameter.getName(), true);
                this.fLocals.add(this.createLocalDeclaration(parameter.getTypeBinding(), name, (Expression)this.fRewriter.createCopy((ASTNode)expression)));
            }
            ++i;
        }
        this.fContext.arguments = realArguments;
    }

    private void computeReceiver() {
        Expression receiver = Invocations.getExpression(this.fInvocation);
        if (receiver == null) {
            return;
        }
        boolean isName = receiver instanceof Name;
        if (isName) {
            this.fContext.receiverIsStatic = ((Name)receiver).resolveBinding() instanceof ITypeBinding;
        }
        if (ASTNodes.isLiteral(receiver) || isName) {
            this.fContext.receiver = this.fBuffer.getContent(receiver.getStartPosition(), receiver.getLength());
            return;
        }
        switch (this.fSourceProvider.getReceiversToBeUpdated()) {
            case 0: {
                this.fLocals.add(this.createLocalDeclaration(receiver.resolveTypeBinding(), this.fInvocationScope.createName("r", true), (Expression)this.fRewriter.createCopy((ASTNode)receiver)));
                return;
            }
            case 1: {
                this.fContext.receiver = this.fBuffer.getContent(receiver.getStartPosition(), receiver.getLength());
                return;
            }
        }
        String local = this.fInvocationScope.createName("r", true);
        this.fLocals.add(this.createLocalDeclaration(receiver.resolveTypeBinding(), local, (Expression)this.fRewriter.createCopy((ASTNode)receiver)));
        this.fContext.receiver = local;
    }

    private void addNewLocals() {
        Iterator iter = this.fLocals.iterator();
        while (iter.hasNext()) {
            ASTNode element = (ASTNode)iter.next();
            this.fRewriter.markAsInserted(element);
            this.fStatements.add(this.fInsertionIndex++, element);
        }
    }

    private void replaceCall(String[] blocks) throws CoreException {
        if (blocks.length == 0) {
            if (this.fNeedsStatement) {
                this.fRewriter.markAsReplaced(this.fTargetNode, (ASTNode)this.fTargetNode.getAST().newEmptyStatement());
            } else {
                this.fRewriter.markAsRemoved(this.fTargetNode);
            }
        } else {
            Object node = null;
            int i = 0;
            while (i < blocks.length - 1) {
                node = this.fRewriter.createPlaceholder(blocks[i], 4);
                this.fRewriter.markAsInserted((ASTNode)node);
                this.fStatements.add(this.fInsertionIndex++, node);
                ++i;
            }
            String block = blocks[blocks.length - 1];
            if (this.fContext.callMode == 21 && this.fSourceProvider.hasReturnValue()) {
                node = this.fSourceProvider.mustEvaluateReturnedExpression() ? (this.fSourceProvider.returnValueNeedsLocalVariable() ? this.createLocalDeclaration(this.fSourceProvider.getReturnType(), this.fInvocationScope.createName(this.fSourceProvider.getMethodName(), true), (Expression)this.fRewriter.createPlaceholder(block, 3)) : this.fTargetNode.getAST().newExpressionStatement((Expression)this.fRewriter.createPlaceholder(block, 3))) : null;
            } else if (this.fTargetNode instanceof Expression) {
                node = this.fRewriter.createPlaceholder(block, 3);
                if (this.needsExplicitCast()) {
                    AST ast = node.getAST();
                    CastExpression castExpression = ast.newCastExpression();
                    ITypeBinding returnType = this.fSourceProvider.getReturnType();
                    this.fImportEdit.addImport(returnType);
                    castExpression.setType(ASTNodeFactory.newType(ast, returnType, false));
                    castExpression.setExpression((Expression)node);
                    node = castExpression;
                }
                if (this.needsParenthesis()) {
                    ParenthesizedExpression pExp = this.fTargetNode.getAST().newParenthesizedExpression();
                    pExp.setExpression((Expression)node);
                    node = pExp;
                }
            } else {
                node = this.fRewriter.createPlaceholder(block, 4);
            }
            if (node != null) {
                if (this.fTargetNode == null) {
                    this.fRewriter.markAsInserted((ASTNode)node);
                    this.fStatements.add(this.fInsertionIndex++, node);
                } else {
                    this.fRewriter.markAsReplaced(this.fTargetNode, (ASTNode)node);
                }
            } else if (this.fTargetNode != null) {
                this.fRewriter.markAsRemoved(this.fTargetNode);
            }
        }
    }

    private boolean needsExplicitCast() {
        if (this.fSourceProvider.returnTypeMatchesReturnExpressions()) {
            return false;
        }
        ASTNode parent = this.fTargetNode.getParent();
        int nodeType = parent.getNodeType();
        if (nodeType == 32) {
            MethodInvocation methodInvocation = (MethodInvocation)parent;
            if (methodInvocation.getExpression() == this.fTargetNode) {
                return false;
            }
            IMethodBinding method = methodInvocation.resolveMethodBinding();
            ITypeBinding[] parameters = method.getParameterTypes();
            int argumentIndex = methodInvocation.arguments().indexOf(this.fInvocation);
            List returnExprs = this.fSourceProvider.getReturnExpressions();
            if (returnExprs.size() != 1) {
                return false;
            }
            parameters[argumentIndex] = ((Expression)returnExprs.get(0)).resolveTypeBinding();
            AmbiguousMethodAnalyzer visitor = new AmbiguousMethodAnalyzer(method, parameters);
            ITypeBinding type = ASTNodes.getReceiverTypeBinding(methodInvocation);
            if (!visitor.visit(type)) {
                return true;
            }
            if (type.isInterface()) {
                return !Bindings.visitInterfaces(type, visitor);
            }
            if (Modifier.isAbstract((int)type.getModifiers())) {
                return !Bindings.visitHierarchy(type, visitor);
            }
            return !Bindings.visitSuperclasses(type, visitor);
        }
        return false;
    }

    private boolean needsParenthesis() {
        if (!this.fSourceProvider.needsReturnedExpressionParenthesis()) {
            return false;
        }
        ASTNode parent = this.fTargetNode.getParent();
        int type = parent.getNodeType();
        return type == 32 || parent instanceof Expression && type != 7;
    }

    private VariableDeclarationStatement createLocalDeclaration(ITypeBinding type, String name, Expression initializer) {
        String typeName = this.fImportEdit.addImport(type);
        VariableDeclarationStatement decl = (VariableDeclarationStatement)ASTNodeFactory.newStatement(this.fInvocation.getAST(), String.valueOf(typeName) + " " + name + ";");
        ((VariableDeclarationFragment)decl.fragments().get(0)).setInitializer(initializer);
        return decl;
    }

    private boolean canInline(Expression actualParameter, ParameterData formalParameter) {
        InlineEvaluator evaluator = new InlineEvaluator(formalParameter);
        actualParameter.accept((ASTVisitor)evaluator);
        return evaluator.getResult();
    }

    private void initializeInsertionPoint(int nos) {
        ASTNode parentStatement;
        ASTNode container;
        int type;
        this.fStatements = null;
        this.fInsertionIndex = -1;
        this.fNeedsStatement = false;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("[Lorg.eclipse.jdt.core.dom.Statement;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((type = (container = (parentStatement = ASTNodes.getParent(this.fInvocation, clazz)).getParent()).getNodeType()) == 8) {
            this.fStatements = ((Block)container).statements();
            this.fInsertionIndex = this.fStatements.indexOf(parentStatement);
        } else if (this.isControlStatement(container)) {
            this.fNeedsStatement = true;
            if (nos > 1) {
                Block block = this.fInvocation.getAST().newBlock();
                this.fStatements = block.statements();
                this.fInsertionIndex = 0;
                Statement currentStatement = null;
                switch (type) {
                    case 24: {
                        currentStatement = ((ForStatement)container).getBody();
                        break;
                    }
                    case 61: {
                        currentStatement = ((WhileStatement)container).getBody();
                        break;
                    }
                    case 19: {
                        currentStatement = ((DoStatement)container).getBody();
                        break;
                    }
                    case 25: {
                        IfStatement node = (IfStatement)container;
                        Statement thenPart = node.getThenStatement();
                        currentStatement = this.fTargetNode == thenPart || ASTNodes.isParent(this.fTargetNode, (ASTNode)thenPart) ? thenPart : node.getElseStatement();
                    }
                }
                Assert.isNotNull(currentStatement);
                if (currentStatement != this.fTargetNode) {
                    ASTNode copy = this.fRewriter.createCopy((ASTNode)currentStatement);
                    this.fStatements.add(copy);
                } else {
                    this.fTargetNode = null;
                }
                this.fRewriter.markAsReplaced((ASTNode)currentStatement, (ASTNode)block);
            }
        }
    }

    private String getContent(ASTNode node) {
        return this.fBuffer.getContent(node.getStartPosition(), node.getLength());
    }

    private static IFile getFile(ICompilationUnit cu) throws CoreException {
        return (IFile)WorkingCopyUtil.getOriginal(cu).getResource();
    }

    private boolean isControlStatement(ASTNode node) {
        int type = node.getNodeType();
        return type == 25 || type == 24 || type == 61 || type == 19;
    }

    private class InlineEvaluator
    extends HierarchicalASTVisitor {
        private ParameterData fFormalArgument;
        private boolean fResult;

        public InlineEvaluator(ParameterData argument) {
            this.fFormalArgument = argument;
        }

        public boolean getResult() {
            return this.fResult;
        }

        private boolean setResult(boolean result) {
            this.fResult = result;
            return false;
        }

        public boolean visit(Expression node) {
            int accessMode = this.fFormalArgument.getSimplifiedAccessMode();
            if (accessMode == 8) {
                return this.setResult(false);
            }
            if (accessMode == 1) {
                return this.setResult(true);
            }
            if (ASTNodes.isLiteral(node)) {
                return this.setResult(true);
            }
            return this.setResult(this.fFormalArgument.getNumberOfAccesses() <= 1);
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (binding instanceof IVariableBinding) {
                if (this.fFormalArgument.getSimplifiedAccessMode() == 2) {
                    return this.setResult(true);
                }
                IVariableBinding vb = (IVariableBinding)binding;
                if (vb.isField()) {
                    return this.setResult(false);
                }
                return this.setResult(CallInliner.this.fFlowInfo.hasAccessMode(CallInliner.this.fFlowContext, vb, 9));
            }
            return this.setResult(false);
        }

        public boolean visit(FieldAccess node) {
            return this.visit(node.getName());
        }

        public boolean visit(SuperFieldAccess node) {
            return this.visit(node.getName());
        }

        public boolean visit(ThisExpression node) {
            int accessMode = this.fFormalArgument.getSimplifiedAccessMode();
            if (accessMode == 2 || accessMode == 1) {
                return this.setResult(true);
            }
            return this.setResult(false);
        }
    }

    private static class AmbiguousMethodAnalyzer
    implements TypeBindingVisitor {
        private String methodName;
        private ITypeBinding[] types;
        private IMethodBinding original;

        public AmbiguousMethodAnalyzer(IMethodBinding original, ITypeBinding[] types) {
            this.original = original;
            this.methodName = original.getName();
            this.types = types;
        }

        public boolean visit(ITypeBinding node) {
            IMethodBinding[] methods = node.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                IMethodBinding candidate = methods[i];
                if (candidate != this.original && this.methodName.equals(candidate.getName()) && this.canImplicitlyCall(candidate)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private boolean canImplicitlyCall(IMethodBinding candidate) {
            ITypeBinding[] parameters = candidate.getParameterTypes();
            if (parameters.length != this.types.length) {
                return false;
            }
            int i = 0;
            while (i < parameters.length) {
                if (!TypeRules.canAssign(this.types[i], parameters[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

