/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.UndoTextChange;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.text.edits.UndoEdit;

public class TextFileChange
extends TextChange {
    private IFile fFile;
    private TextBuffer fAcquiredTextBuffer;
    private int fAcquireCounter;
    private boolean fSave = true;

    public TextFileChange(String name, IFile file) {
        super(name);
        this.fFile = file;
        Assert.isNotNull(this.fFile);
    }

    public void setSave(boolean save) {
        this.fSave = save;
    }

    public IFile getFile() {
        return this.fFile;
    }

    protected TextBuffer acquireTextBuffer() throws CoreException {
        TextBuffer result = TextBuffer.acquire(this.fFile);
        if (this.fAcquiredTextBuffer == null || result == this.fAcquiredTextBuffer) {
            this.fAcquiredTextBuffer = result;
            ++this.fAcquireCounter;
        }
        return result;
    }

    protected void releaseTextBuffer(TextBuffer textBuffer) {
        TextBuffer.release(textBuffer);
        if (textBuffer == this.fAcquiredTextBuffer && --this.fAcquireCounter == 0) {
            this.fAcquiredTextBuffer = null;
        }
    }

    protected TextBuffer createTextBuffer() throws CoreException {
        return TextBuffer.create(this.fFile);
    }

    protected IChange createReverseChange(UndoEdit undo, int changeKind) {
        return new UndoTextFileChange(this.getName(), this.fFile, changeKind, undo);
    }

    public Object getModifiedLanguageElement() {
        return this.fFile;
    }

    public RefactoringStatus aboutToPerform(ChangeContext context, IProgressMonitor pm) {
        if (this.fSave) {
            return Checks.validateModifiesFiles(new IFile[]{this.fFile});
        }
        return new RefactoringStatus();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void perform(ChangeContext context, IProgressMonitor pm) throws JavaModelException, ChangeAbortException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        if (!this.isActive()) {
            super.perform(context, pm);
            return;
        }
        try {
            try {
                this.acquireTextBuffer();
                pm.beginTask("", 10);
                super.perform(context, (IProgressMonitor)new SubProgressMonitor(pm, 8));
                if (this.fSave) {
                    TextBuffer.aboutToChange(this.fAcquiredTextBuffer);
                    TextBuffer.save(this.fAcquiredTextBuffer, (IProgressMonitor)new SubProgressMonitor(pm, 2));
                }
            }
            catch (Exception e) {
                this.handleException(context, e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            pm.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        pm.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performed() {
        block6: {
            if (this.fAcquiredTextBuffer == null) break block6;
            try {
                try {
                    if (this.fSave) {
                        TextBuffer.changed(this.fAcquiredTextBuffer);
                    }
                }
                catch (CoreException coreException) {
                    Assert.isTrue(false, "Should not happen since the buffer is acquired through a text buffer manager");
                }
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                this.releaseTextBuffer(this.fAcquiredTextBuffer);
                throw throwable;
            }
            {
                Object var1_3 = null;
                this.releaseTextBuffer(this.fAcquiredTextBuffer);
            }
        }
        super.performed();
    }

    protected static class UndoTextFileChange
    extends UndoTextChange {
        private IFile fFile;
        private TextBuffer fAcquiredTextBuffer;
        private int fAcquireCounter;

        public UndoTextFileChange(String name, IFile file, int changeKind, UndoEdit undo) {
            super(name, changeKind, undo);
            this.fFile = file;
        }

        public Object getModifiedLanguageElement() {
            return this.fFile;
        }

        protected TextBuffer acquireTextBuffer() throws CoreException {
            TextBuffer result = TextBuffer.acquire(this.fFile);
            if (this.fAcquiredTextBuffer == null || result == this.fAcquiredTextBuffer) {
                this.fAcquiredTextBuffer = result;
                ++this.fAcquireCounter;
            }
            return result;
        }

        protected void releaseTextBuffer(TextBuffer textBuffer) {
            TextBuffer.release(textBuffer);
            if (textBuffer == this.fAcquiredTextBuffer && --this.fAcquireCounter == 0) {
                this.fAcquiredTextBuffer = null;
            }
        }

        protected TextBuffer createTextBuffer() throws CoreException {
            return TextBuffer.create(this.fFile);
        }

        protected IChange createReverseChange(UndoEdit undo, int changeKind) {
            return new UndoTextFileChange(this.getName(), this.fFile, changeKind, undo);
        }

        public RefactoringStatus aboutToPerform(ChangeContext context, IProgressMonitor pm) {
            RefactoringStatus result = Checks.validateModifiesFiles(new IFile[]{this.fFile});
            if (result.hasFatalError()) {
                return result;
            }
            context.checkUnsavedFile(result, this.fFile);
            return result;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void perform(ChangeContext context, IProgressMonitor pm) throws JavaModelException, ChangeAbortException {
            if (!this.isActive()) {
                super.perform(context, pm);
                return;
            }
            try {
                try {
                    this.acquireTextBuffer();
                    pm.beginTask("", 10);
                    super.perform(context, (IProgressMonitor)new SubProgressMonitor(pm, 8));
                    TextBuffer.aboutToChange(this.fAcquiredTextBuffer);
                    TextBuffer.save(this.fAcquiredTextBuffer, (IProgressMonitor)new SubProgressMonitor(pm, 2));
                }
                catch (Exception e) {
                    this.handleException(context, e);
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                pm.done();
                throw throwable;
            }
            {
                Object var4_6 = null;
            }
            pm.done();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void performed() {
            if (this.fAcquiredTextBuffer != null) {
                try {
                    try {
                        TextBuffer.changed(this.fAcquiredTextBuffer);
                    }
                    catch (CoreException coreException) {
                        Assert.isTrue(false, "Should not happen since the buffer is acquired through a text buffer manager");
                    }
                }
                catch (Throwable throwable) {
                    Object var1_2 = null;
                    this.releaseTextBuffer(this.fAcquiredTextBuffer);
                    throw throwable;
                }
                {
                    Object var1_3 = null;
                    this.releaseTextBuffer(this.fAcquiredTextBuffer);
                }
            }
            super.performed();
        }
    }
}

