/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.changes.AbstractTextChange;
import org.eclipse.jdt.internal.corext.textmanipulation.GroupDescription;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRegion;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditCopier;

public abstract class TextChange
extends AbstractTextChange {
    private List fTextEditChanges = new ArrayList(5);
    private TextEditCopier fCopier;
    private TextEdit fEdit;
    private boolean fKeepExecutedTextEdits;
    private boolean fAutoMode;
    private String fTextType = "txt";

    protected TextChange(String name) {
        super(name, 0);
    }

    protected void setTextType(String type) {
        if (type == null) {
            this.fTextType = "txt";
        }
        this.fTextType = type;
    }

    public String getTextType() {
        return this.fTextType;
    }

    public void addTextEdit(String name, TextEdit edit) {
        this.addTextEdit(name, new TextEdit[]{edit});
    }

    public void addTextEdit(String name, TextEdit[] edits) {
        Assert.isNotNull(name);
        Assert.isNotNull(edits);
        GroupDescription description = new GroupDescription(name, edits);
        this.fTextEditChanges.add(new EditChange(description, this));
        if (this.fEdit == null) {
            this.fEdit = new MultiTextEdit();
            this.fAutoMode = true;
        } else {
            Assert.isTrue(this.fAutoMode, "Can only add edits when in auto organizing mode");
        }
        int i = 0;
        while (i < edits.length) {
            TextChange.insert(this.fEdit, edits[i]);
            ++i;
        }
    }

    public void setEdit(TextEdit edit) {
        Assert.isTrue(this.fEdit == null, "Root edit can only be set once");
        Assert.isTrue(edit != null);
        this.fEdit = edit;
        this.fTextEditChanges = new ArrayList(5);
        this.fAutoMode = false;
    }

    public TextEdit getEdit() {
        return this.fEdit;
    }

    public void addGroupDescription(GroupDescription description) {
        Assert.isTrue(this.fEdit != null, "Can only add a description if a root edit exists");
        Assert.isTrue(!this.fAutoMode, "Group descriptions are only supported if root edit has been set by setEdit");
        Assert.isTrue(description != null);
        this.fTextEditChanges.add(new EditChange(description, this));
    }

    public void addGroupDescriptions(GroupDescription[] descriptions) {
        int i = 0;
        while (i < descriptions.length) {
            this.addGroupDescription(descriptions[i]);
            ++i;
        }
    }

    public GroupDescription[] getGroupDescriptions() {
        GroupDescription[] res = new GroupDescription[this.fTextEditChanges.size()];
        int i = 0;
        while (i < res.length) {
            EditChange elem = (EditChange)this.fTextEditChanges.get(i);
            res[i] = elem.getGroupDescription();
            ++i;
        }
        return res;
    }

    public GroupDescription getGroupDescription(String name) {
        int i = 0;
        while (i < this.fTextEditChanges.size()) {
            EditChange elem = (EditChange)this.fTextEditChanges.get(i);
            GroupDescription description = elem.getGroupDescription();
            if (name.equals(description.getName())) {
                return description;
            }
            ++i;
        }
        return null;
    }

    public EditChange[] getTextEditChanges() {
        return this.fTextEditChanges.toArray(new EditChange[this.fTextEditChanges.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCurrentContent() throws JavaModelException {
        String string;
        TextBuffer buffer = null;
        try {
            try {
                buffer = this.acquireTextBuffer();
                string = buffer.getContent();
                Object var3_3 = null;
                if (buffer == null) return string;
            }
            catch (JavaModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (buffer == null) throw throwable;
            this.releaseTextBuffer(buffer);
            throw throwable;
        }
        this.releaseTextBuffer(buffer);
        return string;
    }

    public String getPreviewContent() throws JavaModelException {
        return this.getPreviewTextBuffer().getContent();
    }

    public TextBuffer getPreviewTextBuffer() throws JavaModelException {
        try {
            AbstractTextChange.LocalTextEditProcessor editor = new AbstractTextChange.LocalTextEditProcessor(this.createTextBuffer());
            this.addTextEdits(editor);
            editor.performEdits((IProgressMonitor)new NullProgressMonitor());
            return editor.getTextBuffer();
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public String getCurrentContent(EditChange change, int surroundingLines) throws CoreException {
        return this.getContent(change, surroundingLines, false);
    }

    public String getPreviewContent(EditChange change, int surroundingLines) throws CoreException {
        return this.getContent(change, surroundingLines, true);
    }

    public String getCurrentContent(IRegion range) throws CoreException {
        String string;
        block2: {
            TextBuffer buffer = null;
            try {
                buffer = this.acquireTextBuffer();
                int offset = buffer.getLineInformationOfOffset(range.getOffset()).getOffset();
                int length = range.getLength() + range.getOffset() - offset;
                string = buffer.getContent(offset, length);
                Object var5_6 = null;
                if (buffer == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_7 = null;
                    if (buffer == null) break block3;
                    this.releaseTextBuffer(buffer);
                }
                throw throwable;
            }
            this.releaseTextBuffer(buffer);
        }
        return string;
    }

    public String getPreviewContent(EditChange[] changes, IRegion range) throws CoreException {
        TextBuffer buffer = this.createTextBuffer();
        AbstractTextChange.LocalTextEditProcessor editor = new AbstractTextChange.LocalTextEditProcessor(buffer);
        this.addTextEdits(editor, changes);
        int oldLength = buffer.getLength();
        editor.performEdits((IProgressMonitor)new NullProgressMonitor());
        int delta = buffer.getLength() - oldLength;
        int offset = buffer.getLineInformationOfOffset(range.getOffset()).getOffset();
        int length = range.getLength() + range.getOffset() - offset + delta;
        if (length > 0) {
            return buffer.getContent(offset, length);
        }
        return "";
    }

    public void setKeepExecutedTextEdits(boolean keep) {
        this.fKeepExecutedTextEdits = keep;
        if (!this.fKeepExecutedTextEdits) {
            this.fCopier = null;
        }
    }

    private TextEdit getExecutedTextEdit(TextEdit original) {
        if (!this.fKeepExecutedTextEdits || this.fCopier == null) {
            return null;
        }
        return this.fCopier.getCopy(original);
    }

    public IRegion getNewTextRange(TextEdit edit) {
        Assert.isNotNull(edit);
        TextEdit result = this.getExecutedTextEdit(edit);
        if (result == null) {
            return null;
        }
        return result.getRegion();
    }

    public IRegion getNewTextRange(TextEdit[] edits) {
        Assert.isTrue(edits != null && edits.length > 0);
        if (!this.fKeepExecutedTextEdits || this.fCopier == null) {
            return null;
        }
        TextEdit[] copies = new TextEdit[edits.length];
        int i = 0;
        while (i < edits.length) {
            TextEdit copy = this.fCopier.getCopy(edits[i]);
            if (copy == null) {
                return null;
            }
            copies[i] = copy;
            ++i;
        }
        return TextEdit.getCoverage((TextEdit[])copies);
    }

    public IRegion getNewTextRange(EditChange editChange) {
        return this.getNewTextRange(editChange.getGroupDescription().getTextEdits());
    }

    public void setActive(boolean active) {
        super.setActive(active);
        Iterator iter = this.fTextEditChanges.iterator();
        while (iter.hasNext()) {
            EditChange element = (EditChange)iter.next();
            element.setActive(active);
        }
    }

    protected void addTextEdits(AbstractTextChange.LocalTextEditProcessor editor) throws CoreException {
        if (this.fEdit == null) {
            return;
        }
        ArrayList<TextEdit> excludes = new ArrayList<TextEdit>(0);
        Iterator iter = this.fTextEditChanges.iterator();
        while (iter.hasNext()) {
            EditChange edit = (EditChange)iter.next();
            if (edit.isActive()) continue;
            excludes.addAll(Arrays.asList(edit.getGroupDescription().getTextEdits()));
        }
        this.fCopier = new TextEditCopier(this.fEdit);
        TextEdit copiedEdit = this.fCopier.perform();
        if (copiedEdit != null) {
            editor.add(copiedEdit);
            editor.setExcludes(this.mapEdits(excludes.toArray(new TextEdit[excludes.size()]), this.fCopier));
        }
        if (!this.fKeepExecutedTextEdits) {
            this.fCopier = null;
        }
    }

    protected void addTextEdits(AbstractTextChange.LocalTextEditProcessor editor, EditChange[] changes) throws CoreException {
        if (this.fEdit == null) {
            return;
        }
        ArrayList<TextEdit> includes = new ArrayList<TextEdit>(0);
        int c = 0;
        while (c < changes.length) {
            EditChange change = changes[c];
            Assert.isTrue(change.getTextChange() == this);
            if (change.isActive()) {
                includes.addAll(Arrays.asList(change.getGroupDescription().getTextEdits()));
            }
            ++c;
        }
        this.fCopier = new TextEditCopier(this.fEdit);
        TextEdit copiedEdit = this.fCopier.perform();
        if (copiedEdit != null) {
            editor.add(copiedEdit);
            editor.setIncludes(this.mapEdits(includes.toArray(new TextEdit[includes.size()]), this.fCopier));
        }
        if (!this.fKeepExecutedTextEdits) {
            this.fCopier = null;
        }
    }

    private TextEdit[] mapEdits(TextEdit[] edits, TextEditCopier copier) {
        if (edits == null) {
            return null;
        }
        int i = 0;
        while (i < edits.length) {
            edits[i] = copier.getCopy(edits[i]);
            ++i;
        }
        return edits;
    }

    private String getContent(EditChange change, int surroundingLines, boolean preview) throws CoreException {
        Assert.isTrue(change.getTextChange() == this);
        TextBuffer buffer = this.createTextBuffer();
        IRegion range = null;
        if (preview) {
            AbstractTextChange.LocalTextEditProcessor editor = new AbstractTextChange.LocalTextEditProcessor(buffer);
            boolean keepEdits = this.fKeepExecutedTextEdits;
            this.setKeepExecutedTextEdits(true);
            this.addTextEdits(editor, new EditChange[]{change});
            editor.performEdits((IProgressMonitor)new NullProgressMonitor());
            range = this.getNewTextRange(change);
            this.setKeepExecutedTextEdits(keepEdits);
        } else {
            range = change.getTextRange();
        }
        int startLine = Math.max(buffer.getLineOfOffset(range.getOffset()) - surroundingLines, 0);
        int endLine = Math.min(buffer.getLineOfOffset(range.getOffset() + range.getLength() - 1) + surroundingLines, buffer.getNumberOfLines() - 1);
        int offset = buffer.getLineInformation(startLine).getOffset();
        TextRegion region = buffer.getLineInformation(endLine);
        int length = region.getOffset() + region.getLength() - offset;
        return buffer.getContent(offset, length);
    }

    private static void insert(TextEdit parent, TextEdit edit) {
        TextEdit child;
        if (!parent.hasChildren()) {
            parent.addChild(edit);
            return;
        }
        TextEdit[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            child = children[i];
            if (TextChange.covers(child, edit)) {
                TextChange.insert(child, edit);
                return;
            }
            ++i;
        }
        i = children.length - 1;
        while (i >= 0) {
            child = children[i];
            if (TextChange.covers(edit, child)) {
                parent.removeChild(i);
                edit.addChild(child);
            }
            --i;
        }
        parent.addChild(edit);
    }

    private static boolean covers(TextEdit thisEdit, TextEdit otherEdit) {
        if (thisEdit.getLength() == 0) {
            return false;
        }
        int thisOffset = thisEdit.getOffset();
        int thisEnd = thisEdit.getExclusiveEnd();
        if (otherEdit.getLength() == 0) {
            int otherOffset = otherEdit.getOffset();
            return thisOffset < otherOffset && otherOffset < thisEnd;
        }
        int otherOffset = otherEdit.getOffset();
        int otherEnd = otherEdit.getExclusiveEnd();
        return thisOffset <= otherOffset && otherEnd <= thisEnd;
    }

    public static class EditChange {
        private boolean fIsActive;
        private TextChange fTextChange;
        private GroupDescription fDescription;

        EditChange(GroupDescription description, TextChange change) {
            this.fTextChange = change;
            this.fIsActive = true;
            this.fDescription = description;
        }

        public String getName() {
            return this.fDescription.getName();
        }

        public void setActive(boolean active) {
            this.fIsActive = active;
        }

        public boolean isActive() {
            return this.fIsActive;
        }

        public TextChange getTextChange() {
            return this.fTextChange;
        }

        public IRegion getTextRange() {
            return this.fDescription.getTextRange();
        }

        public boolean isEmpty() {
            return this.fDescription.hasTextEdits();
        }

        GroupDescription getGroupDescription() {
            return this.fDescription;
        }

        public boolean coveredBy(IRegion sourceRegion) {
            int sLength = sourceRegion.getLength();
            if (sLength == 0) {
                return false;
            }
            int sOffset = sourceRegion.getOffset();
            int sEnd = sOffset + sLength - 1;
            TextEdit[] edits = this.fDescription.getTextEdits();
            int i = 0;
            while (i < edits.length) {
                TextEdit edit = edits[i];
                if (edit.isDeleted()) {
                    return false;
                }
                int rOffset = edit.getOffset();
                int rLength = edit.getLength();
                int rEnd = rOffset + rLength - 1;
                if (rLength == 0 ? sOffset >= rOffset || rOffset > sEnd : sOffset > rOffset || rEnd > sEnd) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

