/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.AbstractJavaElementRenameChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;

public class RenameSourceFolderChange
extends AbstractJavaElementRenameChange {
    public RenameSourceFolderChange(IPackageFragmentRoot sourceFolder, String newName) throws JavaModelException {
        this(sourceFolder.getPath(), sourceFolder.getElementName(), newName);
        Assert.isTrue(!sourceFolder.isReadOnly(), "should not be read only");
        Assert.isTrue(!sourceFolder.isArchive(), "should not be an archive");
    }

    private RenameSourceFolderChange(IPath resourcePath, String oldName, String newName) {
        super(resourcePath, oldName, newName);
    }

    private IPath createNewPath() {
        return this.getResourcePath().removeLastSegments(1).append(this.getNewName());
    }

    protected IChange createUndoChange() {
        return new RenameSourceFolderChange(this.createNewPath(), this.getNewName(), this.getOldName());
    }

    public String getName() {
        return RefactoringCoreMessages.getFormattedString("RenameSourceFolderChange.rename", new String[]{this.getOldName(), this.getNewName()});
    }

    protected void doRename(IProgressMonitor pm) throws Exception {
        IPackageFragmentRoot sourceFolder = this.getSourceFolder();
        if (sourceFolder != null) {
            sourceFolder.move(this.getNewPath(), this.getCoreMoveFlags(), this.getJavaModelUpdateFlags(), null, pm);
        }
    }

    private IPath getNewPath() {
        return this.getResource().getFullPath().removeLastSegments(1).append(this.getNewName());
    }

    private IPackageFragmentRoot getSourceFolder() {
        return (IPackageFragmentRoot)this.getModifiedLanguageElement();
    }

    private int getJavaModelUpdateFlags() {
        return 30;
    }

    private int getCoreMoveFlags() {
        if (this.getResource().isLinked()) {
            return 32;
        }
        return 0;
    }

    public RefactoringStatus aboutToPerform(ChangeContext context, IProgressMonitor pm) {
        RefactoringStatus result = super.aboutToPerform(context, pm);
        if (context.getUnsavedFiles().length == 0) {
            return result;
        }
        result.merge(AbstractJavaElementRenameChange.checkIfModifiable(this.getSourceFolder(), context, pm));
        return result;
    }
}

