/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.NullChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.Change;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;

public class RenameResourceChange
extends Change {
    private IPath fResourcePath;
    private String fNewName;

    public RenameResourceChange(IResource resource, String newName) {
        this(resource.getFullPath(), newName);
    }

    private RenameResourceChange(IPath resourcePath, String newName) {
        this.fResourcePath = resourcePath;
        this.fNewName = newName;
    }

    private IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourcePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void perform(ChangeContext context, IProgressMonitor pm) throws JavaModelException {
        block7: {
            block6: {
                try {
                    try {
                        pm.beginTask(RefactoringCoreMessages.getString("RenameResourceChange.rename_resource"), 1);
                        if (!this.isActive()) {
                            pm.worked(1);
                            Object var4_3 = null;
                            break block6;
                        }
                        this.getResource().move(RenameResourceChange.renamedResourcePath(this.fResourcePath, this.fNewName), this.getCoreRenameFlags(), pm);
                    }
                    catch (Exception e) {
                        this.handleException(context, e);
                        this.setActive(false);
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    pm.done();
                    throw throwable;
                }
            }
            pm.done();
            return;
        }
        Object var4_5 = null;
        pm.done();
    }

    private int getCoreRenameFlags() {
        if (this.getResource().isLinked()) {
            return 32;
        }
        return 0;
    }

    public IChange getUndoChange() {
        if (!this.isActive()) {
            return new NullChange();
        }
        String oldName = this.fResourcePath.lastSegment();
        IPath newPath = RenameResourceChange.renamedResourcePath(this.fResourcePath, this.fNewName);
        return new RenameResourceChange(newPath, oldName);
    }

    public static IPath renamedResourcePath(IPath path, String newName) {
        return path.removeLastSegments(1).append(newName);
    }

    public String getName() {
        return RefactoringCoreMessages.getFormattedString("RenameResourceChange.name", new String[]{this.fResourcePath.toString(), this.fNewName});
    }

    public Object getModifiedLanguageElement() {
        return this.getResource();
    }
}

