/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.AbstractJavaElementRenameChange;
import org.eclipse.jdt.internal.corext.refactoring.NullChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.Change;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;

public class RenamePackageChange
extends AbstractJavaElementRenameChange {
    public RenamePackageChange(IPackageFragment pack, String newName) throws JavaModelException {
        this(pack.getPath(), pack.getElementName(), newName);
        Assert.isTrue(!pack.isReadOnly(), "package must not be read only");
    }

    private RenamePackageChange(IPath resourcePath, String oldName, String newName) {
        super(resourcePath, oldName, newName);
    }

    protected IPath createPath(String packageName) {
        return new Path(packageName.replace('.', '/'));
    }

    private IPath createNewPath() {
        IPackageFragment oldPackage = this.getPackage();
        IPath oldPackageName = this.createPath(oldPackage.getElementName());
        IPath newPackageName = this.createPath(this.getNewName());
        return this.getResourcePath().removeLastSegments(oldPackageName.segmentCount()).append(newPackageName);
    }

    private IPackageFragment getPackage() {
        return (IPackageFragment)this.getModifiedLanguageElement();
    }

    public String getName() {
        return RefactoringCoreMessages.getFormattedString("RenamePackageChange.name", new String[]{this.getOldName(), this.getNewName()});
    }

    protected IChange createUndoChange() {
        if (this.getPackage() == null) {
            return new NullChange();
        }
        return new RenamePackageChange(this.createNewPath(), this.getNewName(), this.getOldName());
    }

    protected void doRename(IProgressMonitor pm) throws JavaModelException {
        IPackageFragment pack = this.getPackage();
        if (pack != null) {
            pack.rename(this.getNewName(), false, pm);
        }
    }

    public RefactoringStatus aboutToPerform(ChangeContext context, IProgressMonitor pm) {
        RefactoringStatus result = super.aboutToPerform(context, pm);
        IJavaElement element = (IJavaElement)this.getModifiedLanguageElement();
        if (element != null && element.exists() && context.getUnsavedFiles().length > 0 && element instanceof IPackageFragment) {
            IPackageFragment pack = (IPackageFragment)element;
            try {
                ICompilationUnit[] units = pack.getCompilationUnits();
                if (units == null || units.length == 0) {
                    return result;
                }
                pm.beginTask("", units.length);
                int i = 0;
                while (i < units.length) {
                    pm.subTask(RefactoringCoreMessages.getFormattedString("RenamePackageChange.checking_change", element.getElementName()));
                    Change.checkIfModifiable(units[i], result, context);
                    pm.worked(1);
                    ++i;
                }
                pm.done();
            }
            catch (JavaModelException e) {
                Change.handleJavaModelException(e, result);
            }
        }
        return result;
    }
}

