/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.base;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.base.Context;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public class RefactoringStatusEntry {
    private final String fMessage;
    private final int fSeverity;
    private final Context fContext;
    private final Object fData;
    private final int fCode;

    public RefactoringStatusEntry(String msg, int severity, Context context, Object data, int code) {
        Assert.isTrue(severity == 1 || severity == 2 || severity == 3 || severity == 4);
        Assert.isNotNull(msg);
        this.fMessage = msg;
        this.fSeverity = severity;
        this.fContext = context;
        this.fData = data;
        this.fCode = code;
    }

    public RefactoringStatusEntry(String msg, int severity, Context context) {
        this(msg, severity, context, null, 0);
    }

    public RefactoringStatusEntry(String msg, int severity) {
        this(msg, severity, null);
    }

    public static RefactoringStatusEntry createInfo(String msg) {
        return new RefactoringStatusEntry(msg, 1);
    }

    public static RefactoringStatusEntry createInfo(String msg, Context context) {
        return new RefactoringStatusEntry(msg, 1, context);
    }

    public static RefactoringStatusEntry createWarning(String msg) {
        return new RefactoringStatusEntry(msg, 2);
    }

    public static RefactoringStatusEntry createWarning(String msg, Context context) {
        return new RefactoringStatusEntry(msg, 2, context);
    }

    public static RefactoringStatusEntry createError(String msg) {
        return new RefactoringStatusEntry(msg, 3);
    }

    public static RefactoringStatusEntry createError(String msg, Context context) {
        return new RefactoringStatusEntry(msg, 3, context);
    }

    public static RefactoringStatusEntry createFatal(String msg) {
        return new RefactoringStatusEntry(msg, 4);
    }

    public static RefactoringStatusEntry createFatal(String msg, Context context) {
        return new RefactoringStatusEntry(msg, 4, context);
    }

    public boolean isFatalError() {
        return this.fSeverity == 4;
    }

    public boolean isError() {
        return this.fSeverity == 3;
    }

    public boolean isWarning() {
        return this.fSeverity == 2;
    }

    public boolean isInfo() {
        return this.fSeverity == 1;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public Context getContext() {
        return this.fContext;
    }

    public Object getData() {
        return this.fData;
    }

    public int getCode() {
        return this.fCode;
    }

    public IStatus asStatus() {
        int statusSeverity = 4;
        switch (this.fSeverity) {
            case 0: {
                statusSeverity = 0;
                break;
            }
            case 1: {
                statusSeverity = 1;
                break;
            }
            case 2: 
            case 3: {
                statusSeverity = 2;
            }
        }
        return new Status(statusSeverity, JavaPlugin.getPluginId(), this.fCode, this.fMessage, null);
    }

    public String toString() {
        String contextString = this.fContext == null ? "<Unspecified context>" : this.fContext.toString();
        return "\n" + RefactoringStatus.getSeverityString(this.fSeverity) + ": " + this.fMessage + "\nContext: " + contextString + "\nData: " + this.getData() + "\ncode: " + this.fCode + "\n";
    }
}

