/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.ListenerList;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.IUndoManager;
import org.eclipse.jdt.internal.corext.refactoring.base.IUndoManagerListener;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public class UndoManager
implements IUndoManager {
    private Stack fUndoChanges;
    private Stack fRedoChanges;
    private Stack fUndoNames;
    private Stack fRedoNames;
    private ListenerList fListeners;
    private FlushListener fFlushListener;
    private SaveListener fSaveListener;

    public UndoManager() {
        this.flush();
    }

    public void addListener(IUndoManagerListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add(listener);
    }

    public void removeListener(IUndoManagerListener listener) {
        if (this.fListeners == null) {
            return;
        }
        this.fListeners.remove(listener);
    }

    public void aboutToPerformRefactoring() {
        if (this.fFlushListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fFlushListener);
        }
        if (this.fSaveListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fSaveListener);
        }
    }

    public void refactoringPerformed(boolean success) {
        if (success) {
            if (this.fFlushListener != null) {
                JavaCore.addElementChangedListener((IElementChangedListener)this.fFlushListener);
            }
            if (this.fSaveListener != null) {
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fSaveListener);
            }
        } else {
            this.flush();
        }
    }

    public void shutdown() {
        if (this.fFlushListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fFlushListener);
        }
        if (this.fSaveListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fSaveListener);
        }
    }

    public void flush() {
        this.flushUndo();
        this.flushRedo();
        if (this.fFlushListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fFlushListener);
        }
        if (this.fSaveListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fSaveListener);
        }
        this.fFlushListener = null;
        this.fSaveListener = null;
    }

    private void flushUndo() {
        this.fUndoChanges = new Stack();
        this.fUndoNames = new Stack();
        this.fireUndoStackChanged();
    }

    private void flushRedo() {
        this.fRedoChanges = new Stack();
        this.fRedoNames = new Stack();
        this.fireRedoStackChanged();
    }

    public void addUndo(String refactoringName, IChange change) {
        Assert.isNotNull(refactoringName, "refactoring");
        Assert.isNotNull(change, "change");
        this.fUndoNames.push(refactoringName);
        this.fUndoChanges.push(change);
        this.flushRedo();
        if (this.fFlushListener == null) {
            this.fFlushListener = new FlushListener();
            JavaCore.addElementChangedListener((IElementChangedListener)this.fFlushListener);
        }
        if (this.fSaveListener == null) {
            this.fSaveListener = new SaveListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fSaveListener);
        }
        this.fireUndoStackChanged();
    }

    public RefactoringStatus performUndo(ChangeContext context, IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.fUndoChanges.empty()) {
            return result;
        }
        IChange change = (IChange)this.fUndoChanges.peek();
        this.executeChange(result, context, change, pm);
        if (!result.hasError()) {
            this.fUndoChanges.pop();
            this.fRedoNames.push(this.fUndoNames.pop());
            this.fRedoChanges.push(change.getUndoChange());
            this.fireUndoStackChanged();
            this.fireRedoStackChanged();
        }
        return result;
    }

    public RefactoringStatus performRedo(ChangeContext context, IProgressMonitor pm) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.fRedoChanges.empty()) {
            return result;
        }
        IChange change = (IChange)this.fRedoChanges.peek();
        this.executeChange(result, context, change, pm);
        if (!result.hasError()) {
            this.fRedoChanges.pop();
            this.fUndoNames.push(this.fRedoNames.pop());
            this.fUndoChanges.push(change.getUndoChange());
            this.fireRedoStackChanged();
            this.fireUndoStackChanged();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeChange(RefactoringStatus status, final ChangeContext context, final IChange change, IProgressMonitor pm) throws JavaModelException {
        block16: {
            block14: {
                block15: {
                    if (this.fFlushListener != null) {
                        JavaCore.removeElementChangedListener((IElementChangedListener)this.fFlushListener);
                    }
                    if (this.fSaveListener != null) {
                        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fSaveListener);
                    }
                    try {
                        try {
                            pm.beginTask("", 10);
                            status.merge(change.aboutToPerform(context, (IProgressMonitor)new SubProgressMonitor(pm, 2)));
                            if (status.hasError()) {
                                Object var6_5 = null;
                                change.performed();
                                if (this.fFlushListener == null) break block14;
                                break block15;
                            }
                            JavaCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                                public void run(IProgressMonitor innerPM) throws CoreException {
                                    change.perform(context, innerPM);
                                }
                            }, (IProgressMonitor)new SubProgressMonitor(pm, 8));
                            break block16;
                        }
                        catch (JavaModelException e) {
                            throw e;
                        }
                        catch (CoreException e) {
                            throw new JavaModelException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        change.performed();
                        if (this.fFlushListener != null) {
                            JavaCore.addElementChangedListener((IElementChangedListener)this.fFlushListener);
                        }
                        if (this.fSaveListener != null) {
                            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fSaveListener);
                        }
                        pm.done();
                        throw throwable;
                    }
                }
                JavaCore.addElementChangedListener((IElementChangedListener)this.fFlushListener);
            }
            if (this.fSaveListener != null) {
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fSaveListener);
            }
            pm.done();
            return;
        }
        Object var6_7 = null;
        change.performed();
        if (this.fFlushListener != null) {
            JavaCore.addElementChangedListener((IElementChangedListener)this.fFlushListener);
        }
        if (this.fSaveListener != null) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fSaveListener);
        }
        pm.done();
    }

    public boolean anythingToRedo() {
        return !this.fRedoChanges.empty();
    }

    public boolean anythingToUndo() {
        return !this.fUndoChanges.empty();
    }

    public String peekUndoName() {
        if (this.fUndoNames.size() > 0) {
            return (String)this.fUndoNames.peek();
        }
        return null;
    }

    public String peekRedoName() {
        if (this.fRedoNames.size() > 0) {
            return (String)this.fRedoNames.peek();
        }
        return null;
    }

    private void fireUndoStackChanged() {
        if (this.fListeners == null) {
            return;
        }
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IUndoManagerListener)listeners[i]).undoStackChanged(this);
            ++i;
        }
    }

    private void fireRedoStackChanged() {
        if (this.fListeners == null) {
            return;
        }
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IUndoManagerListener)listeners[i]).redoStackChanged(this);
            ++i;
        }
    }

    private class FlushListener
    implements IElementChangedListener {
        FlushListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (UndoManager.this.fUndoChanges.isEmpty() && UndoManager.this.fRedoChanges.isEmpty()) {
                return;
            }
            this.processDelta(event.getDelta());
        }

        private boolean processDelta(IJavaElementDelta delta) {
            int kind = delta.getKind();
            int details = delta.getFlags();
            int type = delta.getElement().getElementType();
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (kind == 4 && details == 8) break;
                    UndoManager.this.flush();
                    return false;
                }
                case 5: {
                    if ((details & 0x10000) != 0) {
                        return true;
                    }
                    ICompilationUnit unit = (ICompilationUnit)delta.getElement();
                    if (unit.isWorkingCopy()) {
                        return true;
                    }
                    UndoManager.this.flush();
                    return false;
                }
                case 6: {
                    return true;
                }
                default: {
                    UndoManager.this.flush();
                    return false;
                }
            }
            IJavaElementDelta[] affectedChildren = delta.getAffectedChildren();
            if (affectedChildren == null) {
                return true;
            }
            int i = 0;
            while (i < affectedChildren.length) {
                if (!this.processDelta(affectedChildren[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private class SaveListener
    implements IResourceChangeListener {
        SaveListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(this){
                final /* synthetic */ SaveListener this$1;
                {
                    this.this$1 = saveListener;
                }

                public boolean visit(IResourceDelta delta) throws CoreException {
                    ICompilationUnit unit;
                    String ext;
                    IResource resource = delta.getResource();
                    if (resource.getType() == 1 && delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0 && (ext = ((IFile)resource).getFileExtension()) != null && "java".equals(ext) && (unit = JavaCore.createCompilationUnitFrom((IFile)((IFile)resource))) != null && unit.exists()) {
                        SaveListener.access$0(this.this$1).flush();
                        return false;
                    }
                    return true;
                }
            };
            try {
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    delta.accept(visitor);
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e.getStatus());
            }
        }

        static /* synthetic */ UndoManager access$0(SaveListener saveListener) {
            return saveListener.UndoManager.this;
        }
    }
}

