/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;

public class SearchResultGroup {
    private final IResource fResouce;
    private final List fSearchResults;

    public SearchResultGroup(IResource res, SearchResult[] results) {
        Assert.isNotNull(results);
        this.fResouce = res;
        this.fSearchResults = new ArrayList<SearchResult>(Arrays.asList(results));
    }

    public void add(SearchResult result) {
        Assert.isNotNull(result);
        this.fSearchResults.add(result);
    }

    public IResource getResource() {
        return this.fResouce;
    }

    public SearchResult[] getSearchResults() {
        return this.fSearchResults.toArray(new SearchResult[this.fSearchResults.size()]);
    }

    public static IResource[] getResources(SearchResultGroup[] searchResultGroups) {
        HashSet<IResource> resourceSet = new HashSet<IResource>(searchResultGroups.length);
        int i = 0;
        while (i < searchResultGroups.length) {
            resourceSet.add(searchResultGroups[i].getResource());
            ++i;
        }
        return resourceSet.toArray(new IResource[resourceSet.size()]);
    }

    public ICompilationUnit getCompilationUnit() {
        if (this.getSearchResults() == null || this.getSearchResults().length == 0) {
            return null;
        }
        return this.getSearchResults()[0].getCompilationUnit();
    }
}

