/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.SearchResult;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultCollector;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class RefactoringSearchEngine {
    private RefactoringSearchEngine() {
    }

    public static ICompilationUnit[] findAffectedCompilationUnits(final IProgressMonitor pm, IJavaSearchScope scope, ISearchPattern pattern) throws JavaModelException {
        final HashSet matches = new HashSet(5);
        IJavaSearchResultCollector collector = new IJavaSearchResultCollector(){
            private IResource fLastMatch;

            public void aboutToStart() {
            }

            public void accept(IResource resource, int start, int end, IJavaElement enclosingElement, int accuracy) throws CoreException {
                if (this.fLastMatch != resource) {
                    matches.add(resource);
                    this.fLastMatch = resource;
                }
            }

            public void done() {
            }

            public IProgressMonitor getProgressMonitor() {
                return pm;
            }
        };
        new SearchEngine().search(ResourcesPlugin.getWorkspace(), pattern, scope, collector);
        ArrayList<ICompilationUnit> result = new ArrayList<ICompilationUnit>(matches.size());
        Iterator iter = matches.iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            IJavaElement element = JavaCore.create((IResource)resource);
            if (!(element instanceof ICompilationUnit)) continue;
            ICompilationUnit original = (ICompilationUnit)element;
            result.add(JavaModelUtil.toWorkingCopy(original));
        }
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    public static SearchResultGroup[] search(IProgressMonitor pm, IJavaSearchScope scope, ISearchPattern pattern) throws JavaModelException {
        return RefactoringSearchEngine.search(scope, pattern, new SearchResultCollector(pm));
    }

    public static SearchResultGroup[] search(IJavaSearchScope scope, ISearchPattern pattern, SearchResultCollector collector) throws JavaModelException {
        return RefactoringSearchEngine.search(scope, pattern, collector, null);
    }

    public static SearchResultGroup[] search(IProgressMonitor pm, IJavaSearchScope scope, ISearchPattern pattern, ICompilationUnit[] workingCopies) throws JavaModelException {
        return RefactoringSearchEngine.search(scope, pattern, new SearchResultCollector(pm), workingCopies);
    }

    public static SearchResultGroup[] search(IJavaSearchScope scope, ISearchPattern pattern, SearchResultCollector collector, ICompilationUnit[] workingCopies) throws JavaModelException {
        RefactoringSearchEngine.internalSearch(scope, pattern, collector, workingCopies);
        return RefactoringSearchEngine.groupByResource(RefactoringSearchEngine.createSearchResultArray(collector.getResults()));
    }

    public static SearchResultGroup[] groupByResource(SearchResult[] results) {
        Map grouped = RefactoringSearchEngine.groupByResource(Arrays.asList(results));
        SearchResultGroup[] result = new SearchResultGroup[grouped.keySet().size()];
        int i = 0;
        Iterator iter = grouped.keySet().iterator();
        while (iter.hasNext()) {
            IResource resource = (IResource)iter.next();
            List searchResults = (List)grouped.get(resource);
            result[i] = new SearchResultGroup(resource, RefactoringSearchEngine.createSearchResultArray(searchResults));
            ++i;
        }
        return result;
    }

    private static SearchResult[] createSearchResultArray(List searchResults) {
        return searchResults.toArray(new SearchResult[searchResults.size()]);
    }

    private static Map groupByResource(List searchResults) {
        HashMap grouped = new HashMap();
        Iterator iter = searchResults.iterator();
        while (iter.hasNext()) {
            SearchResult searchResult = (SearchResult)iter.next();
            if (!grouped.containsKey(searchResult.getResource())) {
                grouped.put(searchResult.getResource(), new ArrayList(1));
            }
            ((List)grouped.get(searchResult.getResource())).add(searchResult);
        }
        return grouped;
    }

    private static void internalSearch(IJavaSearchScope scope, ISearchPattern pattern, IJavaSearchResultCollector collector, ICompilationUnit[] workingCopies) throws JavaModelException {
        if (pattern == null) {
            return;
        }
        Assert.isNotNull(scope, "scope");
        RefactoringSearchEngine.createSearchEngine(workingCopies).search(ResourcesPlugin.getWorkspace(), pattern, scope, collector);
    }

    private static SearchEngine createSearchEngine(ICompilationUnit[] workingCopies) {
        if (workingCopies == null) {
            return new SearchEngine();
        }
        return new SearchEngine(workingCopies);
    }

    public static ISearchPattern createSearchPattern(IJavaElement[] elements, int limitTo) {
        if (elements == null || elements.length == 0) {
            return null;
        }
        HashSet<IJavaElement> set = new HashSet<IJavaElement>(Arrays.asList(elements));
        Iterator iter = set.iterator();
        IJavaElement first = (IJavaElement)iter.next();
        ISearchPattern pattern = RefactoringSearchEngine.createSearchPattern(first, limitTo);
        while (iter.hasNext()) {
            IJavaElement each = (IJavaElement)iter.next();
            pattern = SearchEngine.createOrSearchPattern((ISearchPattern)pattern, (ISearchPattern)RefactoringSearchEngine.createSearchPattern(each, limitTo));
        }
        return pattern;
    }

    private static ISearchPattern createSearchPattern(IJavaElement element, int limitTo) {
        return SearchEngine.createSearchPattern((IJavaElement)element, (int)limitTo);
    }
}

