/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.corext.Assert;

public class ParameterInfo {
    private static final int INDEX_FOR_ADDED = -1;
    private final IVariableBinding fOldBinding;
    private final String fOldName;
    private final String fOldTypeName;
    private final int fOldIndex;
    private String fNewTypeName;
    private String fDefaultValue;
    private String fNewName;
    private Object fData;
    private boolean fIsDeleted;

    public ParameterInfo(String type, String name, int index) {
        this(null, type, name, index);
    }

    public ParameterInfo(IVariableBinding binding, String type, String name, int index) {
        this.fOldBinding = binding;
        this.fOldTypeName = type;
        this.fNewTypeName = type;
        this.fOldName = name;
        this.fNewName = name;
        this.fOldIndex = index;
        this.fDefaultValue = "";
        this.fIsDeleted = false;
    }

    public static ParameterInfo createInfoForAddedParameter() {
        return new ParameterInfo("", "", -1);
    }

    public boolean isDeleted() {
        return this.fIsDeleted;
    }

    public void markAsDeleted() {
        Assert.isTrue(!this.isAdded());
        this.fIsDeleted = true;
    }

    public boolean isAdded() {
        return this.fOldIndex == -1;
    }

    public String getDefaultValue() {
        return this.fDefaultValue;
    }

    public void setDefaultValue(String value) {
        Assert.isNotNull(value);
        this.fDefaultValue = value;
    }

    public IVariableBinding getOldBinding() {
        return this.fOldBinding;
    }

    public String getOldTypeName() {
        return this.fOldTypeName;
    }

    public String getNewTypeName() {
        return this.fNewTypeName;
    }

    public void setNewTypeName(String type) {
        Assert.isNotNull(type);
        this.fNewTypeName = type;
    }

    public String getOldName() {
        return this.fOldName;
    }

    public int getOldIndex() {
        return this.fOldIndex;
    }

    public void setNewName(String newName) {
        Assert.isNotNull(newName);
        this.fNewName = newName;
    }

    public String getNewName() {
        return this.fNewName;
    }

    public Object getData() {
        return this.fData;
    }

    public void setData(Object data) {
        this.fData = data;
    }

    public boolean isRenamed() {
        return !this.fOldName.equals(this.fNewName);
    }

    public boolean isTypeNameChanged() {
        return !this.fOldTypeName.equals(this.fNewTypeName);
    }
}

