/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.NullChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.Change;
import org.eclipse.jdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.jdt.internal.corext.refactoring.base.IChange;
import org.eclipse.jdt.internal.corext.refactoring.base.ICompositeChange;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;

public class CompositeChange
extends Change
implements ICompositeChange {
    private List fChanges;
    private IChange fUndoChange;
    private String fName;

    public CompositeChange() {
        this(RefactoringCoreMessages.getString("CompositeChange.CompositeChange"));
    }

    public CompositeChange(String name, IChange[] changes) {
        this(name, new ArrayList(changes.length));
        this.addAll(changes);
    }

    public CompositeChange(String name) {
        this(name, new ArrayList(5));
    }

    public CompositeChange(String name, int initialCapacity) {
        this(name, new ArrayList(initialCapacity));
    }

    private CompositeChange(String name, List changes) {
        this.fChanges = changes;
        this.fName = name;
    }

    public final RefactoringStatus aboutToPerform(ChangeContext context, IProgressMonitor pm) {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask("", this.fChanges.size() + 1);
        result.merge(super.aboutToPerform(context, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        Iterator iter = this.fChanges.iterator();
        while (iter.hasNext()) {
            result.merge(((IChange)iter.next()).aboutToPerform(context, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        }
        return result;
    }

    public final void performed() {
        Iterator iter = this.fChanges.iterator();
        while (iter.hasNext()) {
            ((IChange)iter.next()).performed();
        }
    }

    public final IChange getUndoChange() {
        return this.fUndoChange;
    }

    public void addAll(IChange[] changes) {
        int i = 0;
        while (i < changes.length) {
            this.add(changes[i]);
            ++i;
        }
    }

    public void add(IChange change) {
        if (change != null) {
            this.fChanges.add(change);
        }
    }

    public IChange[] getChildren() {
        if (this.fChanges == null) {
            return null;
        }
        return this.fChanges.toArray(new IChange[this.fChanges.size()]);
    }

    final List getChanges() {
        return this.fChanges;
    }

    private List createUndoList(ChangeContext context, IProgressMonitor pm) throws JavaModelException {
        ArrayList<IChange> undoList = null;
        try {
            undoList = new ArrayList<IChange>(this.fChanges.size());
            pm.beginTask("", this.fChanges.size());
            Iterator iter = this.fChanges.iterator();
            while (iter.hasNext()) {
                try {
                    IChange each = (IChange)iter.next();
                    each.perform(context, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    undoList.add(each.getUndoChange());
                    context.addPerformedChange(each);
                }
                catch (Exception e) {
                    this.handleException(context, e);
                }
            }
            pm.done();
            Collections.reverse(undoList);
            return undoList;
        }
        catch (Exception e) {
            this.handleException(context, e);
            if (undoList == null) {
                undoList = new ArrayList(0);
            }
            return undoList;
        }
    }

    public final void perform(ChangeContext context, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 1);
        pm.setTaskName(RefactoringCoreMessages.getString("CompositeChange.performingChangesTask.name"));
        this.fUndoChange = !this.isActive() ? new NullChange() : new CompositeChange(this.fName, this.createUndoList(context, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        pm.done();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("CompositeChange\n");
        Iterator iter = this.fChanges.iterator();
        while (iter.hasNext()) {
            buff.append("<").append(iter.next().toString()).append("/>\n");
        }
        return buff.toString();
    }

    public String getName() {
        return this.fName;
    }

    public Object getModifiedLanguageElement() {
        return null;
    }

    public void setActive(boolean active) {
        Iterator iter = this.fChanges.iterator();
        while (iter.hasNext()) {
            ((IChange)iter.next()).setActive(active);
        }
    }

    public boolean isUndoable() {
        Iterator iter = this.fChanges.iterator();
        while (iter.hasNext()) {
            IChange each = (IChange)iter.next();
            if (each.isUndoable()) continue;
            return false;
        }
        return true;
    }
}

