/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Resources;

public class Checks {
    public static final int IS_RVALUE = 0;
    public static final int NOT_RVALUE_MISC = 1;
    public static final int NOT_RVALUE_VOID = 2;
    static /* synthetic */ Class class$0;

    private Checks() {
    }

    public static RefactoringStatus checkIfConstructorName(IMethod method, String newMethodName, String newTypeName) {
        if (!newMethodName.equals(newTypeName)) {
            return null;
        }
        return RefactoringStatus.createWarningStatus(RefactoringCoreMessages.getFormattedString("Checks.constructor_name", new Object[]{JavaElementUtil.createMethodSignature(method), JavaModelUtil.getFullyQualifiedName(method.getDeclaringType())}));
    }

    public static RefactoringStatus checkFieldName(String name) {
        return Checks.checkName(name, JavaConventions.validateFieldName((String)name));
    }

    public static RefactoringStatus checkIdentifier(String name) {
        return Checks.checkName(name, JavaConventions.validateIdentifier((String)name));
    }

    public static RefactoringStatus checkMethodName(String name) {
        RefactoringStatus status = Checks.checkName(name, JavaConventions.validateMethodName((String)name));
        if (status.isOK() && Checks.startsWithUpperCase(name)) {
            return RefactoringStatus.createWarningStatus(RefactoringCoreMessages.getString("Checks.method_names_lowercase"));
        }
        return status;
    }

    public static RefactoringStatus checkTypeName(String name) {
        if (name.indexOf(".") != -1) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("Checks.no_dot"));
        }
        return Checks.checkName(name, JavaConventions.validateJavaTypeName((String)name));
    }

    public static RefactoringStatus checkPackageName(String name) {
        return Checks.checkName(name, JavaConventions.validatePackageName((String)name));
    }

    public static RefactoringStatus checkCompilationUnitName(String name) {
        return Checks.checkName(name, JavaConventions.validateCompilationUnitName((String)name));
    }

    public static RefactoringStatus checkCompilationUnitNewName(ICompilationUnit cu, String newName) throws JavaModelException {
        if (Checks.resourceExists(RenameResourceChange.renamedResourcePath(ResourceUtil.getResource(cu).getFullPath(), String.valueOf(newName) + ".java"))) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getFormattedString("Checks.cu_name_used", newName));
        }
        return new RefactoringStatus();
    }

    private static boolean startsWithUpperCase(String s) {
        if (s == null) {
            return false;
        }
        if ("".equals(s)) {
            return false;
        }
        return s.charAt(0) == Character.toUpperCase(s.charAt(0));
    }

    public static boolean startsWithLowerCase(String s) {
        if (s == null) {
            return false;
        }
        if ("".equals(s)) {
            return false;
        }
        return s.charAt(0) == Character.toLowerCase(s.charAt(0));
    }

    public static boolean resourceExists(IPath resourcePath) {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(resourcePath) != null;
    }

    public static boolean isTopLevel(IType type) {
        return type.getDeclaringType() == null;
    }

    public static boolean isTopLevelType(IMember member) {
        return member.getElementType() == 7 && Checks.isTopLevel((IType)member);
    }

    public static boolean isAlreadyNamed(IJavaElement element, String name) {
        return name.equals(element.getElementName());
    }

    public static RefactoringStatus checkForNativeMethods(IType type) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(Checks.checkForNativeMethods(type.getMethods()));
        result.merge(Checks.checkForNativeMethods(type.getTypes()));
        return result;
    }

    public static RefactoringStatus checkForNativeMethods(IType[] types) throws JavaModelException {
        if (types == null) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < types.length) {
            result.merge(Checks.checkForNativeMethods(types[i]));
            ++i;
        }
        return result;
    }

    public static RefactoringStatus checkForNativeMethods(ICompilationUnit cu) throws JavaModelException {
        return Checks.checkForNativeMethods(cu.getTypes());
    }

    private static RefactoringStatus checkForNativeMethods(IMethod[] methods) throws JavaModelException {
        if (methods == null) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < methods.length) {
            if (JdtFlags.isNative((IMember)methods[i])) {
                String msg = RefactoringCoreMessages.getFormattedString("Checks.method_native", new String[]{JavaModelUtil.getFullyQualifiedName(methods[i].getDeclaringType()), methods[i].getElementName(), "UnsatisfiedLinkError"});
                result.addError(msg, JavaStatusContext.create((IMember)methods[i]));
            }
            ++i;
        }
        return result;
    }

    public static RefactoringStatus checkMethodInType(ITypeBinding type, String methodName, ITypeBinding[] parameters, IJavaProject scope) {
        IMethodBinding method;
        RefactoringStatus result = new RefactoringStatus();
        if (methodName.equals(type.getName())) {
            result.addWarning(RefactoringCoreMessages.getString("Checks.methodName.constructor"));
        }
        if ((method = Bindings.findMethodInType(type, methodName, parameters)) != null) {
            result.addError(RefactoringCoreMessages.getFormattedString("Checks.methodName.exists", new Object[]{methodName, type.getName()}), JavaStatusContext.create(method, scope));
        }
        return result;
    }

    public static RefactoringStatus checkMethodInHierarchy(ITypeBinding type, String methodName, ITypeBinding returnType, ITypeBinding[] parameters, IJavaProject scope) {
        RefactoringStatus result = new RefactoringStatus();
        IMethodBinding method = Bindings.findMethodInHierarchy(type, methodName, parameters);
        if (method != null) {
            boolean returnTypeClash = false;
            ITypeBinding methodReturnType = method.getReturnType();
            if (returnType != null && methodReturnType != null) {
                String returnTypeKey = returnType.getKey();
                String methodReturnTypeKey = methodReturnType.getKey();
                if (returnTypeKey == null && methodReturnTypeKey == null) {
                    returnTypeClash = returnType != methodReturnType;
                } else if (returnTypeKey != null && methodReturnTypeKey != null) {
                    returnTypeClash = !returnTypeKey.equals(methodReturnTypeKey);
                }
            }
            ITypeBinding dc = method.getDeclaringClass();
            if (returnTypeClash) {
                result.addError(RefactoringCoreMessages.getFormattedString("Checks.methodName.returnTypeClash", new Object[]{methodName, dc.getName()}), JavaStatusContext.create(method, scope));
            } else {
                result.addError(RefactoringCoreMessages.getFormattedString("Checks.methodName.overrides", new Object[]{methodName, dc.getName()}), JavaStatusContext.create(method, scope));
            }
        }
        return result;
    }

    public static RefactoringStatus checkForMainMethod(IType type) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        if (JavaModelUtil.hasMainMethod(type)) {
            result.addWarning(RefactoringCoreMessages.getFormattedString("Checks.has_main", JavaModelUtil.getFullyQualifiedName(type)));
        }
        result.merge(Checks.checkForMainMethods(type.getTypes()));
        return result;
    }

    public static RefactoringStatus checkForMainMethods(IType[] types) throws JavaModelException {
        if (types == null) {
            return null;
        }
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < types.length) {
            result.merge(Checks.checkForMainMethod(types[i]));
            ++i;
        }
        return result;
    }

    public static RefactoringStatus checkForMainMethods(ICompilationUnit cu) throws JavaModelException {
        return Checks.checkForMainMethods(cu.getTypes());
    }

    public static boolean isExtractableExpression(ASTNode[] selectedNodes, ASTNode coveringNode) {
        ASTNode node = coveringNode;
        if (selectedNodes != null && selectedNodes.length == 1) {
            node = selectedNodes[0];
        }
        return Checks.isExtractableExpression(node);
    }

    public static boolean isExtractableExpression(ASTNode node) {
        if (!(node instanceof Expression)) {
            return false;
        }
        if (node instanceof Name) {
            IBinding binding = ((Name)node).resolveBinding();
            return !(binding instanceof ITypeBinding);
        }
        return true;
    }

    private static RefactoringStatus checkName(String name, IStatus status) {
        RefactoringStatus result = new RefactoringStatus();
        if ("".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("Checks.Choose_name"));
        }
        if (status.isOK()) {
            return result;
        }
        switch (status.getSeverity()) {
            case 4: {
                return RefactoringStatus.createFatalErrorStatus(status.getMessage());
            }
            case 2: {
                return RefactoringStatus.createWarningStatus(status.getMessage());
            }
            case 1: {
                return RefactoringStatus.createInfoStatus(status.getMessage());
            }
        }
        return new RefactoringStatus();
    }

    public static IMethod findMethod(String name, int parameterCount, boolean isConstructor, IType type) throws JavaModelException {
        return Checks.findMethod(name, parameterCount, isConstructor, type.getMethods());
    }

    public static IMethod findMethod(IMethod method, IType type) throws JavaModelException {
        return Checks.findMethod(method.getElementName(), method.getParameterTypes().length, method.isConstructor(), type.getMethods());
    }

    public static IMethod findMethod(IMethod method, IMethod[] methods) throws JavaModelException {
        return Checks.findMethod(method.getElementName(), method.getParameterTypes().length, method.isConstructor(), methods);
    }

    public static IMethod findMethod(String name, int parameters, boolean isConstructor, IMethod[] methods) throws JavaModelException {
        int i = methods.length - 1;
        while (i >= 0) {
            IMethod curr = methods[i];
            if (name.equals(curr.getElementName()) && isConstructor == curr.isConstructor() && parameters == curr.getParameterTypes().length) {
                return curr;
            }
            --i;
        }
        return null;
    }

    public static IMethod findSimilarMethod(IMethod method, IType type) throws JavaModelException {
        return Checks.findSimilarMethod(method, type.getMethods());
    }

    public static IMethod findSimilarMethod(IMethod method, IMethod[] methods) throws JavaModelException {
        boolean isConstructor = method.isConstructor();
        int i = 0;
        while (i < methods.length) {
            IMethod otherMethod = methods[i];
            if (otherMethod.isConstructor() == isConstructor && method.isSimilar(otherMethod)) {
                return otherMethod;
            }
            ++i;
        }
        return null;
    }

    public static boolean compareParamTypes(String[] paramTypes1, String[] paramTypes2) {
        if (paramTypes1.length == paramTypes2.length) {
            int i = 0;
            while (i < paramTypes1.length) {
                String t2;
                String t1 = Signature.getSimpleName((String)Signature.toString((String)paramTypes1[i]));
                if (!t1.equals(t2 = Signature.getSimpleName((String)Signature.toString((String)paramTypes2[i])))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static RefactoringStatus checkIfCuBroken(IMember member) throws JavaModelException {
        ICompilationUnit cu = (ICompilationUnit)JavaCore.create((IResource)ResourceUtil.getResource(member));
        if (cu == null) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("Checks.cu_not_created"));
        }
        if (!cu.isStructureKnown()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("Checks.cu_not_parsed"));
        }
        return new RefactoringStatus();
    }

    public static SearchResultGroup[] excludeCompilationUnits(SearchResultGroup[] grouped, RefactoringStatus status) throws JavaModelException {
        ArrayList<SearchResultGroup> result = new ArrayList<SearchResultGroup>();
        boolean wasEmpty = grouped.length == 0;
        int i = 0;
        while (i < grouped.length) {
            IResource resource = grouped[i].getResource();
            IJavaElement element = JavaCore.create((IResource)resource);
            if (element instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)JavaCore.create((IResource)resource);
                if (!cu.isStructureKnown()) {
                    String path = Checks.getFullPath(cu);
                    status.addError(RefactoringCoreMessages.getFormattedString("Checks.cannot_be_parsed", path));
                } else {
                    result.add(grouped[i]);
                }
            }
            ++i;
        }
        if (!wasEmpty && result.isEmpty()) {
            status.addFatalError(RefactoringCoreMessages.getString("Checks.all_excluded"));
        }
        return result.toArray(new SearchResultGroup[result.size()]);
    }

    private static final String getFullPath(ICompilationUnit cu) {
        Assert.isTrue(cu.exists());
        return ResourceUtil.getResource(cu).getFullPath().toString();
    }

    public static RefactoringStatus checkCompileErrorsInAffectedFiles(SearchResultGroup[] grouped) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < grouped.length) {
            IResource resource = grouped[i].getResource();
            if (Checks.hasCompileErrors(resource)) {
                result.addWarning(RefactoringCoreMessages.getFormattedString("Checks.cu_has_compile_errors", resource.getFullPath().makeRelative()));
            }
            ++i;
        }
        return result;
    }

    private static boolean hasCompileErrors(IResource resource) throws JavaModelException {
        try {
            IMarker[] problemMarkers = resource.findMarkers("org.eclipse.jdt.core.problem", true, 2);
            int i = 0;
            while (i < problemMarkers.length) {
                if (problemMarkers[i].getAttribute("severity", -1) == 2) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public static boolean isReadOnly(Object element) throws JavaModelException {
        if (element instanceof IResource) {
            return Checks.isReadOnly((IResource)element);
        }
        if (element instanceof IJavaElement) {
            if (element instanceof IPackageFragmentRoot && Checks.isClasspathDelete((IPackageFragmentRoot)element)) {
                return false;
            }
            return Checks.isReadOnly(((IJavaElement)element).getResource());
        }
        Assert.isTrue(false, "not expected to get here");
        return false;
    }

    public static boolean isReadOnly(IResource res) throws JavaModelException {
        if (res.isReadOnly()) {
            return true;
        }
        if (!(res instanceof IContainer)) {
            return false;
        }
        IContainer container = (IContainer)res;
        try {
            IResource[] children = container.members();
            int i = 0;
            while (i < children.length) {
                if (Checks.isReadOnly(children[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (JavaModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public static boolean isClasspathDelete(IPackageFragmentRoot pkgRoot) throws JavaModelException {
        IResource res = pkgRoot.getResource();
        if (res == null) {
            return true;
        }
        IProject definingProject = res.getProject();
        if (res.getParent() != null && pkgRoot.isArchive() && !res.getParent().equals((Object)definingProject)) {
            return true;
        }
        IProject occurringProject = pkgRoot.getJavaProject().getProject();
        return !definingProject.equals((Object)occurringProject);
    }

    public static RefactoringStatus validateModifiesFiles(IFile[] filesToModify) {
        RefactoringStatus result = new RefactoringStatus();
        IStatus status = Resources.checkInSync((IResource[])filesToModify);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create(status));
        }
        if (!(status = Resources.makeCommittable((IResource[])filesToModify, null)).isOK()) {
            result.merge(RefactoringStatus.create(status));
        }
        return result;
    }

    public static RefactoringStatus validateEdit(ICompilationUnit unit) {
        IResource resource = JavaModelUtil.toOriginal(unit).getResource();
        RefactoringStatus result = new RefactoringStatus();
        if (resource == null) {
            return result;
        }
        IStatus status = Resources.checkInSync(resource);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create(status));
        }
        if (!(status = Resources.makeCommittable(resource, null)).isOK()) {
            result.merge(RefactoringStatus.create(status));
        }
        return result;
    }

    public static RefactoringStatus checkAvailability(IJavaElement javaElement) throws JavaModelException {
        RefactoringStatus result = new RefactoringStatus();
        if (!javaElement.exists()) {
            result.addFatalError(RefactoringCoreMessages.getFormattedString("Refactoring.not_in_model", javaElement.getElementName()));
        }
        if (javaElement.isReadOnly()) {
            result.addFatalError(RefactoringCoreMessages.getFormattedString("Refactoring.read_only", javaElement.getElementName()));
        }
        if (javaElement.exists() && !javaElement.isStructureKnown()) {
            result.addFatalError(RefactoringCoreMessages.getFormattedString("Refactoring.unknown_structure", javaElement.getElementName()));
        }
        if (javaElement instanceof IMember && ((IMember)javaElement).isBinary()) {
            result.addFatalError(RefactoringCoreMessages.getFormattedString("Refactoring.binary", javaElement.getElementName()));
        }
        return result;
    }

    public static boolean isAvailable(IJavaElement javaElement) throws JavaModelException {
        if (javaElement == null) {
            return false;
        }
        if (!javaElement.exists()) {
            return false;
        }
        if (javaElement.isReadOnly()) {
            return false;
        }
        if (!(javaElement instanceof ILocalVariable) && !javaElement.isStructureKnown()) {
            return false;
        }
        return !(javaElement instanceof IMember) || !((IMember)javaElement).isBinary();
    }

    public static IType findTypeInPackage(IPackageFragment pack, String name) throws JavaModelException {
        Assert.isTrue(pack.exists());
        Assert.isTrue(!pack.isReadOnly());
        if (name.indexOf(".") != -1) {
            name = name.substring(0, name.indexOf("."));
        }
        ICompilationUnit[] cus = pack.getCompilationUnits();
        int i = 0;
        while (i < cus.length) {
            if (cus[i].getType(name).exists()) {
                return cus[i].getType(name);
            }
            ++i;
        }
        return null;
    }

    public static RefactoringStatus checkTempName(String newName) {
        RefactoringStatus result = Checks.checkIdentifier(newName);
        if (result.hasFatalError()) {
            return result;
        }
        if (!Checks.startsWithLowerCase(newName)) {
            result.addWarning(RefactoringCoreMessages.getString("ExtractTempRefactoring.convention"));
        }
        return result;
    }

    public static RefactoringStatus checkConstantName(String newName) {
        RefactoringStatus result = Checks.checkFieldName(newName);
        if (result.hasFatalError()) {
            return result;
        }
        int i = 0;
        while (i < newName.length()) {
            char c = newName.charAt(i);
            if (Character.isLetter(c) && !Character.isUpperCase(c)) {
                result.addWarning(RefactoringCoreMessages.getString("ExtractConstantRefactoring.convention"));
                break;
            }
            ++i;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isException(IType iType, IProgressMonitor pm) throws JavaModelException {
        block7: {
            block8: {
                block6: {
                    try {
                        if (iType.isInterface()) {
                            Object var4_2 = null;
                            break block6;
                        }
                        IType[] superTypes = iType.newSupertypeHierarchy(pm).getAllSupertypes(iType);
                        int i = 0;
                        while (true) {
                            if (i >= superTypes.length) {
                                break block7;
                            }
                            if ("java.lang.Throwable".equals(superTypes[i].getFullyQualifiedName())) {
                                break block8;
                            }
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        pm.done();
                        throw throwable;
                    }
                }
                pm.done();
                return false;
            }
            Object var4_3 = null;
            pm.done();
            return true;
        }
        Object var4_4 = null;
        pm.done();
        return false;
    }

    public static int checkExpressionIsRValue(Expression e) {
        if (e instanceof Name && !(((Name)e).resolveBinding() instanceof IVariableBinding)) {
            return 1;
        }
        ITypeBinding tb = e.resolveTypeBinding();
        if (tb == null) {
            return 1;
        }
        if (tb.getName().equals("void")) {
            return 2;
        }
        return 0;
    }

    public static boolean isDeclaredIn(VariableDeclaration tempDeclaration, Class astNodeClass) {
        ASTNode anonymous;
        ASTNode initializer = ASTNodes.getParent((ASTNode)tempDeclaration, astNodeClass);
        if (initializer == null) {
            return false;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.core.dom.AnonymousClassDeclaration;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((anonymous = ASTNodes.getParent((ASTNode)tempDeclaration, clazz)) == null) {
            return true;
        }
        return !ASTNodes.isParent(anonymous, initializer);
    }
}

