/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.javadoc;

import java.util.ArrayList;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocCommentReader;

public class JavaDocTag {
    public static final String PARAM = "param";
    public static final String RETURN = "return";
    public static final String THROWS = "throws";
    public static final String EXCEPTION = "exception";
    private int fOffset;
    private int fLength;
    private int fContentOffset;
    private int fContentLength;
    private String fName;
    private String fContent;

    public JavaDocTag(String name, String content, int offset, int length, int contentOffset, int contentLength) {
        this.fOffset = offset;
        this.fLength = length;
        this.fContentOffset = contentOffset;
        this.fContentLength = contentLength;
        this.fName = name;
        this.fContent = content;
    }

    public JavaDocTag(String tag, String content) {
        this(tag, content, 0, 0, 0, 0);
    }

    public String getName() {
        return this.fName;
    }

    public String getContent() {
        return this.fContent;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getContentOffset() {
        return this.fContentOffset;
    }

    public int getContentLength() {
        return this.fContentLength;
    }

    public static JavaDocTag[] createFromComment(JavaDocCommentReader reader) {
        ArrayList res = new ArrayList();
        int ch = reader.read();
        while (ch != -1 && Character.isWhitespace((char)ch)) {
            ch = reader.read();
        }
        if (ch == -1) {
            return new JavaDocTag[0];
        }
        while ((ch = JavaDocTag.readTag(reader, ch, res)) != -1) {
        }
        return res.toArray(new JavaDocTag[res.size()]);
    }

    private static int readTag(JavaDocCommentReader reader, int ch, ArrayList res) {
        int descStart;
        boolean isFirstSentence = ch != 64;
        int tagStart = reader.getOffset() - 1;
        String name = null;
        int prev = -1;
        if (!isFirstSentence) {
            StringBuffer nameBuffer = new StringBuffer();
            prev = ch;
            ch = reader.read();
            while (ch != -1 && (ch != 64 || prev == 123) && Character.isLetterOrDigit((char)ch)) {
                nameBuffer.append((char)ch);
                prev = ch;
                ch = reader.read();
            }
            name = nameBuffer.toString();
        }
        while (ch != -1 && Character.isWhitespace((char)ch)) {
            prev = ch;
            ch = reader.read();
        }
        int tagEnd = descStart = reader.getOffset() - 1;
        int tagBufEnd = 0;
        int descEnd = descStart;
        StringBuffer descBuffer = new StringBuffer();
        while (ch != -1 && (ch != 64 || prev == 123)) {
            descBuffer.append((char)ch);
            if (!Character.isWhitespace((char)ch)) {
                descEnd = reader.getOffset();
                tagBufEnd = descBuffer.length();
            }
            prev = ch;
            ch = reader.read();
        }
        tagEnd = reader.getOffset();
        if (ch != -1) {
            --tagEnd;
        }
        descBuffer.setLength(tagBufEnd);
        res.add(new JavaDocTag(name, descBuffer.toString(), tagStart, tagEnd - tagStart, descStart, descEnd - descStart));
        return ch;
    }
}

