/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.javadoc;

import java.io.IOException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocCommentReader;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocTag;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

public class JavaDocAccess {
    public static JavaDocCommentReader getJavaDoc(IMember member, boolean allowInherited) throws JavaModelException {
        IBuffer buf;
        IBuffer iBuffer = buf = member.isBinary() ? member.getClassFile().getBuffer() : member.getCompilationUnit().getBuffer();
        if (buf == null) {
            return null;
        }
        ISourceRange range = member.getSourceRange();
        int start = range.getOffset();
        int length = range.getLength();
        if (length > 0 && buf.getChar(start) == '/') {
            IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
            scanner.setSource(buf.getCharacters());
            scanner.resetTo(start, start + length - 1);
            try {
                int terminal = scanner.getNextToken();
                while (terminal == 1001 || terminal == 1002) {
                    terminal = scanner.getNextToken();
                }
                if (terminal == 1003) {
                    start = scanner.getCurrentTokenStartPosition();
                    int end = scanner.getCurrentTokenEndPosition() + 1;
                    return new JavaDocCommentReader(buf, start, end);
                }
            }
            catch (InvalidInputException invalidInputException) {}
        }
        if (allowInherited && member.getElementType() == 9) {
            IMethod method = (IMethod)member;
            return JavaDocAccess.findDocInHierarchy(method.getDeclaringType(), method.getElementName(), method.getParameterTypes(), method.isConstructor());
        }
        return null;
    }

    public static JavaDocCommentReader getJavaDoc(IMember member) throws JavaModelException {
        return JavaDocAccess.getJavaDoc(member, false);
    }

    private static JavaDocCommentReader findDocInHierarchy(IType type, String name, String[] paramTypes, boolean isConstructor) throws JavaModelException {
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        IType[] superTypes = hierarchy.getAllSupertypes(type);
        int i = 0;
        while (i < superTypes.length) {
            JavaDocCommentReader reader;
            IMethod method = JavaModelUtil.findMethod(name, paramTypes, isConstructor, superTypes[i]);
            if (method != null && (reader = JavaDocAccess.getJavaDoc((IMember)method, false)) != null) {
                return reader;
            }
            ++i;
        }
        return null;
    }

    public static String getJavaDocTextString(IMember member, boolean allowInherited) throws JavaModelException {
        try {
            JavaDocCommentReader rd = JavaDocAccess.getJavaDoc(member, allowInherited);
            if (rd != null) {
                return rd.getString();
            }
        }
        catch (IOException e) {
            throw new JavaModelException((Throwable)e, 4);
        }
        return null;
    }

    public static JavaDocTag[] getJavaDocTags(IOpenable openable, int offset, int length) throws JavaModelException {
        IBuffer buffer = openable.getBuffer();
        if (buffer != null) {
            return JavaDocTag.createFromComment(new JavaDocCommentReader(buffer, offset, offset + length));
        }
        return null;
    }

    public static JavaDocTag[] getJavaDocTags(IMember member, boolean allowInherited) throws JavaModelException {
        JavaDocCommentReader rd = JavaDocAccess.getJavaDoc(member, allowInherited);
        if (rd != null) {
            return JavaDocTag.createFromComment(rd);
        }
        return null;
    }
}

