/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.ISourceModifier;
import org.eclipse.text.edits.ReplaceEdit;

public class SourceModifier
implements ISourceModifier {
    private String fDestinationIndent;
    private int fSourceIndentLevel;
    private int fTabWidth;

    public SourceModifier(int sourceIndentLevel, String destinationIndent, int tabWidth) {
        this.fDestinationIndent = destinationIndent;
        this.fSourceIndentLevel = sourceIndentLevel;
        this.fTabWidth = tabWidth;
    }

    public static SourceModifier createCopyModifier(int sourceIndentLevel, String destIndentString, int tabWidth) {
        return new SourceModifier(sourceIndentLevel, destIndentString, tabWidth);
    }

    public static SourceModifier createMoveModifier(int sourceIndentLevel, String destIndentString, int tabWidth) {
        return new SourceModifier(sourceIndentLevel, destIndentString, tabWidth);
    }

    public ISourceModifier copy() {
        return this;
    }

    public ReplaceEdit[] getModifications(String source) {
        ArrayList<ReplaceEdit> result = new ArrayList<ReplaceEdit>();
        int destIndentLevel = Strings.computeIndent(this.fDestinationIndent, this.fTabWidth);
        if (destIndentLevel == this.fSourceIndentLevel) {
            return result.toArray(new ReplaceEdit[result.size()]);
        }
        try {
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(source);
            int nLines = tracker.getNumberOfLines();
            if (nLines == 1) {
                return result.toArray(new ReplaceEdit[result.size()]);
            }
            int i = 1;
            while (i < nLines) {
                IRegion region = tracker.getLineInformation(i);
                int offset = region.getOffset();
                String line = source.substring(offset, offset + region.getLength());
                int length = Strings.computeIndentLength(line, this.fSourceIndentLevel, this.fTabWidth);
                if (length >= 0) {
                    result.add(new ReplaceEdit(offset, length, this.fDestinationIndent));
                } else {
                    length = Strings.computeIndent(line, this.fTabWidth);
                    result.add(new ReplaceEdit(offset, length, ""));
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        return result.toArray(new ReplaceEdit[result.size()]);
    }
}

