/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.corext.dom.ASTNodeConstants;
import org.eclipse.jdt.internal.corext.dom.ListRewriteEvent;
import org.eclipse.jdt.internal.corext.dom.NodeRewriteEvent;
import org.eclipse.jdt.internal.corext.dom.RewriteEvent;
import org.eclipse.jdt.internal.corext.textmanipulation.GroupDescription;

public final class RewriteEventStore {
    private final ArrayList fEvents = new ArrayList();
    private EventHolder fLastEvent = null;
    private HashMap fEventDescriptions = null;
    private HashMap fNodeSourceDatas = new HashMap();
    private HashSet fInsertBoundToPrevious = null;
    private INodePropertyMapper fNodePropertyMapper = null;

    public void setNodePropertyMapper(INodePropertyMapper nodePropertyMapper) {
        this.fNodePropertyMapper = nodePropertyMapper;
    }

    public void clear() {
        this.fEvents.clear();
        this.fLastEvent = null;
        this.fNodeSourceDatas.clear();
        this.fEventDescriptions = null;
        this.fInsertBoundToPrevious = null;
    }

    public void addEvent(ASTNode parent, int childProperty, RewriteEvent event) {
        this.validateHasChildProperty(parent, childProperty);
        if (event.isListRewrite()) {
            this.validateIsListProperty(childProperty);
        }
        EventHolder holder = new EventHolder(parent, childProperty, event);
        int i = 0;
        while (i < this.fEvents.size()) {
            EventHolder curr = (EventHolder)this.fEvents.get(i);
            if (curr.parent == parent && curr.childProperty == childProperty) {
                this.fEvents.set(i, holder);
                this.fLastEvent = null;
                return;
            }
            ++i;
        }
        this.fEvents.add(holder);
    }

    public RewriteEvent getEvent(ASTNode parent, int property) {
        this.validateHasChildProperty(parent, property);
        if (this.fLastEvent != null && this.fLastEvent.parent == parent && this.fLastEvent.childProperty == property) {
            return this.fLastEvent.event;
        }
        int i = 0;
        while (i < this.fEvents.size()) {
            EventHolder holder = (EventHolder)this.fEvents.get(i);
            if (holder.parent == parent && holder.childProperty == property) {
                this.fLastEvent = holder;
                return holder.event;
            }
            ++i;
        }
        return null;
    }

    public NodeRewriteEvent getNodeEvent(ASTNode parent, int childProperty, boolean forceCreation) {
        this.validateIsNodeProperty(childProperty);
        NodeRewriteEvent event = (NodeRewriteEvent)this.getEvent(parent, childProperty);
        if (event == null && forceCreation) {
            Object originalValue = this.accessOriginalValue(parent, childProperty);
            event = new NodeRewriteEvent(originalValue, originalValue);
            this.addEvent(parent, childProperty, event);
        }
        return event;
    }

    public ListRewriteEvent getListEvent(ASTNode parent, int childProperty, boolean forceCreation) {
        this.validateIsListProperty(childProperty);
        ListRewriteEvent event = (ListRewriteEvent)this.getEvent(parent, childProperty);
        if (event == null && forceCreation) {
            List originalValue = (List)this.accessOriginalValue(parent, childProperty);
            event = new ListRewriteEvent(originalValue);
            this.addEvent(parent, childProperty, event);
        }
        return event;
    }

    public boolean hasChildrenChanges(ASTNode parent) {
        int i = 0;
        while (i < this.fEvents.size()) {
            EventHolder holder = (EventHolder)this.fEvents.get(i);
            if (holder.parent == parent) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public RewriteEvent findEventByOriginal(Object original) {
        int i = 0;
        while (i < this.fEvents.size()) {
            RewriteEvent event = ((EventHolder)this.fEvents.get((int)i)).event;
            if (event.getOriginalValue() == original) {
                return event;
            }
            if (event.isListRewrite()) {
                RewriteEvent[] children = event.getChildren();
                int k = 0;
                while (k < children.length) {
                    if (children[k].getOriginalValue() == original) {
                        return children[k];
                    }
                    ++k;
                }
            }
            ++i;
        }
        return null;
    }

    public RewriteEvent findEventByNew(Object original) {
        int i = 0;
        while (i < this.fEvents.size()) {
            RewriteEvent event = ((EventHolder)this.fEvents.get((int)i)).event;
            if (event.getNewValue() == original) {
                return event;
            }
            if (event.isListRewrite()) {
                RewriteEvent[] children = event.getChildren();
                int k = 0;
                while (k < children.length) {
                    if (children[k].getNewValue() == original) {
                        return children[k];
                    }
                    ++k;
                }
            }
            ++i;
        }
        return null;
    }

    public Object getOriginalValue(ASTNode parent, int property) {
        RewriteEvent event = this.getEvent(parent, property);
        if (event != null) {
            return event.getOriginalValue();
        }
        return this.accessOriginalValue(parent, property);
    }

    public Object getNewValue(ASTNode parent, int property) {
        RewriteEvent event = this.getEvent(parent, property);
        if (event != null) {
            return event.getNewValue();
        }
        return this.accessOriginalValue(parent, property);
    }

    public int getChangeKind(ASTNode node) {
        RewriteEvent event = this.findEventByOriginal(node);
        if (event != null) {
            return event.getChangeKind();
        }
        return 0;
    }

    private Object accessOriginalValue(ASTNode parent, int childProperty) {
        if (this.fNodePropertyMapper != null) {
            return this.fNodePropertyMapper.getOriginalValue(parent, childProperty);
        }
        return ASTNodeConstants.getNodeChild(parent, childProperty);
    }

    public GroupDescription getEventDescription(RewriteEvent event) {
        if (this.fEventDescriptions == null) {
            return null;
        }
        return (GroupDescription)this.fEventDescriptions.get(event);
    }

    public void setEventDescription(RewriteEvent event, GroupDescription desc) {
        if (desc != null) {
            if (this.fEventDescriptions == null) {
                this.fEventDescriptions = new HashMap(5);
            }
            this.fEventDescriptions.put(event, desc);
        }
    }

    public NodeSourceData getNodeSourceData(ASTNode node) {
        return (NodeSourceData)this.fNodeSourceDatas.get(node);
    }

    public NodeSourceData createNodeSourceData(ASTNode node) {
        NodeSourceData data = (NodeSourceData)this.fNodeSourceDatas.get(node);
        if (data == null) {
            data = new NodeSourceData();
            this.fNodeSourceDatas.put(node, data);
        }
        return data;
    }

    public boolean isMoveSource(ASTNode node) {
        NodeSourceData data = this.getNodeSourceData(node);
        if (data != null) {
            return data.isMoveSource;
        }
        return false;
    }

    public void setAsMoveSource(ASTNode node) {
        NodeSourceData data = this.createNodeSourceData(node);
        data.isMoveSource = true;
    }

    public int getCopyCount(ASTNode node) {
        NodeSourceData data = this.getNodeSourceData(node);
        if (data != null) {
            return data.copyCount;
        }
        return 0;
    }

    public void increaseCopyCount(ASTNode node) {
        ++this.createNodeSourceData((ASTNode)node).copyCount;
    }

    public boolean isInsertBoundToPrevious(ASTNode node) {
        if (this.fInsertBoundToPrevious != null) {
            return this.fInsertBoundToPrevious.contains(node);
        }
        return false;
    }

    public void setInsertBoundToPrevious(ASTNode node) {
        if (this.fInsertBoundToPrevious == null) {
            this.fInsertBoundToPrevious = new HashSet();
        }
        this.fInsertBoundToPrevious.add(node);
    }

    private void validateIsListProperty(int property) {
        if (!ASTNodeConstants.isListProperty(property)) {
            String message = String.valueOf(ASTNodeConstants.getPropertyName(property)) + " is not a list property";
            throw new IllegalArgumentException(message);
        }
    }

    private void validateHasChildProperty(ASTNode parent, int property) {
        if (!ASTNodeConstants.hasChildProperty(parent, property)) {
            String message = String.valueOf(Signature.getSimpleName((String)parent.getClass().getName())) + " has no property " + ASTNodeConstants.getPropertyName(property);
            throw new IllegalArgumentException(message);
        }
    }

    private void validateIsNodeProperty(int property) {
        if (ASTNodeConstants.isListProperty(property)) {
            String message = String.valueOf(ASTNodeConstants.getPropertyName(property)) + " is not a node property";
            throw new IllegalArgumentException(message);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.fEvents.size()) {
            buf.append(this.fEvents.get(i).toString()).append('\n');
            ++i;
        }
        return buf.toString();
    }

    public static interface INodePropertyMapper {
        public Object getOriginalValue(ASTNode var1, int var2);
    }

    private static class EventHolder {
        public ASTNode parent;
        public int childProperty;
        public RewriteEvent event;

        public EventHolder(ASTNode parent, int childProperty, RewriteEvent change) {
            this.parent = parent;
            this.childProperty = childProperty;
            this.event = change;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.parent).append(" - ");
            buf.append(ASTNodeConstants.getPropertyName(this.childProperty)).append(": ");
            buf.append(this.event).append('\n');
            return buf.toString();
        }
    }

    private static class NodeSourceData {
        boolean isMoveSource = false;
        int copyCount = 0;

        NodeSourceData() {
        }
    }
}

