/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import org.eclipse.jdt.internal.corext.dom.RewriteEvent;

public class NodeRewriteEvent
extends RewriteEvent {
    private Object fOriginalValue;
    private Object fNewValue;

    public NodeRewriteEvent(Object originalValue, Object newValue) {
        this.fOriginalValue = originalValue;
        this.fNewValue = newValue;
    }

    public Object getNewValue() {
        return this.fNewValue;
    }

    public Object getOriginalValue() {
        return this.fOriginalValue;
    }

    public int getChangeKind() {
        if (this.fOriginalValue == this.fNewValue) {
            return 0;
        }
        if (this.fOriginalValue == null) {
            return 1;
        }
        if (this.fNewValue == null) {
            return 2;
        }
        if (this.fOriginalValue.equals(this.fNewValue)) {
            return 0;
        }
        return 4;
    }

    public boolean isListRewrite() {
        return false;
    }

    public void setNewValue(Object newValue) {
        this.fNewValue = newValue;
    }

    public RewriteEvent[] getChildren() {
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        switch (this.getChangeKind()) {
            case 1: {
                buf.append(" [inserted: ");
                buf.append(this.getNewValue());
                buf.append(']');
                break;
            }
            case 4: {
                buf.append(" [replaced: ");
                buf.append(this.getOriginalValue());
                buf.append(" -> ");
                buf.append(this.getNewValue());
                buf.append(']');
                break;
            }
            case 2: {
                buf.append(" [removed: ");
                buf.append(this.getOriginalValue());
                buf.append(']');
                break;
            }
            default: {
                buf.append(" [unchanged]");
            }
        }
        return buf.toString();
    }
}

