/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.internal.corext.dom.ASTNodeConstants;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewriteAnalyzer;
import org.eclipse.jdt.internal.corext.dom.ListRewriteEvent;
import org.eclipse.jdt.internal.corext.dom.NodeRewriteEvent;
import org.eclipse.jdt.internal.corext.dom.RewriteEvent;
import org.eclipse.jdt.internal.corext.dom.RewriteEventStore;
import org.eclipse.jdt.internal.corext.textmanipulation.GroupDescription;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class NewASTRewrite {
    public static final int UNKNOWN = -1;
    public static final int BLOCK = 2;
    public static final int EXPRESSION = 3;
    public static final int STATEMENT = 4;
    public static final int SINGLEVAR_DECLARATION = 5;
    public static final int TYPE = 6;
    public static final int NAME = 7;
    public static final int JAVADOC = 8;
    public static final int VAR_DECLARATION_FRAGMENT = 9;
    public static final int TYPE_DECLARATION = 10;
    public static final int FIELD_DECLARATION = 11;
    public static final int METHOD_DECLARATION = 12;
    public static final int INITIALIZER = 13;
    public static final int PACKAGE_DECLARATION = 14;
    public static final int IMPORT_DECLARATION = 15;
    private ASTNode fRootNode;
    private HashMap fPlaceholderNodes;
    private HashSet fCollapsedNodes;
    private HashMap fTrackedNodes;
    protected final RewriteEventStore fEventStore;

    public NewASTRewrite(ASTNode node) {
        this.fRootNode = node;
        this.fEventStore = new RewriteEventStore();
        this.fPlaceholderNodes = null;
        this.fTrackedNodes = null;
    }

    public AST getAST() {
        return this.fRootNode.getAST();
    }

    public ASTNode getRootNode() {
        return this.fRootNode;
    }

    public TextEdit rewriteAST(IDocument document) {
        MultiTextEdit result = new MultiTextEdit();
        ASTNode rootNode = this.getRootNode();
        if (rootNode != null) {
            ASTRewriteAnalyzer visitor = new ASTRewriteAnalyzer(document, (TextEdit)result, this, this.fEventStore);
            ASTNodes.annotateExtraRanges(rootNode, visitor.getScanner());
            rootNode.accept((ASTVisitor)visitor);
        }
        return result;
    }

    public final void markAsInsert(ASTNode parent, int childProperty, ASTNode insertedNode, GroupDescription description) {
        this.validateIsInsideAST(parent);
        NodeRewriteEvent nodeEvent = this.fEventStore.getNodeEvent(parent, childProperty, true);
        nodeEvent.setNewValue(insertedNode);
        if (description != null) {
            this.fEventStore.setEventDescription(nodeEvent, description);
        }
    }

    public final void markAsInsertBeforeOriginal(ASTNode parent, int childProperty, ASTNode insertedNode, ASTNode siblingInOriginalList, GroupDescription description) {
        this.validateIsInsideAST(parent);
        ListRewriteEvent listEvent = this.fEventStore.getListEvent(parent, childProperty, true);
        RewriteEvent res = listEvent.insertBeforeOriginalSibling(insertedNode, siblingInOriginalList);
        if (res == null) {
            throw new IllegalArgumentException("Sibling is not member of the original list");
        }
        if (this.isInsertBoundToPreviousByDefault(insertedNode)) {
            this.fEventStore.setInsertBoundToPrevious(insertedNode);
        }
        if (description != null) {
            this.fEventStore.setEventDescription(res, description);
        }
    }

    public final void markAsInsertBeforeNew(ASTNode parent, int childProperty, ASTNode insertedNode, ASTNode siblingInNewList, GroupDescription description) {
        this.validateIsInsideAST(parent);
        ListRewriteEvent listEvent = this.fEventStore.getListEvent(parent, childProperty, true);
        RewriteEvent res = listEvent.insertBeforeOriginalSibling(insertedNode, siblingInNewList);
        if (res == null) {
            throw new IllegalArgumentException("Sibling is not member of the new list");
        }
        if (this.isInsertBoundToPreviousByDefault(insertedNode)) {
            this.fEventStore.setInsertBoundToPrevious(insertedNode);
        }
        if (description != null) {
            this.fEventStore.setEventDescription(res, description);
        }
    }

    public final void markAsInsertInOriginal(ASTNode parent, int childProperty, ASTNode insertedNode, int indexInOriginalList, GroupDescription description) {
        this.validateIsInsideAST(parent);
        ListRewriteEvent listEvent = this.fEventStore.getListEvent(parent, childProperty, true);
        RewriteEvent res = listEvent.insertAtOriginalIndex(insertedNode, indexInOriginalList);
        if (res == null) {
            throw new IllegalArgumentException("Sibling is not member of the original list");
        }
        if (this.isInsertBoundToPreviousByDefault(insertedNode)) {
            this.fEventStore.setInsertBoundToPrevious(insertedNode);
        }
        if (description != null) {
            this.fEventStore.setEventDescription(res, description);
        }
    }

    public final void markAsInsertInNew(ASTNode parent, int childProperty, ASTNode insertedNode, int indexInNewList, GroupDescription description) {
        this.validateIsInsideAST(parent);
        ListRewriteEvent listEvent = this.fEventStore.getListEvent(parent, childProperty, true);
        RewriteEvent res = listEvent.insertAtNewIndex(insertedNode, indexInNewList);
        if (res == null) {
            throw new IllegalArgumentException("Sibling is not member of the new list");
        }
        if (this.isInsertBoundToPreviousByDefault(insertedNode)) {
            this.fEventStore.setInsertBoundToPrevious(insertedNode);
        }
        if (description != null) {
            this.fEventStore.setEventDescription(res, description);
        }
    }

    protected boolean isInsertBoundToPreviousByDefault(ASTNode node) {
        return node instanceof Statement || node instanceof FieldDeclaration;
    }

    public final void markAsRemoved(ASTNode parent, int childProperty, GroupDescription description) {
        this.validateIsInsideAST(parent);
        NodeRewriteEvent nodeEvent = this.fEventStore.getNodeEvent(parent, childProperty, true);
        nodeEvent.setNewValue(null);
        if (description != null) {
            this.fEventStore.setEventDescription(nodeEvent, description);
        }
    }

    public final void markAsRemoved(ASTNode parent, int childProperty, ASTNode nodeToRemove, GroupDescription description) {
        this.validateIsInsideAST(parent);
        ListRewriteEvent listEvent = this.fEventStore.getListEvent(parent, childProperty, true);
        RewriteEvent res = listEvent.removeEntry(nodeToRemove);
        if (res == null) {
            throw new IllegalArgumentException("Node to remove is not member of list");
        }
        if (description != null) {
            this.fEventStore.setEventDescription(res, description);
        }
    }

    public final void markAsRemoved(ASTNode node, GroupDescription description) {
        int property = ASTNodeConstants.getPropertyOfNode(node);
        if (ASTNodeConstants.isListProperty(property)) {
            this.markAsRemoved(node.getParent(), property, node, description);
        } else {
            this.markAsRemoved(node.getParent(), property, description);
        }
    }

    public final void markAsRemoved(ASTNode node) {
        this.markAsRemoved(node, null);
    }

    public final void markAsReplaced(ASTNode parent, int childProperty, Object replacingNode, GroupDescription description) {
        this.validateIsInsideAST(parent);
        NodeRewriteEvent nodeEvent = this.fEventStore.getNodeEvent(parent, childProperty, true);
        nodeEvent.setNewValue(replacingNode);
        if (description != null) {
            this.fEventStore.setEventDescription(nodeEvent, description);
        }
    }

    public final void markAsReplaced(ASTNode parent, int childProperty, ASTNode nodeToReplace, ASTNode replacingNode, GroupDescription description) {
        this.validateIsInsideAST(parent);
        ListRewriteEvent listEvent = this.fEventStore.getListEvent(parent, childProperty, true);
        RewriteEvent res = listEvent.replaceEntry(nodeToReplace, replacingNode);
        if (res == null) {
            throw new IllegalArgumentException("Node to replace is not member of list");
        }
        if (description != null) {
            this.fEventStore.setEventDescription(res, description);
        }
    }

    public final void markAsReplaced(ASTNode node, ASTNode replacingNode, GroupDescription description) {
        int property = ASTNodeConstants.getPropertyOfNode(node);
        if (ASTNodeConstants.isListProperty(property)) {
            this.markAsReplaced(node.getParent(), property, node, replacingNode, description);
        } else {
            this.markAsReplaced(node.getParent(), property, replacingNode, description);
        }
    }

    public final void markAsReplaced(ASTNode node, ASTNode replacingNode) {
        this.markAsReplaced(node, replacingNode, null);
    }

    public final void markAsTracked(ASTNode node, GroupDescription description) {
        if (this.getTrackedNodeData(node) != null) {
            throw new IllegalArgumentException("Node is already marked as tracked");
        }
        this.setTrackedNodeData(node, description);
    }

    protected final void clearRewrite() {
        this.fEventStore.clear();
        this.fPlaceholderNodes = null;
    }

    protected final void validateIsInsideAST(ASTNode node) {
        if (node.getStartPosition() == -1) {
            throw new IllegalArgumentException("Node is not an existing node");
        }
        if (node.getAST() != this.getAST()) {
            throw new IllegalArgumentException("Node is not inside the AST");
        }
    }

    public final ASTNode createStringPlaceholder(String code, int nodeType) {
        StringPlaceholderData data = new StringPlaceholderData();
        data.code = code;
        return this.createPlaceholder(data, nodeType);
    }

    public final ASTNode createCopyPlaceholder(ASTNode node) {
        this.validateIsInsideAST(node);
        this.fEventStore.increaseCopyCount(node);
        int placeHolderType = NewASTRewrite.getPlaceholderType(node);
        if (placeHolderType == -1) {
            throw new IllegalArgumentException("Copy placeholders are not supported for nodes of type " + node.getClass().getName());
        }
        CopyPlaceholderData data = new CopyPlaceholderData();
        data.node = node;
        return this.createPlaceholder(data, placeHolderType);
    }

    public final ASTNode createMovePlaceholder(ASTNode node) {
        this.validateIsInsideAST(node);
        int placeHolderType = NewASTRewrite.getPlaceholderType(node);
        if (placeHolderType == -1) {
            throw new IllegalArgumentException("Move placeholders are not supported for nodes of type " + node.getClass().getName());
        }
        this.fEventStore.setAsMoveSource(node);
        MovePlaceholderData data = new MovePlaceholderData();
        data.node = node;
        return this.createPlaceholder(data, placeHolderType);
    }

    protected final Block createCollapsePlaceholder() {
        Block placeHolder = this.getAST().newBlock();
        if (this.fCollapsedNodes == null) {
            this.fCollapsedNodes = new HashSet();
        }
        this.fCollapsedNodes.add(placeHolder);
        return placeHolder;
    }

    public final boolean isCollapsed(ASTNode node) {
        if (this.fCollapsedNodes != null) {
            return this.fCollapsedNodes.contains(node);
        }
        return false;
    }

    public final GroupDescription getTrackedNodeData(ASTNode node) {
        if (this.fTrackedNodes != null) {
            return (GroupDescription)this.fTrackedNodes.get(node);
        }
        return null;
    }

    protected void setTrackedNodeData(ASTNode node, GroupDescription description) {
        if (this.fTrackedNodes == null) {
            this.fTrackedNodes = new HashMap();
        }
        this.fTrackedNodes.put(node, description);
    }

    private final ASTNode createPlaceholder(PlaceholderData data, int nodeType) {
        ReturnStatement placeHolder;
        AST ast = this.getAST();
        switch (nodeType) {
            case 7: {
                placeHolder = ast.newSimpleName("z");
                break;
            }
            case 3: {
                MethodInvocation expression = ast.newMethodInvocation();
                expression.setName(ast.newSimpleName("z"));
                placeHolder = expression;
                break;
            }
            case 6: {
                placeHolder = ast.newSimpleType((Name)ast.newSimpleName("X"));
                break;
            }
            case 4: {
                placeHolder = ast.newReturnStatement();
                break;
            }
            case 2: {
                placeHolder = ast.newBlock();
                break;
            }
            case 12: {
                placeHolder = ast.newMethodDeclaration();
                break;
            }
            case 11: {
                placeHolder = ast.newFieldDeclaration(ast.newVariableDeclarationFragment());
                break;
            }
            case 13: {
                placeHolder = ast.newInitializer();
                break;
            }
            case 5: {
                placeHolder = ast.newSingleVariableDeclaration();
                break;
            }
            case 9: {
                placeHolder = ast.newVariableDeclarationFragment();
                break;
            }
            case 8: {
                placeHolder = ast.newJavadoc();
                break;
            }
            case 10: {
                placeHolder = ast.newTypeDeclaration();
                break;
            }
            case 14: {
                placeHolder = ast.newPackageDeclaration();
                break;
            }
            case 15: {
                placeHolder = ast.newImportDeclaration();
                break;
            }
            default: {
                return null;
            }
        }
        this.setPlaceholderData((ASTNode)placeHolder, data);
        return placeHolder;
    }

    public static int getPlaceholderType(ASTNode existingNode) {
        switch (existingNode.getNodeType()) {
            case 40: 
            case 42: {
                return 7;
            }
            case 5: 
            case 39: 
            case 43: {
                return 6;
            }
            case 8: {
                return 2;
            }
            case 55: {
                return 10;
            }
            case 31: {
                return 12;
            }
            case 23: {
                return 11;
            }
            case 28: {
                return 13;
            }
            case 44: {
                return 5;
            }
            case 59: {
                return 9;
            }
            case 29: {
                return 8;
            }
            case 35: {
                return 14;
            }
            case 26: {
                return 15;
            }
        }
        if (existingNode instanceof Expression) {
            return 3;
        }
        if (existingNode instanceof Statement) {
            return 4;
        }
        return -1;
    }

    protected final Object getPlaceholderData(ASTNode node) {
        if (this.fPlaceholderNodes != null) {
            return this.fPlaceholderNodes.get(node);
        }
        return null;
    }

    private void setPlaceholderData(ASTNode node, PlaceholderData data) {
        if (this.fPlaceholderNodes == null) {
            this.fPlaceholderNodes = new HashMap();
        }
        this.fPlaceholderNodes.put(node, data);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Events:\n");
        buf.append(this.fEventStore.toString());
        return buf.toString();
    }

    private static class PlaceholderData {
        PlaceholderData() {
        }
    }

    protected static final class MovePlaceholderData
    extends PlaceholderData {
        public ASTNode node;

        protected MovePlaceholderData() {
        }

        public String toString() {
            return "[placeholder move: " + this.node + "]";
        }
    }

    protected static final class CopyPlaceholderData
    extends PlaceholderData {
        public ASTNode node;

        protected CopyPlaceholderData() {
        }

        public String toString() {
            return "[placeholder copy: " + this.node + "]";
        }
    }

    protected static final class StringPlaceholderData
    extends PlaceholderData {
        public String code;

        protected StringPlaceholderData() {
        }

        public String toString() {
            return "[placeholder string: " + this.code + "]";
        }
    }
}

