/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.corext.dom.NodeRewriteEvent;
import org.eclipse.jdt.internal.corext.dom.RewriteEvent;

public class ListRewriteEvent
extends RewriteEvent {
    private List fOriginalNodes;
    private List fListEntries;

    public ListRewriteEvent(List originalNodes) {
        this.fOriginalNodes = originalNodes;
    }

    public ListRewriteEvent(RewriteEvent[] children) {
        this.fListEntries = new ArrayList(children.length * 2);
        this.fOriginalNodes = new ArrayList(children.length * 2);
        int i = 0;
        while (i < children.length) {
            RewriteEvent curr = children[i];
            this.fListEntries.add(curr);
            if (curr.getOriginalValue() != null) {
                this.fOriginalNodes.add(curr.getOriginalValue());
            }
            ++i;
        }
    }

    private List getEntries() {
        if (this.fListEntries == null) {
            int nNodes = this.fOriginalNodes.size();
            this.fListEntries = new ArrayList(nNodes * 2);
            int i = 0;
            while (i < nNodes) {
                ASTNode node = (ASTNode)this.fOriginalNodes.get(i);
                this.fListEntries.add(new NodeRewriteEvent(node, node));
                ++i;
            }
        }
        return this.fListEntries;
    }

    public int getChangeKind() {
        if (this.fListEntries != null) {
            int i = 0;
            while (i < this.fListEntries.size()) {
                RewriteEvent curr = (RewriteEvent)this.fListEntries.get(i);
                if (curr.getChangeKind() != 0) {
                    return 8;
                }
                ++i;
            }
        }
        return 0;
    }

    public boolean isListRewrite() {
        return true;
    }

    public RewriteEvent[] getChildren() {
        List listEntries = this.getEntries();
        return listEntries.toArray(new RewriteEvent[listEntries.size()]);
    }

    public Object getOriginalValue() {
        return this.fOriginalNodes;
    }

    public Object getNewValue() {
        List listEntries = this.getEntries();
        ArrayList<Object> res = new ArrayList<Object>(listEntries.size());
        int i = 0;
        while (i < listEntries.size()) {
            RewriteEvent curr = (RewriteEvent)listEntries.get(i);
            Object newVal = curr.getNewValue();
            if (newVal != null) {
                res.add(newVal);
            }
            ++i;
        }
        return res;
    }

    public RewriteEvent removeEntry(ASTNode originalEntry) {
        return this.replaceEntry(originalEntry, null);
    }

    public RewriteEvent replaceEntry(ASTNode originalEntry, ASTNode newEntry) {
        if (originalEntry == null) {
            throw new IllegalArgumentException();
        }
        List listEntries = this.getEntries();
        int nEntries = listEntries.size();
        int i = 0;
        while (i < nEntries) {
            NodeRewriteEvent curr = (NodeRewriteEvent)listEntries.get(i);
            if (curr.getOriginalValue() == originalEntry) {
                curr.setNewValue(newEntry);
                return curr;
            }
            ++i;
        }
        return null;
    }

    public RewriteEvent insertBeforeOriginalSibling(ASTNode insertedNode, ASTNode originalListSibling) {
        List listEntries = this.getEntries();
        if (originalListSibling == null) {
            return this.insertAtCombinedIndex(insertedNode, listEntries.size());
        }
        int i = listEntries.size() - 1;
        while (i >= 0) {
            RewriteEvent curr = (RewriteEvent)listEntries.get(i);
            if (curr.getOriginalValue() == originalListSibling) {
                return this.insertAtCombinedIndex(insertedNode, i);
            }
            --i;
        }
        return null;
    }

    public RewriteEvent insertBeforeNewSibling(ASTNode insertedNode, ASTNode newListSibling) {
        List listEntries = this.getEntries();
        if (newListSibling == null) {
            return this.insertAtCombinedIndex(insertedNode, listEntries.size());
        }
        int i = listEntries.size() - 1;
        while (i >= 0) {
            RewriteEvent curr = (RewriteEvent)listEntries.get(i);
            if (curr.getNewValue() == newListSibling) {
                return this.insertAtCombinedIndex(insertedNode, i);
            }
            --i;
        }
        return null;
    }

    public RewriteEvent insertAtOriginalIndex(ASTNode insertedNode, int insertIndex) {
        int currIndex = 0;
        List listEntries = this.getEntries();
        int nEntries = listEntries.size();
        int i = 0;
        while (i < nEntries) {
            RewriteEvent curr = (RewriteEvent)listEntries.get(i);
            if (curr.getOriginalValue() != null) {
                if (insertIndex == currIndex) {
                    return this.insertAtCombinedIndex(insertedNode, i);
                }
                ++currIndex;
            }
            ++i;
        }
        if (insertIndex == currIndex) {
            return this.insertAtCombinedIndex(insertedNode, nEntries);
        }
        throw new IndexOutOfBoundsException();
    }

    public RewriteEvent insertAtNewIndex(ASTNode insertedNode, int insertIndex) {
        int currIndex = 0;
        List listEntries = this.getEntries();
        int nEntries = listEntries.size();
        int i = 0;
        while (i < nEntries) {
            RewriteEvent curr = (RewriteEvent)listEntries.get(i);
            if (curr.getNewValue() != null) {
                if (insertIndex == currIndex) {
                    return this.insertAtCombinedIndex(insertedNode, i);
                }
                ++currIndex;
            }
            ++i;
        }
        if (insertIndex == currIndex) {
            return this.insertAtCombinedIndex(insertedNode, nEntries);
        }
        throw new IndexOutOfBoundsException();
    }

    public RewriteEvent insertAtCombinedIndex(ASTNode insertedNode, int insertIndex) {
        NodeRewriteEvent change = new NodeRewriteEvent(null, insertedNode);
        this.getEntries().add(insertIndex, change);
        return change;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(" [list change\n\t");
        RewriteEvent[] events = this.getChildren();
        int i = 0;
        while (i < events.length) {
            if (i != 0) {
                buf.append("\n\t");
            }
            buf.append(events[i]);
            ++i;
        }
        buf.append("\n]");
        return buf.toString();
    }
}

