/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.Bindings;

public class LinkedNodeFinder
extends ASTVisitor {
    private IBinding fBinding;
    private ArrayList fResult;

    public static SimpleName[] perform(ASTNode root, IBinding binding) {
        ArrayList res = new ArrayList();
        LinkedNodeFinder nodeFinder = new LinkedNodeFinder(binding, res);
        root.accept((ASTVisitor)nodeFinder);
        return res.toArray(new SimpleName[res.size()]);
    }

    private LinkedNodeFinder(IBinding binding, ArrayList result) {
        this.fBinding = binding;
        this.fResult = result;
    }

    public boolean visit(MethodDeclaration node) {
        ASTNode typeNode;
        if (node.isConstructor() && this.fBinding.getKind() == 2 && (typeNode = node.getParent()) instanceof TypeDeclaration && this.fBinding == ((TypeDeclaration)typeNode).resolveBinding()) {
            this.fResult.add(node.getName());
        }
        return true;
    }

    public boolean visit(TypeDeclaration node) {
        IMethodBinding binding;
        if (this.fBinding.getKind() == 4 && (binding = (IMethodBinding)this.fBinding).isConstructor() && binding.getDeclaringClass() == node.resolveBinding()) {
            this.fResult.add(node.getName());
        }
        return true;
    }

    public boolean visit(SimpleName node) {
        IBinding binding = node.resolveBinding();
        if (this.fBinding == binding) {
            this.fResult.add(node);
        } else if (binding != null && binding.getKind() == this.fBinding.getKind() && binding.getKind() == 4 && this.isConnectedMethod((IMethodBinding)binding, (IMethodBinding)this.fBinding)) {
            this.fResult.add(node);
        }
        return false;
    }

    private boolean isConnectedMethod(IMethodBinding meth1, IMethodBinding meth2) {
        if (Bindings.isEqualMethod(meth1, meth2.getName(), meth2.getParameterTypes())) {
            ITypeBinding type1 = meth1.getDeclaringClass();
            ITypeBinding type2 = meth2.getDeclaringClass();
            if (Bindings.isSuperType(type2, type1) || Bindings.isSuperType(type1, type2)) {
                return true;
            }
        }
        return false;
    }
}

