/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;

public class JavaElementMapper
extends GenericVisitor {
    private IMember fElement;
    private int fStart;
    private int fLength;
    private int fEnd;
    private ASTNode fResult;

    private JavaElementMapper(IMember element) throws JavaModelException {
        Assert.isNotNull(element);
        this.fElement = element;
        ISourceRange sourceRange = this.fElement.getNameRange();
        this.fStart = sourceRange.getOffset();
        this.fLength = sourceRange.getLength();
        this.fEnd = this.fStart + this.fLength;
    }

    public static ASTNode perform(IMember member, Class type) throws JavaModelException {
        JavaElementMapper mapper = new JavaElementMapper(member);
        ICompilationUnit unit = member.getCompilationUnit();
        CompilationUnit node = AST.parseCompilationUnit((ICompilationUnit)unit, (boolean)true);
        node.accept((ASTVisitor)mapper);
        ASTNode result = mapper.fResult;
        while (result != null && !type.isInstance(result)) {
            result = result.getParent();
        }
        return result;
    }

    protected boolean visitNode(ASTNode node) {
        if (this.fResult != null) {
            return false;
        }
        int nodeStart = node.getStartPosition();
        int nodeLength = node.getLength();
        int nodeEnd = nodeStart + nodeLength;
        if (nodeStart == this.fStart && nodeLength == this.fLength) {
            this.fResult = node;
            return false;
        }
        return nodeStart <= this.fStart && this.fEnd <= nodeEnd;
    }
}

