/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.internal.corext.dom.ASTFlattener;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NewASTRewrite;
import org.eclipse.jdt.internal.corext.textmanipulation.GroupDescription;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.TextEdit;

class ASTRewriteFormatter {
    private NewASTRewrite fRewrite;
    private String fLineDelimiter;
    public static final Prefix NONE = new ConstPrefix("");
    public static final Prefix SPACE = new ConstPrefix(" ");
    public static final Prefix ASSERT_COMMENT = new ConstPrefix(" : ");
    public static final Prefix VAR_INITIALIZER = new FormattingPrefix("A a={};", "a={", 2);
    public static final Prefix METHOD_BODY = new FormattingPrefix("void a() {}", ") {", 4);
    public static final Prefix FINALLY_BLOCK = new FormattingPrefix("try {} finally {}", "} finally {", 2);
    public static final Prefix CATCH_BLOCK = new FormattingPrefix("try {} catch(Exception e) {}", "} c", 2);
    public static final BlockContext IF_BLOCK_WITH_ELSE = new BlockFormattingPrefixSuffix("if (true)", "else{}", 8);
    public static final BlockContext IF_BLOCK_NO_ELSE = new BlockFormattingPrefix("if (true)", 8);
    public static final BlockContext ELSE_AFTER_STATEMENT = new BlockFormattingPrefix("if (true) foo(); else ", 15);
    public static final BlockContext ELSE_AFTER_BLOCK = new BlockFormattingPrefix("if (true) {} else ", 11);
    public static final BlockContext FOR_BLOCK = new BlockFormattingPrefix("for (;;) ", 7);
    public static final BlockContext WHILE_BLOCK = new BlockFormattingPrefix("while (true)", 11);
    public static final BlockContext DO_BLOCK = new BlockFormattingPrefixSuffix("do ", "while (true);", 1);

    public ASTRewriteFormatter(NewASTRewrite rewrite, String lineDelimiter) {
        this.fRewrite = rewrite;
        this.fLineDelimiter = lineDelimiter;
    }

    public String getFormattedResult(ASTNode node, int initialIndentationLevel, Collection resultingMarkers) {
        ExtendedFlattener flattener = new ExtendedFlattener(this.fRewrite);
        node.accept((ASTVisitor)flattener);
        Position[] markers = flattener.getMarkers();
        int i = 0;
        while (i < markers.length) {
            resultingMarkers.add(markers[i]);
            ++i;
        }
        Hashtable map = JavaCore.getOptions();
        map.put("org.eclipse.jdt.core.formatter.lineSplit", String.valueOf(9999));
        String unformatted = flattener.getResult();
        TextEdit edit = CodeFormatterUtil.format2(node, unformatted, initialIndentationLevel, this.fLineDelimiter, (Map)map);
        if (edit == null) {
            return unformatted;
        }
        return CodeFormatterUtil.evaluateFormatterEdit(unformatted, edit, markers);
    }

    public static class NodeMarker
    extends Position {
        public Object data;
    }

    private static class ExtendedFlattener
    extends ASTFlattener {
        private ArrayList fPositions = new ArrayList();
        private NewASTRewrite fRewriter;

        public ExtendedFlattener(NewASTRewrite rewrite) {
            this.fRewriter = rewrite;
        }

        public void preVisit(ASTNode node) {
            Object placeholderData;
            GroupDescription trackData = this.fRewriter.getTrackedNodeData(node);
            if (trackData != null) {
                this.addMarker(trackData, this.fResult.length(), 0);
            }
            if ((placeholderData = this.fRewriter.getPlaceholderData(node)) != null) {
                this.addMarker(placeholderData, this.fResult.length(), 0);
            }
        }

        public void postVisit(ASTNode node) {
            GroupDescription trackData;
            Object placeholderData = this.fRewriter.getPlaceholderData(node);
            if (placeholderData != null) {
                this.fixupLength(placeholderData, this.fResult.length());
            }
            if ((trackData = this.fRewriter.getTrackedNodeData(node)) != null) {
                this.fixupLength(trackData, this.fResult.length());
            }
        }

        public boolean visit(Block node) {
            if (this.fRewriter.isCollapsed((ASTNode)node)) {
                return true;
            }
            return super.visit(node);
        }

        private NodeMarker addMarker(Object annotation, int startOffset, int length) {
            NodeMarker marker = new NodeMarker();
            marker.offset = startOffset;
            marker.length = length;
            marker.data = annotation;
            this.fPositions.add(marker);
            return marker;
        }

        private void fixupLength(Object data, int endOffset) {
            int i = this.fPositions.size() - 1;
            while (i >= 0) {
                NodeMarker marker = (NodeMarker)((Object)this.fPositions.get(i));
                if (marker.data == data) {
                    marker.length = endOffset - marker.offset;
                    return;
                }
                --i;
            }
        }

        public NodeMarker[] getMarkers() {
            return this.fPositions.toArray(new NodeMarker[this.fPositions.size()]);
        }
    }

    public static interface Prefix {
        public String getPrefix(int var1, String var2);
    }

    public static interface BlockContext {
        public String[] getPrefixAndSuffix(int var1, String var2, ASTNode var3);
    }

    public static class ConstPrefix
    implements Prefix {
        private String fPrefix;

        public ConstPrefix(String prefix) {
            this.fPrefix = prefix;
        }

        public String getPrefix(int indent, String lineDelim) {
            return this.fPrefix;
        }
    }

    private static class FormattingPrefix
    implements Prefix {
        private int fKind;
        private String fString;
        private int fStart;
        private int fLength;

        public FormattingPrefix(String string, String sub, int kind) {
            this.fStart = string.indexOf(sub);
            this.fLength = sub.length();
            this.fString = string;
            this.fKind = kind;
        }

        public String getPrefix(int indent, String lineDelim) {
            Position pos = new Position(this.fStart, this.fLength);
            String str = this.fString;
            TextEdit res = CodeFormatterUtil.format2(this.fKind, str, indent, lineDelim, null);
            if (res != null) {
                str = CodeFormatterUtil.evaluateFormatterEdit(str, res, new Position[]{pos});
            }
            return str.substring(pos.offset + 1, pos.offset + pos.length - 1);
        }
    }

    private static class BlockFormattingPrefix
    implements BlockContext {
        private String fPrefix;
        private int fStart;

        public BlockFormattingPrefix(String prefix, int start) {
            this.fStart = start;
            this.fPrefix = prefix;
        }

        public String[] getPrefixAndSuffix(int indent, String lineDelim, ASTNode node) {
            String nodeString = ASTNodes.asString(node);
            String str = String.valueOf(this.fPrefix) + nodeString;
            Position pos = new Position(this.fStart, this.fPrefix.length() + 1 - this.fStart);
            TextEdit res = CodeFormatterUtil.format2(2, str, indent, lineDelim, null);
            if (res != null) {
                str = CodeFormatterUtil.evaluateFormatterEdit(str, res, new Position[]{pos});
            }
            return new String[]{str.substring(pos.offset + 1, pos.offset + pos.length - 1), ""};
        }
    }

    private static class BlockFormattingPrefixSuffix
    implements BlockContext {
        private String fPrefix;
        private String fSuffix;
        private int fStart;

        public BlockFormattingPrefixSuffix(String prefix, String suffix, int start) {
            this.fStart = start;
            this.fSuffix = suffix;
            this.fPrefix = prefix;
        }

        public String[] getPrefixAndSuffix(int indent, String lineDelim, ASTNode node) {
            String nodeString = ASTNodes.asString(node);
            int nodeStart = this.fPrefix.length();
            int nodeEnd = nodeStart + nodeString.length() - 1;
            String str = String.valueOf(this.fPrefix) + nodeString + this.fSuffix;
            Position pos1 = new Position(this.fStart, nodeStart + 1 - this.fStart);
            Position pos2 = new Position(nodeEnd, 2);
            TextEdit res = CodeFormatterUtil.format2(2, str, indent, lineDelim, null);
            if (res != null) {
                str = CodeFormatterUtil.evaluateFormatterEdit(str, res, new Position[]{pos1, pos2});
            }
            return new String[]{str.substring(pos1.offset + 1, pos1.offset + pos1.length - 1), str.substring(pos2.offset + 1, pos2.offset + pos2.length - 1)};
        }
    }
}

