/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTFlattener;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTRewriteFormatter;
import org.eclipse.jdt.internal.corext.dom.NewASTRewrite;
import org.eclipse.jdt.internal.corext.dom.RewriteEvent;
import org.eclipse.jdt.internal.corext.dom.RewriteEventStore;
import org.eclipse.jdt.internal.corext.dom.SourceModifier;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.textmanipulation.GroupDescription;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.CopySourceEdit;
import org.eclipse.text.edits.CopyTargetEdit;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ISourceModifier;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MoveTargetEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public final class ASTRewriteAnalyzer
extends ASTVisitor {
    private TextEdit fCurrentEdit;
    private TokenScanner fTokenScanner;
    private HashMap fCopySources;
    private HashMap fMoveSources;
    final IDocument fDocument;
    private final NewASTRewrite fRewrite;
    private final ASTRewriteFormatter fFormatter;
    private RewriteEventStore fEventStore;

    public ASTRewriteAnalyzer(IDocument document, TextEdit rootEdit, NewASTRewrite rewrite, RewriteEventStore eventStore) {
        this.fEventStore = eventStore;
        this.fDocument = document;
        this.fTokenScanner = null;
        this.fRewrite = rewrite;
        this.fCurrentEdit = rootEdit;
        this.fCopySources = new HashMap();
        this.fMoveSources = new HashMap();
        this.fFormatter = new ASTRewriteFormatter(rewrite, this.getLineDelimiter());
    }

    public final TokenScanner getScanner() {
        if (this.fTokenScanner == null) {
            IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
            scanner.setSource(this.fDocument.get().toCharArray());
            this.fTokenScanner = new TokenScanner(scanner, this.fDocument);
        }
        return this.fTokenScanner;
    }

    final int getExtendedOffset(ASTNode node) {
        return ASTNodes.getExtendedOffset(node);
    }

    final int getExtendedLength(ASTNode node) {
        return ASTNodes.getExtendedLength(node);
    }

    final int getExtendedEnd(ASTNode node) {
        return ASTNodes.getExtendedEnd(node);
    }

    private final CopySourceEdit[] getCopySources(ASTNode node) {
        int count = this.fEventStore.getCopyCount(node);
        if (count == 0) {
            return null;
        }
        CopySourceEdit[] edits = (CopySourceEdit[])this.fCopySources.get(node);
        if (edits == null) {
            int offset = this.getExtendedOffset(node);
            int length = this.getExtendedLength(node);
            edits = new CopySourceEdit[count];
            int i = 0;
            while (i < count) {
                edits[i] = new CopySourceEdit(offset, length);
                ++i;
            }
            this.fCopySources.put(node, edits);
        }
        return edits;
    }

    private final MoveSourceEdit getMoveSource(ASTNode node) {
        if (!this.fEventStore.isMoveSource(node)) {
            return null;
        }
        MoveSourceEdit edit = (MoveSourceEdit)this.fMoveSources.get(node);
        if (edit == null) {
            int offset = this.getExtendedOffset(node);
            int length = this.getExtendedLength(node);
            edit = new MoveSourceEdit(offset, length);
        }
        this.fMoveSources.put(node, edit);
        return edit;
    }

    private final int getChangeKind(ASTNode node, int property) {
        RewriteEvent event = this.getEvent(node, property);
        if (event != null) {
            return event.getChangeKind();
        }
        return 0;
    }

    private final boolean hasChildrenChanges(ASTNode node) {
        return this.fEventStore.hasChildrenChanges(node);
    }

    private boolean visitChildrenNeeded(ASTNode node) {
        return true;
    }

    private final boolean isChanged(ASTNode node, int property) {
        RewriteEvent event = this.getEvent(node, property);
        if (event != null) {
            return event.getChangeKind() != 0;
        }
        return false;
    }

    private final boolean isCollapsed(ASTNode node) {
        return this.fRewrite.isCollapsed(node);
    }

    private final boolean isInsertBoundToPrevious(ASTNode node) {
        return this.fEventStore.isInsertBoundToPrevious(node);
    }

    private final GroupDescription getDescription(ASTNode parent, int property) {
        RewriteEvent event = this.getEvent(parent, property);
        if (event != null) {
            return this.getDescription(event);
        }
        return null;
    }

    private final RewriteEvent getEvent(ASTNode parent, int property) {
        return this.fEventStore.getEvent(parent, property);
    }

    private final GroupDescription getDescription(RewriteEvent change) {
        return this.fEventStore.getEventDescription(change);
    }

    private final Object getOriginalValue(ASTNode parent, int property) {
        return this.fEventStore.getOriginalValue(parent, property);
    }

    private final Object getNewValue(ASTNode parent, int property) {
        return this.fEventStore.getNewValue(parent, property);
    }

    private final void addEdit(TextEdit edit) {
        this.fCurrentEdit.addChild(edit);
    }

    private final String getLineDelimiter() {
        return TextUtilities.getDefaultLineDelimiter((IDocument)this.fDocument);
    }

    private final void doTextInsert(int offset, String insertString, GroupDescription description) {
        if (insertString.length() > 0) {
            InsertEdit edit = new InsertEdit(offset, insertString);
            this.addEdit((TextEdit)edit);
            if (description != null) {
                this.addDescription(description, (TextEdit)edit);
            }
        }
    }

    private final void addDescription(GroupDescription groupDesc, TextEdit edit) {
        groupDesc.addTextEdit(edit);
    }

    private final TextEdit doTextRemove(int offset, int len, GroupDescription description) {
        if (len == 0) {
            return null;
        }
        DeleteEdit edit = new DeleteEdit(offset, len);
        this.addEdit((TextEdit)edit);
        if (description != null) {
            this.addDescription(description, (TextEdit)edit);
        }
        return edit;
    }

    private final void doTextRemoveAndVisit(int offset, int len, ASTNode node, GroupDescription description) {
        TextEdit edit = this.doTextRemove(offset, len, description);
        if (edit != null) {
            this.fCurrentEdit = edit;
            this.doVisit(node);
            this.fCurrentEdit = edit.getParent();
        }
    }

    private final int doVisit(ASTNode node) {
        node.accept((ASTVisitor)this);
        return node.getStartPosition() + node.getLength();
    }

    private final int doVisit(ASTNode parent, int property, int offset) {
        Object node = this.getOriginalValue(parent, property);
        if (node instanceof ASTNode) {
            return this.doVisit((ASTNode)node);
        }
        if (node instanceof List) {
            int endPos = offset;
            Iterator iter = ((List)node).iterator();
            while (iter.hasNext()) {
                ASTNode curr = (ASTNode)iter.next();
                endPos = this.doVisit(curr);
            }
            return endPos;
        }
        return offset;
    }

    private final void doTextReplace(int offset, int len, String insertString, GroupDescription description) {
        if (len > 0 || insertString.length() > 0) {
            ReplaceEdit edit = new ReplaceEdit(offset, len, insertString);
            this.addEdit((TextEdit)edit);
            if (description != null) {
                this.addDescription(description, (TextEdit)edit);
            }
        }
    }

    private final TextEdit doTextCopy(ASTNode copiedNode, int destOffset, int sourceIndentLevel, String destIndentString, int tabWidth, GroupDescription description) {
        CopySourceEdit[] edits = this.getCopySources(copiedNode);
        if (edits == null) {
            Assert.isTrue(false, "Copy source not annotated" + copiedNode.toString());
        }
        CopySourceEdit sourceEdit = null;
        int i = 0;
        while (i < edits.length) {
            if (edits[i].getSourceModifier() == null) {
                sourceEdit = edits[i];
                break;
            }
            ++i;
        }
        if (sourceEdit == null) {
            Assert.isTrue(false, "No copy source available" + copiedNode.toString());
        }
        sourceEdit.setSourceModifier((ISourceModifier)SourceModifier.createCopyModifier(sourceIndentLevel, destIndentString, tabWidth));
        CopyTargetEdit targetEdit = new CopyTargetEdit(destOffset, sourceEdit);
        this.addEdit((TextEdit)targetEdit);
        if (description != null) {
            this.addDescription(description, (TextEdit)sourceEdit);
            this.addDescription(description, (TextEdit)targetEdit);
        }
        return targetEdit;
    }

    private final TextEdit doTextMove(ASTNode movedNode, int destOffset, int sourceIndentLevel, String destIndentString, int tabWidth, GroupDescription description) {
        MoveSourceEdit moveEdit = this.getMoveSource(movedNode);
        if (moveEdit.getSourceModifier() != null) {
            Assert.isTrue(false, "No move source available" + movedNode.toString());
        }
        moveEdit.setSourceModifier((ISourceModifier)SourceModifier.createMoveModifier(sourceIndentLevel, destIndentString, tabWidth));
        MoveTargetEdit targetEdit = new MoveTargetEdit(destOffset, moveEdit);
        this.addEdit((TextEdit)targetEdit);
        if (description != null) {
            this.addDescription(description, (TextEdit)moveEdit);
            this.addDescription(description, (TextEdit)targetEdit);
        }
        return targetEdit;
    }

    private void changeNotSupported(ASTNode node) {
        Assert.isTrue(false, "Change not supported in " + node.getClass().getName());
    }

    private int rewriteRequiredNode(ASTNode parent, int property) {
        RewriteEvent event = this.getEvent(parent, property);
        if (event != null && event.getChangeKind() == 4) {
            ASTNode node = (ASTNode)event.getOriginalValue();
            GroupDescription description = this.getDescription(event);
            int offset = this.getExtendedOffset(node);
            int length = this.getExtendedLength(node);
            this.doTextRemoveAndVisit(offset, length, node, description);
            this.doTextInsert(offset, (ASTNode)event.getNewValue(), this.getIndent(offset), true, description);
            return offset + length;
        }
        return this.doVisit(parent, property, 0);
    }

    private int rewriteNode(ASTNode parent, int property, int offset, ASTRewriteFormatter.Prefix prefix) {
        RewriteEvent event = this.getEvent(parent, property);
        if (event != null) {
            switch (event.getChangeKind()) {
                case 1: {
                    ASTNode node = (ASTNode)event.getNewValue();
                    GroupDescription description = this.getDescription(event);
                    int indent = this.getIndent(offset);
                    this.doTextInsert(offset, prefix.getPrefix(indent, this.getLineDelimiter()), description);
                    this.doTextInsert(offset, node, indent, true, description);
                    return offset;
                }
                case 2: {
                    ASTNode node = (ASTNode)event.getOriginalValue();
                    GroupDescription description = this.getDescription(event);
                    int nodeEnd = this.getExtendedEnd(node);
                    int len = nodeEnd - offset;
                    this.doTextRemoveAndVisit(offset, len, node, description);
                    return nodeEnd;
                }
                case 4: {
                    ASTNode node = (ASTNode)event.getOriginalValue();
                    GroupDescription description = this.getDescription(event);
                    int nodeOffset = this.getExtendedOffset(node);
                    int nodeLen = this.getExtendedLength(node);
                    this.doTextRemoveAndVisit(nodeOffset, nodeLen, node, description);
                    this.doTextInsert(nodeOffset, (ASTNode)event.getNewValue(), this.getIndent(offset), true, description);
                    return nodeOffset + nodeLen;
                }
            }
        }
        return this.doVisit(parent, property, offset);
    }

    private int rewriteBodyNode(ASTNode parent, int property, int offset, int endPos, int indent, ASTRewriteFormatter.BlockContext context) {
        RewriteEvent event = this.getEvent(parent, property);
        if (event != null) {
            switch (event.getChangeKind()) {
                case 1: {
                    ASTNode node = (ASTNode)event.getNewValue();
                    GroupDescription description = this.getDescription(event);
                    String[] strings = context.getPrefixAndSuffix(indent, this.getLineDelimiter(), node);
                    this.doTextInsert(offset, strings[0], description);
                    this.doTextInsert(offset, node, indent, true, description);
                    this.doTextInsert(offset, strings[1], description);
                    return offset;
                }
                case 2: {
                    ASTNode node = (ASTNode)event.getOriginalValue();
                    if (endPos == -1) {
                        endPos = this.getExtendedEnd(node);
                    }
                    GroupDescription description = this.getDescription(event);
                    int len = endPos - offset;
                    this.doTextRemoveAndVisit(offset, len, node, description);
                    return endPos;
                }
                case 4: {
                    ASTNode node = (ASTNode)event.getOriginalValue();
                    if (endPos == -1) {
                        endPos = this.getExtendedEnd(node);
                    }
                    GroupDescription description = this.getDescription(event);
                    int nodeLen = endPos - offset;
                    ASTNode replacingNode = (ASTNode)event.getNewValue();
                    String[] strings = context.getPrefixAndSuffix(indent, this.getLineDelimiter(), replacingNode);
                    this.doTextRemoveAndVisit(offset, nodeLen, node, description);
                    String prefix = strings[0];
                    this.doTextInsert(offset, prefix, description);
                    String lineInPrefix = this.getCurrentLine(prefix, prefix.length());
                    if (prefix.length() != lineInPrefix.length()) {
                        indent = Strings.computeIndent(lineInPrefix, CodeFormatterUtil.getTabWidth());
                    }
                    this.doTextInsert(offset, replacingNode, indent, true, description);
                    this.doTextInsert(offset, strings[1], description);
                    return endPos;
                }
            }
        }
        return this.doVisit(parent, property, offset);
    }

    private int rewriteOptionalQualifier(ASTNode parent, int property, int startPos) {
        RewriteEvent event = this.getEvent(parent, property);
        if (event != null) {
            switch (event.getChangeKind()) {
                case 1: {
                    ASTNode node = (ASTNode)event.getNewValue();
                    GroupDescription description = this.getDescription(event);
                    this.doTextInsert(startPos, node, this.getIndent(startPos), true, description);
                    this.doTextInsert(startPos, ".", description);
                    return startPos;
                }
                case 2: {
                    try {
                        ASTNode node = (ASTNode)event.getOriginalValue();
                        GroupDescription description = this.getDescription(event);
                        int dotEnd = this.getScanner().getTokenEndOffset(6, node.getStartPosition() + node.getLength());
                        this.doTextRemoveAndVisit(startPos, dotEnd - startPos, node, description);
                        return dotEnd;
                    }
                    catch (CoreException e) {
                        JavaPlugin.log(e);
                        break;
                    }
                }
                case 4: {
                    ASTNode node = (ASTNode)event.getOriginalValue();
                    GroupDescription description = this.getDescription(event);
                    int offset = this.getExtendedOffset(node);
                    int length = this.getExtendedLength(node);
                    this.doTextRemoveAndVisit(offset, length, node, description);
                    this.doTextInsert(offset, (ASTNode)event.getNewValue(), this.getIndent(startPos), true, description);
                    return offset + length;
                }
            }
        }
        return this.doVisit(parent, property, startPos);
    }

    private int rewriteParagraphList(ASTNode parent, int property, int insertPos, int insertIndent, int separator, int lead) {
        RewriteEvent event = this.getEvent(parent, property);
        if (event == null || event.getChangeKind() == 0) {
            return this.doVisit(parent, property, insertPos);
        }
        RewriteEvent[] events = event.getChildren();
        boolean hasExisting = false;
        int i = 0;
        while (i < events.length) {
            int changeKind = events[i].getChangeKind();
            hasExisting |= changeKind != 1;
            ++i;
        }
        ParagraphListRewriter listRewriter = new ParagraphListRewriter(insertIndent, separator);
        StringBuffer leadString = new StringBuffer();
        if (!hasExisting) {
            int i2 = 0;
            while (i2 < lead) {
                leadString.append(this.getLineDelimiter());
                ++i2;
            }
            leadString.append(CodeFormatterUtil.createIndentString(insertIndent));
        }
        return listRewriter.rewriteList(event.getChildren(), insertPos, leadString.toString());
    }

    private int rewriteNodeList(ASTNode parent, int property, int pos, String keyword, String separator) {
        RewriteEvent event = this.getEvent(parent, property);
        if (event != null && event.getChangeKind() != 0) {
            return new ListRewriter().rewriteList(event.getChildren(), pos, keyword, separator);
        }
        return this.doVisit(parent, property, pos);
    }

    private void rewriteMethodBody(MethodDeclaration parent, int startPos) {
        RewriteEvent event = this.getEvent((ASTNode)parent, 4);
        if (event != null) {
            switch (event.getChangeKind()) {
                case 1: {
                    int endPos = parent.getStartPosition() + parent.getLength();
                    GroupDescription description = this.getDescription(event);
                    ASTNode body = (ASTNode)event.getNewValue();
                    this.doTextRemove(startPos, endPos - startPos, description);
                    int indent = this.getIndent(parent.getStartPosition());
                    String prefix = ASTRewriteFormatter.METHOD_BODY.getPrefix(indent, this.getLineDelimiter());
                    this.doTextInsert(startPos, prefix, description);
                    this.doTextInsert(startPos, body, indent, true, description);
                    return;
                }
                case 2: {
                    GroupDescription description = this.getDescription(event);
                    ASTNode body = (ASTNode)event.getOriginalValue();
                    int endPos = parent.getStartPosition() + parent.getLength();
                    this.doTextRemoveAndVisit(startPos, endPos - startPos, body, description);
                    this.doTextInsert(startPos, ";", description);
                    return;
                }
                case 4: {
                    GroupDescription description = this.getDescription(event);
                    ASTNode body = (ASTNode)event.getOriginalValue();
                    this.doTextRemoveAndVisit(body.getStartPosition(), body.getLength(), body, description);
                    this.doTextInsert(body.getStartPosition(), (ASTNode)event.getNewValue(), this.getIndent(body.getStartPosition()), true, description);
                    return;
                }
            }
        }
        this.doVisit((ASTNode)parent, 4, startPos);
    }

    private int rewriteExtraDimensions(ASTNode parent, int property, int pos) {
        int newDim;
        RewriteEvent event = this.getEvent(parent, property);
        if (event == null || event.getChangeKind() == 0) {
            return (Integer)this.getOriginalValue(parent, property);
        }
        int oldDim = (Integer)event.getOriginalValue();
        if (oldDim != (newDim = ((Integer)event.getNewValue()).intValue())) {
            GroupDescription description = this.getDescription(event);
            this.rewriteExtraDimensions(oldDim, newDim, pos, description);
        }
        return oldDim;
    }

    private void rewriteExtraDimensions(int oldDim, int newDim, int pos, GroupDescription description) {
        block5: {
            block4: {
                if (oldDim >= newDim) break block4;
                int i = oldDim;
                while (i < newDim) {
                    this.doTextInsert(pos, "[]", description);
                    ++i;
                }
                break block5;
            }
            if (newDim >= oldDim) break block5;
            try {
                this.getScanner().setOffset(pos);
                int i = newDim;
                while (i < oldDim) {
                    this.getScanner().readToToken(166);
                    ++i;
                }
                this.doTextRemove(pos, this.getScanner().getCurrentEndOffset() - pos, description);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
    }

    private int getPosAfterLeftBrace(int pos) {
        try {
            int nextToken = this.getScanner().readNext(pos, true);
            if (nextToken == 110) {
                return this.getScanner().getCurrentEndOffset();
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        return pos;
    }

    final int getIndent(int pos) {
        try {
            IRegion line = this.fDocument.getLineInformationOfOffset(pos);
            String str = this.fDocument.get(line.getOffset(), line.getLength());
            return Strings.computeIndent(str, CodeFormatterUtil.getTabWidth());
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    final void doTextInsert(int insertOffset, ASTNode node, int initialIndentLevel, boolean removeLeadingIndent, GroupDescription description) {
        ArrayList<ASTRewriteFormatter.NodeMarker> markers = new ArrayList<ASTRewriteFormatter.NodeMarker>();
        String formatted = this.fFormatter.getFormattedResult(node, initialIndentLevel, markers);
        int tabWidth = CodeFormatterUtil.getTabWidth();
        int currPos = 0;
        if (removeLeadingIndent) {
            while (currPos < formatted.length() && Character.isWhitespace(formatted.charAt(currPos))) {
                ++currPos;
            }
        }
        int i = 0;
        while (i < markers.size()) {
            Object data;
            ASTRewriteFormatter.NodeMarker curr = (ASTRewriteFormatter.NodeMarker)((Object)markers.get(i));
            int offset = curr.offset;
            if (offset != currPos) {
                String insertStr = formatted.substring(currPos, offset);
                this.doTextInsert(insertOffset, insertStr, description);
            }
            if ((data = curr.data) instanceof GroupDescription) {
                RangeMarker edit = new RangeMarker(insertOffset, 0);
                this.addDescription((GroupDescription)data, (TextEdit)edit);
                this.addEdit((TextEdit)edit);
                if (curr.length != 0) {
                    int end = offset + curr.length;
                    int k = i + 1;
                    while (k < markers.size() && ((ASTRewriteFormatter.NodeMarker)((Object)markers.get((int)k))).offset < end) {
                        ++k;
                    }
                    curr.offset = end;
                    curr.length = 0;
                    markers.add(k, curr);
                }
                currPos = offset;
            } else {
                String destIndentString = Strings.getIndentString(this.getCurrentLine(formatted, offset), tabWidth);
                if (data instanceof NewASTRewrite.MovePlaceholderData) {
                    ASTNode existingNode = ((NewASTRewrite.MovePlaceholderData)data).node;
                    int srcIndentLevel = this.getIndent(existingNode.getStartPosition());
                    this.doTextMove(existingNode, insertOffset, srcIndentLevel, destIndentString, tabWidth, description);
                    currPos = offset + curr.length;
                } else if (data instanceof NewASTRewrite.CopyPlaceholderData) {
                    ASTNode existingNode = ((NewASTRewrite.CopyPlaceholderData)data).node;
                    int srcIndentLevel = this.getIndent(existingNode.getStartPosition());
                    this.doTextCopy(existingNode, insertOffset, srcIndentLevel, destIndentString, tabWidth, description);
                    currPos = offset + curr.length;
                } else if (data instanceof NewASTRewrite.StringPlaceholderData) {
                    String code = ((NewASTRewrite.StringPlaceholderData)data).code;
                    String str = Strings.changeIndent(code, 0, tabWidth, destIndentString, this.getLineDelimiter());
                    this.doTextInsert(insertOffset, str, description);
                    currPos = offset + curr.length;
                }
            }
            ++i;
        }
        if (currPos < formatted.length()) {
            String insertStr = formatted.substring(currPos);
            this.doTextInsert(insertOffset, insertStr, description);
        }
    }

    private String getCurrentLine(String str, int pos) {
        int i = pos - 1;
        while (i >= 0) {
            char ch = str.charAt(i);
            if (Strings.isLineDelimiterChar(ch)) {
                return str.substring(i + 1, pos);
            }
            --i;
        }
        return str.substring(0, pos);
    }

    private void rewriteModifiers(ASTNode parent, int property, int offset) {
        RewriteEvent event = this.getEvent(parent, property);
        if (event == null || event.getChangeKind() != 4) {
            return;
        }
        int oldModifiers = (Integer)event.getOriginalValue();
        int newModifiers = (Integer)event.getNewValue();
        GroupDescription description = this.getDescription(event);
        try {
            int startPos;
            int tok = this.getScanner().readNext(offset, true);
            int endPos = startPos = this.getScanner().getCurrentStartOffset();
            block15: while (true) {
                boolean keep = true;
                switch (tok) {
                    case 103: {
                        keep = Modifier.isPublic((int)newModifiers);
                        break;
                    }
                    case 102: {
                        keep = Modifier.isProtected((int)newModifiers);
                        break;
                    }
                    case 101: {
                        keep = Modifier.isPrivate((int)newModifiers);
                        break;
                    }
                    case 94: {
                        keep = Modifier.isStatic((int)newModifiers);
                        break;
                    }
                    case 99: {
                        keep = Modifier.isFinal((int)newModifiers);
                        break;
                    }
                    case 98: {
                        keep = Modifier.isAbstract((int)newModifiers);
                        break;
                    }
                    case 100: {
                        keep = Modifier.isNative((int)newModifiers);
                        break;
                    }
                    case 106: {
                        keep = Modifier.isVolatile((int)newModifiers);
                        break;
                    }
                    case 104: {
                        keep = Modifier.isStrictfp((int)newModifiers);
                        break;
                    }
                    case 105: {
                        keep = Modifier.isTransient((int)newModifiers);
                        break;
                    }
                    case 85: {
                        keep = Modifier.isSynchronized((int)newModifiers);
                        break;
                    }
                    default: {
                        break block15;
                    }
                }
                tok = this.getScanner().readNext(true);
                int currPos = endPos;
                endPos = this.getScanner().getCurrentStartOffset();
                if (keep) continue;
                this.doTextRemove(currPos, endPos - currPos, description);
            }
            int addedModifiers = newModifiers & ~oldModifiers;
            if (addedModifiers != 0) {
                int visibilityModifiers;
                if (startPos != endPos && (visibilityModifiers = addedModifiers & 7) != 0) {
                    StringBuffer buf = new StringBuffer();
                    ASTFlattener.printModifiers(visibilityModifiers, buf);
                    this.doTextInsert(startPos, buf.toString(), description);
                    addedModifiers &= ~visibilityModifiers;
                }
                StringBuffer buf = new StringBuffer();
                ASTFlattener.printModifiers(addedModifiers, buf);
                this.doTextInsert(endPos, buf.toString(), description);
            }
        }
        catch (CoreException coreException) {}
    }

    private void replaceOperation(int posBeforeOperation, String newOperation, GroupDescription description) {
        try {
            this.getScanner().readNext(posBeforeOperation, true);
            this.doTextReplace(this.getScanner().getCurrentStartOffset(), this.getScanner().getCurrentLength(), newOperation, description);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
    }

    private void rewriteOperation(ASTNode parent, int property, int posBeforeOperation) {
        RewriteEvent event = this.getEvent(parent, property);
        if (event != null && event.getChangeKind() != 0) {
            try {
                String newOperation = event.getNewValue().toString();
                GroupDescription description = this.getDescription(event);
                this.getScanner().readNext(posBeforeOperation, true);
                this.doTextReplace(this.getScanner().getCurrentStartOffset(), this.getScanner().getCurrentLength(), newOperation, description);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
    }

    public void postVisit(ASTNode node) {
        GroupDescription description = this.fRewrite.getTrackedNodeData(node);
        if (description != null) {
            this.fCurrentEdit = this.fCurrentEdit.getParent();
        }
        int count = this.fEventStore.getCopyCount(node);
        while (count > 0) {
            this.fCurrentEdit = this.fCurrentEdit.getParent();
            --count;
        }
        if (this.fEventStore.isMoveSource(node)) {
            this.fCurrentEdit = this.fCurrentEdit.getParent();
        }
    }

    public void preVisit(ASTNode node) {
        GroupDescription description;
        CopySourceEdit[] edits;
        MoveSourceEdit moveEdit = this.getMoveSource(node);
        if (moveEdit != null) {
            this.addEdit((TextEdit)moveEdit);
            this.fCurrentEdit = moveEdit;
        }
        if ((edits = this.getCopySources(node)) != null) {
            int i = 0;
            while (i < edits.length) {
                CopySourceEdit edit = edits[i];
                this.addEdit((TextEdit)edit);
                this.fCurrentEdit = edit;
                ++i;
            }
        }
        if ((description = this.fRewrite.getTrackedNodeData(node)) != null) {
            int offset = this.getExtendedOffset(node);
            int length = this.getExtendedLength(node);
            RangeMarker edit = new RangeMarker(offset, length);
            this.addDescription(description, (TextEdit)edit);
            this.addEdit((TextEdit)edit);
            this.fCurrentEdit = edit;
        }
    }

    public boolean visit(CompilationUnit node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        int startPos = this.rewriteNode((ASTNode)node, 38, 0, ASTRewriteFormatter.NONE);
        if (this.getChangeKind((ASTNode)node, 38) == 1) {
            this.doTextInsert(0, this.getLineDelimiter(), this.getDescription((ASTNode)node, 38));
        }
        startPos = this.rewriteParagraphList((ASTNode)node, 21, startPos, 0, 0, 2);
        this.rewriteParagraphList((ASTNode)node, 54, startPos, 0, -1, 2);
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        RewriteEvent interfaceEvent;
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteModifiers((ASTNode)node, 34, node.getStartPosition());
        boolean isInterface = (Boolean)this.getOriginalValue((ASTNode)node, 26);
        boolean invertType = this.isChanged((ASTNode)node, 26);
        if (invertType) {
            try {
                int typeToken = isInterface ? 180 : 165;
                this.getScanner().readToToken(typeToken, node.getStartPosition());
                String str = isInterface ? "class" : "interface";
                int start = this.getScanner().getCurrentStartOffset();
                int end = this.getScanner().getCurrentEndOffset();
                this.doTextReplace(start, end - start, str, this.getDescription((ASTNode)node, 26));
            }
            catch (CoreException coreException) {}
        }
        int pos = this.rewriteRequiredNode((ASTNode)node, 35);
        if (!isInterface || invertType) {
            RewriteEvent superClassEvent = this.getEvent((ASTNode)node, 47);
            int changeKind = superClassEvent != null ? superClassEvent.getChangeKind() : 0;
            switch (changeKind) {
                case 1: {
                    ASTNode superClass = (ASTNode)superClassEvent.getNewValue();
                    String str = " extends " + ASTNodes.asString(superClass);
                    this.doTextInsert(pos, str, this.getDescription(superClassEvent));
                    break;
                }
                case 2: {
                    ASTNode superClass = (ASTNode)superClassEvent.getOriginalValue();
                    int endPos = this.getExtendedEnd(superClass);
                    this.doTextRemoveAndVisit(pos, endPos - pos, superClass, this.getDescription(superClassEvent));
                    pos = endPos;
                    break;
                }
                case 4: {
                    ASTNode superClass = (ASTNode)superClassEvent.getOriginalValue();
                    int offset = this.getExtendedOffset(superClass);
                    int length = this.getExtendedLength(superClass);
                    this.doTextRemoveAndVisit(offset, length, superClass, this.getDescription(superClassEvent));
                    this.doTextInsert(offset, (ASTNode)superClassEvent.getNewValue(), 0, false, this.getDescription(superClassEvent));
                    pos = offset + length;
                    break;
                }
                case 0: {
                    pos = this.doVisit((ASTNode)node, 47, pos);
                }
            }
        }
        if ((interfaceEvent = this.getEvent((ASTNode)node, 46)) == null || interfaceEvent.getChangeKind() == 0) {
            List originalNodes;
            if (invertType && !(originalNodes = (List)this.getOriginalValue((ASTNode)node, 46)).isEmpty()) {
                String keyword = isInterface ? " implements " : " extends ";
                ASTNode firstNode = (ASTNode)originalNodes.get(0);
                this.doTextReplace(pos, firstNode.getStartPosition() - pos, keyword, this.getDescription((ASTNode)node, 26));
            }
            pos = this.doVisit((ASTNode)node, 46, pos);
        } else {
            List newNodes;
            String keyword;
            String string = keyword = isInterface == invertType ? " implements " : " extends ";
            if (invertType && !(newNodes = (List)this.getNewValue((ASTNode)node, 46)).isEmpty()) {
                List origNodes = (List)this.getOriginalValue((ASTNode)node, 46);
                int firstStart = pos;
                if (!origNodes.isEmpty()) {
                    firstStart = ((ASTNode)origNodes.get(0)).getStartPosition();
                }
                this.doTextReplace(pos, firstStart - pos, keyword, this.getDescription((ASTNode)node, 26));
                keyword = "";
                pos = firstStart;
            }
            pos = this.rewriteNodeList((ASTNode)node, 46, pos, keyword, ", ");
        }
        int startIndent = this.getIndent(node.getStartPosition()) + 1;
        int startPos = this.getPosAfterLeftBrace(pos);
        this.rewriteParagraphList((ASTNode)node, 5, startPos, startIndent, -1, 2);
        return false;
    }

    private void rewriteReturnType(MethodDeclaration node, boolean isConstructor, boolean isConstructorChange) {
        boolean returnTypeExists;
        ASTNode originalReturnType = (ASTNode)this.getOriginalValue((ASTNode)node, 42);
        boolean bl = returnTypeExists = originalReturnType != null && originalReturnType.getStartPosition() != -1;
        if (!isConstructorChange && returnTypeExists) {
            this.rewriteRequiredNode((ASTNode)node, 42);
            return;
        }
        ASTNode newReturnType = (ASTNode)this.getNewValue((ASTNode)node, 42);
        if (isConstructorChange || !returnTypeExists && newReturnType != originalReturnType) {
            try {
                int startPos = node.getStartPosition();
                this.getScanner().setOffset(startPos);
                int token = this.getScanner().readNext(true);
                while (TokenScanner.isModifier(token)) {
                    startPos = this.getScanner().getCurrentEndOffset();
                    token = this.getScanner().readNext(true);
                }
                GroupDescription description = this.getDescription((ASTNode)node, 42);
                if (isConstructor || !returnTypeExists) {
                    this.doTextInsert(startPos, " ", description);
                    this.doTextInsert(startPos, newReturnType, this.getIndent(startPos), true, description);
                } else {
                    int len = this.getExtendedEnd(originalReturnType) - startPos;
                    this.doTextRemoveAndVisit(startPos, len, originalReturnType, description);
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
    }

    public boolean visit(MethodDeclaration node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteModifiers((ASTNode)node, 34, node.getStartPosition());
        boolean isConstructorChange = this.isChanged((ASTNode)node, 25);
        boolean isConstructor = (Boolean)this.getOriginalValue((ASTNode)node, 25);
        if (!isConstructor || isConstructorChange) {
            this.rewriteReturnType(node, isConstructor, isConstructorChange);
        }
        int pos = this.rewriteRequiredNode((ASTNode)node, 35);
        try {
            if (this.isChanged((ASTNode)node, 39)) {
                pos = this.getScanner().getTokenEndOffset(7, pos);
                pos = this.rewriteNodeList((ASTNode)node, 39, pos, "", ", ");
            } else {
                pos = this.doVisit((ASTNode)node, 39, pos);
            }
            pos = this.getScanner().getTokenEndOffset(86, pos);
            int extraDims = this.rewriteExtraDimensions((ASTNode)node, 17, pos);
            boolean hasExceptionChanges = this.isChanged((ASTNode)node, 50);
            int bodyChangeKind = this.getChangeKind((ASTNode)node, 4);
            if (extraDims > 0 && (hasExceptionChanges || bodyChangeKind == 1 || bodyChangeKind == 2)) {
                int dim = (Integer)this.getOriginalValue((ASTNode)node, 17);
                while (dim > 0) {
                    pos = this.getScanner().getTokenEndOffset(166, pos);
                    --dim;
                }
            }
            pos = this.rewriteNodeList((ASTNode)node, 50, pos, " throws ", ", ");
            this.rewriteMethodBody(node, pos);
        }
        catch (CoreException coreException) {}
        return false;
    }

    public boolean visit(Block node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        int startPos = this.isCollapsed((ASTNode)node) ? node.getStartPosition() : this.getPosAfterLeftBrace(node.getStartPosition());
        int startIndent = this.getIndent(node.getStartPosition()) + 1;
        this.rewriteParagraphList((ASTNode)node, 45, startPos, startIndent, 0, 1);
        return false;
    }

    public boolean visit(ReturnStatement node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        try {
            int offset = this.getScanner().getTokenEndOffset(124, node.getStartPosition());
            this.rewriteNode((ASTNode)node, 14, offset, ASTRewriteFormatter.SPACE);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        return false;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        int startPos = this.getPosAfterLeftBrace(node.getStartPosition());
        int startIndent = this.getIndent(node.getStartPosition()) + 1;
        this.rewriteParagraphList((ASTNode)node, 5, startPos, startIndent, -1, 2);
        return false;
    }

    public boolean visit(ArrayAccess node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteRequiredNode((ASTNode)node, 3);
        this.rewriteRequiredNode((ASTNode)node, 22);
        return false;
    }

    public boolean visit(ArrayCreation node) {
        int nOldBrackets;
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        ArrayType arrayType = (ArrayType)this.getOriginalValue((ASTNode)node, 52);
        int nNewBrackets = nOldBrackets = this.getDimensions(arrayType);
        GroupDescription description = null;
        RewriteEvent typeEvent = this.getEvent((ASTNode)node, 52);
        if (typeEvent != null && typeEvent.getChangeKind() == 4) {
            Type oldType;
            ArrayType replacingType = (ArrayType)typeEvent.getNewValue();
            description = this.getDescription(typeEvent);
            Type newType = replacingType.getElementType();
            if (!newType.equals((Object)(oldType = this.getElementType(arrayType)))) {
                int offset = this.getExtendedOffset((ASTNode)oldType);
                int length = this.getExtendedLength((ASTNode)oldType);
                this.doTextRemove(offset, length, description);
                this.doTextInsert(offset, (ASTNode)newType, 0, false, description);
            }
            nNewBrackets = replacingType.getDimensions();
        }
        this.doVisit((ASTNode)arrayType);
        try {
            int kind;
            boolean hasDimensionChanges;
            int offset = this.getScanner().getTokenStartOffset(15, arrayType.getStartPosition());
            RewriteEvent dimEvent = this.getEvent((ASTNode)node, 9);
            boolean bl = hasDimensionChanges = dimEvent != null && dimEvent.getChangeKind() != 0;
            if (hasDimensionChanges) {
                RewriteEvent[] events = dimEvent.getChildren();
                int i = 0;
                while (i < events.length) {
                    RewriteEvent event = events[i];
                    int changeKind = event.getChangeKind();
                    if (changeKind == 1) {
                        description = this.getDescription(event);
                        this.doTextInsert(offset, "[", description);
                        this.doTextInsert(offset, (ASTNode)event.getNewValue(), 0, false, description);
                        this.doTextInsert(offset, "]", description);
                        --nNewBrackets;
                    } else {
                        ASTNode elem = (ASTNode)event.getOriginalValue();
                        int elemEnd = elem.getStartPosition() + elem.getLength();
                        int endPos = this.getScanner().getTokenEndOffset(166, elemEnd);
                        if (changeKind == 2) {
                            description = this.getDescription(event);
                            this.doTextRemoveAndVisit(offset, endPos - offset, elem, description);
                        } else if (changeKind == 4) {
                            description = this.getDescription(event);
                            int elemOffset = this.getExtendedOffset(elem);
                            int elemLength = this.getExtendedLength(elem);
                            this.doTextRemoveAndVisit(elemOffset, elemLength, elem, description);
                            this.doTextInsert(elemOffset, (ASTNode)event.getNewValue(), 0, false, description);
                            --nNewBrackets;
                        } else {
                            this.doVisit(elem);
                            --nNewBrackets;
                        }
                        offset = endPos;
                        --nOldBrackets;
                    }
                    ++i;
                }
            } else {
                offset = this.doVisit((ASTNode)node, 9, offset);
            }
            if (nOldBrackets != nNewBrackets) {
                if (!hasDimensionChanges) {
                    offset = this.getScanner().getTokenEndOffset(166, offset);
                }
                this.rewriteExtraDimensions(nOldBrackets, nNewBrackets, offset, description);
            }
            offset = (kind = this.getChangeKind((ASTNode)node, 23)) == 2 ? this.getScanner().getPreviousTokenEndOffset(110, offset) : node.getStartPosition() + node.getLength();
            this.rewriteNode((ASTNode)node, 23, offset, ASTRewriteFormatter.SPACE);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        return false;
    }

    private Type getElementType(ArrayType parent) {
        Type t = (Type)this.getOriginalValue((ASTNode)parent, 8);
        while (t.isArrayType()) {
            t = (Type)this.getOriginalValue((ASTNode)t, 8);
        }
        return t;
    }

    private int getDimensions(ArrayType parent) {
        Type t = (Type)this.getOriginalValue((ASTNode)parent, 8);
        int dimensions = 1;
        while (t.isArrayType()) {
            ++dimensions;
            t = (Type)this.getOriginalValue((ASTNode)t, 8);
        }
        return dimensions;
    }

    public boolean visit(ArrayInitializer node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        int startPos = this.getPosAfterLeftBrace(node.getStartPosition());
        this.rewriteNodeList((ASTNode)node, 15, startPos, "", ", ");
        return false;
    }

    public boolean visit(ArrayType node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteRequiredNode((ASTNode)node, 8);
        return false;
    }

    public boolean visit(AssertStatement node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        int offset = this.rewriteRequiredNode((ASTNode)node, 14);
        this.rewriteNode((ASTNode)node, 33, offset, ASTRewriteFormatter.ASSERT_COMMENT);
        return false;
    }

    public boolean visit(Assignment node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        int pos = this.rewriteRequiredNode((ASTNode)node, 30);
        this.rewriteOperation((ASTNode)node, 37, pos);
        this.rewriteRequiredNode((ASTNode)node, 43);
        return false;
    }

    public boolean visit(BooleanLiteral node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.changeNotSupported((ASTNode)node);
        return false;
    }

    public boolean visit(BreakStatement node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        try {
            int offset = this.getScanner().getTokenEndOffset(119, node.getStartPosition());
            this.rewriteNode((ASTNode)node, 29, offset, ASTRewriteFormatter.SPACE);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        return false;
    }

    public boolean visit(CastExpression node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteRequiredNode((ASTNode)node, 52);
        this.rewriteRequiredNode((ASTNode)node, 14);
        return false;
    }

    public boolean visit(CatchClause node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteRequiredNode((ASTNode)node, 13);
        this.rewriteRequiredNode((ASTNode)node, 4);
        return false;
    }

    public boolean visit(CharacterLiteral node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.changeNotSupported((ASTNode)node);
        return false;
    }

    public boolean visit(ClassInstanceCreation node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteOptionalQualifier((ASTNode)node, 14, node.getStartPosition());
        int pos = this.rewriteRequiredNode((ASTNode)node, 35);
        if (this.isChanged((ASTNode)node, 2)) {
            try {
                int startpos = this.getScanner().getTokenEndOffset(7, pos);
                this.rewriteNodeList((ASTNode)node, 2, startpos, "", ", ");
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        } else {
            this.doVisit((ASTNode)node, 2, 0);
        }
        int kind = this.getChangeKind((ASTNode)node, 1);
        if (kind == 2) {
            try {
                pos = this.getScanner().getPreviousTokenEndOffset(110, pos);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        } else {
            pos = node.getStartPosition() + node.getLength();
        }
        this.rewriteNode((ASTNode)node, 1, pos, ASTRewriteFormatter.SPACE);
        return false;
    }

    public boolean visit(ConditionalExpression node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteRequiredNode((ASTNode)node, 14);
        this.rewriteRequiredNode((ASTNode)node, 48);
        this.rewriteRequiredNode((ASTNode)node, 10);
        return false;
    }

    public boolean visit(ConstructorInvocation node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        try {
            int startpos = this.getScanner().getTokenEndOffset(7, node.getStartPosition());
            this.rewriteNodeList((ASTNode)node, 2, startpos, "", ", ");
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        return false;
    }

    public boolean visit(ContinueStatement node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        try {
            int offset = this.getScanner().getTokenEndOffset(120, node.getStartPosition());
            this.rewriteNode((ASTNode)node, 29, offset, ASTRewriteFormatter.SPACE);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        return false;
    }

    public boolean visit(DoStatement node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        int pos = node.getStartPosition();
        try {
            RewriteEvent event = this.getEvent((ASTNode)node, 4);
            if (event != null && event.getChangeKind() == 4) {
                int startOffset = this.getScanner().getTokenEndOffset(121, pos);
                ASTNode body = (ASTNode)event.getOriginalValue();
                int bodyEnd = body.getStartPosition() + body.getLength();
                int endPos = this.getScanner().getTokenStartOffset(117, bodyEnd);
                this.rewriteBodyNode((ASTNode)node, 4, startOffset, endPos, this.getIndent(node.getStartPosition()), ASTRewriteFormatter.DO_BLOCK);
            } else {
                this.doVisit((ASTNode)node, 4, pos);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        this.rewriteRequiredNode((ASTNode)node, 14);
        return false;
    }

    public boolean visit(EmptyStatement node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.changeNotSupported((ASTNode)node);
        return false;
    }

    public boolean visit(ExpressionStatement node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteRequiredNode((ASTNode)node, 14);
        return false;
    }

    public boolean visit(FieldAccess node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteRequiredNode((ASTNode)node, 14);
        this.rewriteRequiredNode((ASTNode)node, 35);
        return false;
    }

    public boolean visit(FieldDeclaration node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteModifiers((ASTNode)node, 34, node.getStartPosition());
        int pos = this.rewriteRequiredNode((ASTNode)node, 52);
        this.rewriteNodeList((ASTNode)node, 19, pos, "", ", ");
        return false;
    }

    public boolean visit(ForStatement node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        try {
            int startOffset;
            int pos = node.getStartPosition();
            if (this.isChanged((ASTNode)node, 24)) {
                startOffset = this.getScanner().getTokenEndOffset(7, pos);
                pos = this.rewriteNodeList((ASTNode)node, 24, startOffset, "", ", ");
            } else {
                pos = this.doVisit((ASTNode)node, 24, pos);
            }
            pos = this.getScanner().getTokenEndOffset(64, pos);
            pos = this.rewriteNode((ASTNode)node, 14, pos, ASTRewriteFormatter.NONE);
            if (this.isChanged((ASTNode)node, 55)) {
                startOffset = this.getScanner().getTokenEndOffset(64, pos);
                pos = this.rewriteNodeList((ASTNode)node, 55, startOffset, "", ", ");
            } else {
                pos = this.doVisit((ASTNode)node, 55, pos);
            }
            RewriteEvent bodyEvent = this.getEvent((ASTNode)node, 4);
            if (bodyEvent != null && bodyEvent.getChangeKind() == 4) {
                int startOffset2 = this.getScanner().getTokenEndOffset(86, pos);
                this.rewriteBodyNode((ASTNode)node, 4, startOffset2, -1, this.getIndent(node.getStartPosition()), ASTRewriteFormatter.WHILE_BLOCK);
            } else {
                this.doVisit((ASTNode)node, 4, 0);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        return false;
    }

    public boolean visit(IfStatement node) {
        int indent;
        int elseChange;
        int pos;
        block11: {
            if (!this.hasChildrenChanges((ASTNode)node)) {
                return this.visitChildrenNeeded((ASTNode)node);
            }
            pos = this.rewriteRequiredNode((ASTNode)node, 14);
            RewriteEvent thenEvent = this.getEvent((ASTNode)node, 49);
            elseChange = this.getChangeKind((ASTNode)node, 11);
            if (thenEvent != null && thenEvent.getChangeKind() != 0) {
                try {
                    pos = this.getScanner().getTokenEndOffset(86, pos);
                    indent = this.getIndent(node.getStartPosition());
                    int endPos = -1;
                    Object elseStatement = this.getOriginalValue((ASTNode)node, 11);
                    if (elseStatement != null) {
                        ASTNode thenStatement = (ASTNode)thenEvent.getOriginalValue();
                        endPos = this.getScanner().getTokenStartOffset(213, thenStatement.getStartPosition() + thenStatement.getLength());
                    }
                    if (elseStatement == null || elseChange != 0) {
                        pos = this.rewriteBodyNode((ASTNode)node, 49, pos, endPos, indent, ASTRewriteFormatter.IF_BLOCK_NO_ELSE);
                        break block11;
                    }
                    pos = this.rewriteBodyNode((ASTNode)node, 49, pos, endPos, indent, ASTRewriteFormatter.IF_BLOCK_WITH_ELSE);
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                }
            } else {
                pos = this.doVisit((ASTNode)node, 49, pos);
            }
        }
        if (elseChange != 0) {
            indent = this.getIndent(node.getStartPosition());
            Object newThen = this.getNewValue((ASTNode)node, 49);
            if (newThen instanceof Block) {
                this.rewriteBodyNode((ASTNode)node, 11, pos, -1, indent, ASTRewriteFormatter.ELSE_AFTER_BLOCK);
            } else {
                this.rewriteBodyNode((ASTNode)node, 11, pos, -1, indent, ASTRewriteFormatter.ELSE_AFTER_STATEMENT);
            }
        } else {
            pos = this.doVisit((ASTNode)node, 11, pos);
        }
        return false;
    }

    public boolean visit(ImportDeclaration node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        int pos = this.rewriteRequiredNode((ASTNode)node, 35);
        RewriteEvent event = this.getEvent((ASTNode)node, 27);
        if (event != null && event.getChangeKind() != 0) {
            boolean isOnDemand = (Boolean)event.getOriginalValue();
            if (!isOnDemand) {
                this.doTextInsert(pos, ".*", this.getDescription(event));
            } else {
                try {
                    int endPos = this.getScanner().getTokenStartOffset(64, pos);
                    this.doTextRemove(pos, endPos - pos, this.getDescription(event));
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                }
            }
        }
        return false;
    }

    public boolean visit(InfixExpression node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        int pos = this.rewriteRequiredNode((ASTNode)node, 31);
        boolean needsNewOperation = this.isChanged((ASTNode)node, 37);
        String operation = this.getNewValue((ASTNode)node, 37).toString();
        if (needsNewOperation) {
            this.replaceOperation(pos, operation, this.getDescription((ASTNode)node, 37));
        }
        pos = this.rewriteRequiredNode((ASTNode)node, 44);
        RewriteEvent event = this.getEvent((ASTNode)node, 16);
        String prefixString = String.valueOf(' ') + operation + ' ';
        if (needsNewOperation) {
            int startPos = pos;
            GroupDescription description = this.getDescription((ASTNode)node, 37);
            if (event != null && event.getChangeKind() != 0) {
                RewriteEvent[] extendedOperands = event.getChildren();
                int i = 0;
                while (i < extendedOperands.length) {
                    RewriteEvent curr = extendedOperands[i];
                    ASTNode elem = (ASTNode)curr.getOriginalValue();
                    if (elem != null) {
                        if (curr.getChangeKind() != 4) {
                            this.replaceOperation(startPos, operation, description);
                        }
                        startPos = elem.getStartPosition() + elem.getLength();
                    }
                    ++i;
                }
            } else {
                List extendedOperands = (List)this.getOriginalValue((ASTNode)node, 16);
                int i = 0;
                while (i < extendedOperands.size()) {
                    ASTNode elem = (ASTNode)extendedOperands.get(i);
                    this.replaceOperation(startPos, operation, description);
                    startPos = elem.getStartPosition() + elem.getLength();
                    ++i;
                }
            }
        }
        this.rewriteNodeList((ASTNode)node, 16, pos, prefixString, prefixString);
        return false;
    }

    public boolean visit(Initializer node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteModifiers((ASTNode)node, 34, node.getStartPosition());
        this.rewriteRequiredNode((ASTNode)node, 4);
        return false;
    }

    public boolean visit(InstanceofExpression node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteRequiredNode((ASTNode)node, 31);
        this.rewriteRequiredNode((ASTNode)node, 44);
        return false;
    }

    public boolean visit(Javadoc node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.changeNotSupported((ASTNode)node);
        return false;
    }

    public boolean visit(LabeledStatement node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteRequiredNode((ASTNode)node, 29);
        this.rewriteRequiredNode((ASTNode)node, 4);
        return false;
    }

    public boolean visit(MethodInvocation node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteOptionalQualifier((ASTNode)node, 14, node.getStartPosition());
        int pos = this.rewriteRequiredNode((ASTNode)node, 35);
        if (this.isChanged((ASTNode)node, 2)) {
            try {
                int startOffset = this.getScanner().getTokenEndOffset(7, pos);
                this.rewriteNodeList((ASTNode)node, 2, startOffset, "", ", ");
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        } else {
            this.doVisit((ASTNode)node, 2, 0);
        }
        return false;
    }

    public boolean visit(NullLiteral node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.changeNotSupported((ASTNode)node);
        return false;
    }

    public boolean visit(NumberLiteral node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.changeNotSupported((ASTNode)node);
        return false;
    }

    public boolean visit(PackageDeclaration node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteRequiredNode((ASTNode)node, 35);
        return false;
    }

    public boolean visit(ParenthesizedExpression node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteRequiredNode((ASTNode)node, 14);
        return false;
    }

    public boolean visit(PostfixExpression node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        int pos = this.rewriteRequiredNode((ASTNode)node, 36);
        this.rewriteOperation((ASTNode)node, 37, pos);
        return false;
    }

    public boolean visit(PrefixExpression node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteOperation((ASTNode)node, 37, node.getStartPosition());
        this.rewriteRequiredNode((ASTNode)node, 36);
        return false;
    }

    public boolean visit(PrimitiveType node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.changeNotSupported((ASTNode)node);
        return false;
    }

    public boolean visit(QualifiedName node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteRequiredNode((ASTNode)node, 41);
        this.rewriteRequiredNode((ASTNode)node, 35);
        return false;
    }

    public boolean visit(SimpleName node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.changeNotSupported((ASTNode)node);
        return false;
    }

    public boolean visit(SimpleType node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteRequiredNode((ASTNode)node, 35);
        return false;
    }

    public boolean visit(SingleVariableDeclaration node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteModifiers((ASTNode)node, 34, node.getStartPosition());
        this.rewriteRequiredNode((ASTNode)node, 52);
        int pos = this.rewriteRequiredNode((ASTNode)node, 35);
        int extraDims = this.rewriteExtraDimensions((ASTNode)node, 17, pos);
        if (extraDims > 0) {
            int kind = this.getChangeKind((ASTNode)node, 23);
            if (kind == 2) {
                try {
                    pos = this.getScanner().getPreviousTokenEndOffset(167, pos);
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                }
            } else {
                pos = node.getStartPosition() + node.getLength();
            }
        }
        this.rewriteNode((ASTNode)node, 23, pos, ASTRewriteFormatter.VAR_INITIALIZER);
        return false;
    }

    public boolean visit(StringLiteral node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.changeNotSupported((ASTNode)node);
        return false;
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        int pos = this.rewriteOptionalQualifier((ASTNode)node, 14, node.getStartPosition());
        if (this.isChanged((ASTNode)node, 2)) {
            try {
                pos = this.getScanner().getTokenEndOffset(7, pos);
                this.rewriteNodeList((ASTNode)node, 2, pos, "", ", ");
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        } else {
            this.doVisit((ASTNode)node, 2, 0);
        }
        return false;
    }

    public boolean visit(SuperFieldAccess node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteOptionalQualifier((ASTNode)node, 41, node.getStartPosition());
        this.rewriteRequiredNode((ASTNode)node, 35);
        return false;
    }

    public boolean visit(SuperMethodInvocation node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteOptionalQualifier((ASTNode)node, 41, node.getStartPosition());
        int pos = this.rewriteRequiredNode((ASTNode)node, 35);
        if (this.isChanged((ASTNode)node, 2)) {
            try {
                pos = this.getScanner().getTokenEndOffset(7, pos);
                this.rewriteNodeList((ASTNode)node, 2, pos, "", ", ");
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        } else {
            this.doVisit((ASTNode)node, 2, 0);
        }
        return false;
    }

    public boolean visit(SwitchCase node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteRequiredNode((ASTNode)node, 14);
        return false;
    }

    public boolean visit(SwitchStatement node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        int pos = this.rewriteRequiredNode((ASTNode)node, 14);
        RewriteEvent event = this.getEvent((ASTNode)node, 45);
        if (event != null && event.getChangeKind() != 0) {
            try {
                pos = this.getScanner().getTokenEndOffset(110, pos);
                int insertIndent = this.getIndent(node.getStartPosition()) + 1;
                SwitchListRewriter listRewriter = new SwitchListRewriter(insertIndent);
                StringBuffer leadString = new StringBuffer();
                leadString.append(this.getLineDelimiter());
                leadString.append(CodeFormatterUtil.createIndentString(insertIndent));
                listRewriter.rewriteList(event.getChildren(), pos, leadString.toString());
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        } else {
            this.doVisit((ASTNode)node, 45, 0);
        }
        return false;
    }

    public boolean visit(SynchronizedStatement node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteRequiredNode((ASTNode)node, 14);
        this.rewriteRequiredNode((ASTNode)node, 4);
        return false;
    }

    public boolean visit(ThisExpression node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteOptionalQualifier((ASTNode)node, 41, node.getStartPosition());
        return false;
    }

    public boolean visit(ThrowStatement node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteRequiredNode((ASTNode)node, 14);
        return false;
    }

    public boolean visit(TryStatement node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        int pos = this.rewriteRequiredNode((ASTNode)node, 4);
        if (this.isChanged((ASTNode)node, 6)) {
            int indent = this.getIndent(node.getStartPosition());
            String prefix = ASTRewriteFormatter.CATCH_BLOCK.getPrefix(indent, this.getLineDelimiter());
            pos = this.rewriteNodeList((ASTNode)node, 6, pos, prefix, prefix);
        } else {
            pos = this.doVisit((ASTNode)node, 6, pos);
        }
        this.rewriteNode((ASTNode)node, 18, pos, ASTRewriteFormatter.FINALLY_BLOCK);
        return false;
    }

    public boolean visit(TypeDeclarationStatement node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteRequiredNode((ASTNode)node, 53);
        return false;
    }

    public boolean visit(TypeLiteral node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteRequiredNode((ASTNode)node, 52);
        return false;
    }

    public boolean visit(VariableDeclarationExpression node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteModifiers((ASTNode)node, 34, node.getStartPosition());
        int pos = this.rewriteRequiredNode((ASTNode)node, 52);
        this.rewriteNodeList((ASTNode)node, 19, pos, "", ", ");
        return false;
    }

    public boolean visit(VariableDeclarationFragment node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        int pos = this.rewriteRequiredNode((ASTNode)node, 35);
        int extraDims = this.rewriteExtraDimensions((ASTNode)node, 17, pos);
        if (extraDims > 0) {
            int kind = this.getChangeKind((ASTNode)node, 23);
            if (kind == 2) {
                try {
                    pos = this.getScanner().getPreviousTokenEndOffset(167, pos);
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                }
            } else {
                pos = node.getStartPosition() + node.getLength();
            }
        }
        this.rewriteNode((ASTNode)node, 23, pos, ASTRewriteFormatter.VAR_INITIALIZER);
        return false;
    }

    public boolean visit(VariableDeclarationStatement node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        this.rewriteModifiers((ASTNode)node, 34, node.getStartPosition());
        int pos = this.rewriteRequiredNode((ASTNode)node, 52);
        this.rewriteNodeList((ASTNode)node, 19, pos, "", ", ");
        return false;
    }

    public boolean visit(WhileStatement node) {
        if (!this.hasChildrenChanges((ASTNode)node)) {
            return this.visitChildrenNeeded((ASTNode)node);
        }
        int pos = this.rewriteRequiredNode((ASTNode)node, 14);
        try {
            if (this.isChanged((ASTNode)node, 4)) {
                int startOffset = this.getScanner().getTokenEndOffset(86, pos);
                this.rewriteBodyNode((ASTNode)node, 4, startOffset, -1, this.getIndent(node.getStartPosition()), ASTRewriteFormatter.WHILE_BLOCK);
            } else {
                this.doVisit((ASTNode)node, 4, 0);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        return false;
    }

    private class ListRewriter {
        protected String fContantSeparator;
        protected int fStartPos;
        protected RewriteEvent[] fList;

        ListRewriter() {
        }

        protected final ASTNode getOriginalNode(int index) {
            return (ASTNode)this.fList[index].getOriginalValue();
        }

        protected String getSeparatorString(int nodeIndex) {
            return this.fContantSeparator;
        }

        protected int getInitialIndent() {
            return ASTRewriteAnalyzer.this.getIndent(this.fStartPos);
        }

        protected int getNodeIndent(int nodeIndex) {
            ASTNode node = this.getOriginalNode(nodeIndex);
            if (node == null) {
                int i = nodeIndex - 1;
                while (i >= 0) {
                    ASTNode curr = this.getOriginalNode(i);
                    if (curr != null) {
                        return ASTRewriteAnalyzer.this.getIndent(curr.getStartPosition());
                    }
                    --i;
                }
                return this.getInitialIndent();
            }
            return ASTRewriteAnalyzer.this.getIndent(node.getStartPosition());
        }

        protected int getStartOfNextNode(int nextIndex, int defaultPos) {
            int i = nextIndex;
            while (i < this.fList.length) {
                RewriteEvent elem = this.fList[i];
                if (elem.getChangeKind() != 1) {
                    ASTNode node = (ASTNode)elem.getOriginalValue();
                    return ASTRewriteAnalyzer.this.getExtendedOffset(node);
                }
                ++i;
            }
            return defaultPos;
        }

        protected int getEndOfNode(ASTNode node) {
            return ASTRewriteAnalyzer.this.getExtendedEnd(node);
        }

        public final int rewriteList(RewriteEvent[] listEvents, int startPos, String keyword, String separator) {
            this.fContantSeparator = separator;
            return this.rewriteList(listEvents, startPos, keyword);
        }

        private boolean insertAfterSeparator(ASTNode node) {
            return !ASTRewriteAnalyzer.this.isInsertBoundToPrevious(node);
        }

        public final int rewriteList(RewriteEvent[] listEvents, int startPos, String keyword) {
            this.fList = listEvents;
            this.fStartPos = startPos;
            int total = this.fList.length;
            if (total == 0) {
                return this.fStartPos;
            }
            int currPos = -1;
            int lastNonInsert = -1;
            int lastNonDelete = -1;
            int i = 0;
            while (i < total) {
                int currMark = this.fList[i].getChangeKind();
                if (currMark != 1) {
                    lastNonInsert = i;
                    if (currPos == -1) {
                        ASTNode elem = (ASTNode)this.fList[i].getOriginalValue();
                        currPos = ASTRewriteAnalyzer.this.getExtendedOffset(elem);
                    }
                }
                if (currMark != 2) {
                    lastNonDelete = i;
                }
                ++i;
            }
            if (currPos == -1) {
                if (keyword.length() > 0) {
                    GroupDescription description = ASTRewriteAnalyzer.this.getDescription(this.fList[0]);
                    ASTRewriteAnalyzer.this.doTextInsert(startPos, keyword, description);
                }
                currPos = startPos;
            }
            if (lastNonDelete == -1) {
                currPos = startPos;
            }
            int prevEnd = currPos;
            int separatorState = 1;
            int i2 = 0;
            while (i2 < total) {
                ASTNode node;
                RewriteEvent currEvent = this.fList[i2];
                int currMark = currEvent.getChangeKind();
                int nextIndex = i2 + 1;
                if (currMark == 1) {
                    GroupDescription description = ASTRewriteAnalyzer.this.getDescription(currEvent);
                    ASTNode node2 = (ASTNode)currEvent.getNewValue();
                    if (separatorState == 0) {
                        ASTRewriteAnalyzer.this.doTextInsert(currPos, this.getSeparatorString(i2 - 1), description);
                        separatorState = 1;
                    }
                    if (separatorState == 1 || this.insertAfterSeparator(node2)) {
                        ASTRewriteAnalyzer.this.doTextInsert(currPos, node2, this.getNodeIndent(i2), true, description);
                        separatorState = 1;
                        if (i2 != lastNonDelete) {
                            if (this.fList[nextIndex].getChangeKind() != 1) {
                                ASTRewriteAnalyzer.this.doTextInsert(currPos, this.getSeparatorString(i2), description);
                            } else {
                                separatorState = 0;
                            }
                        }
                    } else {
                        ASTRewriteAnalyzer.this.doTextInsert(prevEnd, this.getSeparatorString(i2 - 1), description);
                        ASTRewriteAnalyzer.this.doTextInsert(prevEnd, node2, this.getNodeIndent(i2), true, description);
                    }
                } else if (currMark == 2) {
                    node = (ASTNode)currEvent.getOriginalValue();
                    int currEnd = this.getEndOfNode(node);
                    if (i2 > lastNonDelete && separatorState == 2) {
                        ASTRewriteAnalyzer.this.doTextRemoveAndVisit(prevEnd, currEnd - prevEnd, node, ASTRewriteAnalyzer.this.getDescription(currEvent));
                        currPos = currEnd;
                        prevEnd = currEnd;
                    } else {
                        int end = this.getStartOfNextNode(nextIndex, currEnd);
                        ASTRewriteAnalyzer.this.doTextRemoveAndVisit(currPos, end - currPos, node, ASTRewriteAnalyzer.this.getDescription(currEvent));
                        currPos = end;
                        prevEnd = currEnd;
                        separatorState = 1;
                    }
                } else {
                    if (currMark == 4) {
                        node = (ASTNode)currEvent.getOriginalValue();
                        int currEnd = this.getEndOfNode(node);
                        GroupDescription description = ASTRewriteAnalyzer.this.getDescription(currEvent);
                        ASTNode changed = (ASTNode)currEvent.getNewValue();
                        ASTRewriteAnalyzer.this.doTextRemoveAndVisit(currPos, currEnd - currPos, node, ASTRewriteAnalyzer.this.getDescription(currEvent));
                        ASTRewriteAnalyzer.this.doTextInsert(currPos, changed, this.getNodeIndent(i2), true, description);
                        prevEnd = currEnd;
                    } else {
                        node = (ASTNode)currEvent.getOriginalValue();
                        ASTRewriteAnalyzer.this.doVisit(node);
                    }
                    if (i2 == lastNonInsert) {
                        separatorState = 0;
                        if (currMark == 0) {
                            node = (ASTNode)currEvent.getOriginalValue();
                            prevEnd = this.getEndOfNode(node);
                        }
                        currPos = prevEnd;
                    } else if (this.fList[nextIndex].getChangeKind() != 0) {
                        if (currMark == 0) {
                            node = (ASTNode)currEvent.getOriginalValue();
                            prevEnd = this.getEndOfNode(node);
                        }
                        currPos = this.getStartOfNextNode(nextIndex, prevEnd);
                        separatorState = 2;
                    }
                }
                ++i2;
            }
            return currPos;
        }
    }

    private class ParagraphListRewriter
    extends ListRewriter {
        public final int DEFAULT_SPACING = 1;
        private int fInitialIndent;
        private int fSeparatorLines;

        public ParagraphListRewriter(int initialIndent, int separator) {
            this.fInitialIndent = initialIndent;
            this.fSeparatorLines = separator;
        }

        protected int getInitialIndent() {
            return this.fInitialIndent;
        }

        protected String getSeparatorString(int nodeIndex) {
            int newLines = this.fSeparatorLines == -1 ? this.getNewLines(nodeIndex) : this.fSeparatorLines;
            String lineDelim = ASTRewriteAnalyzer.this.getLineDelimiter();
            StringBuffer buf = new StringBuffer(lineDelim);
            int i = 0;
            while (i < newLines) {
                buf.append(lineDelim);
                ++i;
            }
            buf.append(CodeFormatterUtil.createIndentString(this.getNodeIndent(nodeIndex + 1)));
            return buf.toString();
        }

        private ASTNode getNode(int nodeIndex) {
            ASTNode elem = (ASTNode)this.fList[nodeIndex].getOriginalValue();
            if (elem == null) {
                elem = (ASTNode)this.fList[nodeIndex].getNewValue();
            }
            return elem;
        }

        private int getNewLines(int nodeIndex) {
            ASTNode curr = this.getNode(nodeIndex);
            ASTNode next = this.getNode(nodeIndex + 1);
            int currKind = curr.getNodeType();
            int nextKind = next.getNodeType();
            ASTNode last = null;
            ASTNode secondLast = null;
            int i = 0;
            while (i < this.fList.length) {
                ASTNode elem = (ASTNode)this.fList[i].getOriginalValue();
                if (elem != null) {
                    if (last != null) {
                        if (elem.getNodeType() == nextKind && last.getNodeType() == currKind) {
                            return this.countEmptyLines(last);
                        }
                        secondLast = last;
                    }
                    last = elem;
                }
                ++i;
            }
            if (currKind == 23 && nextKind == 23) {
                return 0;
            }
            if (secondLast != null) {
                return this.countEmptyLines(secondLast);
            }
            return 1;
        }

        private int countEmptyLines(ASTNode last) {
            IDocument doc = ASTRewriteAnalyzer.this.fDocument;
            try {
                int lastLine = doc.getLineOfOffset(last.getStartPosition() + last.getLength());
                int scanLine = lastLine + 1;
                int numLines = doc.getNumberOfLines();
                while (scanLine < numLines && this.containsOnlyWhitespaces(doc, scanLine)) {
                    ++scanLine;
                }
                return scanLine - lastLine - 1;
            }
            catch (BadLocationException e) {
                JavaPlugin.log(e);
                return 0;
            }
        }

        private boolean containsOnlyWhitespaces(IDocument doc, int line) throws BadLocationException {
            int offset = doc.getLineOffset(line);
            int end = offset + doc.getLineLength(line);
            while (offset < end && Character.isWhitespace(doc.getChar(offset))) {
                ++offset;
            }
            return offset == end;
        }
    }

    private class SwitchListRewriter
    extends ParagraphListRewriter {
        public SwitchListRewriter(int initialIndent) {
            super(initialIndent, 0);
        }

        protected int getNodeIndent(int nodeIndex) {
            int indent = this.getInitialIndent();
            ASTNode node = (ASTNode)this.fList[nodeIndex].getOriginalValue();
            if (node == null) {
                node = (ASTNode)this.fList[nodeIndex].getNewValue();
            }
            if (node.getNodeType() != 49) {
                ++indent;
            }
            return indent;
        }
    }
}

