/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.dom.ASTNodeConstants;
import org.eclipse.jdt.internal.corext.dom.ASTRewriteClear;
import org.eclipse.jdt.internal.corext.dom.ListRewriteEvent;
import org.eclipse.jdt.internal.corext.dom.NewASTRewrite;
import org.eclipse.jdt.internal.corext.dom.NodeRewriteEvent;
import org.eclipse.jdt.internal.corext.dom.RewriteEvent;
import org.eclipse.jdt.internal.corext.dom.RewriteEventStore;
import org.eclipse.jdt.internal.corext.textmanipulation.GroupDescription;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.text.edits.TextEdit;

public final class ASTRewrite
extends NewASTRewrite {
    private HashMap fChangedProperties = new HashMap();
    private boolean fHasASTModifications = false;

    public ASTRewrite(ASTNode node) {
        super(node);
        this.fEventStore.setNodePropertyMapper(new RewriteEventStore.INodePropertyMapper(){

            public Object getOriginalValue(ASTNode parent, int childProperty) {
                Object originalValue = ASTNodeConstants.getNodeChild(parent, childProperty);
                if (originalValue instanceof List) {
                    List originalList = (List)originalValue;
                    ArrayList<ASTNode> fixedList = new ArrayList<ASTNode>(originalList.size());
                    int i = 0;
                    while (i < originalList.size()) {
                        ASTNode curr = (ASTNode)originalList.get(i);
                        if (!ASTRewrite.this.isInserted(curr)) {
                            fixedList.add(curr);
                        }
                        ++i;
                    }
                    return fixedList;
                }
                if (originalValue instanceof ASTNode && ASTRewrite.this.isInserted((ASTNode)originalValue)) {
                    return null;
                }
                return originalValue;
            }
        });
    }

    public final void rewriteNode(TextBuffer textBuffer, TextEdit rootEdit) {
        this.convertOldToNewEvents();
        TextEdit res = super.rewriteAST(textBuffer.getDocument());
        rootEdit.addChildren(res.removeChildren());
    }

    private void convertOldToNewEvents() {
        HashSet processedListEvents = new HashSet();
        Iterator iter = this.fChangedProperties.keySet().iterator();
        while (iter.hasNext()) {
            ASTNode node = (ASTNode)iter.next();
            ASTInsert object = this.getChangeProperty(node);
            if (object == null || node.getParent().getStartPosition() == -1) continue;
            this.processChange(node, null, node, object.description, processedListEvents);
            if (!object.isBoundToPrevious) continue;
            this.fEventStore.setInsertBoundToPrevious(node);
        }
    }

    private void processChange(ASTNode nodeInAST, ASTNode originalNode, ASTNode newNode, GroupDescription desc, Set processedListEvents) {
        ASTNode parent = nodeInAST.getParent();
        int childProperty = ASTNodeConstants.getPropertyOfNode(nodeInAST);
        if (ASTNodeConstants.isListProperty(childProperty)) {
            ListRewriteEvent event = this.fEventStore.getListEvent(parent, childProperty, true);
            if (processedListEvents.add(event)) {
                this.convertListChange(event, (List)ASTNodeConstants.getNodeChild(parent, childProperty));
            }
        } else {
            NodeRewriteEvent event = this.fEventStore.getNodeEvent(parent, childProperty, true);
            event.setNewValue(newNode);
            this.fEventStore.setEventDescription(event, desc);
        }
    }

    private void convertListChange(ListRewriteEvent listEvent, List modifiedList) {
        int insertIndex = 0;
        int i = 0;
        while (i < modifiedList.size()) {
            ASTNode curr = (ASTNode)modifiedList.get(i);
            ASTInsert object = this.getChangeProperty(curr);
            if (object != null) {
                RewriteEvent change = listEvent.insertAtOriginalIndex(curr, insertIndex);
                this.fEventStore.setEventDescription(change, object.description);
                if (object.isBoundToPrevious) {
                    this.fEventStore.setInsertBoundToPrevious(curr);
                }
            } else {
                ++insertIndex;
            }
            ++i;
        }
    }

    public final void removeModifications() {
        if (this.fHasASTModifications) {
            this.getRootNode().accept((ASTVisitor)new ASTRewriteClear(this));
            this.fHasASTModifications = false;
        }
        this.fChangedProperties.clear();
        this.clearRewrite();
    }

    public boolean hasASTModifications() {
        return this.fHasASTModifications;
    }

    public final void markAsInserted(ASTNode node, GroupDescription description) {
        Assert.isTrue(!this.isCollapsed(node), "Tries to insert a collapsed node");
        ASTInsert insert = new ASTInsert();
        insert.isBoundToPrevious = this.isInsertBoundToPreviousByDefault(node);
        insert.description = description;
        this.setChangeProperty(node, insert);
        this.fHasASTModifications = true;
        node.setSourceRange(-1, 0);
    }

    public final void markAsInserted(ASTNode node) {
        this.markAsInserted(node, null);
    }

    public final Block getCollapseTargetPlaceholder(Statement[] children) {
        Block res = this.createCollapsePlaceholder();
        List statements = res.statements();
        int i = 0;
        while (i < children.length) {
            statements.add(children[i]);
            ++i;
        }
        return res;
    }

    public final ASTNode createCopy(ASTNode node) {
        return this.createCopyPlaceholder(node);
    }

    public final ASTNode createMove(ASTNode node) {
        int changeKind = this.fEventStore.getChangeKind(node);
        if (changeKind != 2 && changeKind != 4) {
            this.markAsRemoved(node);
        }
        return this.createMovePlaceholder(node);
    }

    public final ASTNode createPlaceholder(String code, int nodeType) {
        return this.createStringPlaceholder(code, nodeType);
    }

    public final ASTNode collapseNodes(List list, int index, int length) {
        Assert.isTrue(index >= 0 && length > 0 && list.size() >= index + length, "Index or length out of bound");
        ASTNode firstNode = (ASTNode)list.get(index);
        ASTNode lastNode = (ASTNode)list.get(index + length - 1);
        this.validateIsInsideAST(firstNode);
        this.validateIsInsideAST(lastNode);
        Assert.isTrue(lastNode instanceof Statement, "Can only collapse statements");
        int startPos = firstNode.getStartPosition();
        int endPos = lastNode.getStartPosition() + lastNode.getLength();
        Block compoundNode = this.createCollapsePlaceholder();
        List children = compoundNode.statements();
        compoundNode.setSourceRange(startPos, endPos - startPos);
        int childProperty = ASTNodeConstants.getPropertyOfNode(firstNode);
        ListRewriteEvent existingEvent = this.fEventStore.getListEvent(firstNode.getParent(), childProperty, false);
        if (existingEvent != null) {
            RewriteEvent[] origChildren = existingEvent.getChildren();
            Assert.isTrue(origChildren.length == list.size());
            RewriteEvent[] newChildren = new RewriteEvent[origChildren.length - length + 1];
            System.arraycopy(origChildren, 0, newChildren, 0, index);
            newChildren[index] = new NodeRewriteEvent(compoundNode, compoundNode);
            System.arraycopy(origChildren, index + length, newChildren, index + 1, origChildren.length - index - length);
            this.fEventStore.addEvent(firstNode.getParent(), childProperty, new ListRewriteEvent(newChildren));
            RewriteEvent[] newCollapsedChildren = new RewriteEvent[length];
            System.arraycopy(origChildren, index, newCollapsedChildren, 0, length);
            this.fEventStore.addEvent((ASTNode)compoundNode, 45, new ListRewriteEvent(newCollapsedChildren));
        }
        int i = 0;
        while (i < length) {
            Object curr = list.remove(index);
            children.add(curr);
            ++i;
        }
        list.add(index, compoundNode);
        this.fHasASTModifications = true;
        return compoundNode;
    }

    public final boolean isInserted(ASTNode node) {
        return this.getChangeProperty(node) != null;
    }

    public boolean isRemoved(ASTNode node) {
        return this.fEventStore.getChangeKind(node) == 2;
    }

    public boolean isReplaced(ASTNode node) {
        return this.fEventStore.getChangeKind(node) == 4;
    }

    public final ASTNode getReplacingNode(ASTNode node) {
        RewriteEvent event = this.fEventStore.findEventByOriginal(node);
        if (event != null && event.getChangeKind() == 4) {
            return (ASTNode)event.getNewValue();
        }
        return null;
    }

    private final void setChangeProperty(ASTNode node, ASTInsert change) {
        this.fChangedProperties.put(node, change);
    }

    private final ASTInsert getChangeProperty(ASTNode node) {
        return (ASTInsert)this.fChangedProperties.get(node);
    }

    private static class ASTInsert {
        public GroupDescription description;
        public boolean isBoundToPrevious;

        ASTInsert() {
        }
    }
}

