/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.ASTFlattener;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.text.edits.TextEdit;

public class ASTNodes {
    public static final int NODE_ONLY = 0;
    public static final int INCLUDE_FIRST_PARENT = 1;
    public static final int INCLUDE_ALL_PARENTS = 2;
    public static final int WARINING = 1;
    public static final int ERROR = 2;
    public static final int PROBLEMS = 3;
    private static final Message[] EMPTY_MESSAGES = new Message[0];
    private static final IProblem[] EMPTY_PROBLEMS = new IProblem[0];
    private static final int CLEAR_VISIBILITY = -8;
    public static final String NODE_RANGE_PROPERTY = "noderange";

    private ASTNodes() {
    }

    public static String asString(ASTNode node) {
        ASTFlattener flattener = new ASTFlattener();
        node.accept((ASTVisitor)flattener);
        return flattener.getResult();
    }

    public static String asFormattedString(ASTNode node, int indent, String lineDelim) {
        String unformatted = ASTNodes.asString(node);
        TextEdit edit = CodeFormatterUtil.format2(node, unformatted, indent, lineDelim, null);
        if (edit != null) {
            return CodeFormatterUtil.evaluateFormatterEdit(unformatted, edit, null);
        }
        return unformatted;
    }

    public static List getContainingList(ASTNode node) {
        if (node.getParent() == null) {
            return null;
        }
        ListFinder finder = new ListFinder(node);
        node.getParent().accept((ASTVisitor)finder);
        return finder.result;
    }

    public static List getChildren(ASTNode node) {
        ChildrenCollector visitor = new ChildrenCollector();
        node.accept((ASTVisitor)visitor);
        return visitor.result;
    }

    public static Type getElementType(Type type) {
        if (!type.isArrayType()) {
            return type;
        }
        return ((ArrayType)type).getElementType();
    }

    public static ASTNode findDeclaration(IBinding binding, ASTNode root) {
        if ((root = root.getRoot()) instanceof CompilationUnit) {
            return ((CompilationUnit)root).findDeclaringNode(binding);
        }
        return null;
    }

    public static VariableDeclaration findVariableDeclaration(IVariableBinding binding, ASTNode root) {
        if (binding.isField()) {
            return null;
        }
        ASTNode result = ASTNodes.findDeclaration((IBinding)binding, root);
        if (result instanceof VariableDeclaration) {
            return (VariableDeclaration)result;
        }
        return null;
    }

    public static Type getType(AST ast, VariableDeclaration declaration) {
        Type type = null;
        if (declaration instanceof SingleVariableDeclaration) {
            type = ((SingleVariableDeclaration)declaration).getType();
        } else if (declaration instanceof VariableDeclarationFragment) {
            ASTNode parent = ((VariableDeclarationFragment)declaration).getParent();
            if (parent instanceof VariableDeclarationExpression) {
                type = ((VariableDeclarationExpression)parent).getType();
            } else if (parent instanceof VariableDeclarationStatement) {
                type = ((VariableDeclarationStatement)parent).getType();
            }
        }
        if (type == null) {
            return null;
        }
        type = (Type)ASTNode.copySubtree((AST)ast, (ASTNode)type);
        int extraDim = 0;
        if (declaration.getNodeType() == 59) {
            extraDim = ((VariableDeclarationFragment)declaration).getExtraDimensions();
        } else if (declaration.getNodeType() == 44) {
            extraDim = ((SingleVariableDeclaration)declaration).getExtraDimensions();
        }
        int i = 0;
        while (i < extraDim) {
            type = ast.newArrayType(type);
            ++i;
        }
        return type;
    }

    public static int getModifiers(VariableDeclaration declaration) {
        Assert.isNotNull(declaration);
        if (declaration instanceof SingleVariableDeclaration) {
            return ((SingleVariableDeclaration)declaration).getModifiers();
        }
        if (declaration instanceof VariableDeclarationFragment) {
            ASTNode parent = declaration.getParent();
            if (parent instanceof VariableDeclarationExpression) {
                return ((VariableDeclarationExpression)parent).getModifiers();
            }
            if (parent instanceof VariableDeclarationStatement) {
                return ((VariableDeclarationStatement)parent).getModifiers();
            }
        }
        return 0;
    }

    public static boolean isSingleDeclaration(VariableDeclaration declaration) {
        Assert.isNotNull(declaration);
        if (declaration instanceof SingleVariableDeclaration) {
            return true;
        }
        if (declaration instanceof VariableDeclarationFragment) {
            ASTNode parent = declaration.getParent();
            if (parent instanceof VariableDeclarationExpression) {
                return ((VariableDeclarationExpression)parent).fragments().size() == 1;
            }
            if (parent instanceof VariableDeclarationStatement) {
                return ((VariableDeclarationStatement)parent).fragments().size() == 1;
            }
        }
        return false;
    }

    public static boolean isLiteral(Expression expression) {
        int type = expression.getNodeType();
        return type == 9 || type == 13 || type == 33 || type == 34 || type == 45 || type == 57;
    }

    public static boolean isLabel(SimpleName name) {
        int parentType = name.getParent().getNodeType();
        return parentType == 30 || parentType == 10 || parentType != 18;
    }

    public static boolean isStatic(BodyDeclaration declaration) {
        switch (declaration.getNodeType()) {
            case 23: {
                return Modifier.isStatic((int)((FieldDeclaration)declaration).getModifiers());
            }
            case 31: {
                return Modifier.isStatic((int)((MethodDeclaration)declaration).getModifiers());
            }
            case 55: {
                return Modifier.isStatic((int)((TypeDeclaration)declaration).getModifiers());
            }
            case 28: {
                return Modifier.isStatic((int)((Initializer)declaration).getModifiers());
            }
        }
        return false;
    }

    public static String getTypeName(Type type) {
        final StringBuffer buffer = new StringBuffer();
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(PrimitiveType node) {
                buffer.append(node.getPrimitiveTypeCode().toString());
                return false;
            }

            public boolean visit(SimpleName node) {
                buffer.append(node.getIdentifier());
                return false;
            }

            public boolean visit(QualifiedName node) {
                buffer.append(node.getName().getIdentifier());
                return false;
            }

            public void endVisit(ArrayType node) {
                buffer.append("[]");
            }
        };
        type.accept(visitor);
        return buffer.toString();
    }

    public static InfixExpression.Operator convertToInfixOperator(Assignment.Operator operator) {
        if (operator.equals(Assignment.Operator.PLUS_ASSIGN)) {
            return InfixExpression.Operator.PLUS;
        }
        if (operator.equals(Assignment.Operator.MINUS_ASSIGN)) {
            return InfixExpression.Operator.MINUS;
        }
        if (operator.equals(Assignment.Operator.TIMES_ASSIGN)) {
            return InfixExpression.Operator.TIMES;
        }
        if (operator.equals(Assignment.Operator.DIVIDE_ASSIGN)) {
            return InfixExpression.Operator.DIVIDE;
        }
        if (operator.equals(Assignment.Operator.BIT_AND_ASSIGN)) {
            return InfixExpression.Operator.AND;
        }
        if (operator.equals(Assignment.Operator.BIT_OR_ASSIGN)) {
            return InfixExpression.Operator.OR;
        }
        if (operator.equals(Assignment.Operator.BIT_XOR_ASSIGN)) {
            return InfixExpression.Operator.XOR;
        }
        if (operator.equals(Assignment.Operator.REMAINDER_ASSIGN)) {
            return InfixExpression.Operator.REMAINDER;
        }
        if (operator.equals(Assignment.Operator.LEFT_SHIFT_ASSIGN)) {
            return InfixExpression.Operator.LEFT_SHIFT;
        }
        if (operator.equals(Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN)) {
            return InfixExpression.Operator.RIGHT_SHIFT_SIGNED;
        }
        if (operator.equals(Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN)) {
            return InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED;
        }
        Assert.isTrue(false, "Cannot convert assignment operator");
        return null;
    }

    public static boolean needsParentheses(Expression expression) {
        int type = expression.getNodeType();
        return type == 27 || type == 16 || type == 38 || type == 37 || type == 11;
    }

    public static boolean substituteMustBeParenthesized(Expression substitute, Expression location) {
        MethodInvocation mi;
        VariableDeclarationFragment vdf;
        if (!ASTNodes.needsParentheses(substitute)) {
            return false;
        }
        ASTNode parent = location.getParent();
        return !(parent instanceof VariableDeclarationFragment ? (vdf = (VariableDeclarationFragment)parent).getInitializer().equals((Object)location) : (parent instanceof MethodInvocation ? (mi = (MethodInvocation)parent).arguments().contains(location) : parent instanceof ReturnStatement));
    }

    public static ASTNode getParent(ASTNode node, Class parentClass) {
        while ((node = node.getParent()) != null && !parentClass.isInstance(node)) {
        }
        return node;
    }

    public static ASTNode getParent(ASTNode node, int nodeType) {
        while ((node = node.getParent()) != null && node.getNodeType() != nodeType) {
        }
        return node;
    }

    public static boolean isParent(ASTNode node, ASTNode parent) {
        Assert.isNotNull(parent);
        do {
            if ((node = node.getParent()) != parent) continue;
            return true;
        } while (node != null);
        return false;
    }

    public static int getExclusiveEnd(ASTNode node) {
        return node.getStartPosition() + node.getLength();
    }

    public static int getInclusiveEnd(ASTNode node) {
        return node.getStartPosition() + node.getLength() - 1;
    }

    public static IMethodBinding getMethodBinding(Name node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof IMethodBinding) {
            return (IMethodBinding)binding;
        }
        return null;
    }

    public static IVariableBinding getVariableBinding(Name node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof IVariableBinding) {
            return (IVariableBinding)binding;
        }
        return null;
    }

    public static IVariableBinding getLocalVariableBinding(Name node) {
        IVariableBinding result = ASTNodes.getVariableBinding(node);
        if (result == null || result.isField()) {
            return null;
        }
        return result;
    }

    public static IVariableBinding getFieldBinding(Name node) {
        IVariableBinding result = ASTNodes.getVariableBinding(node);
        if (result == null || !result.isField()) {
            return null;
        }
        return result;
    }

    public static ITypeBinding getTypeBinding(Name node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof ITypeBinding) {
            return (ITypeBinding)binding;
        }
        return null;
    }

    public static ITypeBinding getReceiverTypeBinding(MethodInvocation invocation) {
        ITypeBinding result = null;
        Expression exp = invocation.getExpression();
        if (exp != null) {
            return exp.resolveTypeBinding();
        }
        TypeDeclaration type = (TypeDeclaration)ASTNodes.getParent((ASTNode)invocation, 55);
        if (type != null) {
            return type.resolveBinding();
        }
        return result;
    }

    public static ITypeBinding getDeclaringType(BodyDeclaration declaration) {
        BodyDeclaration node = declaration;
        while (node != null) {
            switch (node.getNodeType()) {
                case 55: {
                    return ((TypeDeclaration)node).resolveBinding();
                }
                case 1: {
                    return ((AnonymousClassDeclaration)node).resolveBinding();
                }
            }
            node = node.getParent();
        }
        return null;
    }

    public static void expandRange(ASTNode[] nodes, TextBuffer buffer, int start, int length) throws CoreException {
        int scannerStart;
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(buffer.getContent(start, length).toCharArray());
        TokenScanner tokenizer = new TokenScanner(scanner);
        ASTNode node = nodes[0];
        int pos = tokenizer.getNextStartOffset(0, false);
        int newStart = start + pos;
        if (newStart < node.getStartPosition()) {
            node.setSourceRange(newStart, node.getLength() + node.getStartPosition() - newStart);
        }
        node = nodes[nodes.length - 1];
        pos = scannerStart = node.getStartPosition() + node.getLength() - start;
        try {
            while (true) {
                pos = tokenizer.getNextEndOffset(pos, false);
            }
        }
        catch (CoreException coreException) {
            node.setSourceRange(node.getStartPosition(), node.getLength() + pos - scannerStart);
            return;
        }
    }

    public static IProblem[] getProblems(ASTNode node, int scope, int severity) {
        ASTNode root = node.getRoot();
        if (!(root instanceof CompilationUnit)) {
            return EMPTY_PROBLEMS;
        }
        IProblem[] problems = ((CompilationUnit)root).getProblems();
        if (root == node) {
            return problems;
        }
        int iterations = ASTNodes.computeIterations(scope);
        ArrayList<IProblem> result = new ArrayList<IProblem>(5);
        int i = 0;
        while (i < problems.length) {
            IProblem problem = problems[i];
            boolean consider = false;
            if ((severity & 3) == 3) {
                consider = true;
            } else if ((severity & 1) != 0) {
                consider = problem.isWarning();
            } else if ((severity & 2) != 0) {
                consider = problem.isError();
            }
            if (consider) {
                ASTNode temp = node;
                int count = iterations;
                do {
                    int problemOffset;
                    int nodeOffset;
                    if ((nodeOffset = temp.getStartPosition()) <= (problemOffset = problem.getSourceStart()) && problemOffset < nodeOffset + temp.getLength()) {
                        result.add(problem);
                        count = 0;
                        continue;
                    }
                    --count;
                } while ((temp = temp.getParent()) != null && count > 0);
            }
            ++i;
        }
        return result.toArray(new IProblem[result.size()]);
    }

    public static Message[] getMessages(ASTNode node, int flags) {
        ASTNode root = node.getRoot();
        if (!(root instanceof CompilationUnit)) {
            return EMPTY_MESSAGES;
        }
        Message[] messages = ((CompilationUnit)root).getMessages();
        if (root == node) {
            return messages;
        }
        int iterations = ASTNodes.computeIterations(flags);
        ArrayList<Message> result = new ArrayList<Message>(5);
        int i = 0;
        while (i < messages.length) {
            Message message = messages[i];
            ASTNode temp = node;
            int count = iterations;
            do {
                int messageOffset;
                int nodeOffset;
                if ((nodeOffset = temp.getStartPosition()) <= (messageOffset = message.getStartPosition()) && messageOffset < nodeOffset + temp.getLength()) {
                    result.add(message);
                    count = 0;
                    continue;
                }
                --count;
            } while ((temp = temp.getParent()) != null && count > 0);
            ++i;
        }
        return result.toArray(new Message[result.size()]);
    }

    private static int computeIterations(int flags) {
        switch (flags) {
            case 0: {
                return 1;
            }
            case 2: {
                return Integer.MAX_VALUE;
            }
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    public static int getExtendedOffset(ASTNode node) {
        ISourceRange range = (ISourceRange)node.getProperty(NODE_RANGE_PROPERTY);
        if (range != null) {
            return range.getOffset();
        }
        return node.getStartPosition();
    }

    public static int getExtendedEnd(ASTNode node) {
        ISourceRange range = (ISourceRange)node.getProperty(NODE_RANGE_PROPERTY);
        if (range != null) {
            return range.getOffset() + range.getLength();
        }
        return node.getStartPosition() + node.getLength();
    }

    public static int getExtendedLength(ASTNode node) {
        ISourceRange range = (ISourceRange)node.getProperty(NODE_RANGE_PROPERTY);
        if (range != null) {
            return range.getLength();
        }
        return node.getLength();
    }

    public static void annotateExtraRanges(ASTNode node, TokenScanner scanner) {
        ASTNode astRoot = node.getRoot();
        if (astRoot.getProperty(NODE_RANGE_PROPERTY) != null) {
            return;
        }
        astRoot.setProperty(NODE_RANGE_PROPERTY, (Object)new SourceRange(node.getStartPosition(), node.getLength()));
        ASTNodes.doExtraRangesForChildren(astRoot, scanner);
    }

    private static void doExtraRangesForChildren(ASTNode node, TokenScanner scanner) {
        List children = ASTNodes.getChildren(node);
        int lastChild = children.size() - 1;
        int lastPos = node.getStartPosition() + node.getLength();
        int endOfLast = node.getStartPosition();
        int i = 0;
        while (i <= lastChild) {
            ASTNode curr = (ASTNode)children.get(i);
            if (curr.getStartPosition() != -1) {
                int beginOfNext = ASTNodes.getNextExistingOffset(children, i, lastPos);
                endOfLast = ASTNodes.annotateNode(curr, endOfLast, beginOfNext, scanner);
                ASTNodes.doExtraRangesForChildren(curr, scanner);
            }
            ++i;
        }
    }

    private static int getNextExistingOffset(List children, int idx, int def) {
        int i = idx + 1;
        while (i < children.size()) {
            ASTNode curr = (ASTNode)children.get(i);
            if (curr.getStartPosition() != -1) {
                return curr.getStartPosition();
            }
            ++i;
        }
        return def;
    }

    private static int annotateNode(ASTNode node, int prevEnd, int nextStart, TokenScanner scanner) {
        int tokenStart = node.getStartPosition();
        int tokenLength = node.getLength();
        try {
            int start = scanner.getTokenCommentStart(prevEnd, tokenStart);
            int length = scanner.getTokenCommentEnd(tokenStart + tokenLength, nextStart) - start;
            if (start != tokenStart || length != tokenLength) {
                node.setProperty(NODE_RANGE_PROPERTY, (Object)new SourceRange(start, length));
            }
            return start + length;
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            return tokenStart + tokenLength;
        }
    }

    public static int getInsertionIndex(BodyDeclaration member, List container) {
        return ASTNodes.getInsertionIndex(container, member.getNodeType(), ASTNodes.isStatic(member));
    }

    private static int getInsertionIndex(List container, int memberType, boolean isStatic) {
        if (memberType == 55 || memberType == 28) {
            return 0;
        }
        int defaultIndex = container.size();
        if (memberType == 23) {
            int first = -1;
            int last = -1;
            int i = 0;
            Iterator iter = container.iterator();
            while (iter.hasNext()) {
                int nodeType = ((BodyDeclaration)iter.next()).getNodeType();
                switch (nodeType) {
                    case 23: {
                        last = i;
                        break;
                    }
                    case 31: {
                        if (first != -1) break;
                        first = i;
                    }
                }
                ++i;
            }
            if (last != -1) {
                return ++last;
            }
            if (first != -1) {
                return first;
            }
            return defaultIndex;
        }
        if (memberType == 31) {
            int lastMethod = -1;
            int lastStaticMethod = -1;
            int firstMethod = -1;
            int i = 0;
            Iterator iter = container.iterator();
            while (iter.hasNext()) {
                ASTNode node = (ASTNode)iter.next();
                int nodeType = node.getNodeType();
                switch (nodeType) {
                    case 31: {
                        MethodDeclaration declaration = (MethodDeclaration)node;
                        if (firstMethod == -1) {
                            firstMethod = i;
                        }
                        if (isStatic && Modifier.isStatic((int)declaration.getModifiers())) {
                            lastStaticMethod = i;
                        }
                        lastMethod = i;
                    }
                }
                ++i;
            }
            if (isStatic) {
                if (lastStaticMethod != -1) {
                    return ++lastStaticMethod;
                }
                if (firstMethod != 1) {
                    return firstMethod;
                }
            } else if (lastMethod != -1) {
                return ++lastMethod;
            }
            return defaultIndex;
        }
        return defaultIndex;
    }

    public static SimpleName getLeftMostSimpleName(QualifiedName name) {
        final SimpleName[] result = new SimpleName[1];
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(QualifiedName qualifiedName) {
                Name left = qualifiedName.getQualifier();
                if (left instanceof SimpleName) {
                    result[0] = (SimpleName)left;
                } else {
                    left.accept((ASTVisitor)this);
                }
                return false;
            }
        };
        name.accept(visitor);
        return result[0];
    }

    public static int changeVisibility(int modifiers, int visibility) {
        return modifiers & 0xFFFFFFF8 | visibility;
    }

    private static class ChildrenCollector
    extends GenericVisitor {
        public List result = null;

        protected boolean visitNode(ASTNode node) {
            if (this.result == null) {
                this.result = new ArrayList();
                return true;
            }
            this.result.add(node);
            return false;
        }
    }

    private static class ListFinder
    extends ASTVisitor {
        public List result;
        private ASTNode fNode;

        public ListFinder(ASTNode node) {
            this.fNode = node;
        }

        public boolean visit(AnonymousClassDeclaration node) {
            this.test(node.bodyDeclarations());
            return false;
        }

        public boolean visit(ArrayCreation node) {
            this.test(node.dimensions());
            return false;
        }

        public boolean visit(ArrayInitializer node) {
            this.test(node.expressions());
            return false;
        }

        public boolean visit(Block node) {
            this.test(node.statements());
            return false;
        }

        public boolean visit(ClassInstanceCreation node) {
            this.test(node.arguments());
            return false;
        }

        public boolean visit(CompilationUnit node) {
            this.test(node.imports());
            this.test(node.types());
            return false;
        }

        public boolean visit(ConstructorInvocation node) {
            this.test(node.arguments());
            return false;
        }

        public boolean visit(FieldDeclaration node) {
            this.test(node.fragments());
            return false;
        }

        public boolean visit(ForStatement node) {
            this.test(node.initializers());
            this.test(node.updaters());
            return false;
        }

        public boolean visit(MethodDeclaration node) {
            this.test(node.parameters());
            this.test(node.thrownExceptions());
            return false;
        }

        public boolean visit(MethodInvocation node) {
            this.test(node.arguments());
            return false;
        }

        public boolean visit(SuperConstructorInvocation node) {
            this.test(node.arguments());
            return false;
        }

        public boolean visit(SuperMethodInvocation node) {
            this.test(node.arguments());
            return false;
        }

        public boolean visit(SwitchStatement node) {
            this.test(node.statements());
            return false;
        }

        public boolean visit(TryStatement node) {
            this.test(node.catchClauses());
            return false;
        }

        public boolean visit(TypeDeclaration node) {
            this.test(node.bodyDeclarations());
            this.test(node.superInterfaces());
            return false;
        }

        public boolean visit(VariableDeclarationExpression node) {
            this.test(node.fragments());
            return false;
        }

        public boolean visit(VariableDeclarationStatement node) {
            this.test(node.fragments());
            return false;
        }

        private void test(List nodes) {
            if (nodes.contains(this.fNode)) {
                this.result = nodes;
            }
        }
    }
}

