/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;

public class OrganizeImportsOperation
implements IWorkspaceRunnable {
    private Selection fRange;
    private ImportsStructure fImportsStructure;
    private boolean fDoSave;
    private boolean fIgnoreLowerCaseNames;
    private IChooseImportQuery fChooseImportQuery;
    private int fNumberOfImportsAdded;
    private IProblem fParsingError;
    private CompilationUnit fASTRoot;

    public OrganizeImportsOperation(ImportsStructure impStructure, Selection range, boolean ignoreLowerCaseNames, boolean save, IChooseImportQuery chooseImportQuery) {
        this.fImportsStructure = impStructure;
        this.fRange = range;
        this.fDoSave = save;
        this.fIgnoreLowerCaseNames = ignoreLowerCaseNames;
        this.fChooseImportQuery = chooseImportQuery;
        this.fNumberOfImportsAdded = 0;
        this.fParsingError = null;
        this.fASTRoot = AST.parseCompilationUnit((ICompilationUnit)impStructure.getCompilationUnit(), (boolean)true);
    }

    public OrganizeImportsOperation(ICompilationUnit cu, String[] importOrder, int importThreshold, boolean ignoreLowerCaseNames, boolean save, boolean doResolve, IChooseImportQuery chooseImportQuery) throws CoreException {
        this(new ImportsStructure(cu, importOrder, importThreshold, false), null, ignoreLowerCaseNames, save, chooseImportQuery);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        block11: {
            block9: {
                try {
                    int nOldImports;
                    block10: {
                        TypeInfo[] chosen;
                        if (monitor == null) {
                            monitor = new NullProgressMonitor();
                        }
                        ICompilationUnit cu = this.fImportsStructure.getCompilationUnit();
                        this.fNumberOfImportsAdded = 0;
                        monitor.beginTask(CodeGenerationMessages.getFormattedString("OrganizeImportsOperation.description", cu.getElementName()), 2);
                        ArrayList oldSingleImports = new ArrayList();
                        ArrayList<String> oldDemandImports = new ArrayList<String>();
                        Iterator references = this.findTypeReferences(oldSingleImports, oldDemandImports);
                        if (references == null) {
                            Object var15_6 = null;
                            break block9;
                        }
                        nOldImports = oldDemandImports.size() + oldSingleImports.size();
                        oldDemandImports.add("");
                        oldDemandImports.add("java.lang");
                        oldDemandImports.add(cu.getParent().getElementName());
                        monitor.worked(1);
                        TypeReferenceProcessor processor = new TypeReferenceProcessor(oldSingleImports, oldDemandImports, this.fASTRoot, this.fImportsStructure, this.fIgnoreLowerCaseNames);
                        ArrayList<TypeInfo[]> openChoices = new ArrayList<TypeInfo[]>();
                        ArrayList<SourceRange> sourceRanges = new ArrayList<SourceRange>();
                        while (true) {
                            if (!references.hasNext()) {
                                processor = null;
                                if (openChoices.size() > 0 && this.fChooseImportQuery != null) {
                                    ISourceRange[] ranges;
                                    TypeInfo[][] choices = (TypeInfo[][])openChoices.toArray((T[])new TypeInfo[openChoices.size()][]);
                                    chosen = this.fChooseImportQuery.chooseImports(choices, ranges = sourceRanges.toArray(new ISourceRange[sourceRanges.size()]));
                                    if (chosen != null) break;
                                    throw new OperationCanceledException();
                                }
                                break block10;
                            }
                            SimpleName typeRef = (SimpleName)references.next();
                            TypeInfo[] openChoice = processor.process(typeRef);
                            if (openChoice == null) continue;
                            openChoices.add(openChoice);
                            sourceRanges.add(new SourceRange(typeRef.getStartPosition(), typeRef.getLength()));
                        }
                        int i = 0;
                        while (i < chosen.length) {
                            TypeInfo typeInfo = chosen[i];
                            this.fImportsStructure.addImport(typeInfo.getFullyQualifiedName());
                            ++i;
                        }
                    }
                    this.fImportsStructure.create(this.fDoSave, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    this.fNumberOfImportsAdded = this.fImportsStructure.getNumberOfImportsCreated() - nOldImports;
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var15_7 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return;
        }
        Object var15_8 = null;
        monitor.done();
    }

    private boolean isAffected(IProblem problem) {
        return this.fRange == null || this.fRange.getOffset() <= problem.getSourceEnd() && this.fRange.getExclusiveEnd() > problem.getSourceStart();
    }

    private Iterator findTypeReferences(ArrayList oldSingleImports, ArrayList oldDemandImports) throws JavaModelException {
        IProblem[] problems = this.fASTRoot.getProblems();
        int i = 0;
        while (i < problems.length) {
            IProblem curr = problems[i];
            if (curr.isError() && (curr.getID() & 0x40000000) != 0 && this.isAffected(curr)) {
                this.fParsingError = problems[i];
                return null;
            }
            ++i;
        }
        ArrayList result = new ArrayList();
        TypeRefASTVisitor visitor = new TypeRefASTVisitor(this.fRange, result, oldSingleImports, oldDemandImports);
        this.fASTRoot.accept((ASTVisitor)visitor);
        return result.iterator();
    }

    public IProblem getParseError() {
        return this.fParsingError;
    }

    public int getNumberOfImportsAdded() {
        return this.fNumberOfImportsAdded;
    }

    public static interface IChooseImportQuery {
        public TypeInfo[] chooseImports(TypeInfo[][] var1, ISourceRange[] var2);
    }

    private static class TypeRefASTVisitor
    extends GenericVisitor {
        private Selection fRange;
        private Collection fResult;
        private ArrayList fOldSingleImports;
        private ArrayList fOldDemandImports;

        public TypeRefASTVisitor(Selection rangeLimit, Collection result, ArrayList oldSingleImports, ArrayList oldDemandImports) {
            this.fResult = result;
            this.fOldSingleImports = oldSingleImports;
            this.fOldDemandImports = oldDemandImports;
            this.fRange = rangeLimit;
        }

        private boolean isAffected(ASTNode node) {
            return this.fRange == null || !this.fRange.liesOutside(node);
        }

        private void addReference(SimpleName name) {
            if (this.isAffected((ASTNode)name)) {
                this.fResult.add(name);
            }
        }

        private void typeRefFound(Name node) {
            if (node != null) {
                while (node.isQualifiedName()) {
                    node = ((QualifiedName)node).getQualifier();
                }
                this.addReference((SimpleName)node);
            }
        }

        private void possibleTypeRefFound(Name node) {
            while (node.isQualifiedName()) {
                node = ((QualifiedName)node).getQualifier();
            }
            IBinding binding = node.resolveBinding();
            if (binding == null || binding.getKind() == 2) {
                this.addReference((SimpleName)node);
            }
        }

        private void visitChildren(List elements) {
            int nElements = elements.size();
            int i = 0;
            while (i < nElements) {
                ((ASTNode)elements.get(i)).accept((ASTVisitor)this);
                ++i;
            }
        }

        protected boolean visitNode(ASTNode node) {
            return this.isAffected(node);
        }

        public boolean visit(ArrayType node) {
            node.getElementType().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(SimpleType node) {
            this.typeRefFound(node.getName());
            return false;
        }

        public boolean visit(QualifiedName node) {
            this.possibleTypeRefFound((Name)node);
            return false;
        }

        public boolean visit(ImportDeclaration node) {
            String id = ASTResolving.getFullName(node.getName());
            if (node.isOnDemand()) {
                this.fOldDemandImports.add(id);
            } else {
                this.fOldSingleImports.add(id);
            }
            return false;
        }

        public boolean visit(PackageDeclaration node) {
            return false;
        }

        public boolean visit(ThisExpression node) {
            this.typeRefFound(node.getQualifier());
            return false;
        }

        private void evalQualifyingExpression(Expression expr) {
            if (expr != null) {
                if (expr instanceof Name) {
                    this.possibleTypeRefFound((Name)expr);
                } else {
                    expr.accept((ASTVisitor)this);
                }
            }
        }

        public boolean visit(ClassInstanceCreation node) {
            this.typeRefFound(node.getName());
            this.evalQualifyingExpression(node.getExpression());
            if (node.getAnonymousClassDeclaration() != null) {
                node.getAnonymousClassDeclaration().accept((ASTVisitor)this);
            }
            this.visitChildren(node.arguments());
            return false;
        }

        public boolean visit(MethodInvocation node) {
            this.evalQualifyingExpression(node.getExpression());
            this.visitChildren(node.arguments());
            return false;
        }

        public boolean visit(SuperConstructorInvocation node) {
            if (!this.isAffected((ASTNode)node)) {
                return false;
            }
            this.evalQualifyingExpression(node.getExpression());
            this.visitChildren(node.arguments());
            return false;
        }

        public boolean visit(FieldAccess node) {
            this.evalQualifyingExpression(node.getExpression());
            return false;
        }

        public boolean visit(SimpleName node) {
            return false;
        }

        public boolean visit(TypeDeclaration node) {
            if (!this.isAffected((ASTNode)node)) {
                return false;
            }
            this.typeRefFound(node.getSuperclass());
            Iterator iter = node.superInterfaces().iterator();
            while (iter.hasNext()) {
                this.typeRefFound((Name)iter.next());
            }
            this.visitChildren(node.bodyDeclarations());
            return false;
        }

        public boolean visit(MethodDeclaration node) {
            if (!this.isAffected((ASTNode)node)) {
                return false;
            }
            if (!node.isConstructor()) {
                node.getReturnType().accept((ASTVisitor)this);
            }
            this.visitChildren(node.parameters());
            Iterator iter = node.thrownExceptions().iterator();
            while (iter.hasNext()) {
                this.typeRefFound((Name)iter.next());
            }
            if (node.getBody() != null) {
                node.getBody().accept((ASTVisitor)this);
            }
            return false;
        }
    }

    private static class TypeReferenceProcessor {
        private ArrayList fOldSingleImports;
        private ArrayList fOldDemandImports;
        private HashSet fImportsAdded;
        private ImportsStructure fImpStructure;
        private ArrayList fTypeRefsFound;
        private boolean fIgnoreLowerCaseNames;
        private IJavaSearchScope fSearchScope;
        private IPackageFragment fCurrPackage;
        private ScopeAnalyzer fAnalyzer;

        public TypeReferenceProcessor(ArrayList oldSingleImports, ArrayList oldDemandImports, CompilationUnit root, ImportsStructure impStructure, boolean ignoreLowerCaseNames) throws JavaModelException {
            this.fOldSingleImports = oldSingleImports;
            this.fOldDemandImports = oldDemandImports;
            this.fImpStructure = impStructure;
            this.fIgnoreLowerCaseNames = ignoreLowerCaseNames;
            this.fAnalyzer = new ScopeAnalyzer(root);
            ICompilationUnit cu = this.fImpStructure.getCompilationUnit();
            this.fSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{cu.getJavaProject()});
            this.fCurrPackage = (IPackageFragment)cu.getParent();
            this.fTypeRefsFound = new ArrayList();
            this.fImportsAdded = new HashSet();
        }

        private boolean needsImport(ITypeBinding typeBinding, SimpleName ref) {
            if (!typeBinding.isTopLevel() && !typeBinding.isMember()) {
                return false;
            }
            int modifiers = typeBinding.getModifiers();
            if (Modifier.isPrivate((int)modifiers)) {
                return false;
            }
            ITypeBinding currTypeBinding = Bindings.getBindingOfParentType((ASTNode)ref);
            if (currTypeBinding == null) {
                return false;
            }
            if (!Modifier.isPublic((int)modifiers) && !currTypeBinding.getPackage().getName().equals(typeBinding.getPackage().getName())) {
                return false;
            }
            if (ref.getParent() instanceof TypeDeclaration) {
                return true;
            }
            if (typeBinding.isMember()) {
                IBinding[] visibleTypes = this.fAnalyzer.getDeclarationsInScope(ref, 4);
                int i = 0;
                while (i < visibleTypes.length) {
                    if (visibleTypes[i] == typeBinding) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public TypeInfo[] process(SimpleName ref) throws CoreException {
            block18: {
                TypeInfo[] typeInfoArray;
                block20: {
                    TypeInfo[] typeInfoArray2;
                    block19: {
                        TypeInfo[] typeInfoArray3;
                        block17: {
                            TypeInfo[] typeInfoArray4;
                            block16: {
                                String typeName = ref.getIdentifier();
                                if (this.fImportsAdded.contains(typeName)) {
                                    return null;
                                }
                                try {
                                    IBinding binding = ref.resolveBinding();
                                    if (binding != null) {
                                        if (binding.getKind() == 2) {
                                            ITypeBinding typeBinding = (ITypeBinding)binding;
                                            if (typeBinding.isArray()) {
                                                typeBinding = typeBinding.getElementType();
                                            }
                                            if (this.needsImport(typeBinding, ref)) {
                                                this.fImpStructure.addImport(typeBinding);
                                                this.fImportsAdded.add(typeName);
                                            }
                                        }
                                        TypeInfo[] typeInfoArray5 = null;
                                        Object var12_11 = null;
                                        this.fTypeRefsFound.clear();
                                        return typeInfoArray5;
                                    }
                                    this.fImportsAdded.add(typeName);
                                    ArrayList typeRefsFound = this.fTypeRefsFound;
                                    this.findTypeRefs(typeName, typeRefsFound);
                                    int nFound = typeRefsFound.size();
                                    if (nFound == 0) {
                                        typeInfoArray4 = null;
                                        break block16;
                                    }
                                    if (nFound == 1) {
                                        TypeInfo typeRef = (TypeInfo)typeRefsFound.get(0);
                                        this.fImpStructure.addImport(typeRef.getFullyQualifiedName());
                                        typeInfoArray3 = null;
                                        break block17;
                                    }
                                    String containerToImport = null;
                                    boolean ambiguousImports = false;
                                    int i = 0;
                                    while (true) {
                                        if (i >= nFound) {
                                            if (containerToImport == null || ambiguousImports) break;
                                            this.fImpStructure.addImport(containerToImport, typeName);
                                            break block18;
                                        }
                                        TypeInfo typeRef = (TypeInfo)typeRefsFound.get(i);
                                        String fullName = typeRef.getFullyQualifiedName();
                                        String containerName = typeRef.getTypeContainerName();
                                        if (this.fOldSingleImports.contains(fullName)) {
                                            this.fImpStructure.addImport(fullName);
                                            typeInfoArray2 = null;
                                            break block19;
                                        }
                                        if (this.fOldDemandImports.contains(containerName)) {
                                            if (containerToImport == null) {
                                                containerToImport = containerName;
                                            } else {
                                                ambiguousImports = true;
                                            }
                                        }
                                        ++i;
                                    }
                                    typeInfoArray = typeRefsFound.toArray(new TypeInfo[nFound]);
                                    break block20;
                                }
                                catch (Throwable throwable) {
                                    Object var12_16 = null;
                                    this.fTypeRefsFound.clear();
                                    throw throwable;
                                }
                            }
                            Object var12_12 = null;
                            this.fTypeRefsFound.clear();
                            return typeInfoArray4;
                        }
                        Object var12_13 = null;
                        this.fTypeRefsFound.clear();
                        return typeInfoArray3;
                    }
                    Object var12_14 = null;
                    this.fTypeRefsFound.clear();
                    return typeInfoArray2;
                }
                Object var12_15 = null;
                this.fTypeRefsFound.clear();
                return typeInfoArray;
            }
            Object var12_17 = null;
            this.fTypeRefsFound.clear();
            return null;
        }

        private void findTypeRefs(String simpleTypeName, Collection typeRefsFound) throws JavaModelException {
            if (this.fIgnoreLowerCaseNames && simpleTypeName.length() > 0 && Strings.isLowerCase(simpleTypeName.charAt(0))) {
                return;
            }
            TypeInfo[] infos = AllTypesCache.getTypesForName(simpleTypeName, this.fSearchScope, null);
            int i = 0;
            while (i < infos.length) {
                TypeInfo curr = infos[i];
                IType type = curr.resolveType(this.fSearchScope);
                if (type != null && JavaModelUtil.isVisible((IMember)type, this.fCurrPackage)) {
                    typeRefsFound.add(curr);
                }
                ++i;
            }
        }
    }
}

