/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.codemanipulation.IImportsStructure;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.textmanipulation.TextRegion;
import org.eclipse.jdt.internal.corext.util.AllTypesCache;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public final class ImportsStructure
implements IImportsStructure {
    private ICompilationUnit fCompilationUnit;
    private ArrayList fPackageEntries;
    private int fImportOnDemandThreshold;
    private boolean fFilterImplicitImports;
    private boolean fFindAmbiguousImports;
    private int fNumberOfImportsCreated;
    private boolean fHasChanges;
    private static final String JAVA_LANG = "java.lang";

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImportsStructure(ICompilationUnit cu, String[] preferenceOrder, int importThreshold, boolean restoreExistingImports) throws CoreException {
        block8: {
            this.fHasChanges = false;
            ICompilationUnit iCompilationUnit = this.fCompilationUnit = cu;
            synchronized (iCompilationUnit) {
                this.fCompilationUnit.reconcile();
            }
            IImportContainer container = cu.getImportContainer();
            this.fImportOnDemandThreshold = importThreshold;
            this.fFilterImplicitImports = true;
            this.fFindAmbiguousImports = !restoreExistingImports;
            this.fPackageEntries = new ArrayList(20);
            if (restoreExistingImports && container.exists()) {
                TextBuffer buffer = null;
                try {
                    buffer = this.aquireTextBuffer();
                    this.addExistingImports(buffer, cu.getImports());
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (buffer != null) {
                        TextBuffer.release(buffer);
                    }
                    throw throwable;
                }
                {
                    Object var7_9 = null;
                    if (buffer == null) break block8;
                }
                TextBuffer.release(buffer);
            }
        }
        this.addPreferenceOrderHolders(preferenceOrder);
        this.fNumberOfImportsCreated = 0;
        this.fHasChanges = false;
    }

    private void addPreferenceOrderHolders(String[] preferenceOrder) {
        if (this.fPackageEntries.isEmpty()) {
            int i = 0;
            while (i < preferenceOrder.length) {
                PackageEntry entry = new PackageEntry(preferenceOrder[i]);
                this.fPackageEntries.add(entry);
                ++i;
            }
        } else {
            PackageEntry[] lastAssigned = new PackageEntry[preferenceOrder.length];
            int k = 0;
            while (k < this.fPackageEntries.size()) {
                PackageEntry entry = (PackageEntry)this.fPackageEntries.get(k);
                if (!entry.isComment()) {
                    String currName = entry.getName();
                    int currNameLen = currName.length();
                    int bestGroupIndex = -1;
                    int bestGroupLen = -1;
                    int i = 0;
                    while (i < preferenceOrder.length) {
                        String currPrefEntry = preferenceOrder[i];
                        int currPrefLen = currPrefEntry.length();
                        if (!(!currName.startsWith(currPrefEntry) || currPrefLen < bestGroupLen || currPrefLen != currNameLen && currName.charAt(currPrefLen) != '.' || bestGroupIndex != -1 && currPrefLen <= bestGroupLen)) {
                            bestGroupLen = currPrefLen;
                            bestGroupIndex = i;
                        }
                        ++i;
                    }
                    if (bestGroupIndex != -1) {
                        entry.setGroupID(preferenceOrder[bestGroupIndex]);
                        lastAssigned[bestGroupIndex] = entry;
                    }
                }
                ++k;
            }
            int currAppendIndex = 0;
            int i = 0;
            while (i < lastAssigned.length) {
                PackageEntry entry = lastAssigned[i];
                if (entry == null) {
                    PackageEntry newEntry = new PackageEntry(preferenceOrder[i]);
                    this.fPackageEntries.add(currAppendIndex, newEntry);
                    ++currAppendIndex;
                } else {
                    currAppendIndex = this.fPackageEntries.indexOf(entry) + 1;
                }
                ++i;
            }
        }
    }

    private void addExistingImports(TextBuffer buffer, IImportDeclaration[] decls) throws JavaModelException {
        if (decls.length == 0) {
            return;
        }
        PackageEntry currPackage = null;
        IImportDeclaration curr = decls[0];
        ISourceRange sourceRange = curr.getSourceRange();
        int currOffset = sourceRange.getOffset();
        int currLength = sourceRange.getLength();
        int currEndLine = buffer.getLineOfOffset(currOffset + currLength);
        int i = 1;
        while (i < decls.length) {
            String name = curr.getElementName();
            String packName = Signature.getQualifier((String)name);
            if (currPackage == null || !packName.equals(currPackage.getName())) {
                currPackage = new PackageEntry(packName, null);
                this.fPackageEntries.add(currPackage);
            }
            IImportDeclaration next = decls[i];
            sourceRange = next.getSourceRange();
            int nextOffset = sourceRange.getOffset();
            int nextLength = sourceRange.getLength();
            int nextOffsetLine = buffer.getLineOfOffset(nextOffset);
            if (currEndLine < nextOffsetLine) {
                nextOffset = buffer.getLineInformation(++currEndLine).getOffset();
            }
            currPackage.add(new ImportDeclEntry(name, buffer.getContent(currOffset, nextOffset - currOffset)));
            currOffset = nextOffset;
            curr = next;
            if (currEndLine < nextOffsetLine) {
                nextOffset = buffer.getLineInformation(nextOffsetLine).getOffset();
                currPackage = new PackageEntry();
                this.fPackageEntries.add(currPackage);
                currPackage.add(new ImportDeclEntry(null, buffer.getContent(currOffset, nextOffset - currOffset)));
                currOffset = nextOffset;
            }
            currEndLine = buffer.getLineOfOffset(nextOffset + nextLength);
            ++i;
        }
        String name = curr.getElementName();
        String packName = Signature.getQualifier((String)name);
        if (currPackage == null || !packName.equals(currPackage.getName())) {
            currPackage = new PackageEntry(packName, null);
            this.fPackageEntries.add(currPackage);
        }
        ISourceRange range = curr.getSourceRange();
        int endOffset = range.getOffset() + range.getLength();
        String content = String.valueOf(buffer.getContent(currOffset, endOffset - currOffset)) + buffer.getLineDelimiter();
        currPackage.add(new ImportDeclEntry(name, content));
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public void setFilterImplicitImports(boolean filterImplicitImports) {
        this.fFilterImplicitImports = filterImplicitImports;
    }

    public void setFindAmbiguousImports(boolean findAmbiguousImports) {
        this.fFindAmbiguousImports = findAmbiguousImports;
    }

    private static int getCommonPrefixLength(String s, String t) {
        int len = Math.min(s.length(), t.length());
        int i = 0;
        while (i < len) {
            if (s.charAt(i) != t.charAt(i)) {
                return i;
            }
            ++i;
        }
        return len;
    }

    private static char getCharAt(String str, int index) {
        if (str.length() > index) {
            return str.charAt(index);
        }
        return '\u0000';
    }

    private PackageEntry findBestMatch(String newName) {
        if (this.fPackageEntries.isEmpty()) {
            return null;
        }
        String groupId = null;
        int longestPrefix = -1;
        int i = 0;
        while (i < this.fPackageEntries.size()) {
            PackageEntry curr = (PackageEntry)this.fPackageEntries.get(i);
            String currGroup = curr.getGroupID();
            if (currGroup != null && newName.startsWith(currGroup)) {
                int prefixLen = currGroup.length();
                if (prefixLen == newName.length()) {
                    return curr;
                }
                if (newName.charAt(prefixLen) == '.' && prefixLen > longestPrefix) {
                    longestPrefix = prefixLen;
                    groupId = currGroup;
                }
            }
            ++i;
        }
        PackageEntry bestMatch = null;
        PackageMatcher matcher = new PackageMatcher();
        matcher.initialize(newName, "");
        int i2 = 0;
        while (i2 < this.fPackageEntries.size()) {
            PackageEntry curr = (PackageEntry)this.fPackageEntries.get(i2);
            if (!curr.isComment() && (groupId == null || groupId.equals(curr.getGroupID()))) {
                boolean preferrCurr;
                boolean bl = preferrCurr = bestMatch == null || curr.getNumberOfImports() > bestMatch.getNumberOfImports();
                if (matcher.isBetterMatch(curr.getName(), preferrCurr)) {
                    bestMatch = curr;
                }
            }
            ++i2;
        }
        return bestMatch;
    }

    public static boolean isImplicitImport(String qualifier, ICompilationUnit cu) {
        if (JAVA_LANG.equals(qualifier)) {
            return true;
        }
        String packageName = cu.getParent().getElementName();
        if (qualifier.equals(packageName)) {
            return true;
        }
        String mainTypeName = JavaModelUtil.concatenateName(packageName, Signature.getQualifier((String)cu.getElementName()));
        return qualifier.equals(mainTypeName);
    }

    public String addImport(ITypeBinding binding) {
        ITypeBinding normalizedBinding = Bindings.normalizeTypeBinding(binding);
        if (normalizedBinding == null) {
            return binding.getName();
        }
        String qualifiedName = normalizedBinding.getQualifiedName();
        if (qualifiedName.length() > 0) {
            return this.addImport(qualifiedName);
        }
        return normalizedBinding.getName();
    }

    public String addImport(String typeContainerName, String typeName) {
        return this.addImport(JavaModelUtil.concatenateName(typeContainerName, typeName));
    }

    public String addImport(String qualifiedTypeName) {
        int bracketOffset = qualifiedTypeName.indexOf(91);
        if (bracketOffset != -1) {
            return String.valueOf(this.internalAddImport(qualifiedTypeName.substring(0, bracketOffset))) + qualifiedTypeName.substring(bracketOffset);
        }
        return this.internalAddImport(qualifiedTypeName);
    }

    private String internalAddImport(String fullTypeName) {
        String typeContainerName = Signature.getQualifier((String)fullTypeName);
        String typeName = Signature.getSimpleName((String)fullTypeName);
        if (typeContainerName.length() == 0 && PrimitiveType.toCode((String)typeName) != null) {
            return fullTypeName;
        }
        if (!"*".equals(typeName)) {
            String topLevelTypeName = Signature.getQualifier((String)this.fCompilationUnit.getElementName());
            if (typeName.equals(topLevelTypeName)) {
                if (!typeContainerName.equals(this.fCompilationUnit.getParent().getElementName())) {
                    return fullTypeName;
                }
                return typeName;
            }
            String existing = this.findImport(typeName);
            if (existing != null) {
                if (fullTypeName.equals(existing)) {
                    return typeName;
                }
                return fullTypeName;
            }
        }
        ImportDeclEntry decl = new ImportDeclEntry(fullTypeName, null);
        PackageEntry bestMatch = this.findBestMatch(typeContainerName);
        if (bestMatch == null) {
            PackageEntry packEntry = new PackageEntry(typeContainerName, null);
            packEntry.add(decl);
            this.fPackageEntries.add(0, packEntry);
        } else {
            int cmp = typeContainerName.compareTo(bestMatch.getName());
            if (cmp == 0) {
                bestMatch.sortIn(decl);
            } else {
                String group = bestMatch.getGroupID();
                if (group != null && !typeContainerName.startsWith(group)) {
                    group = null;
                }
                PackageEntry packEntry = new PackageEntry(typeContainerName, group);
                packEntry.add(decl);
                int index = this.fPackageEntries.indexOf(bestMatch);
                if (cmp < 0) {
                    this.fPackageEntries.add(index, packEntry);
                } else {
                    this.fPackageEntries.add(index + 1, packEntry);
                }
            }
        }
        this.fHasChanges = true;
        return typeName;
    }

    public boolean removeImport(String qualifiedTypeName) {
        String typeContainerName = Signature.getQualifier((String)qualifiedTypeName);
        int bracketOffset = qualifiedTypeName.indexOf(91);
        if (bracketOffset != -1) {
            qualifiedTypeName = qualifiedTypeName.substring(0, bracketOffset);
        }
        int nPackages = this.fPackageEntries.size();
        int i = 0;
        while (i < nPackages) {
            PackageEntry entry = (PackageEntry)this.fPackageEntries.get(i);
            if (entry.getName().equals(typeContainerName) && entry.remove(qualifiedTypeName)) {
                this.fHasChanges = true;
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean removeImport(ITypeBinding binding) {
        if ((binding = Bindings.normalizeTypeBinding(binding)) == null) {
            return false;
        }
        String qualifiedName = binding.getQualifiedName();
        if (qualifiedName.length() > 0) {
            return this.removeImport(qualifiedName);
        }
        return false;
    }

    public String findImport(String simpleName) {
        int nPackages = this.fPackageEntries.size();
        int i = 0;
        while (i < nPackages) {
            PackageEntry entry = (PackageEntry)this.fPackageEntries.get(i);
            ImportDeclEntry found = entry.find(simpleName);
            if (found != null) {
                return found.getElementName();
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void create(boolean save, IProgressMonitor monitor) throws CoreException {
        block7: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            TextBuffer buffer = null;
            try {
                buffer = this.aquireTextBuffer();
                IRegion textRange = this.getReplaceRange(buffer);
                String replaceString = this.getReplaceString(buffer, textRange);
                if (replaceString != null) {
                    buffer.replace(textRange, replaceString);
                    if (save) {
                        TextBuffer.commitChanges(buffer, true, null);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (buffer != null) {
                    this.releaseTextBuffer(buffer);
                }
                monitor.done();
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (buffer == null) break block7;
            }
            this.releaseTextBuffer(buffer);
        }
        monitor.done();
    }

    private TextBuffer aquireTextBuffer() throws CoreException {
        IFile file;
        if (JavaModelUtil.isPrimary(this.fCompilationUnit) && (file = (IFile)JavaModelUtil.toOriginal(this.fCompilationUnit).getResource()).exists()) {
            return TextBuffer.acquire(file);
        }
        return TextBuffer.create(this.fCompilationUnit.getSource());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void releaseTextBuffer(TextBuffer buffer) throws CoreException {
        block5: {
            block4: {
                try {
                    IFile file;
                    if (JavaModelUtil.isPrimary(this.fCompilationUnit) && (file = (IFile)JavaModelUtil.toOriginal(this.fCompilationUnit).getResource()).exists()) {
                        Object var3_3 = null;
                        break block4;
                    }
                    this.fCompilationUnit.getBuffer().setContents(buffer.getContent());
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    TextBuffer.release(buffer);
                    throw throwable;
                }
            }
            TextBuffer.release(buffer);
            return;
        }
        Object var3_5 = null;
        TextBuffer.release(buffer);
    }

    public IRegion getReplaceRange(TextBuffer textBuffer) throws JavaModelException {
        ICompilationUnit iCompilationUnit = this.fCompilationUnit;
        synchronized (iCompilationUnit) {
            this.fCompilationUnit.reconcile();
        }
        IImportContainer container = this.fCompilationUnit.getImportContainer();
        if (container.exists()) {
            int nextLine;
            ISourceRange importSourceRange = container.getSourceRange();
            int startPos = importSourceRange.getOffset();
            int endPos = startPos + importSourceRange.getLength();
            if (!Strings.isLineDelimiterChar(textBuffer.getChar(endPos - 1)) && (nextLine = textBuffer.getLineOfOffset(endPos) + 1) < textBuffer.getNumberOfLines()) {
                int stopPos = textBuffer.getLineInformation(nextLine).getOffset();
                while (endPos < stopPos && Character.isWhitespace(textBuffer.getChar(endPos))) {
                    ++endPos;
                }
            }
            return new Region(startPos, endPos - startPos);
        }
        int start = this.getPackageStatementEndPos(textBuffer);
        return new Region(start, 0);
    }

    public String getReplaceString(TextBuffer textBuffer, IRegion textRange) throws JavaModelException {
        int importsStart = textRange.getOffset();
        int importsLen = textRange.getLength();
        String lineDelim = textBuffer.getLineDelimiter();
        StringBuffer buf = new StringBuffer();
        int nCreated = 0;
        PackageEntry lastPackage = null;
        Set onDemandConflicts = null;
        if (this.fFindAmbiguousImports) {
            onDemandConflicts = this.evaluateStarImportConflicts();
        }
        int nPackageEntries = this.fPackageEntries.size();
        int i = 0;
        while (i < nPackageEntries) {
            PackageEntry pack = (PackageEntry)this.fPackageEntries.get(i);
            int nImports = pack.getNumberOfImports();
            if (this.fFilterImplicitImports && ImportsStructure.isImplicitImport(pack.getName(), this.fCompilationUnit)) {
                pack.removeAllNew();
                nImports = pack.getNumberOfImports();
            }
            if (nImports != 0) {
                if (lastPackage != null && !pack.isComment() && !pack.isSameGroup(lastPackage)) {
                    ImportDeclEntry last = lastPackage.getImportAt(lastPackage.getNumberOfImports() - 1);
                    ImportDeclEntry first = pack.getImportAt(0);
                    if (!lastPackage.isComment() && (last.isNew() || first.isNew())) {
                        buf.append(lineDelim);
                    }
                }
                lastPackage = pack;
                boolean doStarImport = pack.hasStarImport(this.fImportOnDemandThreshold, onDemandConflicts);
                if (doStarImport && pack.find("*") == null) {
                    String starImportString = String.valueOf(pack.getName()) + ".*";
                    this.appendImportToBuffer(buf, starImportString, lineDelim);
                    ++nCreated;
                }
                int k = 0;
                while (k < nImports) {
                    ImportDeclEntry currDecl = pack.getImportAt(k);
                    String content = currDecl.getContent();
                    if (content == null) {
                        if (!doStarImport || currDecl.isOnDemand() || onDemandConflicts != null && onDemandConflicts.contains(currDecl.getSimpleName())) {
                            this.appendImportToBuffer(buf, currDecl.getElementName(), lineDelim);
                            ++nCreated;
                        }
                    } else {
                        buf.append(content);
                    }
                    ++k;
                }
            }
            ++i;
        }
        if (importsLen == 0 && nCreated > 0) {
            IType[] types;
            if (this.fCompilationUnit.getPackageDeclarations().length > 0) {
                buf.insert(0, lineDelim);
            }
            if ((types = this.fCompilationUnit.getTypes()).length > 0 && types[0].getSourceRange().getOffset() == importsStart) {
                buf.append(lineDelim);
            }
        }
        this.fNumberOfImportsCreated = nCreated;
        String newContent = buf.toString();
        if (this.hasChanged(textBuffer, importsStart, importsLen, newContent)) {
            return newContent;
        }
        return null;
    }

    private Set evaluateStarImportConflicts() throws JavaModelException {
        int nPackageEntries = this.fPackageEntries.size();
        HashSet<String> starImportPackages = new HashSet<String>(nPackageEntries);
        int i = 0;
        while (i < nPackageEntries) {
            PackageEntry pack = (PackageEntry)this.fPackageEntries.get(i);
            if (pack.hasStarImport(this.fImportOnDemandThreshold, null)) {
                starImportPackages.add(pack.getName());
            }
            ++i;
        }
        if (starImportPackages.isEmpty()) {
            return null;
        }
        starImportPackages.add(this.fCompilationUnit.getParent().getElementName());
        starImportPackages.add(JAVA_LANG);
        TypeInfo[] allTypes = AllTypesCache.getAllTypes(null);
        if (allTypes.length < 2) {
            return null;
        }
        HashSet<String> onDemandConflicts = new HashSet<String>();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.fCompilationUnit.getJavaProject()});
        String curr = allTypes[0].getTypeName();
        int offset = 0;
        int i2 = 1;
        while (i2 < allTypes.length) {
            String name = allTypes[i2].getTypeName();
            if (!name.equals(curr)) {
                if (i2 - offset > 1 && this.isConflictingTypeName(allTypes, offset, i2, starImportPackages, scope)) {
                    onDemandConflicts.add(curr);
                }
                curr = name;
                offset = i2;
            }
            ++i2;
        }
        if (i2 - offset > 1 && this.isConflictingTypeName(allTypes, offset, i2, starImportPackages, scope)) {
            onDemandConflicts.add(curr);
        }
        return onDemandConflicts;
    }

    private boolean isConflictingTypeName(TypeInfo[] allTypes, int start, int end, HashSet starImportPackages, IJavaSearchScope scope) {
        String conflictingContainer = null;
        int i = start;
        while (i < end) {
            TypeInfo curr = allTypes[i];
            String containerName = curr.getTypeContainerName();
            if (!containerName.equals(conflictingContainer) && starImportPackages.contains(containerName) && curr.isEnclosed(scope)) {
                if (conflictingContainer != null) {
                    return true;
                }
                conflictingContainer = containerName;
            }
            ++i;
        }
        return false;
    }

    private boolean hasChanged(TextBuffer textBuffer, int offset, int length, String content) {
        if (content.length() != length) {
            return true;
        }
        int i = 0;
        while (i < length) {
            if (content.charAt(i) != textBuffer.getChar(offset + i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void appendImportToBuffer(StringBuffer buf, String importName, String lineDelim) {
        String str = "import " + importName + ';' + lineDelim;
        buf.append(str);
    }

    private int getPackageStatementEndPos(TextBuffer buffer) throws JavaModelException {
        ISourceRange range;
        int line;
        TextRegion region;
        IPackageDeclaration[] packDecls = this.fCompilationUnit.getPackageDeclarations();
        if (packDecls != null && packDecls.length > 0 && (region = buffer.getLineInformation((line = buffer.getLineOfOffset((range = packDecls[0].getSourceRange()).getOffset() + range.getLength())) + 1)) != null) {
            return region.getOffset();
        }
        return 0;
    }

    public String toString() {
        int nPackages = this.fPackageEntries.size();
        StringBuffer buf = new StringBuffer("\n-----------------------\n");
        int i = 0;
        while (i < nPackages) {
            PackageEntry entry = (PackageEntry)this.fPackageEntries.get(i);
            buf.append(entry.toString());
            ++i;
        }
        return buf.toString();
    }

    public int getNumberOfImportsCreated() {
        return this.fNumberOfImportsCreated;
    }

    public boolean hasChanges() {
        return this.fHasChanges;
    }

    public static class PackageMatcher {
        private String fNewName;
        private String fBestName;
        private int fBestMatchLen;

        public void initialize(String newName, String bestName) {
            this.fNewName = newName;
            this.fBestName = bestName;
            this.fBestMatchLen = ImportsStructure.getCommonPrefixLength(bestName, this.fNewName);
        }

        public boolean isBetterMatch(String currName, boolean preferCurr) {
            boolean isBetter;
            int currMatchLen = ImportsStructure.getCommonPrefixLength(currName, this.fNewName);
            int matchDiff = currMatchLen - this.fBestMatchLen;
            if (matchDiff == 0) {
                isBetter = currMatchLen == this.fNewName.length() && currMatchLen == currName.length() && currMatchLen == this.fBestName.length() ? preferCurr : this.sameMatchLenTest(currName);
            } else {
                boolean bl = isBetter = matchDiff > 0;
            }
            if (isBetter) {
                this.fBestName = currName;
                this.fBestMatchLen = currMatchLen;
            }
            return isBetter;
        }

        private boolean sameMatchLenTest(String currName) {
            int matchLen = this.fBestMatchLen;
            char newChar = ImportsStructure.getCharAt(this.fNewName, matchLen);
            char currChar = ImportsStructure.getCharAt(currName, matchLen);
            char bestChar = ImportsStructure.getCharAt(this.fBestName, matchLen);
            if (newChar < currChar) {
                if (bestChar < newChar) {
                    return currChar - newChar < newChar - bestChar;
                }
                if (currChar == bestChar) {
                    return false;
                }
                return currChar < bestChar;
            }
            if (bestChar > newChar) {
                return newChar - currChar < bestChar - newChar;
            }
            if (currChar == bestChar) {
                return true;
            }
            return currChar > bestChar;
        }
    }

    private static final class ImportDeclEntry {
        private String fElementName;
        private String fContent;

        public ImportDeclEntry(String elementName, String existingContent) {
            this.fElementName = elementName;
            this.fContent = existingContent;
        }

        public String getElementName() {
            return this.fElementName;
        }

        public String getSimpleName() {
            return Signature.getSimpleName((String)this.fElementName);
        }

        public boolean isOnDemand() {
            return this.fElementName != null && this.fElementName.endsWith(".*");
        }

        public boolean isNew() {
            return this.fContent == null;
        }

        public boolean isComment() {
            return this.fElementName == null;
        }

        public String getContent() {
            return this.fContent;
        }
    }

    private static final class PackageEntry {
        private String fName;
        private ArrayList fImportEntries;
        private String fGroup;

        public PackageEntry() {
            this("!", null);
        }

        public PackageEntry(String name) {
            this(name, name);
        }

        public PackageEntry(String name, String group) {
            this.fName = name;
            this.fImportEntries = new ArrayList(5);
            this.fGroup = group;
        }

        public int findInsertPosition(String fullImportName) {
            int nInports = this.fImportEntries.size();
            int i = 0;
            while (i < nInports) {
                ImportDeclEntry curr = this.getImportAt(i);
                if (!curr.isComment() && fullImportName.compareTo(curr.getElementName()) <= 0) {
                    return i;
                }
                ++i;
            }
            return nInports;
        }

        public void sortIn(ImportDeclEntry imp) {
            String fullImportName = imp.getElementName();
            int insertPosition = -1;
            int nInports = this.fImportEntries.size();
            int i = 0;
            while (i < nInports) {
                ImportDeclEntry curr = this.getImportAt(i);
                if (!curr.isComment()) {
                    int cmp = fullImportName.compareTo(curr.getElementName());
                    if (cmp == 0) {
                        return;
                    }
                    if (cmp < 0 && insertPosition == -1) {
                        insertPosition = i;
                    }
                }
                ++i;
            }
            if (insertPosition == -1) {
                this.fImportEntries.add(imp);
            } else {
                this.fImportEntries.add(insertPosition, imp);
            }
        }

        public void add(ImportDeclEntry imp) {
            this.fImportEntries.add(imp);
        }

        public ImportDeclEntry find(String simpleName) {
            int nInports = this.fImportEntries.size();
            int i = 0;
            while (i < nInports) {
                int dotPos;
                String name;
                ImportDeclEntry curr = this.getImportAt(i);
                if (!curr.isComment() && (name = curr.getElementName()).endsWith(simpleName) && ((dotPos = name.length() - simpleName.length() - 1) == -1 || dotPos > 0 && name.charAt(dotPos) == '.')) {
                    return curr;
                }
                ++i;
            }
            return null;
        }

        public boolean remove(String fullName) {
            int nInports = this.fImportEntries.size();
            int i = 0;
            while (i < nInports) {
                ImportDeclEntry curr = this.getImportAt(i);
                if (!curr.isComment() && fullName.equals(curr.getElementName())) {
                    this.fImportEntries.remove(i);
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void removeAllNew() {
            int nInports = this.fImportEntries.size();
            int i = nInports - 1;
            while (i >= 0) {
                ImportDeclEntry curr = this.getImportAt(i);
                if (curr.isNew()) {
                    this.fImportEntries.remove(i);
                }
                --i;
            }
        }

        public ImportDeclEntry getImportAt(int index) {
            return (ImportDeclEntry)this.fImportEntries.get(index);
        }

        public boolean hasStarImport(int threshold, Set explicitImports) {
            if (this.isComment() || this.isDefaultPackage()) {
                return false;
            }
            int nImports = this.getNumberOfImports();
            int count = 0;
            boolean containsNew = false;
            int i = 0;
            while (i < nImports) {
                ImportDeclEntry curr = this.getImportAt(i);
                if (curr.isOnDemand()) {
                    return true;
                }
                if (!curr.isComment()) {
                    ++count;
                    boolean isExplicit = explicitImports != null && explicitImports.contains(curr.getSimpleName());
                    containsNew |= curr.isNew() && !isExplicit;
                }
                ++i;
            }
            return count >= threshold && containsNew;
        }

        public int getNumberOfImports() {
            return this.fImportEntries.size();
        }

        public String getName() {
            return this.fName;
        }

        public String getGroupID() {
            return this.fGroup;
        }

        public void setGroupID(String groupID) {
            this.fGroup = groupID;
        }

        public boolean isSameGroup(PackageEntry other) {
            if (this.fGroup == null) {
                return other.getGroupID() == null;
            }
            return this.fGroup.equals(other.getGroupID());
        }

        public ImportDeclEntry getLast() {
            int nImports = this.getNumberOfImports();
            if (nImports > 0) {
                return this.getImportAt(nImports - 1);
            }
            return null;
        }

        public boolean isComment() {
            return "!".equals(this.fName);
        }

        public boolean isDefaultPackage() {
            return this.fName.length() == 0;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            if (this.isComment()) {
                buf.append("comment\n");
            } else {
                buf.append(this.fName);
                buf.append(", groupId: ");
                buf.append(this.fGroup);
                buf.append("\n");
                int nImports = this.getNumberOfImports();
                int i = 0;
                while (i < nImports) {
                    ImportDeclEntry curr = this.getImportAt(i);
                    buf.append("  ");
                    buf.append(curr.getSimpleName());
                    if (curr.isNew()) {
                        buf.append(" (new)");
                    }
                    buf.append("\n");
                    ++i;
                }
            }
            return buf.toString();
        }
    }
}

