/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public final class ImportRewrite {
    private ImportsStructure fImportsStructure;

    public ImportRewrite(ICompilationUnit cunit, CodeGenerationSettings settings) throws CoreException {
        Assert.isNotNull(cunit);
        Assert.isNotNull(settings);
        this.fImportsStructure = new ImportsStructure(cunit, settings.importOrder, settings.importThreshold, true);
    }

    public final TextEdit createEdit(TextBuffer buffer) throws CoreException {
        IRegion region = this.fImportsStructure.getReplaceRange(buffer);
        String text = this.fImportsStructure.getReplaceString(buffer, region);
        if (text == null) {
            return new MultiTextEdit(region.getOffset(), 0);
        }
        return new ReplaceEdit(region.getOffset(), region.getLength(), text);
    }

    public final void rewrite(TextBuffer buffer, TextEdit rootEdit) throws MalformedTreeException, CoreException {
        IRegion region = this.fImportsStructure.getReplaceRange(buffer);
        String text = this.fImportsStructure.getReplaceString(buffer, region);
        if (text != null) {
            rootEdit.addChild((TextEdit)new ReplaceEdit(region.getOffset(), region.getLength(), text));
        }
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fImportsStructure.getCompilationUnit();
    }

    public void setFilterImplicitImports(boolean filterImplicitImports) {
        this.fImportsStructure.setFilterImplicitImports(filterImplicitImports);
    }

    public void setFindAmbiguosImports(boolean findAmbiguosImports) {
        this.fImportsStructure.setFindAmbiguousImports(findAmbiguosImports);
    }

    public String addImport(String qualifiedTypeName) {
        return this.fImportsStructure.addImport(qualifiedTypeName);
    }

    public String addImport(ITypeBinding binding) {
        return this.fImportsStructure.addImport(binding);
    }

    public boolean removeImport(ITypeBinding binding) {
        return this.fImportsStructure.removeImport(binding);
    }

    public boolean removeImport(String qualifiedTypeName) {
        return this.fImportsStructure.removeImport(qualifiedTypeName);
    }

    public boolean isEmpty() {
        return !this.fImportsStructure.hasChanges();
    }
}

