/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ui.PreferenceConstants;

public class GetterSetterUtil {
    private static final String[] EMPTY = new String[0];

    private GetterSetterUtil() {
    }

    public static String getGetterName(IField field, String[] excludedNames) throws JavaModelException {
        boolean useIs = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.gettersetter.use.is");
        return GetterSetterUtil.getGetterName(field, excludedNames, useIs);
    }

    private static String getGetterName(IField field, String[] excludedNames, boolean useIsForBoolGetters) throws JavaModelException {
        if (excludedNames == null) {
            excludedNames = EMPTY;
        }
        return GetterSetterUtil.getGetterName(field.getJavaProject(), field.getElementName(), field.getFlags(), useIsForBoolGetters && JavaModelUtil.isBoolean(field), excludedNames);
    }

    public static String getGetterName(IJavaProject project, String fieldName, int flags, boolean isBoolean, String[] excludedNames) {
        return NamingConventions.suggestGetterName((IJavaProject)project, (String)fieldName, (int)flags, (boolean)isBoolean, (String[])excludedNames);
    }

    public static String getSetterName(IJavaProject project, String fieldName, int flags, boolean isBoolean, String[] excludedNames) {
        return NamingConventions.suggestSetterName((IJavaProject)project, (String)fieldName, (int)flags, (boolean)isBoolean, (String[])excludedNames);
    }

    public static String getSetterName(IField field, String[] excludedNames) throws JavaModelException {
        if (excludedNames == null) {
            excludedNames = EMPTY;
        }
        return NamingConventions.suggestSetterName((IJavaProject)field.getJavaProject(), (String)field.getElementName(), (int)field.getFlags(), (boolean)JavaModelUtil.isBoolean(field), (String[])excludedNames);
    }

    public static IMethod getGetter(IField field) throws JavaModelException {
        IMethod primaryCandidate = JavaModelUtil.findMethod(GetterSetterUtil.getGetterName(field, EMPTY, true), new String[0], false, field.getDeclaringType());
        if (!JavaModelUtil.isBoolean(field) || primaryCandidate != null && primaryCandidate.exists()) {
            return primaryCandidate;
        }
        String secondCandidateName = GetterSetterUtil.getGetterName(field, EMPTY, false);
        return JavaModelUtil.findMethod(secondCandidateName, new String[0], false, field.getDeclaringType());
    }

    public static IMethod getSetter(IField field) throws JavaModelException {
        String[] args = new String[]{field.getTypeSignature()};
        return JavaModelUtil.findMethod(GetterSetterUtil.getSetterName(field, EMPTY), args, false, field.getDeclaringType());
    }
}

