/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;

public class AddUnimplementedMethodsOperation
implements IWorkspaceRunnable {
    private IJavaElement fInsertPosition;
    private IMethod[] fSelected;
    private IType fType;
    private IMethod[] fCreatedMethods;
    private boolean fDoSave;
    private CodeGenerationSettings fSettings;

    public AddUnimplementedMethodsOperation(IType type, CodeGenerationSettings settings, IMethod[] selected, boolean save, IJavaElement insertPosition) {
        this.fType = type;
        this.fDoSave = save;
        this.fCreatedMethods = null;
        this.fSettings = settings;
        this.fSelected = selected;
        this.fInsertPosition = insertPosition;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            ArrayList<IMethod> createdMethods;
            block7: {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.setTaskName(CodeGenerationMessages.getString("AddUnimplementedMethodsOperation.description"));
                monitor.beginTask("", 3);
                ITypeHierarchy hierarchy = this.fType.newSupertypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                monitor.worked(1);
                ImportsStructure imports = new ImportsStructure(this.fType.getCompilationUnit(), this.fSettings.importOrder, this.fSettings.importThreshold, true);
                String[] toImplement = StubUtility.genOverrideStubs(this.fSelected, this.fType, hierarchy, this.fSettings, imports);
                int nToImplement = toImplement.length;
                createdMethods = new ArrayList<IMethod>(nToImplement);
                if (nToImplement > 0) {
                    String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)this.fType);
                    int indent = StubUtility.getIndentUsed((IJavaElement)this.fType) + 1;
                    int i = 0;
                    while (true) {
                        if (i >= nToImplement) {
                            monitor.worked(1);
                            imports.create(this.fDoSave, null);
                            monitor.worked(1);
                            break block7;
                        }
                        String formattedContent = String.valueOf(CodeFormatterUtil.format(4, toImplement[i], indent, null, lineDelim, null)) + lineDelim;
                        IMethod curr = this.fType.createMethod(formattedContent, this.fInsertPosition, true, null);
                        createdMethods.add(curr);
                        ++i;
                    }
                }
                monitor.worked(2);
            }
            this.fCreatedMethods = new IMethod[createdMethods.size()];
            createdMethods.toArray(this.fCreatedMethods);
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var12_14 = null;
        }
        monitor.done();
    }

    public IMethod[] getCreatedMethods() {
        return this.fCreatedMethods;
    }
}

