/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class AddJavaDocStubOperation
implements IWorkspaceRunnable {
    private IMember[] fMembers;

    public AddJavaDocStubOperation(IMember[] members) {
        this.fMembers = members;
    }

    private String createTypeComment(IType type, String lineDelimiter) throws CoreException {
        return CodeGeneration.getTypeComment(type.getCompilationUnit(), type.getTypeQualifiedName('.'), lineDelimiter);
    }

    private String createMethodComment(IMethod meth, String lineDelimiter) throws CoreException {
        IType declaringType = meth.getDeclaringType();
        IMethod overridden = null;
        if (!meth.isConstructor()) {
            ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy(declaringType);
            overridden = JavaModelUtil.findMethodDeclarationInHierarchy(hierarchy, declaringType, meth.getElementName(), meth.getParameterTypes(), false);
        }
        return CodeGeneration.getMethodComment(meth, overridden, lineDelimiter);
    }

    private String createFieldComment(IField field, String lineDelimiter) throws JavaModelException, CoreException {
        String typeName = Signature.toString((String)field.getTypeSignature());
        String fieldName = field.getElementName();
        return CodeGeneration.getFieldComment(field.getCompilationUnit(), typeName, fieldName, String.valueOf('\n'));
    }

    private void sortEntries() {
        Arrays.sort(this.fMembers, new Comparator(){

            public int compare(Object object1, Object object2) {
                try {
                    return ((IMember)object2).getSourceRange().getOffset() - ((IMember)object1).getSourceRange().getOffset();
                }
                catch (JavaModelException javaModelException) {
                    return 0;
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        TextBuffer buffer;
        block18: {
            block16: {
                block17: {
                    buffer = null;
                    try {
                        if (monitor == null) {
                            monitor = new NullProgressMonitor();
                        }
                        monitor.beginTask(CodeGenerationMessages.getString("AddJavaDocStubOperation.description"), this.fMembers.length);
                        if (this.fMembers.length == 0) {
                            Object var15_3 = null;
                            if (buffer == null) break block16;
                            break block17;
                        }
                        ICompilationUnit cu = this.fMembers[0].getCompilationUnit();
                        buffer = TextBuffer.acquire((IFile)JavaModelUtil.toOriginal(cu).getResource());
                        this.sortEntries();
                        String lineDelim = buffer.getLineDelimiter();
                        int i = 0;
                        while (i < this.fMembers.length) {
                            String indentedComment;
                            IMember curr = this.fMembers[i];
                            int memberStartOffset = curr.getSourceRange().getOffset();
                            String comment = null;
                            switch (curr.getElementType()) {
                                case 7: {
                                    comment = this.createTypeComment((IType)curr, lineDelim);
                                    break;
                                }
                                case 8: {
                                    comment = this.createFieldComment((IField)curr, lineDelim);
                                    break;
                                }
                                case 9: {
                                    comment = this.createMethodComment((IMethod)curr, lineDelim);
                                    break;
                                }
                            }
                            if (comment == null) {
                                StringBuffer buf = new StringBuffer();
                                buf.append("/**").append(lineDelim);
                                buf.append(" *").append(lineDelim);
                                buf.append(" */").append(lineDelim);
                                comment = buf.toString();
                            } else if (!comment.endsWith(lineDelim)) {
                                comment = String.valueOf(comment) + lineDelim;
                            }
                            int tabWidth = CodeFormatterUtil.getTabWidth();
                            String line = buffer.getLineContentOfOffset(memberStartOffset);
                            String indentString = Strings.getIndentString(line, tabWidth);
                            String insertString = indentedComment = Strings.changeIndent(comment, 0, tabWidth, indentString, lineDelim);
                            Region range = new Region(memberStartOffset, 0);
                            buffer.replace((IRegion)range, insertString);
                            monitor.worked(1);
                            ++i;
                        }
                        break block18;
                    }
                    catch (Throwable throwable) {
                        Object var15_4 = null;
                        if (buffer != null) {
                            TextBuffer.release(buffer);
                        }
                        monitor.done();
                        throw throwable;
                    }
                }
                TextBuffer.release(buffer);
            }
            monitor.done();
            return;
        }
        Object var15_5 = null;
        if (buffer != null) {
            TextBuffer.release(buffer);
        }
        monitor.done();
    }
}

