/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.IImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jdt.ui.CodeGeneration;

public class AddDelegateMethodsOperation
implements IWorkspaceRunnable {
    private List fList;
    private IType fType;
    private IJavaElement fInsertPosition;
    private List fCreatedMethods;
    private CodeGenerationSettings fCodeSettings;

    public AddDelegateMethodsOperation(List resultList, CodeGenerationSettings settings, IType type, IJavaElement elementPosition) {
        this.fList = resultList;
        this.fType = type;
        this.fCreatedMethods = new ArrayList();
        this.fInsertPosition = elementPosition;
        this.fCodeSettings = settings;
    }

    public IMethod[] getCreatedMethods() {
        return this.fCreatedMethods.toArray(new IMethod[this.fCreatedMethods.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws CoreException {
        block12: {
            try {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                int listSize = this.fList.size();
                String message = ActionMessages.getFormattedString("AddDelegateMethodsOperation.monitor.message", String.valueOf(listSize));
                monitor.setTaskName(message);
                monitor.beginTask("", listSize);
                monitor.worked(1);
                boolean addComments = this.fCodeSettings.createComments;
                IMethod[] existingMethods = this.fType.getMethods();
                String lineDelim = StubUtility.getLineDelimiterUsed((IJavaElement)this.fType);
                int indent = StubUtility.getIndentUsed((IJavaElement)this.fType) + 1;
                ImportsStructure imports = new ImportsStructure(this.fType.getCompilationUnit(), this.fCodeSettings.importOrder, this.fCodeSettings.importThreshold, true);
                ITypeHierarchy typeHierarchy = this.fType.newSupertypeHierarchy(null);
                int i = 0;
                while (true) {
                    if (i >= listSize) {
                        imports.create(false, null);
                        break block12;
                    }
                    if (monitor.isCanceled()) {
                        if (i > 0) {
                            imports.create(false, null);
                        }
                        Object var20_20 = null;
                        break;
                    }
                    String content = null;
                    Methods2Field wrapper = (Methods2Field)this.fList.get(i);
                    IMethod curr = wrapper.fMethod;
                    IField field = wrapper.fField;
                    monitor.subTask(JavaElementLabels.getElementLabel((IJavaElement)curr, 1));
                    IMethod overwrittenMethod = JavaModelUtil.findMethodImplementationInHierarchy(typeHierarchy, this.fType, curr.getElementName(), curr.getParameterTypes(), curr.isConstructor());
                    if (overwrittenMethod == null) {
                        content = this.createStub(field, curr, addComments, overwrittenMethod, imports);
                    } else {
                        IMethod declaration = JavaModelUtil.findMethodDeclarationInHierarchy(typeHierarchy, this.fType, curr.getElementName(), curr.getParameterTypes(), curr.isConstructor());
                        content = this.createStub(field, declaration, addComments, overwrittenMethod, imports);
                    }
                    IJavaElement sibling = this.fInsertPosition;
                    IMethod existing = JavaModelUtil.findMethod(curr.getElementName(), curr.getParameterTypes(), curr.isConstructor(), existingMethods);
                    if (existing == null) {
                        if (curr.isConstructor() && existingMethods.length > 0) {
                            sibling = existingMethods[0];
                        }
                        String formattedContent = String.valueOf(CodeFormatterUtil.format(4, content, indent, null, lineDelim, null)) + lineDelim;
                        IMethod created = this.fType.createMethod(formattedContent, sibling, true, null);
                        this.fCreatedMethods.add(created);
                        monitor.worked(1);
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var20_21 = null;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return;
        }
        Object var20_22 = null;
        monitor.done();
    }

    private String createStub(IField field, IMethod curr, boolean addComment, IMethod overridden, IImportsStructure imports) throws CoreException {
        String comment;
        String methodName = curr.getElementName();
        String[] paramNames = StubUtility.suggestArgumentNames(curr.getJavaProject(), curr.getParameterNames());
        String returnTypSig = curr.getReturnType();
        StringBuffer buf = new StringBuffer();
        if (addComment && (comment = CodeGeneration.getMethodComment(this.fType.getCompilationUnit(), this.fType.getElementName(), methodName, paramNames, curr.getExceptionTypes(), returnTypSig, overridden, String.valueOf('\n'))) != null) {
            buf.append(comment);
            buf.append('\n');
        }
        String methodDeclaration = null;
        if (this.fType.isClass()) {
            StringBuffer body = new StringBuffer();
            if (!"V".equals(returnTypSig)) {
                body.append("return ");
            }
            if (JdtFlags.isStatic((IMember)curr)) {
                body.append(AddDelegateMethodsOperation.resolveTypeOfField(field).getElementName());
            } else {
                body.append(field.getElementName());
            }
            body.append('.').append(methodName).append('(');
            int i = 0;
            while (i < paramNames.length) {
                body.append(paramNames[i]);
                if (i < paramNames.length - 1) {
                    body.append(',');
                }
                ++i;
            }
            body.append(");");
            methodDeclaration = body.toString();
        }
        int flags = curr.getFlags() & 0xFFFFFFDF;
        StubUtility.genMethodDeclaration(this.fType.getElementName(), curr, flags, methodDeclaration, imports, buf);
        return buf.toString();
    }

    private static IType resolveTypeOfField(IField field) throws JavaModelException {
        boolean isPrimitive = AddDelegateMethodsOperation.hasPrimitiveType(field);
        boolean isArray = AddDelegateMethodsOperation.isArray(field);
        if (!isPrimitive && !isArray) {
            String typeName = JavaModelUtil.getResolvedTypeName(field.getTypeSignature(), field.getDeclaringType());
            return typeName != null ? field.getJavaProject().findType(typeName) : null;
        }
        if (isArray) {
            return AddDelegateMethodsOperation.getJavaLangObject(field.getJavaProject());
        }
        return null;
    }

    private static boolean hasPrimitiveType(IField field) throws JavaModelException {
        String signature = field.getTypeSignature();
        char first = Signature.getElementType((String)signature).charAt(0);
        return first != 'L' && first != 'Q';
    }

    private static IType getJavaLangObject(IJavaProject project) throws JavaModelException {
        return JavaModelUtil.findType(project, "java.lang.Object");
    }

    private static boolean isArray(IField field) throws JavaModelException {
        return Signature.getArrayCount((String)field.getTypeSignature()) > 0;
    }

    public static class Methods2Field {
        public IMethod fMethod = null;
        public IField fField = null;

        public Methods2Field(IMethod method, IField field) {
            this.fMethod = method;
            this.fField = field;
        }
    }
}

