/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.callhierarchy;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.internal.corext.callhierarchy.CallSearchResultCollector;

class MethodReferencesSearchCollector
implements IJavaSearchResultCollector {
    private CallSearchResultCollector fSearchResults = new CallSearchResultCollector();
    private IProgressMonitor fProgressMonitor;
    private boolean fRequireExactMatch = true;

    MethodReferencesSearchCollector() {
    }

    public Map getCallers() {
        return this.fSearchResults.getCallers();
    }

    public IProgressMonitor getProgressMonitor() {
        return this.fProgressMonitor;
    }

    public void aboutToStart() {
    }

    public void accept(IResource resource, int start, int end, IJavaElement enclosingElement, int accuracy) throws CoreException {
        if (this.fRequireExactMatch && accuracy != 0) {
            return;
        }
        if (enclosingElement != null && enclosingElement instanceof IMember) {
            IMember member = (IMember)enclosingElement;
            switch (enclosingElement.getElementType()) {
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.fSearchResults.addMember(member, member, start, end);
                }
            }
        }
    }

    public void done() {
    }

    void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }
}

