/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.callhierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodCall;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodReferencesSearchCollector;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.jdt.internal.ui.JavaPlugin;

class CallerMethodWrapper
extends MethodWrapper {
    public CallerMethodWrapper(MethodWrapper parent, MethodCall methodCall) {
        super(parent, methodCall);
    }

    protected IJavaSearchScope getSearchScope() {
        return CallHierarchy.getDefault().getSearchScope();
    }

    protected String getTaskName() {
        return CallHierarchyMessages.getString("CallerMethodWrapper.taskname");
    }

    protected MethodWrapper createMethodWrapper(MethodCall methodCall) {
        return new CallerMethodWrapper(this, methodCall);
    }

    protected Map findChildren(IProgressMonitor progressMonitor) {
        try {
            MethodReferencesSearchCollector searchCollector = new MethodReferencesSearchCollector();
            SearchEngine searchEngine = new SearchEngine();
            SubProgressMonitor monitor = new SubProgressMonitor(progressMonitor, 95, 2);
            Iterator iter = this.getMembers().iterator();
            while (iter.hasNext()) {
                this.checkCanceled(progressMonitor);
                IMember member = (IMember)iter.next();
                searchCollector.setProgressMonitor((IProgressMonitor)monitor);
                searchEngine.search(ResourcesPlugin.getWorkspace(), (IJavaElement)member, 2, this.getSearchScope(), (IJavaSearchResultCollector)searchCollector);
            }
            return searchCollector.getCallers();
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return new HashMap(0);
        }
    }

    private Collection getMembers() {
        ArrayList<IMember> result = new ArrayList<IMember>();
        result.add(this.getMember());
        return result;
    }

    public int getDirection() {
        return 1;
    }
}

