/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.callhierarchy;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public class CallLocation
implements IAdaptable {
    public static final int UNKNOWN_LINE_NUMBER = -1;
    private IMember fCalledMember;
    private IMember fMember;
    private String fCallText;
    private int fEnd;
    private int fStart;
    private int fLineNumber;
    static /* synthetic */ Class class$0;

    public CallLocation(IMember member, IMember calledMember, int start, int end) {
        this(member, calledMember, start, end, -1);
    }

    public CallLocation(IMember member, IMember calledMember, int start, int end, int lineNumber) {
        this.fMember = JavaModelUtil.toOriginal(member);
        this.fCalledMember = JavaModelUtil.toOriginal(calledMember);
        this.fStart = start;
        this.fEnd = end;
        this.fLineNumber = lineNumber;
    }

    public IMember getCalledMember() {
        return this.fCalledMember;
    }

    public int getEnd() {
        return this.fEnd;
    }

    public IMember getMember() {
        return this.fMember;
    }

    public int getStart() {
        return this.fStart;
    }

    public int getLineNumber() {
        CompilationUnit unit;
        if (this.fLineNumber == -1 && (unit = CallHierarchy.getCompilationUnitNode(this.fMember, false)) != null) {
            this.fLineNumber = unit.lineNumber(this.fStart);
        }
        return this.fLineNumber;
    }

    public String toString() {
        return this.getCallText();
    }

    public String getCallText() {
        if (this.fCallText == null) {
            try {
                IOpenable openable = this.fMember.getOpenable();
                if (openable == null) {
                    return "";
                }
                this.fCallText = openable.getBuffer().getText(this.fStart, this.fEnd - this.fStart);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return "";
            }
        }
        return this.fCallText;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.core.IJavaElement;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(adapter)) {
            return this.getMember();
        }
        return null;
    }
}

