/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.launcher;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileLock;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Main {
    protected boolean debug = false;
    protected String bootLocation = null;
    protected String installLocation = null;
    protected String configurationLocation;
    protected String framework = "org.eclipse.osgi";
    protected String devClassPath = null;
    protected boolean inDevelopmentMode = false;
    private String showSplash = null;
    private String endSplash = null;
    private boolean cmdInitialize = false;
    private Process showProcess = null;
    private boolean splashDown = false;
    private final Runnable endSplashHandler = new Runnable(){

        public void run() {
            Main.this.takeDownSplash();
        }
    };
    private static final String BOOT = "-boot";
    private static final String FRAMEWORK = "-framework";
    private static final String INSTALL = "-install";
    private static final String INITIALIZE = "-initialize";
    private static final String DEBUG = "-debug";
    private static final String DEV = "-dev";
    private static final String DATA = "-data";
    private static final String CONFIGURATION = "-configuration";
    private static final String SHOWSPLASH = "-showsplash";
    private static final String ENDSPLASH = "-endsplash";
    private static final String SPLASH_IMAGE = "splash.bmp";
    private static final String OSGI = "org.eclipse.osgi";
    private static final String STARTER = "org.eclipse.core.runtime.adaptor.EclipseStarter";
    private static final String PLATFORM_URL = "platform:/base/";
    private static final String CONFIG_FILE = "config.ini";
    private static final String CONFIG_FILE_TEMP_SUFFIX = ".tmp";
    private static final String CONFIG_FILE_BAK_SUFFIX = ".bak";
    private static final String USER_HOME = "user.home";
    private static final String USER_DIR = "user.dir";
    private static final String ECLIPSE = "eclipse";
    private static final String PRODUCT_SITE_MARKER = ".eclipseproduct";
    private static final String PRODUCT_SITE_ID = "id";
    private static final String PRODUCT_SITE_VERSION = "version";
    private static final String CFG_INSTALLLOCATION = "osgi.installLocation";
    private static final String CFG_FRAMEWORK = "osgi.framework";
    private static final String CFG_SPLASHPATH = "osgi.splashPath";
    private static final String CFG_SPLASHLOCATION = "osgi.splashLocation";
    private static final String CFG_CLASSPATH = "osgi.frameworkClassPath";
    private static final String CFG_EOF = "eof";
    protected static final String SESSION = "!SESSION";
    protected static final String ENTRY = "!ENTRY";
    protected static final String MESSAGE = "!MESSAGE";
    protected static final String STACK = "!STACK";
    protected static final int ERROR = 4;
    protected static final String PLUGIN_ID = "org.eclipse.core.launcher";
    protected static File logFile = null;
    protected static BufferedWriter log = null;
    protected static boolean newSession = true;
    protected static String[] arguments;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    protected Object basicRun(String[] args) throws Exception {
        URL[] bootPath = this.getBootPath(this.bootLocation);
        this.handleSplash(bootPath);
        URLClassLoader loader = new URLClassLoader(bootPath, null);
        Class<?> clazz = loader.loadClass(STARTER);
        Class[] classArray = new Class[2];
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("[Ljava.lang.Runnable;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz3;
        Method method = clazz.getDeclaredMethod("run", classArray);
        try {
            return method.invoke(clazz, args, this.endSplashHandler);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            if (e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw e;
        }
    }

    private String decode(String urlString) {
        try {
            Object result;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("[Ljava.net.URLDecoder;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            Class[] classArray = new Class[2];
            Class<?> clazz3 = class$3;
            if (clazz3 == null) {
                try {
                    clazz3 = class$3 = Class.forName("[Ljava.lang.String;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz3;
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("[Ljava.lang.String;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz4;
            Method method = clazz2.getDeclaredMethod("decode", classArray);
            if (urlString.indexOf(43) >= 0) {
                int len = urlString.length();
                StringBuffer buf = new StringBuffer(len);
                int i = 0;
                while (i < len) {
                    char c = urlString.charAt(i);
                    if (c == '+') {
                        buf.append("%2B");
                    } else {
                        buf.append(c);
                    }
                    ++i;
                }
                urlString = buf.toString();
            }
            if ((result = method.invoke(null, urlString, "UTF-8")) != null) {
                return (String)result;
            }
        }
        catch (Exception exception) {}
        boolean replaced = false;
        byte[] encodedBytes = urlString.getBytes();
        int encodedLength = encodedBytes.length;
        byte[] decodedBytes = new byte[encodedLength];
        int decodedLength = 0;
        int i = 0;
        while (i < encodedLength) {
            byte b = encodedBytes[i];
            if (b == 37) {
                byte enc1 = encodedBytes[++i];
                byte enc2 = encodedBytes[++i];
                b = (byte)((this.hexToByte(enc1) << 4) + this.hexToByte(enc2));
                replaced = true;
            }
            decodedBytes[decodedLength++] = b;
            ++i;
        }
        if (!replaced) {
            return urlString;
        }
        try {
            return new String(decodedBytes, 0, decodedLength, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(decodedBytes, 0, decodedLength);
        }
    }

    private String[] getArrayFromList(String prop) {
        if (prop == null || prop.trim().equals("")) {
            return new String[0];
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(prop, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[list.size()]);
    }

    private URL[] getDevPath(URL base) throws IOException {
        String devBase = base.toExternalForm();
        ArrayList result = new ArrayList(5);
        if (this.inDevelopmentMode) {
            this.addDevEntries(devBase, result);
        }
        this.addBaseJars(devBase, result);
        return result.toArray(new URL[result.size()]);
    }

    private void addBaseJars(String devBase, ArrayList result) throws IOException {
        String baseJarList = System.getProperty(CFG_CLASSPATH);
        if (baseJarList == null) {
            Properties defaults = this.loadProperties(new URL(String.valueOf(devBase) + "eclipse.properties"));
            baseJarList = defaults.getProperty(CFG_CLASSPATH);
            if (baseJarList == null) {
                throw new IOException("Unable to initialize osgi.frameworkClassPath");
            }
            System.getProperties().put(CFG_CLASSPATH, baseJarList);
        }
        String[] baseJars = this.getArrayFromList(baseJarList);
        int i = 0;
        while (i < baseJars.length) {
            String string = baseJars[i];
            try {
                URL url = new URL(string);
                this.addEntry(url, result);
            }
            catch (MalformedURLException malformedURLException) {
                this.addEntry(new URL(String.valueOf(devBase) + string), result);
            }
            ++i;
        }
    }

    private void addEntry(URL url, List result) {
        if (new File(url.getFile()).exists()) {
            result.add(url);
        }
    }

    private void addDevEntries(String devBase, List result) throws MalformedURLException {
        String[] locations = this.getArrayFromList(this.devClassPath);
        int i = 0;
        while (i < locations.length) {
            String spec = String.valueOf(devBase) + locations[i];
            char lastChar = spec.charAt(spec.length() - 1);
            URL url = spec.endsWith(".jar") || lastChar == '/' || lastChar == '\\' ? new URL(spec) : new URL(String.valueOf(spec) + "/");
            this.addEntry(url, result);
            ++i;
        }
    }

    private URL[] getBootPath(String base) throws IOException {
        URL url = null;
        if (base != null) {
            url = new URL(base);
        } else {
            url = new URL(this.getInstallLocation());
            String path = String.valueOf(url.getFile()) + "/plugins";
            if ((path = this.searchFor(this.framework, path)) == null) {
                throw new RuntimeException("Could not find framework");
            }
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), path);
        }
        if (System.getProperty(CFG_FRAMEWORK) == null) {
            System.getProperties().put(CFG_FRAMEWORK, url.toExternalForm());
        }
        if (this.debug) {
            System.out.println("Framework located:\n    " + url.toExternalForm());
        }
        URL[] result = this.getDevPath(url);
        if (this.debug) {
            System.out.println("Framework classpath:");
            int i = 0;
            while (i < result.length) {
                System.out.println("    " + result[i].toExternalForm());
                ++i;
            }
        }
        return result;
    }

    private String searchFor(final String target, String start) {
        FileFilter filter = new FileFilter(){

            public boolean accept(File candidate) {
                return candidate.isDirectory() && (candidate.getName().equals(target) || candidate.getName().startsWith(String.valueOf(target) + "_"));
            }
        };
        File[] candidates = new File(start).listFiles(filter);
        if (candidates == null) {
            return null;
        }
        String result = null;
        Object[] maxVersion = null;
        int i = 0;
        while (i < candidates.length) {
            String name = candidates[i].getName();
            String version = "";
            int index = name.indexOf(95);
            if (index != -1) {
                version = name.substring(index + 1);
            }
            Object[] currentVersion = this.getVersionElements(version);
            if (maxVersion == null) {
                result = candidates[i].getAbsolutePath();
                maxVersion = currentVersion;
            } else if (Main.compareVersion(maxVersion, currentVersion) < 0) {
                result = candidates[i].getAbsolutePath();
                maxVersion = currentVersion;
            }
            ++i;
        }
        if (result == null) {
            return null;
        }
        return String.valueOf(result.replace(File.separatorChar, '/')) + "/";
    }

    private static int compareVersion(Object[] left, Object[] right) {
        int result = ((Integer)left[0]).compareTo((Integer)right[0]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[1]).compareTo((Integer)right[1]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[2]).compareTo((Integer)right[2]);
        if (result != 0) {
            return result;
        }
        return ((String)left[3]).compareTo((String)right[3]);
    }

    private Object[] getVersionElements(String version) {
        Object[] result = new Object[]{new Integer(0), new Integer(0), new Integer(0), ""};
        StringTokenizer t = new StringTokenizer(version, ".");
        int i = 0;
        while (t.hasMoreTokens() && i < 4) {
            String token = t.nextToken();
            if (i < 3) {
                try {
                    result[i++] = new Integer(token);
                    continue;
                }
                catch (Exception exception) {
                    break;
                }
            }
            result[i++] = token;
        }
        return result;
    }

    public static void main(String[] args) {
        arguments = args;
        if (!Main.isCompatible()) {
            System.exit(14);
        }
        if (Main.isAlreadyRunning()) {
            System.exit(15);
        }
        Main launcher = new Main();
        try {
            launcher.run(args);
        }
        catch (Throwable e) {
            launcher.takeDownSplash();
            Main.log("Exception launching the Eclipse Platform:");
            Main.log(e);
            System.exit(13);
        }
    }

    public static void main(String argString) throws Exception {
        Vector<Object> list = new Vector<Object>(5);
        StringTokenizer tokens = new StringTokenizer(argString, " ");
        while (tokens.hasMoreElements()) {
            list.addElement(tokens.nextElement());
        }
        Main.main(list.toArray(new String[list.size()]));
    }

    protected String[] processCommandLine(String[] args) throws Exception {
        int[] configArgs = new int[100];
        configArgs[0] = -1;
        int configArgIndex = 0;
        int i = 0;
        while (i < args.length) {
            boolean found = false;
            if (args[i].equalsIgnoreCase(DEBUG)) {
                this.debug = true;
            } else if (args[i].equalsIgnoreCase(INITIALIZE)) {
                this.cmdInitialize = true;
            } else if (args[i].equalsIgnoreCase(DEV) && (i + 1 == args.length || i + 1 < args.length && args[i + 1].startsWith("-"))) {
                this.inDevelopmentMode = true;
            } else if (found) {
                configArgs[configArgIndex++] = i;
            } else if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase(BOOT)) {
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(FRAMEWORK)) {
                    this.framework = arg;
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(INSTALL)) {
                    this.setInstallLocation(arg);
                    found = true;
                }
                if (args[i - 1].equalsIgnoreCase(DEV)) {
                    this.inDevelopmentMode = true;
                    this.devClassPath = arg;
                } else {
                    if (args[i - 1].equalsIgnoreCase(CONFIGURATION)) {
                        this.configurationLocation = arg;
                        found = true;
                    }
                    if (args[i - 1].equalsIgnoreCase(SHOWSPLASH)) {
                        this.showSplash = arg;
                        found = true;
                    }
                    if (args[i - 1].equalsIgnoreCase(ENDSPLASH)) {
                        this.endSplash = arg;
                        found = true;
                    }
                    if (found) {
                        configArgs[configArgIndex++] = i - 1;
                        configArgs[configArgIndex++] = i;
                    }
                }
            }
            ++i;
        }
        if (configArgIndex == 0) {
            return args;
        }
        String[] passThruArgs = new String[args.length - configArgIndex];
        configArgIndex = 0;
        int j = 0;
        int i2 = 0;
        while (i2 < args.length) {
            if (i2 == configArgs[configArgIndex]) {
                ++configArgIndex;
            } else {
                passThruArgs[j++] = args[i2];
            }
            ++i2;
        }
        return passThruArgs;
    }

    public Object run(String[] args) throws Exception {
        System.getProperties().setProperty("eclipse.debug.startupTime", Long.toString(System.currentTimeMillis()));
        String[] passThruArgs = this.processCommandLine(args);
        this.setConfigurationLocation();
        passThruArgs = this.processConfiguration(passThruArgs);
        this.getInstallLocation();
        return this.basicRun(passThruArgs);
    }

    private void setConfigurationLocation() {
        String location = System.getProperty("osgi.configuration.area");
        if (location != null) {
            this.configurationLocation = location;
            return;
        }
        if (this.configurationLocation == null || this.configurationLocation.trim().length() == 0) {
            this.configurationLocation = String.valueOf(this.computeDefaultConfigurationLocation()) + "/.config";
        } else {
            this.configurationLocation = this.configurationLocation.replace(File.separatorChar, '/');
            String tmp = null;
            if (this.configurationLocation.equalsIgnoreCase(USER_HOME)) {
                tmp = System.getProperty(USER_HOME);
            } else if (this.configurationLocation.equalsIgnoreCase(USER_DIR)) {
                tmp = System.getProperty(USER_DIR);
            }
            if (tmp != null) {
                if (!tmp.endsWith(File.separator)) {
                    tmp = String.valueOf(tmp) + File.separator;
                }
                this.configurationLocation = "file:" + tmp.replace(File.separatorChar, '/') + "/.config";
            } else {
                int index = this.configurationLocation.lastIndexOf(47);
                if (this.configurationLocation.endsWith(".cfg") || this.configurationLocation.endsWith("/")) {
                    this.configurationLocation = this.configurationLocation.substring(0, index);
                }
            }
            try {
                this.configurationLocation = new URL(this.configurationLocation).getFile();
            }
            catch (MalformedURLException malformedURLException) {}
        }
        System.getProperties().put("osgi.configuration.area", this.configurationLocation);
    }

    private String[] processConfiguration(String[] passThruArgs) throws MalformedURLException {
        URL configURL = null;
        if (this.configurationLocation != null && this.configurationLocation.trim().length() != 0) {
            configURL = new URL("file:" + this.configurationLocation + "/" + CONFIG_FILE);
        }
        this.loadConfiguration(configURL);
        String urlString = System.getProperty(CFG_FRAMEWORK, null);
        if (urlString != null) {
            if (!urlString.endsWith("/")) {
                urlString = String.valueOf(urlString) + "/";
                System.getProperties().put(CFG_FRAMEWORK, urlString);
            }
            this.bootLocation = this.resolve(urlString);
        }
        return passThruArgs;
    }

    private String getInstallLocation() {
        if (this.installLocation != null) {
            return this.installLocation;
        }
        this.installLocation = System.getProperty(CFG_INSTALLLOCATION);
        if (this.installLocation != null) {
            return this.installLocation;
        }
        URL result = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        String path = this.decode(result.getFile());
        path = new File(path).getAbsolutePath().replace(File.separatorChar, '/');
        if (File.separatorChar == '\\' && Character.isUpperCase(path.charAt(0))) {
            char[] chars = path.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            path = new String(chars);
        }
        if (path.endsWith(".jar")) {
            path = path.substring(0, path.lastIndexOf("/") + 1);
        }
        try {
            result = new URL(result.getProtocol(), result.getHost(), result.getPort(), path);
        }
        catch (MalformedURLException malformedURLException) {}
        this.setInstallLocation(result.toExternalForm());
        return result.toExternalForm();
    }

    private String computeDefaultConfigurationLocation() {
        String install = this.getInstallLocation();
        File installDir = new File(install.substring(5));
        if (install.startsWith("file:") && installDir.canWrite()) {
            if (this.debug) {
                System.out.println("Using the installation directory.");
            }
            return installDir.getAbsolutePath();
        }
        if (this.debug) {
            System.out.println("Using the user.home location.");
        }
        String appName = ".eclipse";
        File eclipseProduct = new File(installDir, PRODUCT_SITE_MARKER);
        if (eclipseProduct.exists()) {
            Properties props = new Properties();
            try {
                String appVersion;
                props.load(new FileInputStream(eclipseProduct));
                String appId = props.getProperty(PRODUCT_SITE_ID);
                if (appId == null || appId.trim().length() == 0) {
                    appId = ECLIPSE;
                }
                if ((appVersion = props.getProperty(PRODUCT_SITE_VERSION)) == null || appVersion.trim().length() == 0) {
                    appVersion = "";
                }
                appName = String.valueOf(appName) + File.separator + appId + "_" + appVersion;
            }
            catch (IOException iOException) {}
        }
        String userHome = System.getProperty(USER_HOME);
        File configDir = new File(userHome, appName);
        configDir.mkdirs();
        return configDir.getAbsolutePath();
    }

    private Properties loadConfiguration(URL url) {
        Properties result;
        block11: {
            if (url == null) {
                try {
                    String location = this.computeDefaultConfigurationLocation();
                    url = new URL(String.valueOf(location) + "/" + CONFIG_FILE);
                }
                catch (IOException iOException) {}
            }
            result = null;
            try {
                result = this.loadProperties(url);
                if (this.debug) {
                    System.out.println("Configuration file:\n    " + url.toString());
                }
            }
            catch (IOException iOException) {
                try {
                    String location = this.getInstallLocation().replace('/', File.separatorChar);
                    if (!location.endsWith(File.separator)) {
                        location = String.valueOf(location) + File.separator;
                    }
                    location = String.valueOf(location) + ".config" + File.separator + CONFIG_FILE;
                    url = new URL(location);
                    result = this.loadProperties(url);
                    if (this.debug) {
                        System.out.println("Configuration file\n    " + url.toString());
                    }
                }
                catch (IOException e1) {
                    if (!this.debug) break block11;
                    System.out.println("Unable to load configuration\n" + e1);
                }
            }
        }
        if (result != null) {
            this.mergeProperties(System.getProperties(), result);
        }
        return result;
    }

    private Properties loadProperties(URL url) throws IOException {
        Properties result = null;
        IOException originalException = null;
        try {
            result = this.load(url, null);
        }
        catch (IOException e1) {
            originalException = e1;
            try {
                result = this.load(url, CONFIG_FILE_TEMP_SUFFIX);
            }
            catch (IOException iOException) {
                try {
                    result = this.load(url, CONFIG_FILE_BAK_SUFFIX);
                }
                catch (IOException iOException2) {
                    throw originalException;
                }
            }
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private Properties load(URL url, String suffix) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 149->152)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleSplash(URL[] defaultPath) {
        if (this.cmdInitialize) {
            this.showSplash = null;
            this.endSplash = null;
            return;
        }
        if (this.endSplash != null) {
            this.showSplash = null;
            return;
        }
        if (this.showSplash == null) {
            return;
        }
        String location = this.getSplashLocation(defaultPath);
        if (this.debug) {
            System.out.println("Splash path:\n    " + location);
        }
        if (location == null) {
            return;
        }
        String[] cmd = new String[location != null ? 4 : 3];
        int sIndex = 0;
        int eIndex = this.showSplash.indexOf(" -show");
        if (eIndex == -1) {
            return;
        }
        cmd[0] = this.showSplash.substring(sIndex, eIndex);
        sIndex = eIndex + 1;
        if ((eIndex = this.showSplash.indexOf(" ", sIndex)) == -1) {
            return;
        }
        cmd[1] = this.showSplash.substring(sIndex, eIndex);
        cmd[2] = this.showSplash.substring(eIndex + 1);
        if (location != null) {
            cmd[3] = location;
        }
        try {
            this.showProcess = Runtime.getRuntime().exec(cmd);
        }
        catch (Exception e) {
            Main.log("Exception showing splash screen.");
            Main.log(e);
        }
    }

    protected void takeDownSplash() {
        if (this.splashDown) {
            return;
        }
        if (this.endSplash != null) {
            try {
                Runtime.getRuntime().exec(this.endSplash);
            }
            catch (Exception exception) {}
        }
        if (this.showProcess != null) {
            this.showProcess.destroy();
            this.showProcess = null;
        }
        this.splashDown = true;
    }

    private String getSplashLocation(URL[] bootPath) {
        int pix;
        String result = System.getProperty(CFG_SPLASHLOCATION);
        if (result != null) {
            return result;
        }
        String splashPath = System.getProperty(CFG_SPLASHPATH);
        if (splashPath != null) {
            String[] entries = this.getArrayFromList(splashPath);
            ArrayList<String> path = new ArrayList<String>(entries.length);
            int i = 0;
            while (i < entries.length) {
                String entry = this.resolve(entries[i]);
                if (entry == null || entry.startsWith("file:")) {
                    File entryFile = new File(entry.substring(5).replace('/', File.separatorChar));
                    if ((entry = this.searchFor(entryFile.getName(), entryFile.getParent())) != null) {
                        path.add(entry);
                    }
                } else {
                    Main.log("Invalid splash path entry: " + entries[i]);
                }
                ++i;
            }
            result = this.searchForSplash(path.toArray(new String[path.size()]));
            if (result != null) {
                System.getProperties().put(CFG_SPLASHLOCATION, result);
                return result;
            }
        }
        String temp = bootPath[0].getFile();
        int ix = (temp = temp.replace('/', File.separatorChar)).lastIndexOf("plugins" + File.separator);
        if (ix != -1 && (pix = temp.indexOf(File.separator, ix + 8)) != -1 && (result = this.searchForSplash(new String[]{temp = temp.substring(0, pix)})) != null) {
            System.getProperties().put(CFG_SPLASHLOCATION, result);
        }
        return result;
    }

    private String searchForSplash(String[] searchPath) {
        if (searchPath == null) {
            return null;
        }
        String localePath = Locale.getDefault().toString().replace('_', File.separatorChar);
        while (localePath != null) {
            int ix;
            String suffix = localePath.equals("") ? SPLASH_IMAGE : "nl" + File.separator + localePath + File.separator + SPLASH_IMAGE;
            int i = 0;
            while (i < searchPath.length) {
                File result;
                String path = searchPath[i];
                if (!path.endsWith(File.separator)) {
                    path = String.valueOf(path) + File.separator;
                }
                if ((result = new File(path = String.valueOf(path) + suffix)).exists()) {
                    return result.getAbsolutePath();
                }
                ++i;
            }
            localePath = localePath.equals("") ? null : ((ix = localePath.lastIndexOf(File.separator)) == -1 ? "" : localePath.substring(0, ix));
        }
        return null;
    }

    private String resolve(String urlString) {
        if (urlString.startsWith("reference:")) {
            urlString = urlString.substring(10);
            System.getProperties().put(CFG_FRAMEWORK, urlString);
        }
        if (urlString.startsWith(PLATFORM_URL)) {
            String root = this.getInstallLocation();
            if (!root.endsWith("/")) {
                root = String.valueOf(root) + "/";
            }
            String path = urlString.substring(PLATFORM_URL.length());
            return String.valueOf(root) + path;
        }
        return urlString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized void log(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            block16: {
                try {
                    block15: {
                        Main.openLogFile();
                        try {
                            if (newSession) {
                                log.write(SESSION);
                                log.write(32);
                                int i = SESSION.length();
                                while (true) {
                                    if (i >= 78) {
                                        log.newLine();
                                        newSession = false;
                                        break;
                                    }
                                    log.write(45);
                                    ++i;
                                }
                            }
                            Main.write(obj);
                            Object var2_5 = null;
                            if (logFile != null) break block15;
                            if (log == null) break block16;
                        }
                        catch (Throwable throwable) {
                            Object var2_4 = null;
                            if (logFile == null) {
                                if (log == null) throw throwable;
                                log.flush();
                                throw throwable;
                            }
                            Main.closeLogFile();
                            throw throwable;
                        }
                        log.flush();
                        break block16;
                    }
                    Main.closeLogFile();
                }
                catch (Exception e) {
                    System.err.println("An exception occurred while writing to the platform log:");
                    e.printStackTrace(System.err);
                    System.err.println("Logging to the console instead.");
                    try {
                        log = Main.logForStream(System.err);
                        Main.write(obj);
                        log.flush();
                    }
                    catch (Exception e2) {
                        System.err.println("An exception occurred while logging to the console:");
                        e2.printStackTrace(System.err);
                    }
                }
            }
            Object var4_9 = null;
            log = null;
            return;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            log = null;
            throw throwable;
        }
    }

    private static void write(Object obj) throws IOException {
        if (obj == null) {
            return;
        }
        if (obj instanceof Throwable) {
            log.write(STACK);
            log.newLine();
            ((Throwable)obj).printStackTrace(new PrintWriter(log));
        } else {
            log.write(ENTRY);
            log.write(32);
            log.write(PLUGIN_ID);
            log.write(32);
            log.write(String.valueOf(4));
            log.write(32);
            log.write(String.valueOf(0));
            log.write(32);
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy kk:mm:ss.SS");
                log.write(formatter.format(new Date()));
            }
            catch (Exception exception) {
                log.write(Long.toString(System.currentTimeMillis()));
            }
            log.newLine();
            log.write(MESSAGE);
            log.write(32);
            log.write(String.valueOf(obj));
        }
        log.newLine();
    }

    private static void computeLogFileLocation() {
        if (logFile != null) {
            return;
        }
        File base = Main.computeMetadataLocation();
        logFile = new File(base, ".log");
        logFile.getParentFile().mkdirs();
    }

    private static File computeLockFileLocation() {
        File base = Main.computeMetadataLocation();
        File result = new File(base, ".lock");
        result.getParentFile().mkdirs();
        return result;
    }

    private static File computeMetadataLocation() {
        File result = null;
        int i = 0;
        while (arguments != null && result == null && i < arguments.length) {
            if (arguments[i].equalsIgnoreCase(DATA) && i + 1 < arguments.length) {
                result = new File(arguments[i + 1]);
            }
            ++i;
        }
        if (result == null) {
            result = new File(System.getProperty(USER_DIR), "workspace");
        }
        return new File(result, ".metadata");
    }

    private int hexToByte(byte b) {
        switch (b) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: 
            case 97: {
                return 10;
            }
            case 66: 
            case 98: {
                return 11;
            }
            case 67: 
            case 99: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 69: 
            case 101: {
                return 14;
            }
            case 70: 
            case 102: {
                return 15;
            }
        }
        throw new IllegalArgumentException("Switch error decoding URL");
    }

    private static void openLogFile() throws IOException {
        Main.computeLogFileLocation();
        try {
            log = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(logFile.getAbsolutePath(), true), "UTF-8"));
        }
        catch (IOException e) {
            logFile = null;
            throw e;
        }
    }

    private static BufferedWriter logForStream(OutputStream output) {
        try {
            return new BufferedWriter(new OutputStreamWriter(output, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new BufferedWriter(new OutputStreamWriter(output));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void closeLogFile() throws IOException {
        try {
            if (log != null) {
                log.flush();
                log.close();
            }
        }
        catch (Throwable throwable) {
            Object var0_1 = null;
            log = null;
            throw throwable;
        }
        {
            Object var0_2 = null;
            log = null;
            return;
        }
    }

    private void setInstallLocation(String location) {
        this.installLocation = location;
        System.getProperties().setProperty(CFG_INSTALLLOCATION, this.installLocation);
    }

    private static boolean isCompatible() {
        try {
            String vmVersionString = System.getProperty("java.version");
            Identifier minimum = new Identifier(1, 3, 0);
            Identifier version = new Identifier(vmVersionString);
            return version.isGreaterEqualTo(minimum);
        }
        catch (SecurityException securityException) {
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isAlreadyRunning() {
        boolean bl;
        if (System.getProperty("org.eclipse.core.runtime.ignoreLockFile") != null) {
            return false;
        }
        File lockFile = Main.computeLockFileLocation();
        FileOutputStream stream = null;
        try {
            try {
                stream = new FileOutputStream(lockFile, true);
                FileLock lock = stream.getChannel().tryLock();
                bl = lock == null;
                Object var3_4 = null;
                if (stream == null) return bl;
            }
            catch (IOException iOException) {
                Object var3_5 = null;
                if (stream == null) return false;
                try {
                    stream.close();
                    return false;
                }
                catch (IOException iOException2) {}
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            if (stream == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            stream.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        stream.close();
        return bl;
    }

    private void mergeProperties(Properties destination, Properties source) {
        Enumeration<Object> e = source.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.equals(CFG_EOF)) continue;
            String value = source.getProperty(key);
            if (destination.getProperty(key) != null) continue;
            destination.put(key, value);
        }
    }

    static class Identifier {
        private static final String DELIM = ". ";
        private int major;
        private int minor;
        private int service;

        Identifier(int major, int minor, int service) {
            this.major = major;
            this.minor = minor;
            this.service = service;
        }

        Identifier(String versionString) {
            StringTokenizer tokenizer = new StringTokenizer(versionString, DELIM);
            if (tokenizer.hasMoreTokens()) {
                this.major = Integer.parseInt(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                this.minor = Integer.parseInt(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                this.service = Integer.parseInt(tokenizer.nextToken());
            }
        }

        boolean isGreaterEqualTo(Identifier minimum) {
            if (this.major < minimum.major) {
                return false;
            }
            if (this.major > minimum.major) {
                return true;
            }
            if (this.minor < minimum.minor) {
                return false;
            }
            if (this.minor > minimum.minor) {
                return true;
            }
            return this.service >= minimum.service;
        }
    }
}

