/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.properties;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeEditor;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.ICellEditorActivationListener;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetEntryListener;
import org.eclipse.ui.views.properties.PropertiesMessages;
import org.eclipse.ui.views.properties.PropertySheetCategory;

class PropertySheetViewer
extends Viewer {
    private Object[] input;
    private IPropertySheetEntry rootEntry;
    private PropertySheetCategory[] categories;
    private TableTree tableTree;
    private TableTreeEditor tableTreeEditor;
    private static String[] columnLabels = new String[]{PropertiesMessages.getString("PropertyViewer.property"), PropertiesMessages.getString("PropertyViewer.value")};
    private static String MISCELLANEOUS_CATEGORY_NAME = PropertiesMessages.getString("PropertyViewer.misc");
    private int columnToEdit = 1;
    private CellEditor cellEditor;
    private IPropertySheetEntryListener entryListener;
    private ICellEditorListener editorListener;
    private boolean isShowingCategories = true;
    private boolean isShowingExpertProperties = false;
    private IStatusLineManager statusLineManager;
    private ListenerList activationListeners = new ListenerList(3);

    public PropertySheetViewer(Composite parent) {
        this.tableTree = new TableTree(parent, 98308);
        Table table = this.tableTree.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.addColumns();
        this.hookControl();
        this.tableTreeEditor = new TableTreeEditor(this.tableTree);
        this.createEntryListener();
        this.createEditorListener();
    }

    private void activateCellEditor(TableTreeItem item) {
        this.tableTree.showSelection();
        IPropertySheetEntry activeEntry = (IPropertySheetEntry)item.getData();
        this.cellEditor = activeEntry.getEditor((Composite)this.tableTree.getTable());
        if (this.cellEditor == null) {
            return;
        }
        this.cellEditor.activate();
        Control control = this.cellEditor.getControl();
        if (control == null) {
            this.cellEditor.deactivate();
            this.cellEditor = null;
            return;
        }
        this.cellEditor.addListener(this.editorListener);
        CellEditor.LayoutData layout = this.cellEditor.getLayoutData();
        this.tableTreeEditor.horizontalAlignment = layout.horizontalAlignment;
        this.tableTreeEditor.grabHorizontal = layout.grabHorizontal;
        this.tableTreeEditor.minimumWidth = layout.minimumWidth;
        this.tableTreeEditor.setEditor(control, item, this.columnToEdit);
        this.setErrorMessage(this.cellEditor.getErrorMessage());
        this.cellEditor.setFocus();
        this.fireCellEditorActivated(this.cellEditor);
    }

    void addActivationListener(ICellEditorActivationListener listener) {
        this.activationListeners.add((Object)listener);
    }

    private void addColumns() {
        Table table = this.tableTree.getTable();
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columnLabels.length) {
            String string = columnLabels[i];
            if (string != null) {
                TableColumn column = i < columns.length ? columns[i] : new TableColumn(table, 0);
                column.setText(string);
            }
            ++i;
        }
        ColumnWeightData c1Layout = new ColumnWeightData(40, false);
        ColumnWeightData c2Layout = new ColumnWeightData(60, true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)c1Layout);
        layout.addColumnData((ColumnLayoutData)c2Layout);
        table.setLayout((Layout)layout);
    }

    private void applyEditorValue() {
        TableTreeItem treeItem = this.tableTreeEditor.getItem();
        if (treeItem == null || treeItem.isDisposed()) {
            return;
        }
        IPropertySheetEntry entry = (IPropertySheetEntry)treeItem.getData();
        entry.applyEditorValue();
    }

    private void createChildren(Widget widget) {
        Object node;
        List children;
        TableTreeItem[] childItems = widget == this.tableTree ? this.tableTree.getItems() : ((TableTreeItem)widget).getItems();
        if (childItems.length > 0) {
            Object data = childItems[0].getData();
            if (data != null) {
                return;
            }
            childItems[0].dispose();
        }
        if ((children = this.getChildren(node = widget.getData())).isEmpty()) {
            return;
        }
        int i = 0;
        while (i < children.size()) {
            this.createItem(children.get(i), widget, i);
            ++i;
        }
    }

    private void createEditorListener() {
        this.editorListener = new ICellEditorListener(){

            public void cancelEditor() {
                PropertySheetViewer.this.deactivateCellEditor();
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void applyEditorValue() {
            }
        };
    }

    private void createEntryListener() {
        this.entryListener = new IPropertySheetEntryListener(){

            public void childEntriesChanged(IPropertySheetEntry entry) {
                if (entry == PropertySheetViewer.this.rootEntry) {
                    PropertySheetViewer.this.updateChildrenOf(entry, (Widget)PropertySheetViewer.this.tableTree);
                } else {
                    TableTreeItem item = PropertySheetViewer.this.findItem(entry);
                    if (item != null) {
                        PropertySheetViewer.this.updateChildrenOf(entry, (Widget)item);
                    }
                }
            }

            public void valueChanged(IPropertySheetEntry entry) {
                TableTreeItem item = PropertySheetViewer.this.findItem(entry);
                if (item != null) {
                    PropertySheetViewer.this.updateEntry(entry, item);
                }
            }

            public void errorMessageChanged(IPropertySheetEntry entry) {
                PropertySheetViewer.this.setErrorMessage(entry.getErrorText());
            }
        };
    }

    private void createItem(Object node, Widget parent, int i) {
        TableTreeItem item = parent instanceof TableTreeItem ? new TableTreeItem((TableTreeItem)parent, 0, i) : new TableTreeItem((TableTree)parent, 0, i);
        item.setData(node);
        if (node instanceof IPropertySheetEntry) {
            ((IPropertySheetEntry)node).addPropertySheetEntryListener(this.entryListener);
        }
        if (node instanceof IPropertySheetEntry) {
            this.updateEntry((IPropertySheetEntry)node, item);
        } else {
            this.updateCategory((PropertySheetCategory)node, item);
        }
    }

    void deactivateCellEditor() {
        this.tableTreeEditor.setEditor(null, null, this.columnToEdit);
        if (this.cellEditor != null) {
            this.cellEditor.deactivate();
            this.fireCellEditorDeactivated(this.cellEditor);
            this.cellEditor.removeListener(this.editorListener);
            this.cellEditor = null;
        }
        this.setErrorMessage(null);
    }

    private void entrySelectionChanged() {
        SelectionChangedEvent changeEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        this.fireSelectionChanged(changeEvent);
    }

    private TableTreeItem findItem(IPropertySheetEntry entry) {
        TableTreeItem[] items = this.tableTree.getItems();
        int i = 0;
        while (i < items.length) {
            TableTreeItem item = items[i];
            TableTreeItem findItem = this.findItem(entry, item);
            if (findItem != null) {
                return findItem;
            }
            ++i;
        }
        return null;
    }

    private TableTreeItem findItem(IPropertySheetEntry entry, TableTreeItem item) {
        if (entry == item.getData()) {
            return item;
        }
        TableTreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            TableTreeItem childItem = items[i];
            TableTreeItem findItem = this.findItem(entry, childItem);
            if (findItem != null) {
                return findItem;
            }
            ++i;
        }
        return null;
    }

    private void fireCellEditorActivated(CellEditor cellEditor) {
        Object[] listeners = this.activationListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ICellEditorActivationListener)listeners[i]).cellEditorActivated(cellEditor);
            ++i;
        }
    }

    private void fireCellEditorDeactivated(CellEditor cellEditor) {
        Object[] listeners = this.activationListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ICellEditorActivationListener)listeners[i]).cellEditorDeactivated(cellEditor);
            ++i;
        }
    }

    public CellEditor getActiveCellEditor() {
        return this.cellEditor;
    }

    private List getChildren(Object node) {
        IPropertySheetEntry entry = null;
        PropertySheetCategory category = null;
        if (node instanceof IPropertySheetEntry) {
            entry = (IPropertySheetEntry)node;
        } else {
            category = (PropertySheetCategory)node;
        }
        List children = category == null ? this.getChildren(entry) : this.getChildren(category);
        return children;
    }

    private List getChildren(IPropertySheetEntry entry) {
        if (entry == this.rootEntry && this.isShowingCategories && (this.categories.length > 1 || this.categories.length == 1 && !this.categories[0].getCategoryName().equals(MISCELLANEOUS_CATEGORY_NAME))) {
            return Arrays.asList(this.categories);
        }
        return this.getFilteredEntries(entry.getChildEntries());
    }

    private List getChildren(PropertySheetCategory category) {
        return this.getFilteredEntries(category.getChildEntries());
    }

    public Control getControl() {
        return this.tableTree;
    }

    private List getFilteredEntries(IPropertySheetEntry[] entires) {
        if (this.isShowingExpertProperties) {
            return Arrays.asList(entires);
        }
        ArrayList<IPropertySheetEntry> filteredEntries = new ArrayList<IPropertySheetEntry>(entires.length);
        int i = 0;
        while (i < entires.length) {
            String[] filters = entires[i].getFilters();
            boolean expert = false;
            if (filters != null) {
                int j = 0;
                while (j < filters.length) {
                    if (filters[j].equals("org.eclipse.ui.views.properties.expert")) {
                        expert = true;
                        break;
                    }
                    ++j;
                }
            }
            if (!expert) {
                filteredEntries.add(entires[i]);
            }
            ++i;
        }
        return filteredEntries;
    }

    public Object getInput() {
        return this.input;
    }

    public IPropertySheetEntry getRootEntry() {
        return this.rootEntry;
    }

    public ISelection getSelection() {
        if (this.tableTree.getSelectionCount() == 0) {
            return StructuredSelection.EMPTY;
        }
        TableTreeItem[] sel = this.tableTree.getSelection();
        ArrayList<Object> entries = new ArrayList<Object>(sel.length);
        int i = 0;
        while (i < sel.length) {
            TableTreeItem ti = sel[i];
            Object data = ti.getData();
            if (data instanceof IPropertySheetEntry) {
                entries.add(data);
            }
            ++i;
        }
        return new StructuredSelection(entries);
    }

    private void handleSelect(TableTreeItem selection) {
        TableTreeItem[] sel;
        if (this.cellEditor != null) {
            this.applyEditorValue();
            this.deactivateCellEditor();
        }
        if ((sel = new TableTreeItem[]{selection}).length == 0) {
            this.setMessage(null);
            this.setErrorMessage(null);
        } else {
            Object object = sel[0].getData();
            if (object instanceof IPropertySheetEntry) {
                IPropertySheetEntry activeEntry = (IPropertySheetEntry)object;
                this.setMessage(activeEntry.getDescription());
                this.activateCellEditor(sel[0]);
            }
        }
        this.entrySelectionChanged();
    }

    private void handleTreeCollapse(TreeEvent event) {
        if (this.cellEditor != null) {
            this.applyEditorValue();
            this.deactivateCellEditor();
        }
    }

    private void handleTreeExpand(TreeEvent event) {
        this.createChildren(event.item);
    }

    void hideCategories() {
        this.isShowingCategories = false;
        this.categories = null;
        this.refresh();
    }

    void hideExpert() {
        this.isShowingExpertProperties = false;
        this.refresh();
    }

    private void hookControl() {
        this.tableTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PropertySheetViewer.this.handleSelect((TableTreeItem)e.item);
            }
        });
        this.tableTree.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                TableTreeItem item = PropertySheetViewer.this.tableTree.getItem(pt);
                if (item != null) {
                    PropertySheetViewer.this.handleSelect(item);
                }
            }
        });
        this.tableTree.addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent event) {
                PropertySheetViewer.this.handleTreeExpand(event);
            }

            public void treeCollapsed(TreeEvent event) {
                PropertySheetViewer.this.handleTreeCollapse(event);
            }
        });
        this.tableTree.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    PropertySheetViewer.this.deactivateCellEditor();
                } else if (e.keyCode == 0x100000E) {
                    PropertySheetViewer.this.setInput(PropertySheetViewer.this.getInput());
                }
            }
        });
    }

    public void refresh() {
        if (this.rootEntry != null) {
            this.updateChildrenOf(this.rootEntry, (Widget)this.tableTree);
        }
    }

    void removeActivationListener(ICellEditorActivationListener listener) {
        this.activationListeners.remove((Object)listener);
    }

    private void removeItem(TableTreeItem item) {
        Object data = item.getData();
        if (data instanceof IPropertySheetEntry) {
            ((IPropertySheetEntry)data).removePropertySheetEntryListener(this.entryListener);
        }
        item.setData(null);
        item.dispose();
    }

    public void resetProperties() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            ((IPropertySheetEntry)iterator.next()).resetPropertyValue();
        }
    }

    private void setErrorMessage(String errorMessage) {
        if (this.statusLineManager != null) {
            this.statusLineManager.setErrorMessage(errorMessage);
        }
    }

    public void setInput(Object newInput) {
        this.applyEditorValue();
        this.deactivateCellEditor();
        this.input = (Object[])newInput;
        if (this.input == null) {
            this.input = new Object[0];
        }
        if (this.rootEntry != null) {
            this.rootEntry.setValues(this.input);
            this.updateChildrenOf(this.rootEntry, (Widget)this.tableTree);
        }
    }

    private void setMessage(String message) {
        if (this.statusLineManager != null) {
            this.statusLineManager.setMessage(message);
        }
    }

    public void setRootEntry(IPropertySheetEntry root) {
        if (this.rootEntry != null) {
            this.rootEntry.removePropertySheetEntryListener(this.entryListener);
        }
        this.rootEntry = root;
        this.tableTree.setData((Object)this.rootEntry);
        this.rootEntry.addPropertySheetEntryListener(this.entryListener);
        this.setInput(this.input);
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void setStatusLineManager(IStatusLineManager manager) {
        this.statusLineManager = manager;
    }

    void showCategories() {
        this.isShowingCategories = true;
        this.refresh();
    }

    void showExpert() {
        this.isShowingExpertProperties = true;
        this.refresh();
    }

    private void updateCategories() {
        List childEntries;
        if (this.categories == null) {
            this.categories = new PropertySheetCategory[0];
        }
        if ((childEntries = this.getFilteredEntries(this.rootEntry.getChildEntries())).size() == 0) {
            this.categories = new PropertySheetCategory[0];
            return;
        }
        HashMap<String, PropertySheetCategory> categoryCache = new HashMap<String, PropertySheetCategory>(this.categories.length * 2 + 1);
        int i = 0;
        while (i < this.categories.length) {
            this.categories[i].removeAllEntries();
            categoryCache.put(this.categories[i].getCategoryName(), this.categories[i]);
            ++i;
        }
        ArrayList<PropertySheetCategory> categoriesToRemove = new ArrayList<PropertySheetCategory>(Arrays.asList(this.categories));
        PropertySheetCategory misc = (PropertySheetCategory)categoryCache.get(MISCELLANEOUS_CATEGORY_NAME);
        if (misc == null) {
            misc = new PropertySheetCategory(MISCELLANEOUS_CATEGORY_NAME);
        }
        boolean addMisc = false;
        int i2 = 0;
        while (i2 < childEntries.size()) {
            IPropertySheetEntry childEntry = (IPropertySheetEntry)childEntries.get(i2);
            String categoryName = childEntry.getCategory();
            if (categoryName == null) {
                misc.addEntry(childEntry);
                addMisc = true;
                categoriesToRemove.remove(misc);
            } else {
                PropertySheetCategory category = (PropertySheetCategory)categoryCache.get(categoryName);
                if (category == null) {
                    category = new PropertySheetCategory(categoryName);
                    categoryCache.put(categoryName, category);
                } else {
                    categoriesToRemove.remove(category);
                }
                category.addEntry(childEntry);
            }
            ++i2;
        }
        if (addMisc) {
            categoryCache.put(MISCELLANEOUS_CATEGORY_NAME, misc);
        }
        ArrayList list = new ArrayList(categoryCache.values());
        int i3 = 0;
        while (i3 < categoriesToRemove.size()) {
            list.remove(categoriesToRemove.get(i3));
            ++i3;
        }
        Collections.sort(list, new Comparator(){
            Collator coll = Collator.getInstance(Locale.getDefault());

            public int compare(Object a, Object b) {
                PropertySheetCategory c1 = (PropertySheetCategory)a;
                String dname1 = c1.getCategoryName();
                PropertySheetCategory c2 = (PropertySheetCategory)b;
                String dname2 = c2.getCategoryName();
                return this.coll.compare(dname1, dname2);
            }
        });
        this.categories = list.toArray(new PropertySheetCategory[list.size()]);
    }

    private void updateCategory(PropertySheetCategory category, TableTreeItem item) {
        item.setData((Object)category);
        item.setText(0, category.getCategoryName());
        item.setText(1, "");
        if (category.getAutoExpand()) {
            this.createChildren((Widget)item);
            item.setExpanded(true);
            category.setAutoExpand(false);
        } else {
            this.updatePlus(category, item);
        }
    }

    private void updateChildrenOf(Object node, Widget widget) {
        TableTreeItem[] childItems;
        IPropertySheetEntry entry = null;
        PropertySheetCategory category = null;
        if (node instanceof IPropertySheetEntry) {
            entry = (IPropertySheetEntry)node;
        } else {
            category = (PropertySheetCategory)node;
        }
        TableTreeItem item = null;
        if (node == this.rootEntry) {
            childItems = this.tableTree.getItems();
        } else {
            item = (TableTreeItem)widget;
            childItems = item.getItems();
        }
        if (item != null && !item.getExpanded()) {
            int i = 0;
            while (i < childItems.length) {
                if (childItems[i].getData() != null) {
                    this.removeItem(childItems[i]);
                }
                ++i;
            }
            if ((category != null || entry.hasChildEntries()) && childItems.length == 0) {
                new TableTreeItem(item, 0);
            }
            return;
        }
        if (node == this.rootEntry && this.isShowingCategories) {
            this.updateCategories();
        }
        List children = this.getChildren(node);
        HashSet<Object> set = new HashSet<Object>(childItems.length * 2 + 1);
        int i = 0;
        while (i < childItems.length) {
            Object data = childItems[i].getData();
            if (data != null) {
                Object e = data;
                int ix = children.indexOf(e);
                if (ix < 0) {
                    this.removeItem(childItems[i]);
                } else {
                    set.add(e);
                }
            } else if (data == null) {
                item.dispose();
            }
            ++i;
        }
        int oldCnt = -1;
        if (widget == this.tableTree) {
            oldCnt = this.tableTree.getItemCount();
        }
        int newSize = children.size();
        int i2 = 0;
        while (i2 < newSize) {
            Object el = children.get(i2);
            if (!set.contains(el)) {
                this.createItem(el, widget, i2);
            }
            ++i2;
        }
        if (widget == this.tableTree && oldCnt == 0 && this.tableTree.getItemCount() == 1) {
            this.tableTree.setRedraw(false);
            this.tableTree.setRedraw(true);
        }
        childItems = entry == this.rootEntry ? this.tableTree.getItems() : item.getItems();
        i2 = 0;
        while (i2 < newSize) {
            Object el = children.get(i2);
            if (el instanceof IPropertySheetEntry) {
                this.updateEntry((IPropertySheetEntry)el, childItems[i2]);
            } else {
                this.updateCategory((PropertySheetCategory)el, childItems[i2]);
                this.updateChildrenOf((PropertySheetCategory)el, (Widget)childItems[i2]);
            }
            ++i2;
        }
        this.entrySelectionChanged();
    }

    private void updateEntry(IPropertySheetEntry entry, TableTreeItem item) {
        item.setData((Object)entry);
        item.setText(0, entry.getDisplayName());
        item.setText(1, entry.getValueAsString());
        Image image = entry.getImage();
        if (item.getImage(1) != image) {
            item.setImage(1, image);
        }
        this.updatePlus(entry, item);
    }

    private void updatePlus(Object node, TableTreeItem item) {
        IPropertySheetEntry entry = null;
        PropertySheetCategory category = null;
        if (node instanceof IPropertySheetEntry) {
            entry = (IPropertySheetEntry)node;
        } else {
            category = (PropertySheetCategory)node;
        }
        boolean hasPlus = item.getItemCount() > 0;
        boolean needsPlus = category != null || entry.hasChildEntries();
        boolean removeAll = false;
        boolean addDummy = false;
        if (hasPlus != needsPlus) {
            if (needsPlus) {
                addDummy = true;
            } else {
                removeAll = true;
            }
        }
        if (removeAll) {
            TableTreeItem[] items = item.getItems();
            int i = 0;
            while (i < items.length) {
                this.removeItem(items[i]);
                ++i;
            }
        }
        if (addDummy) {
            new TableTreeItem(item, 0);
        }
    }
}

